;  EXPLORE.EM,  EMACSSRC>EMACS*>EXTENSIONS>SOURCES, TOOLS GROUP-MAM-DNK, 04/21/83
;  Contains the functions for EXPLORE mode in EMACS
;  Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;
; Modifications:
; DATE     PROGRAMER    CHANGE
; 04/21/83 MAM          Added code to list segdirs.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; explore    Moves up and down directory structure and lets user type file ;;;
;;;            manage commands from within EMACS.  Bound as ^xd.             ;;;
;;; explore_attributes                                                       ;;;
;;;            Show the attributes of files and directories.                 ;;;
;;; explore_create                                                           ;;;
;;;            Creates a new file while in explore mode and then puts point  ;;;
;;;            into that file.  If the file already exists, go to that file. ;;;
;;; explore_delete                                                           ;;;
;;;            Deletes a file or directory.  Bound as k in explore mode.     ;;;
;;; explore_dir$  Interlude that does some setting up if a display will be   ;;;
;;;            needed.                                                       ;;;
;;; explore_dive                                                             ;;;
;;;            Goes to a file or displays a new directory.                   ;;;
;;; explore_pop                                                              ;;;
;;;            Where actual work of explore_restore is done.                 ;;;
;;; explore_rename                                                           ;;;
;;;            Changes the name of a file.  If there is an equal sign at the ;;;
;;;            end, explore will prompt for the wildcard specification (that ;;;
;;;            is the left side.)                                            ;;;
;;; explore_restore                                                          ;;;
;;;            Decrements the counter that indicates the directory level,    ;;;
;;;            then goes to that place.                                      ;;;
;;; explore_spool                                                            ;;;;
;;;            Spools a file.  Goes to the file to see if it has a runoff    ;;;
;;;            output header.  If it does, it spools to a form called        ;;;
;;;            "WHITE".                                                      ;;;
;;; get_explore_path$                                                        ;;;
;;;            Returns the current path of the displayed directory (not the  ;;;
;;;            attach point.)                                                ;;;
;;; insert_dir_info$                                                         ;;;
;;;            Where the actual work of displaying a directory occurs.       ;;;
;;; set_spool  lets the user specifiy some global options to the spool       ;;;
;;;            command                                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; 02/03/83 Zane    (if (null loaded$) (load))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Global variables: spool_options$, explore_level$, path$

(defun init_explore_globals$ ()
    (if inited_explore_globals$ (return))
    (setq inited_explore_globals$ true)
    (if (null spool_options$)
        (setq spool_options$ ""))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; If this variable is set to true, will check to see if runoff output      ;;;

    (if (null white_ok$)
        (setq white_ok$ false))


(set_mode_key "explore" "a" "explore_attributes")
(set_mode_key "explore" "A" "explore_attributes")
(set_mode_key "explore" "c" "explore_create")
(set_mode_key "explore" "C" "explore_create")
(set_mode_key "explore" "g" "explore_dive")
(set_mode_key "explore" "G" "explore_dive")
(set_mode_key "explore" "d" "explore_dive")
(set_mode_key "explore" "D" "explore_dive")
(set_mode_key "explore" "h" "explore_help")
(set_mode_key "explore" "H" "explore_help")
(set_mode_key "explore" "k" "explore_delete")
(set_mode_key "explore" "K" "explore_delete")
(set_mode_key "explore" "n" "explore_create")
(set_mode_key "explore" "N" "explore_create")
(set_mode_key "explore" "r" "explore_rename")
(set_mode_key "explore" "R" "explore_rename")
(set_mode_key "explore" "s" "explore_spool")
(set_mode_key "explore" "S" "explore_spool")
(set_mode_key "explore" "?" "explore_help")
(set_mode_key "explore" "u" "explore_pop")
(set_mode_key "explore" "U" "explore_pop")
(set_mode_key "explore" "^xu" "explore_pop")
(set_mode_key "explore" "^xU" "explore_pop"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; set_spool                                                                ;;;
;;;   lets the user specify some global options to the spool command         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom set_spool
    &doc "EXPLORE: Sets spool options such as -copy, etc."
(let ((temp ""))
(with_command_abort_handler
    (info_message
         (catenate "Current spool options: " spool_options$))
    (setq temp (prompt "New spool options ~ha8^G to retain current options~ha9"))
    (setq spool_options$ (catenate " " temp))
command_abort_handler
    ))                                 ; end of let and of
                                       ; with_command_abort_handler, too
(info_message (catenate "Spool options are now: " spool_options$))
(sleep_for_n_milliseconds 1500)
(info_message "")
    )



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; explore                                                                  ;;;
;;;    Moves up and down directory structure and lets user type file manage- ;;;
;;;    commands from within EMACS.  Bound as ^xd.                            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom explore
     &doc "EXPLORE: Explore the hierarchy package."
     &args ((reply &prompt "Directory to Explore"))
     (init_explore_globals$)
     (setq explore_level$ 0)
     (if (= r&doc "EXPLORE: Dive from an explore directory."
    (info_message "EXPLORE:  Go or Dive into entry;  Please wait...")
    (save_excursion                    ; make sure can actually dive, and not
       (begin_line)                    ; line inserted for readability
       (if (| (line_is_blank)
           (looking_at "The "))
           (error_message "You must be pointed at a file or directory name")
           (ring_the_bell)
           (return)))
                                       ; make sure return to same spot after
                                       ; ^xu
    (buffer_info (user pushpos) (copy_cursor current_cursor))
    (setq path$ (get_explore_path$))   ; reset path$
                                       ; make sure no problem if from mfd
    (if (= ">>" (substr path$ (1- (string_length path$)) 2))
        (setq path$ (substr path$ 1 (1- (string_length path$)))))
                                       ; diving to a file
    (if (null (list_dir path$ directories))
        (select_buf (current_line))
        (set_key "^xU" "explore_restore")
        (set_key "^xu" "explore_restore")
                                       ; set some keys in that buffer
        (find_file path$)              ; make sure can get back to explore list
        (set_key "^xU" "explore_restore")
        (set_key "^xu" "explore_restore")
                                       ; set these mode keys AFTER we find_file
                                       ; so that the user can get back to the
                                       ; explore list even if s/he needs to
                                       ; specify a new buffer name to avoid
                                       ; duplication, etc.
        (info_message "Type 'CONTROL-X U' to return to Explore directory")
    else                               ; diving into a directory
        (if (= (index path$ ">") 0)    ; if there are no >s in path$,
            (setq path$ (catenate "*>" path$)))
                                       ; explicitly add parent

        (explore_dir$)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; get_explore_path$                                                        ;;;
;;;   Returns the current path of the displayed directory (not the attach    ;;;
;;;   point).                                                                ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun get_explore_path$ (&returns string)
                                       ; if spaces in line due to attributes
                                       ; must get rid of them
    (let ((line (current_line))
          (path (buffer_info (user path$)))
          (path1 (file_info ".foobar" directory_name))
          (pos  (index line " ")))
          (if (> pos 0)
             (setq line (substr line 1 (1- pos))))
                                       ; append the path and stuff from line
                                       ; together
         (if (= path path1)
             (setq explore_line$ line)
             (return explore_line$))
         (if (= (substr path 1 1) "~~")
             (return (catenate  (substr path 2) ">" line))
          else
             (return (catenate  (buffer_info (user path$)) ">" line)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; explore_restore                                                          ;;;
;;;     Decrements the counter that indicates the directory level, then goes ;;;
;;;     that place.  Usually pop is called--this is called from a file with  ;;;
;;;     with ^xu.                                                            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom explore_restore
    &doc "EXPLORE: Pop from a file in explore."
    (setq explore_level$ (1+ explore_level$))
    (explore_pop))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; explore_pop                                                              ;;;
;;;    Where actual work of explore_rstore is done. Bound a u in explore mode;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom explore_pop
    &doc "EXPLORE: Pop from explore sublevel."
    (if (< explore_level$ 2)
        (ring_the_bell)
        (display_error_noabort "At top level.")
        (return))
    (setq explore_level$ (1- explore_level$))
    (go_to_buffer (catenate ".explore." (integer_to_string explore_level$)))
    (go_to_cursor (buffer_info (user pushpos))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; explore_delete                                                           ;;;
;;;    Deletes a file or directory.  Bound as k in explore mode.             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom explore_delete
    &doc "EXPLORE: Delete a file."
    (let ((path (get_explore_path$))
          (msg  "Are you sure you want to delete "))
         (select (file_info path type) ; change msg if directory
             "directory"
                 (setq msg "***Is it OK to delete the DIRECTORY: "))
         (if (yesno (catenate msg path))
             (buffer_info read_only false)
             (save_position
                 (let ((err (file_operation path delete)))
                      (if (^= err 0)
                      (primos_internal_quiet
                           (catenate "delete " path)))))
             (begin_line)
             (with_cursor here
                   (if (not (next_line)) (end_line))
                   (delete_point_cursor here))
             (buffer_info modified false)
             (buffer_info read_only true)))
    (info_message ""))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; explore_create                                                           ;;;
;;;     Creates a new file while in explore mode and then puts point into    ;;;
;;;     that file.  If the file already exists, go to that file.             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom explore_create
     &doc "EXPLORE: Create a file."
     &args ((filename &prompt "Filename"))
     (setq path$ (buffer_info (user path$)))
     (if (= (substr path$ 1 1) "~~") (setq path$ (substr path$ 2)))
     (if (file_info (catenate path$ ">" filename) exists)  ;check if file exists
         (buffer_info (user pushpos) (copy_cursor current_cursor))
         (find_file (catenate path$ ">" filename))
         (set_key "^xu" "explore_restore")
         (set_key "^xU" "explore_restore")
         (return))
     (with_no_redisplay
          (save_excursion
              (select_buf ".empty")
              (write_file (catenate path$ ">" filename)))
          (insert_dir_info$)
          (move_top)
          (if u must be pointed at a file or directory name")
           (return))
       (info_message "Getting attributes...")
       (let ((path$ (get_explore_path$)))
            (if (> (index (current_line) " ") 0)
                (return))
            (end_line)
            (whitespace_to_hpos 34)
            (insert " ")
            (insert (file_info path$ type))
            (insert " ")
            (insert (evaluate_af (catenate "[attrib '"
                                           path$
                                           "' -dtm]")))
            (if (not (file_info path$ dumped))
                (insert " (not dumped)")))
            (info_message "")
            (buffer_info read_only true))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; explore_help                                                             ;;;
;;;     Shows what commands are available in explore mode.  Bound to ?       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom explore_help
        &doc "EXPLORE: Describe explore."
        (print "          The following keys are active in EXPLORE mode:                      ")
        (print "                                                                              ")
        (print "    ?     Show this Help                                                      ")
        (print "    a     get Attributes of this entry;  ^U A gets Attributes of all entries  ")
        (print "    c     Create a new file                                                   ")
        (print "    d     Dive, same as 'g'                                                   ")
        (print "    g     Go to file or directory                                             ")
        (print "    h     show this Help                                                      ")
        (print "    k     Kill (delete) this file                     (Most EXPLORE commands  ")
        (print "    n     create a New file                                refer to the file  ")
        (print "    r     Rename this file                                or directory where  ")
        (print "    s     Spool this file                              you place the cursor)  ")
        (print "    u     Pop from this EXPLORE level                                         ")
        (print "  ^X U    Pop from this FILE (for use from explored file)                     ")
        (print "                                                                              ")
        (print "        Place the cursor on the FILE or DIRECTORY you want to Explore.        ")
        (print "--- (Use the set_spool command to change or inspect your spooling options) ---")
        (info_message
               "Any keystroke clears the EXPLORE Help information.")
        )

