;  FILE_HOOKS.EM,  EMACSSRC>EMACS*>EXTENSIONS>SOURCES, TOOLS GROUP, 11/14/84
;  Contains a sample version of the file_hooks macro
;  Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;
; Modifications:
;
; 11/14/84 MAM          Changed rpg suffix to default to vrpg
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(defun found_file_hook  ()
     (setq file_hook_type$ (list user_type$))
     (if (null (car file_hook_type$))
         (if (null (cdr file_hook_type$))
             (return)))
     (if (= file_hook_type$ '(no_file_hooks))
         (return))
     (eval file_hook_type$))

(defun no_file_hooks$ () )

(defun clerical$ ()
    (select (suffix$)
      "runi"
          (fill_on)
      otherwise
          (fill_on)))

(defun programmer$ ()
      (select (suffix$)
          "runi"
               (fill_on)          ; text mode
          "em"
               (lisp_on)          ; lisp mode
          "cbl"
               (cbl_on)           ; new cobol
          "cobol"
               (cobol_on)         ; cobol on
          "ftn" "f77"
               (fortran_on)       ; fortran mode
          "rpg"
               (vrpg_on)          ; vrpg mode
          "vrpg"
               (vrpg_on)          ; vrpg mode
          "pl1"
               (pl1_on)           ; full pl1
          "pl1g"
               (pl1g_on)          ; pl1 subset G
          "como"
               ()
          otherwise
               ()
          ))

;;; The file hook macro does not work with select buffer
;;; The following macro lets it be used


    (defcom mod_select_buf
        &doc "Select buffer"
        &args ((buf_name &prompt "Buffer" &string))
        (select_buf buf_name)
        (if (null (buffer_info modes))
            (found_file_hook)))

; 02/03/83 Zane    (set_permanent_key "^xb" "mod_select_buf")
; 02/03/83 Zane    (set_permanent_key "^xB" "mod_select_buf")

