;  FILL.EM, EMACSSRC>EMACS*>EXTENSIONS>SOURCES, TOOLS GROUP, 07/15/83
;  Contains miscellaneous routines that deal with margins in EMACS
;  Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;
; Modifications:
;
; 07/15/83 MAM        Fixed typo, placment to placement, line 248
; 11/02/82 BMZ        Added fasload of text package for back_para...
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; all_modes_off     extended command that shuts off all                    ;;;
;;;                   modes                                                  ;;;
;;; fill              inserts cr so you don't have to         {space}        ;;;
;;; fill_on           turns on fill_mode                                     ;;;
;;; fill_off          turns off fill_mode                                    ;;;
;;; fill_para         fills and justifies a paragraph         {esc}q         ;;;
;;; indent_to_fill_prefix                                                    ;;;
;;;                   indents left margin to fill prefix      {esc}^i        ;;;
;;; set_left_margin   extended command that sets the left                    ;;;
;;;                   margin                                                 ;;;
;;; set_right_margin  extended command that sets the right                   ;;;
;;;                   margin for filling                                     ;;;
;;; take_left_margin  same as set_left_margin except user is  ^x^zf          ;;;
;;;                   not prompted for position                              ;;;
;;; take_right_margin same as set_right_margin except user    ^x.            ;;;
;;;                   is not prompted for position                           ;;;
;;; tell_modes        extended command that prints lists of                  ;;;
;;;                   all modes                                              ;;;
;;; tell_left_margin  displays what the left margin is                       ;;;
;;; tell_right_margin displays what the right margin is                      ;;;
;;;                                                                          ;;;

; 02/03/83 Zane   (if (null loaded$) (load))
; 02/03/83 Zane   (if (null text_loaded$)
; 02/03/83 Zane       (fasload "emacs*>extensions>text"))

;;; Global Variables:                                                        ;;;
;
;   Now set up as part of core initializtion
;
; 02/03/83 Zane         (if (null fill_prefix)
; 02/03/83 Zane             (setq fill_prefix 0))
; 02/03/83 Zane
; 02/03/83 Zane         (if (null default_right_margin)
; 02/03/83 Zane             (setq default_right_margin 70))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; fill_on                                                                  ;;;
;;;   Extended command that turns on fill mode.                              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom fill_on
     &doc "Allows character wrapping for this buffer"
     (set_mode_key "fill" " "  "wrap")
     (set_mode_key "fill" "^j" "wrap")
     (if (= (buffer_info fill_column) 0)
         (buffer_info fill_column default_right_margin))
     (turn_mode_on (find_mode 'fill) last)
     (info_message (catenate "Word wrapping is on at a right margin of "
                             (integer_to_string default_right_margin))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; fill_off                                                                 ;;;
;;;    Extended command that turns off fill mode.                            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom fill_off
     &doc "Shuts off wrapping for this buffer"
     (buffer_info fill_column 0)
     (turn_mode_off (find_mode 'fill))
     (buffer_info fill_column 0)
     (info_message "Word wrapping is now off"))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; wrap                                                                     ;;;
;;;   Command that takes a space and carriage return and checks its          ;;;
;;;   horizontal position. If it is greater than fill column, wrap           ;;;
;;;   puts in a carriage return.                                             ;;;
;;;                                                                          ;;;
;;;        (wrap optional-integer)                                           ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom wrap
     &doc "Inserts cr so you don't have to"
     &na (&pass count &default 1)
     (do_n_times count (wrap$)))
(defun wrap$ ()
     (if (null character_argument) (setq character_argument " "))
     (if (and (> (cur_hpos) (1+ (buffer_info fill_column)))
              (> (buffer_info fill_column) 10))
                                       ; insure enough space
         (insert "")                ; insert three ^z garbage chars
         (go_to_hpos (buffer_info fill_column))
                                       ; go to fill_column
         (if (search_bk_in_line " ")   ; find whitespace previous and delete
             (delete_white_sides)
             (cr)                      ; finally add cr
             (save_excursion           ; if next line is blank, get rid of
                 (next_line)           ; it.  try to do something similar
                 (if (line_is_blank)   ; to fundamental in this respect
                     (if_at " "
                          (kill_line 2)
                      else
                          (delete_char)))))
         (forward_search "")        ; get rid of garbage
         (rubout_char 3))
     (insert (character_argument)))    ; insert character causing invokation




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; indent_to_fill_prefix                                                    ;;;
;;;    This function indents a region to the fill_prefix.  This is bound as  ;;;
;;;    {esc}{tab}.                                                           ;;;
;;;                                                                          ;;;
;;;         (indent_for_fill_prefix)                                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom indent_to_fill_prefix
     &doc "Indents line to a fill prefix"
     &na (&pass count &default 1)
     (if (< count 0)                   ; set different point if negative
         (setq count (- count))        ; argument, makes things easier for
         (prev_line count))            ; next step
     (do_n_times count
         (begin_line)
         (setq placement 0))
        (next_line))
    (go_to_cursor end_point)
    (return start_point))

(defun build_list_para$ (       (count integer)
                        &local (temp_fill_prefix integer)
                               (tag string)
                               (length integer)
                               (start_point cursor))
                                       ; this routine sets up environment
                                       ; so that build_para can do its thing
      (setq temp_fill_prefix fill_prefix)
                                       ; set up right indentation
      (buffer_info fill_column (- (buffer_info fill_column) 4))
      (if_at "o"                       ; different list types have dif. indents
           (setq fill_prefix (+ fill_prefix 7))
       else
           (setq fill_prefix (+ fill_prefix 8)))
      (with_cursor here                ; save the indicator such as bullet
         (skip_to_white)               ; or number
         (setq tag (point_cursor_to_string here))
         (setq length (string_length tag))
         (delete_point_cursor here))
      (white_delete)                   ; make sure no garbage spaces
                                       ; now do a build_para
      (setq start_point (build_para$ count))
                                       ; restore fill_column
      (buffer_info fill_column (+ (buffer_info fill_column) 4))
      (save_excursion                  ; restore indicator
         (go_to_cursor start_point)
         (go_to_hpos (- fill_prefix (1+ length)))
         (delete_char length)
         (insert tag)
         (setq fill_prefix temp_fill_prefix)))

(defun pad$ (         (placement integer)
             &local   (to_pad integer)
             &returns integer)
                                       ; figure out how many spaces to add
     (setq to_pad (- (buffer_info fill_column) (string_length (current_line))))
     (if (= to_pad 0) (return placement))
                                       ; if = 1 pad from right
                                       ; otherwise pad from left
     (if (= placement 1)
         (end_line)
         (do_forever
            (if (search_bk_in_line " ")  ; find a space and make sure after
                                         ; fill prefix
                (if (<= (cur_hpos) fill_prefix)
                    (end_line)
                 else
                    (insert " ")
                    (setq to_pad (1- to_pad))   ; decrement amount of spaces to
                    (if (= to_pad 0)            ; add.  If zero, exit
                        (setq placement 0)
                        (return placement))
                    (skip_back_over_white))
             else
                 (end_line))))
                                       ; padding from the left begins
     (begin_line)
     (skip_over_white)                 ; avoid fill prefix
     (do_forever
          (if (search_fd_in_line " ")  ; same as above except reverse
              (insert " ")             ; direction
              (setq to_pad (1- to_pad))
              (if (= to_pad 0)
                  (setq placement 1)
                  (return placement))
              (skip_over_white)
           else
              (begin_line)
              (skip_over_white))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;untidy                                                                    ;;;
;;;  Unjustifies a paragraph made neat by a fill_para                        ;;;
;;;                                                                          ;;;
;;;      (untidy)     or      (untidy$)                                      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(defcom untidy
   &doc "Unjustifies a paragraph"
   (untidy$))
(defun untidy$ (&local (paragraph string)
                       (pos integer)
                       (wrap_column integer)
                       (line_num integer)
                       (temp_fill_prefix integer))
     (if (< (buffer_info fill_column) 10)
                                       ; check for sufficient space
         (info_message "Not enough space to fill, Reset fill column")
         (ring_the_bell)
         (return))
                                       ; essentially, all that occurs is
                                       ; that initial blanks are shaved
                                       ; then region is filled
     (setq temp_fill_prefix fill_prefix)
     (setq fill_prefix 0)
     (begin_line)
     (if (line_is_blank)
         (prev_line)
      else
         (if_at "."
              (prev_line)))
     (do_forever
         (if_at "." (next_line) (stop_doing))
         (if (line_is_blank) (next_line) (stop_doing))
         (if (beginning_of_buffer_p) (stop_doing))
         (prev_line))
     (with_cursor here
         (do_forever
            (if_at "." (stop_doing))
            (if (line_is_blank) (stop_doing))
            (if (lastlinep) (move_bottom) (stop_doing))
            (next_line))
         (setq paragraph (point_cursor_to_string here))
         (delete_point_cursor here))
      (create_text_save_buffer$ paragraph)
      (setq paragraph (trim paragraph))
      (open_line)
      (save_excursion
        (insert (trim (translate paragraph " " "~n"))))
      (setq line_num (line_number current_cursor))
      (do_forever                      ; get rid of double spaces
          (if (forward_search "  ")
              (if (^= (line_number current_cursor) line_num)
                  (stop_doing))
              (rubout_char)
              (back_char)
           else
              (stop_doing)))
       (goto_line line_num)
       (checker$ ".")
       (checker$ "!")
       (checker$ "?")
       (fill_para -1)
       (setq fill_prefix temp_fill_prefix))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; checker                                                                  ;;;
;;;      This is a pretty stupid routine that adds a double space after some ;;;
;;;      punctuation points.  One of these days, should spend some time and  ;;;
;;;      add some intelligence.                                              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun checker$ (       (to_check string)
                &local (line_num integer))
   (setq line_num (line_number current_cursor))
   (save_excursion
     (do_forever
         (if (forward_search to_check)
             (if (^= (line_number current_cursor) line_num)
                 (stop_doing))
             (if_at " "
                 (insert " "))
           else
              (stop_doing)))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; set_right_margin                                                         ;;;
;;;   Command that sets the right margin for wrapping.  This is bound        ;;;
;;;   as ^x^zf.                                                              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom set_right_margin
     &doc "Sets the right margin to whatever you specify"
     &args ((column &prompt "What is the right margin"
                    &default default_right_margin
                    &integer))
     (buffer_info fill_column column)
     (if (> (buffer_info fill_column) 10)
         (tell_right_margin)))
(defun set_right ()
     (set_right_margin))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;take_right_margin                                                         ;;;
;;;   Command that takes the right margin from the current column position   ;;;
;;;;;;;;;;;;;;;;;;;;;;