;  FORTRAN.EM,  EMACSSRC>EMACS*>EXTENSIONS>SOURCES, TOOLS GROUP, 11/07/82
;  Contains the functions for FORTRAN mode
;  Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; FUNCTIONS:                                                               ;;;
;;;      do$            Indentation for lines beginning with DO              ;;;
;;;      fortran_character_indent$                                           ;;;
;;;                     Check if should indent what is typed at col 1        ;;;
;;;      fortran_comment$                                                    ;;;
;;;                     Checks if comment character is inserted at col 1     ;;;
;;;      fortran_continuation$                                               ;;;
;;;                     Checks if continuation char is inserted at col 1     ;;;
;;;      fortran_do_toggle                                                   ;;;
;;;                     Every time typed, changes state of what occurs when  ;;;
;;;                     line begins with DO                                  ;;;
;;;      fortran_on     Turns on fortran mode                                ;;;
;;;      fortran_off    Turns off fortran mode                               ;;;
;;;      fortran_space$  Checks column before invoking fortran_wrap$           ;;;
;;;      fortran_wrap$   Basically the same as regular wrap function          ;;;
;;;      set_fortran_comment                                                 ;;;
;;;                     Sets up the indentation after a comment              ;;;_
;;;      set_fortran_cont                                                    ;;;
;;;                     Sets the continuation char that will be printed      ;;;
;;;      set_indent$    Figures out what indentation should be               ;;;
;;;      setup_character_indent$                                             ;;;
;;;                     Binds all character insertions to correct function   ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; do$                                                                      ;;;
;;;    If fortran_do$ is true, then if the first non-space characters after  ;;;
;;;    column 6 are DO, then an added level of indentation is added          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun do$ ()
   (dispatch
      "do " "DO " "Do "
      "do~n" "DO~n" "Do~n"
         (type_tab)
         (setq current_indent$ (cur_hpos))
      otherwise
         (setq current_indent$ (cur_hpos))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; set_indent$                                                              ;;;
;;;    Function that figures out what the current line should be indented to ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun set_indent$ ()
    (save_excursion
        (if (not (prev_line))
            (setq current_indent$ 7)
            (return))
        (if (go_to_hpos 7)
            (skip_over_white)
            (if fortran_do$
                (do$)
             else
                (setq current_indent$ (cur_hpos)))
         else
            (setq current_indent$ 7))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; set_fortran_comment                                                      ;;;
;;;    Command that lets the user indicate to what space comment text should ;;;
;;;    begin in.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom set_fortran_comment
    &doc "Sets up the indentation after a FORTRAN comment"
    (setq fortran_comment_indent$
          (prompt_for_integer "What is the comment indentation column" 3)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; set_fortran_cont                                                         ;;;
;;;   Lets the user specify what character should be printed in column 6 for ;;;
;;;   continuations                                                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom set_fortran_cont
    &doc "Sets the continuation character"
    (setq fortran_continue_char$
         (substr
             (prompt_for_string "What is the continuation character" "C") 1 1)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; fortran_do_toggle                                                        ;;;
;;;    Changes the fortran_do$ boolean from true to false or vice versa.  See;;;
;;;    do$ for what this does.                                               ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom fortran_do_toggle
    &doc "Changes DO indentation"
    (if (= fortran_do$ true)
        (setq fortran_do$ false)
        (info_message "DO does not add indentation")
    else
        (setq fortran_do$ true)
        (info_message "DO adds indentation")))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; fortran_on                                                               ;;;
;;;   Turns on fortran mode                                                  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom fortran_on
    &doc "Turns on FORTRAN mode"
    (if (null fortran_comment_indent$)
        (setq fortran_comment_indent$ 3))
    (if (null fortran_continue_char$)
        (setq fortran_continue_char$ "C"))
    (if (null fortran_do$)
        (setq fortran_do$ false))
    (setq current_indent$ 7)
    (if (null fortra;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun setup_character_indent$ (&local (charcode integer)
                                       (fortran dispatch))
    (setq fortran (find_mode 'fortran))
    (setq charcodes "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")
    (do_forever
      (if (= 0 (string_length charcodes)) (stop_doing))
      (dispatch_info fortran (substr charcodes 1 1) 'fortran_character_indent$)
      (setq charcodes (substr charcodes 2))
      )
    )


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; fortran_space$                                                            ;;;
;;;   Normally just inserts a space.  However, if past col 72 does a wrap.   ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom fortran_space$
     (if (> (cur_hpos) 72)
         (fortran_wrap$))
     (self_insert " "))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; fortran_wrap$                                                             ;;;
;;;   Wraps line if text is past column 72.  Normally invoked by a space or  ;;;
;;;   a carriage return.                                                     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom fortran_wrap$
    &doc "Fill in FORTRAN mode"
    (if (<= (cur_hpos) 6)
        (setq current_indent$ 7)
        (cr)
        (return))
    (if (< (cur_hpos) 73)
        (cr)
        (return))
    (save_excursion
        (next_line)
        (set_indent$))
    (insert "")
    (go_to_hpos (buffer_info fill_column))
    (if (search_bk_in_line " ")
        (delete_white_sides)
        (cr)
        (prev_line)
        (if_at "C"
            (next_line)
            (insert fortran_continue_char$)
            (insert " ")
         else
            (next_line)
            (whitespace_to_hpos 6)
            (whitespace_to_hpos current_indent$)
            (insert fortran_continue_char$))
    (save_excursion
            (next_line)
            (if (line_is_blank)
                (if_at " "
                      (kill_line 2)
                 else
                      (delete_char)))))
    (forward_search "")
    (rubout_char 3))

(defun fundamental_fortran_keybindings$ ()
   (set_mode_key "fortran" " " "fortran_space$")
   (set_mode_key "fortran" "^j" "fortran_wrap$")
   (set_mode_key "fortran" "^i" "type_tab")
   (set_mode_key "fortran" "^[>" "back_tab")
   (set_mode_key "fortran" "/" "fortran_comment$")
   (set_mode_key "fortran" "*" "fortran_comment$")
   (set_mode_key "fortran" "&" "fortran_continuation$"))


