;  KILL_RING.EM,  EMACSSRC>EMACS*>EXTENSIONS>SOURCES, TOOLS GROUP-DNK, 11/05/82
;  Contains the EMACS functions for viewing the kill ring
;  Copyright (c) 1981, Prime Computer, Inc., Natick, MA 01760
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This file contains the routine for viewing the contents of a kill        ;;;
;;; ring and putting these contents into a home buffer.                      ;;;
;;;                                                                          ;;;
;;; view_kill_ring         ^x^zk                                             ;;;
;;; yank_kill_text         ^x^z^y                                            ;;;
;;;                                                                          ;;;
;;; After view_kill_ring is invoked, the contents of kill buffers are        ;;;
;;; displayed. At all times you are given the options of next, saving, or    ;;;
;;; quiting.                                                                 ;;;
;;;                                                                          ;;;
;;; quit   you are returned to the place you started from before invoking    ;;;
;;;        this comand                                                       ;;;
;;; save   the contents of the kill ring are stored internally.  You are     ;;;
;;;        immediately returned to the place you started from before         ;;;
;;;        invocation.                                                       ;;;
;;; next   you are presented with the contents of the next kill buffer.      ;;;
;;;        After you've seen them all, you are returned to where you         ;;;
;;;        started. For convenience, {cr} is the same as continue.           ;;;
;;;                                                                          ;;;


;;; Global Variables: save_text$                                              ;;;

; 02/03/83 Zane                        (setq save_text$ "")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom view_kill_ring
     &doc "Looks at contents of kill rings"
     &na (&pass count &default 1)
     (view_kill_ringf count))
(defun view_kill_ringf (       (count integer)
                        &local (response string)
                               (counter integer)
                               (other_counter integer)
                               (kill_array array)
                               (buffer_spec string)
                               (here cursor))
    (if (= count 1)                    ; this is for future use so that
        (setq buffer_spec ".kill.")    ; we also have a text kill ring
     else
        (setq buffer_spec ".text."))
    (save_excursion
        (setq kill_array (make_array 'string 12)) ;all kill buf names in array
        (setq counter 1)
        (select_buf ".buffers")                   ;don't loose place
        (move_top)
        (do_forever
           (if (forward_search buffer_spec)       ;look for buffers
               (begin_line)
               (with_cursor here
                  (forward_search " ")            ; put it into array
                  (aset (point_cursor_to_string here) kill_array counter)
                  (setq counter (1+ counter)))
            else
                (stop_doing)))
        (setq other_counter 1)                        ; other_counter = an array
        (setq counter (1- counter))                   ; index.  counter = num of
        (if (= counter 0)                             ; kill rings
            (info_message "No kills or saves made")
            (return))
        (do_n_times counter
           (select_buf (aref kill_array other_counter))
           (move_top)
           (do_forever
               (info_message "View Text: Type s, n, v, q, ?")
               (setq response (char_to_string (read_character)))
               (select response
                   "s" "S"
                       (move_top)
                       (with_cursor here
                           (move_bottom)
                           (setq save_text$ (point_cursor_to_string here)))
                       (info_message "Text saved, type ^X^Z^Y to restore")
                       (return)
                   "~cj" "n" "N"
                       (stop_doing)
                   "q" "Q"  "~cg"
                       (info_message "")
                       (return)
                   "v" "V"
                       (view_file)
                   "?"
                       (save_excursion
                          (select_buf ".help.kill")
                          (buffer_info dont_show true)
                          (if (empty_buffer_p)
                          (insert "~n~n")
                          (insert "n    Next item (also a cr)~n")
                          (insert "q    Quit~n")
                          (insert "s    Save this text~n")
                          (insert "v    Viewer to examine large text~n")
                          (insert "?    Show this help text~n~n~n")
                          (insert "Type any character to return")
                          (buffer_info changed_ok true))
                          (read_character))
                  otherwise
                          (info_message "Unknown Response")
                          (sleep_for_n_milliseconds 1000)))
           (setq other_counter (1+ other_counter))))
       (info_message " "))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom yank_kill_text
     &doc "Inserts text saved by view_kill_ring"
     (back_char (string_length (insert save_text$)))
     (exchange_mark))

; 02/03/83 Zane   (setq kill_ring_loaded$ true)
