;  LISP.EM,  EMACSSRC>EMACS*>EXTENSIONS>SOURCES, TOOLS GROUP-MAM-DNK, 11/05/82
;  Contains the functions for the EMACS lisp mode
;  Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;
;;; All these functions are invoked in lisp mode                             ;;;
;;;                                                                          ;;;
;;; close_paren      After typing a close parenthesis, Emacs moves  )        ;;;
;;;                  to the corresponding open parenthesis, waits,           ;;;
;;;                  then returns to the close parenthesis.                  ;;;
;;; set_paren_time$  Sets the amount of time that close paren waits          ;;;
;;;                  before returning to point                               ;;;
;;; balfor           Moves forward to the close parenthesis that {esc}{ctrl-f};;
;;;                  corresponds to the last open parenthesis                ;;;
;;; balbak           Moves backward to the open parenthesis that {esc}{crtl-b};;
;;;                  corresponds to the last close parenthesis               ;;;
;;; lisp_on          Extended command that turns on lisp mode                ;;;
;;; lisp_off         Extended command that turns off lisp mode               ;;;
;;; lisp_comment     Command that puts in a comment designator   {esc};      ;;;
;;; lisp_indent_relativef                                                    ;;;
;;;                  Insures that a line is indented properly    {esc}i      ;;;
;;;                                                                          ;;;
;;; Note:  In lisp mode, a carriage return is bound to cret_indent_relative  ;;;
;;;                                                                          ;;;

; 02/03/83 Zane   (if (null loaded$) (load))


;;; Global Variables: lisp_comment_column, paren_time$                       ;;;

; 02/03/83 Zane                    (setq lisp_comment_column 40)
; 02/03/83 Zane
; 02/03/83 Zane                    (if (null no_paren_match$)
; 02/03/83 Zane                        (setq paren_time$ 750))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; lisp_on                                                                  ;;;
;;;   Extended command that turns on lisp mode.                              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom lisp_on
    &doc "Set lisp mode"
    (if (null lisp_keybindings$)
        (fundamental_lisp_keybindings$)
     else
       (if (^= "loaded" lisp_keybindings$)
          (load_lisp_keybindings$)))
    (setq lisp_keybindings$ "loaded")
    (turn_mode_on (find_mode 'lisp) first))

(defun fundamental_lisp_keybindings$ ()
    (set_mode_key "lisp" ")" "close_paren")  ; (
    (set_mode_key "lisp" "^[^F" "balfor")
    (set_mode_key "lisp" "^[^B" "balbak")
    (set_mode_key "lisp" "^j" "cret_indent_relative")
    (set_mode_key "lisp" "^[i" "lisp_indent_command")
    (set_mode_key "lisp" "^[I" "lisp_indent_command")
    (set_mode_key "lisp" "^[;" "lisp_comment"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; lisp_off                                                                 ;;;
;;;   Extended command that turns off lisp mode.                             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom lisp_off
    &doc "Turns off lisp mode"
    (turn_mode_off (find_mode 'lisp)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; close_paren                                                              ;;;
;;;   Command that moves the cursor to the open parenthesis that             ;;;
;;;   corresponds to the close parenthesis just typed.  After a              ;;;
;;;   pause, the cursor returns to the position just after the closing       ;;;
;;;   parenthesis just typed. This command understand nesting so that        ;;;
;;;   it will skip over any number of nested parenthesis.  This command      ;;;
;;;   is bound as ) in lisp mode.                                            ;;;
;;;                                                                          ;;;
;;;        (close_paren)                                                     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom close_paren
    &doc "Goes to matching open parenthesis"
    (close_parenf))
(defun close_parenf (&local (number_close integer)
                           (start_point cursor)
                           (a_parenthesis cursor))  ;( for paren matching
    (insert ")")         ; insert the close parenthesis
    (if (= paren_time$ 0) (return))
    (setq number_close 1)
    (setq start_point (copy_cursor current_cursor))
    (save_excursion                    ; set a start point
                                       ; loop goes back and forth
                                       ; until right place is found
                                       ; number_close is number found
       (do_forever
            (if (reverse_search "(")  ;) for paren matching
                (setq a_parenthesis (copy_cursor current_cursor))
                (do_n_times number_close  ;( for paren matching
                    (forward_search ")"))
                (if (= current_cursor start_point)
                    (go_to_cursor a_parenthesis)
                    (redisplay)
                    (sleep_for_n_milliseconds paren_time$)
                    (stop_doing))
                (setq number_close (1+ number_close))
                (go_to_cursor a_parenthesis)
            else
                (info_message "This is an unmatched parenthesis")
                (return)))))
                                                   ;( for paren matching

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; set_paren_time                                                           ;;;
;;;   extended command that lets the user set the amount of wait time        ;;;
;;;   for close parenthesis matching.  This value is in milliseconds.        ;;;
;;;   On a fast machine, this might be around 1500, on a slow machine,       ;;;
;;;   you'd might want to try something like 500                             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom set_paren_time
   &doc "Sets the amount of time for paren matching"
   (setq paren_time$ (prompt_for_integer "How long is wait time" 750)))


;;;;;;;;;;;;;;;;;;;;;;balance parenthesis")
            (return))))





;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; lisp_indent_command                                                      ;;;
;;;   Command that insures that statements are indented in some semblance    ;;;
;;;   of order.  This is normally bound as {esc}i.                           ;;;
;;;                                                                          ;;;
;;;        (lisp_indent_command)   or   (lisp_indent)                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom lisp_indent_command
        &doc "lisp: indent"
        (lisp_indent))

(defun lisp_indent (&local (hpos integer))
       (save_excursion
          (begin_line)
          (verify_bk " ")
          (dispatch
               "("
               ")"  (forward_char)
                    (balbak)
           otherwise
                   (verify_bk " ")
                   (search_bk " ")
                   (forward_char))
          (setq hpos (cur_hpos)))
       (indent_line_to_hpos hpos))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; lisp_comment                                                             ;;;
;;;    Command that moves the lisp comment column (default of 40) and        ;;;
;;;    inserts a comment designator.  If point is past this column,          ;;;
;;;    the designator is placed on the next line (which this command         ;;;
;;;    creates).                                                             ;;;
;;;                                                                          ;;;
;;;         (lisp_comment)                                                   ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom lisp_comment
        &doc "Move to Lisp comment column"
        (end_line)
        (if (> (cur_hpos) lisp_comment_column)
            (insert "~n")
            (self_insert " " (1- lisp_comment_column))
         else
            (self_insert " " (- lisp_comment_column (cur_hpos))))
         (insert "; ")
         (return))


