; RPG.EM, EMACSSRC>EMACS*>EXTENSIONS>SOURCES, EMACS TEAM-DNK, 06/18/84
; Part 1 of RPG mode macros
; Copyright (c) 1984, Prime Computer, Inc., Natick, MA 01760
;
; RPG mode is used for writing RPG software source.
;
; Modifications:
;
; 06/10/84 DNK       Added appropriate SUI terminal xx_highlights to
;                    various screen-painting macros.
; 04/10/84 cdm       Updated header template for program id. rev 19.4
;                    Also made fixes to calc and output templates.
; 03/02/84 MAM       Fix for lower case card type characters.
; 12/05/83 MAM       More fixes to config
; 11/29/83 MAM       Fixed some config problems, BUT CONFIG NEEDS REWRITING.
;                    Added rpg_force_old$ for old RPG compiler.
;                    Fixed help key problems, added vrpg_off, fixed ruler
;                    template.  Now blanks shadow cursor when turned off.
; 11/24/83 MAM       Changed config variables to be global for all buffers.
; 11/02/83 MAM       Fixed 2->4 lines of template, now overlay_off when rpg_off
; 10/06/83 MAM       More fixes, rpg_set$, rpg_split_window_stay$, rpg_setup$..
; 09/28/83 MAM       Fixed rpg buffer selection and added rpg find_file
; 09/21/83 MAM       Setup mod_select_buf to check for RPG before and after
; 09/06/83 Zane      Re-Built for 19.3
;
; User Visible Commands:
;
;   rpg_on             turns on rpg mode
;   vrpg_on            turns on rpg mode, uses vrpg compiler
;   rpg_off            turns rpg mode off
;   rpg_config         sets various control values
;   rpg_cr$            invokes (cr) and rpg_tab$
;   rpg_tab$           moves to next logical column
;   rpg_template$      enable display of template
;   rpg_kill_template$ disable display of template
;   rpg_help$          tells about what can go at current column
;   rpg_info           function to get/set mode characteristics
;
(defcom rpg_config
&doc "Configure RPG Mode"
  (setq rpg_current$ 'rpg_split_window$)
  (rpg_yesno$  "Enable automatic display of template (current value - ")
  (if (^ (eval rpg_current$))
    (pre_rpg_one_window$)
    (setq rpg_current$ 'rpg_help_sw$)
    (rpg_yesno$
          "Enable automatic display of help in minibuffer (current value - ")
    (if (eval rpg_current$)
      (setq rpg_current$ 'rpg_full_help_sw$)
      (rpg_yesno$ "Use full form for help messages (current value - "))
  else
    (make_rpg_template_window$)
    (setq rpg_current$ 'rpg_show_shadow$)
    (rpg_yesno$ "Enable display of shadow cursor (current value - ")
    (if (eval rpg_current$)
        (rpg_shadow$ true)
     else
        (rpg_shadow$ false))
    (setq rpg_current$ 'rpg_full_template$)
    (rpg_yesno$ "Use full formatted template (current value - ")
    (rpg_shadow$ false)
    (pre_rpg_one_window$)
    (rpg_plater$)
    (rpg_shadow$ rpg_show_shadow$)
    (setq rpg_help_sw$ true)
    (setq rpg_current$ 'rpg_full_help_sw$)
    (rpg_yesno$ "Use full form for help messages (current value - ")
    (sui_refresh)
  )
  (setq rpg_current$ 'rpg_force_old$)
  (rpg_yesno$ "Use OLD RPG not VRPG compiler (current value - ")
  (if rpg_force_old$
      (buffer_info (user language_name$) "rpg")
   else
      (buffer_info (user language_name$) "vrpg")
      )
    )

(defun rpg_yesno$ ( (msg string) &local (tfstring string))
  (setq virgin_msg true)
  (setq msg (catenate msg (ret_bval$) ")"))
  (do_forever
    (info_message " CR - no change; (Y YES T TRUE) - set true; (N NO F FALSE) - set false;")
    (setq tfstring (prompt msg))
    (info_message "")
    (select (upcase tfstring)
      "" (return)
      "Y" "YES" "T" "TRUE" (set rpg_current$ true) (return)
      "N" "NO" "F" "FALSE" (set rpg_current$ false) (return)
     otherwise
      (if virgin_msg
        (setq msg (catenate msg " (Y or N)")))
      (setq virgin_msg false))))

(defun ret_bval$ (&returns string)
    (if (eval rpg_current$)
        (return "YES")
     else
        (return "NO")
    )
)
(defun rpg_info ( &quote (to_eval atom)
                  &eval
                  &optional (new_value any)
                  &returns any )
  (setq retval (eval to_eval))
  (select to_eval
    show_template
     (if (null new_value) (return rpg_split_window$))
     (setq rpg_split_window$ new_value)
    show_shadow
     (if (null new_value) (return rpg_show_shadow$))
     (setq rpg_show_shadow$ new_value)
    show_help
     (if (null new_value) (return rpg_help_sw$))
     (setq rpg_help_sw$ new_value)
    brief_help
     (if (null new_value) (return rpg_brief_help$))
     (setq rpg_brief_help$ new_value)
    brief_template
     (if (null new_value) (return rpg_brief_template$))
     (setq rpg_brief_template$ new_value)
    force_rpg
     (if (null new_value) (return force_rpg$))
     (setq force_rpg$ new_value)
   otherwise
    (info_message "Bad parameter to rpg_info")
    (ring_the_bell)(set_command_abort_flag)(return ()))
  (if (member (find_mode 'rpg) (buffer_info modes))
    (pre_rpg_one_window$)
    (rpg_off)
    (rpg_on))
  (return retval)
)

(defcom rpg_on
  &doc "Turns on RPG mode, defaults to VRPG compiler"
  (if rpg_force_old$
      (buffer_info (user language_name$) "rpg")
   else
      (buffer_info (user language_name$) "vrpg"))
  (xrpg_on))

(defcom vrpg_on
  &doc "Turns on RPG mode with VRPG compiler"
  (buffer_info (user language_name$) "vrpg")
  (xrpg_on))

(defun xrpg_on ()
  (refresh)
  (if (member (find_mode 'rpg) (buffer_info modes))
    (turn_mode_off (find_mode 'rpg)))
  (turn_mode_on (find_mode 'overlay) first)
  (turn_mode_on (find_mode 'rpg) first)
  (2don)
  (rpg_init$)
;  (rpg_hook$)
  (if (null rpg_first_use$)
    (info_message "Use rpg_config to customize RPG mode characteristics")
    (setq rpg_first_use$ false)))

(defun change_go_to_buffer$()
    (fset 'x_go_to_buffer (fsymeval 'go_to_buffer)))

(defun rpg_go_to_buffer((buf_name$ string))
    (rpg_reset$)
    (with_command_abort_handler
        (x_go_to_buffer buf_name$)
        (rpg_setup$)
      command_abort_handler
        (rpg_setup$))
   )

;(defun change_mod_sel_window))
)

; rpg_cr$
;   same as fundamental (cr), but calls rpg_tab$
;
(defcom rpg_cr$
  &doc "RPG carriage return leaves point in column 6"
  (cr)
  (rpg_tab$)
  )

; rpg_tab$
;   If current line is white tab over to column 6, otherwise
;   use the character in column 6 to determine next tab point.
;
(defcom rpg_tab$
  &doc "Forward tab based on current RPG card type"
  (if (> (cur_hpos) 79)
    (return))
  (if (line_is_blank)
    (rpg_tab_to$ 6)
    (return))
  (rpg_smart_tab$ true))

(defcom rpg_back_tab$
  &doc "Backward tab based on current RPG card type"
  (if (< (cur_hpos) 6)
    (rpg_tab_to$ 1)
    (return))
  (if (> (cur_hpos) 80)
    (rpg_tab_to$ 80)
    (return))
  (rpg_smart_tab$ false))

(defun rpg_smart_tab$ ( (rpg_move_forward boolean)
                       &local (rpg_array_offset$ integer) )
  (select (upcase (substr (current_line) 6 1))
    "L"   (setq rpg_array_offset$ 0)
    "I"   (setq rpg_array_offset$ 80)
    "C"   (setq rpg_array_offset$ 160)
    "O"   (setq rpg_array_offset$ 240)
    "E"   (setq rpg_array_offset$ 320)
    "H"   (setq rpg_array_offset$ 400)
    "F"   (setq rpg_array_offset$ 480)
    otherwise  (setq rpg_array_offset$ 400))
  (if rpg_move_forward
    (setq rpg_array_index$ (1+ rpg_array_offset$))
    (setq rpg_array_index$ (+ rpg_array_index$ (cur_hpos)))
    (do_forever
      (if (aref rpg_tabs$ rpg_array_index$)
        (stop_doing))
      (setq rpg_array_index$ (1+ rpg_array_index$)))
   else
    (setq rpg_array_index$ (+ rpg_array_offset$ (cur_hpos)))
    (setq rpg_array_index$ (- rpg_array_index$ 2))
    (do_forever
      (if (aref rpg_tabs$ rpg_array_index$)
        (stop_doing))
      (setq rpg_array_index$ (1- rpg_array_index$))))
  (rpg_tab_to$ (- rpg_array_index$ rpg_array_offset$)))

(defun rpg_tab_to$ ( (where_to integer) )
  (if (^ (go_to_hpos where_to))
    (end_line)
    (whitespace_to_hpos where_to)))

(defcom rpg_template$
  &doc "Enable display of RPG template in top window"
  (setq rpg_split_window$ true)
  (setq rpg_help_sw$ true)
  (make_rpg_template_window$)
  (rpg_plater$)
    (select keybinding$                ; support SUI users' screens
     "pt45"   (pt45_highlight)
     "pst100" (pst100_highlight)
     "pt200"  (pt200_highlight)
     )
)

(defcom rpg_kill_template$
  &doc "Disable display of RPG template window"
  (rpg_info show_template false)
  (one_window)
    (select keybinding$                ; support SUI users' screens
     "pt45"   (pt45_highlight)
     "pst100" (pst100_highlight)
     "pt200"  (pt200_highlight)
     )
)

; rpg_help$
;   displays a line of help info onto the mini-buffer.
;   The help info is chosen from context - card type and current
;   cursor position.
;
(defcom rpg_help$
 &doc "Supply RPG help based on current card type and column number"
 (if rpg_full_help_sw$
     (rpg_helpf$)
     (return))
 (info_message (integer_to_string (cur_hpos)))
 (return))


; rpg_full_help$
;   Always displays the full rpg help message
;
(defcom rpg_full_help$
 &doc "Supply the FULL RPG help based on current card type and column number"
 (rpg_helpf$))

(defun rpg_helpf$ ( &local (column_number integer) )
  (setq column_number (cur_hpos))
  (select (upcase(substr (current_line) 6 1))
    "I" (setq help_msg (rpg_help_input$ column_number))
    "O" (setq help_msg (rpg_help_output$ column_number))
    "L" (setq help_msg (rpg_help_line$ column_number))
    "E" (setq help_msg (rpg_help_ext$ column_number))
    "C" (setq help_msg (rpg_help_calc$ column_number))
    "H" (setq help_msg (rpg_help_header$ column_number))
    "F" (setq help_msg (rpg_help_file$ column_number))
    otherwise
      (if (< column_number 6)
        (setq help_msg " col 1-5 numeric line sequence")
       else
         (if (= 6 column_number)
           (setq help_msg " col 6 - card type - I O F E C L H")
          else
           (setq help_msg " unrecognizable card"))))
(info_message (catenate "@" (integer_to_string column_number) help_msg)))

(defun rpg_make_templates$ ()
(setq rpg_ext_plate$
"                                 #entries
            from   to      table | #/tab    tbl/arr
line E | | file    file    array | |   lt    name  lt      comment
#####-##--########--------######---####---#-#------###-#-######################"
)
(setq rpg_file_plate$
"             desc        lgth RA
           type|eof     mode |        L        max    label      A   switches
line F file   |||  blk rec | |  of key| device rec    exit       U    |
#####-########-#-#-####----#--#-##----#-------######-######------#-##-##-------"
)
(setq rpg_input_plate$
"                       CZD    CZD    CZD               L1-L9  M1-M9
            seq ind      |      |      |                   | |
line I file   |   | pos N| pos N| pos N|   frm  to   field | | indicat
#####-########--#-##----#-#----#-#----#-#-#----####-######--##--##--##---------"
)
(setq rpg_output_plate$
"           type  space       edit code
         AN/OR| |                    | end
line O file  ||F| skip indic   field | pos     edit word
#####-########-#-#--##-##-##-##------#-####-##########################---------"
)
(setq rpg_calc_plate$
"       AN/OR                                      dec
       |                   oper                size| H L E
line C | indicat  factor1    |   factor2  result | | indic  comment
#####-##-##-##-##----------#####----------######---#-##--##--------------------"
)
(setq rpg_header_plate$
"
                     date                           file request      program id
line H              |                              |                      |
#####-##############-##############################-######################------"
)
(setq rpg_line_plate$
"                    overflow
                 FL |
line L file   lns | | OL     comment
#####-########---##---##-------------------------------------------------------"
)
(setq rpg_ruler_plate$
"
         1         2         3         4         5         6         7         8
12345678901234567890123456789012345678901234567890123456789012345678901234567890"
)
)  ; of rpg_make_templates$

(defun rpg_hook$ ()
 (if (^ (member (find_mode 'rpg) (buffer_info modes)))(return))
 (if (& (= (line_number current_cursor) last_rpg_line_number$)
        (= (cur_hpos) last_rpg_hpos$))
     (return))
 (with_no_redisplay
   (if (& rpg_split_window$ (^ (have_input_p)))
     (rpg_plater$)
     (if (& rpg_show_shadow$ (^ (have_input_p)))
       (rpg_shadow$ true)))
   (if (& rpg_help_sw$ (^ (have_input_p)))
     (rpg_help$)
     (setq last_rpg_hpos$ (cur_hpos))
     (setq last_rpg_line_number$ (line_number current_cursor)))))


(defun rpg_plater$ ()
  (if rpg_full_template$
    (setq card_type$ (substr (current_line) 6 1))
    (select(upcase card_type$)
      "I" "O" "E" "C" "L" "F" "H"
          (setq rpg_plate_buf_name$ (catenate "?rpg_plate" card_type$))
      otherwise ())
   else
    