; VIEW.EM, EMACSSRC>EMACS*>EXTENSIONS>SOURCES, TOOLS GROUP-DNK, 11/05/82
; Mode to view a file without modifying it
; Copyright (c) 1982, Prime Computer, Inc., Natick Ma 01760
;
; view           view a file without modifiying it          ^x^v
; view_routine   function that moves to file
; view_on        establishes view mode
; view_off       shuts off view mode
; forward_search_again
;                  repeats the last forward search              n
; reverse_search_again
;                  repeats the last reverse search              p
; may_not_write    prevents writing the view file             ^xs ^x^s
;                                                               ^x^w
;
; Mode Bindings:  {space}     next_page
;                 b           back_page
;                 s           forward_search_command
;                 r           reverse_search_command
;                 <           move_top
;                 >           move_bottom
;
; Global Variables: buffername$


; view
;    Command that starts view mode.
;
;             (view optional-integer)
;
;    If the optional-integer has a value of 4, this shuts off view
;    mode.

(defcom view
     &doc "View a file (view without modifying)"
     (view_routine))


; view_routine
;   Functions that turns on or off view mode.


(defun view_routine (&local (name string)
                            (buffername string))
     (if (= (numeric_argument) 4)
          (view_off)
          (return))
     (setq name (prompt "View file"))
     (mark)
     (setq buffername (buffer_name current_cursor))
     (if (not (= "" name))
          (find_file name))
     (buffer_info (user buffername$) buffername)
     (view_on))

; view_on
;     Command that turns on view mode.
;
;        (view_on)

(defcom view_on
     &doc "Set view mode on current buffer"
     (if (null view_keybindings$)
       (fundamental_view_bindings$))
     (setq view_keybindings$ "loaded")
     (buffer_info changed_ok true)
     (buffer_info read_only true)
     (mark)
     (buffer_info (user buffername$) (buffer_name current_cursor))
     (turn_mode_on (find_mode 'view) first)
     (info_message "NOTE: To exit view mode use 'view_off' or type '^u^x^v'"))

; view_off
;   Command that turns off view mode.  May be invoked by ^u^x^v.
;
;        (view_off)

(defcom view_off
     &doc "Turn off view mode (and turn off changed_ok flag)"
     (turn_mode_off (find_mode 'view))
     (buffer_info changed_ok false)
     (buffer_info read_only false)
     (if (^= (buffer_name current_cursor) (buffer_info (user buffername$)))
         (select_buf (buffer_info (user buffername$)))))


; forward_search_again
;   Command that searches for the next occurrence of a search text
;   in view mode.  In this mode, it is bound as "n".


(defcom forward_search_again
     &doc "Search forward for last string searched for"
     (forward_search_command ""))


; reverse_search_again
;   Command that searches for the next occurrence of a search text
;   in view mode.  In this mode, it is bound as "p".


(defcom reverse_search_again
     &doc "Search backward for last string searched for"
     (reverse_search_command ""))

; may_not_write
;   Command that is essentially a dummy binding for all commands that
;   could write a file accidently in view mode.  It is bound to
;   ^xs, ^x^s, and ^x^w in this mode.


(defcom may_not_write
     &doc "Command to complain about attempts to write file"
     (ring_the_bell)
     (info_message "ERROR: Attempt to write file in VIEW mode"))

(defun fundamental_view_bindings$ ()
  (set_mode_key "view" " " "next_page")
  (set_mode_key "view" "b" "back_page")
  (set_mode_key "view" "B" "back_page")
  (set_mode_key "view" "s" "forward_search_command")
  (set_mode_key "view" "S" "forward_search_command")
  (set_mode_key "view" "r" "reverse_search_command")
  (set_mode_key "view" "R" "reverse_search_command")
  (set_mode_key "view" "p" "reverse_search_again")
  (set_mode_key "view" "P" "reverse_search_again")
  (set_mode_key "view" "<" "move_top")
  (set_mode_key "view" ">" "move_bottom")
  (set_mode_key "view" "^xs" "may_not_write")
  (set_mode_key "view" "^xS" "may_not_write")
  (set_mode_key "view" "^x^s" "may_not_write")
  (set_mode_key "view" "^x^w" "may_not_write")
  (set_mode_key "view" "^x^v" "view"))
