;  SUI_PRIMOS_CMDS.EM,  EMACSSRC>EMACS*>EXTENSIONS>SUI>SOURCES, EMACS TEAM-DNK, 06/20/84
;  Standard User Interface for PT45, PST100, and PT200: PRIMOS-level commands.
;  Copyright (c) 1984, Prime Computer, Inc., Natick, MA 01760

(defcom sui_primos_command
    &doc "SUI:  Library primos_command, with added user feedback"
    (restrict_to_sui$)
    (info_message
"No prefix = Phantom; ! = internal, to file_output; !! = primos_internal_screen")
    (primos_command)
    (sui_refresh)                      ; This SUI-specific highlighting
                                       ; saves user the need
                                       ; to use the ^L key after
                                       ; a primos_command.  ^G will do it ALL.
)                                      ; end of sui_primos_command

(defcom spool
     &doc "SUI:  PRIMOS command:  Prompts for FileName and spools it"
     &args ((filename &prompt "Filename to spool"))
    (with_command_abort_handler
     (save_position
         (if (file_info filename exists)
             (info_message
"Any additional parameters to the SPOOL command:  e.g., -forms white")
             (setq extra$ (prompt "Parameters"))
             (primos_command (catenate "spool " filename " " extra$))
             (redisplay)
             (info_message
 "You will return to your starting display in 4 seconds.")
             (sleep_for_n_milliseconds 1000)
             (info_message
 "You will return to your starting display in 3 seconds.")
             (sleep_for_n_milliseconds 1000)
             (info_message
 "You will return to your starting display in 2 seconds.")
             (sleep_for_n_milliseconds 1000)
             (info_message
 "You will return to your starting display in 1 second.")
             (sleep_for_n_milliseconds 1000)
             (info_message "")             ; clear out the additional prompt
         else
             (ring_the_bell)
             (info_message (catenate "Sorry, file "
                                         filename " does not exist."))
             (sleep_for_n_milliseconds sui_info_message_time$)
             (info_message
"                              Alternatively, you can press CONTROL-G to exit.")
             (setq fname$ (prompt "Please re-enter filename to spool"))
             (spool fname$)            ; try recursively.
         )                             ; end of IF re existence of file.
         )                             ; end of save_position.
  command_abort_handler
  (info_message "")                    ; clear out any junk msgs lying around.
  )                                    ; end of with_command_abort_handler
)                                      ; end of defcom spool

(defcom status
     &doc "SUI:  PRIMOS command: Shows status information"
     &args ((status &prompt
     "(Optional) additional arguments to STATUS command"))
     (statusf$ status)
     )                                 ; call the defun

(defcom stat
     &doc "SUI:  PRIMOS command: Shows status information"
     &args ((status &prompt
     "(Optional) additional arguments to STATUS command"))
     (statusf$ status)
     )                                 ; call the defun

(defun statusf$ ((status string))
     (select keybinding$               ; use the hack that turns off host
                                       ; notification mode till further notice
     "pst100"
     (host_off$))
     (primos_internal_screen (catenate "status " status ";
type STATUS done.  Press CONTROL-G to repaint the EMACS screen."))
     (sui_refresh))                    ; which turns host notification
                                       ; back on again if needed

(defcom listf
     &doc "SUI:  PRIMOS command: Provides a directory listing"
     (listf$)                          ; call the defun
     )

(defcom l
     &doc "SUI:  PRIMOS command: Provides a directory listing"
     (listf$)                          ; call the defun
     )

(defun listf$ ()
     (restrict_to_sui$)
     (select keybinding$               ; use the hack that turns off host
                                       ; notification mode till further notice
     "pst100"
     (host_off$))
     (primos_internal_screen
      "type LISTF at current attach point:;listf;
type LISTF at current attach point done.  ~
Press CONTROL-G to repaint the EMACS screen.")
     (sui_refresh))

(defcom ld
     &doc "SUI:  PRIMOS command: Does an LD, List Directory"
     (restrict_to_sui$)
     (select keybinding$               ; use the hack that turns off host
                                       ; notification mode till further notice
     "pst100"
     (host_off$))
     (primos_internal_screen "type LD at current attach point:;ld;
type LD at current attach point done.  ~
Press CONTROL-G to repaint the EMACS screen.")
     (sui_refresh))

(defcom tld
     &doc "SUI:  PRIMOS command: Provides a `Time-ordered' LD"
     (restrict_to_sui$)
     (select keybinding$               ; use the hack that turns off host
                                       ; notification mode till further notice
     "pst100"
     (host_off$))
     (primos_internal_screen
          "type Time-Ordered LD at current attach point:;ld -long -srtd;
type TLD at current attach point done.  ~
Press CONTROL-G to repaint the EMACS screen.")
     (sui_refresh))

(defcom vld
     &doc "SUI:  PRIMOS command: Provides a `Verbose' LD"
     (restrict_to_sui$)
     (select keybinding$               ; use the hack that turns off host
                                       ; notification mode till further notice
     "pst100"
     (host_off$))
     (primos_internal_screen
          "type Verbose LD at current attach point:;ld -long -srtn;
type VLD at current attach point done.  ~
Press CONTROL-G to repaint the EMACS screen.")
     (sui_refresh))

(defcom attach
     &doc "SUI:  PRIMOS command: Attaches to a different directory"
     &args ((pathname &prompt "New ATTACH point"))
     (attach$ pathname)                ; call the defun
     )

(defcom a
     &doc "SUI:  PRIMOS command: Attaches to a different directory"
     &args ((pathname &prompt "New ATTACH point"))
     (attach$ pathname)                ; call the defun
     )

(defun attach$ ((pathname string))
     (restrict_to_sui$)
     (if (> 1 (string_length pathname))
                                       ; has user just pressed RETURN?
         (info_message "RETURN is equivalent to CONTROL-G")
         (sleep_for_n_milliseconds sui_info_message_time$)
         (abort_command)
         )                             ; end of test of null attach point
     (select keybinding$               ; use the hack that turns off host
                                       ; notification mode till further notice
     "pst100"
     (host_off$))
     (with_command_abort_handler       ; fix things up in case user gives
                                       ; an impossible-to-attach-to dir.
       (primos_internal_quiet (catenate "atta