typedef struct bitmap_node *bitmap_type;


bitmap_type BM_New(int width, int height);
void BM_Clear(bitmap_type bitmap, int col);
void BM_Line(bitmap_type bm, int x0,int y0,int x1,int y1, int col);
void BM_Rect(bitmap_type bm, int x0,int y0,int x1,int y1, int col);
void BM_Arrow(bitmap_type bitmap, int x0,int y0,int x1,int y1, int rgb);
void BM_ArrowArc(bitmap_type bitmap, int x0,int y0,int x1,int y1, int d, int rgb);
void BM_SetPixel(bitmap_type bm, int x,int y, int col);
void BM_Bubble(bitmap_type bitmap, str text, int x, int y, 
			    int rgb_text, int rgb_outline, int rgb_background);
void BM_BubbleIntersect(bitmap_type bitmap, str text, 
				int x0, int y0, int x1, int y1, int *p);
void BM_BubbleSize(bitmap_type bitmap, str text, int *xp, int *yp);
void BM_Display(bitmap_type bm);
str BM_Output(bitmap_type bm);
void BM_Free(bitmap_type bm);
