/*** MAKE.H :  For the MAKE.C module.  Used by JOIN.C. ***/

void InitMake(void);                    // Initialise the Make module
void MakeThis(Make *A);              // Make this entity
void MakeDepends(Make *B);       // Declare that the current entity
					    // depends on B.
void MakeChanged(Make *A, bool InterfaceChanged);
					    // Update this entity's time-stamps.
void MakeAssert(Make *A);         // Check this make_node (debugging)
timestamp_type MakeCurrentStamp(void);
void MakeEntityClear(Make *A);
void MakeDelete(Make *A);        // Destroy this make entity.
void MakeEntityReset(void);             // Informs 'Make' that we are parsing
					    // something from either this editor
					    // position or this string.
void MakeEntityUpdate(Namedobj* obj);    // Update the current make info
					    // into a proper make entity.
Make *MakeEntityNew(Namedobj* obj);
					    // Create a new Make with the
					    // info equiv to M..Update().
Make *MakeDummy(void);
timestamp_type MakeTimeAdvance(void);   // Signal an environment state change.
bool MakeEntityInUse(Make *A);// Is this object in use?  We know
					    // that it is if its check stamp is
					    // the current time-stamp.

