// Sch_evol.cpp
/*
        This module is the implementation of the functions needed in
        order to cope with Schema Evolution in Barbados.
*/

#include <string>
#include "barbados.h"
#include "array.h"
#include "tfc.h"

#include "sch_evol.h"



char* Classdef::getReducedClassdef(void)
{   
        return NULL;
}

#if 0



using std::string;

static string buffer; // static buffer for operations

// ------------------------------------------------------------- ReducedClassdef
// ------------------------------------------ ReducedClassdef::ReducedClassdef()
ReducedClassdef::ReducedClassdef(const char *&desc)
{
        totalsize   = strlen(desc);
        desc_starts = 0;

        // Find the descriptor of the class
        while (desc[desc_starts] != '|'
            && desc[desc_starts] != 0)
                ++desc_starts;

        buffer = (char *) ::malloc(anon_heap, totalsize + 1);

        if (buffer != NULL)
                memcpy(buffer, desc, totalsize + 1);
}

ReducedClassdef::ReducedClassdef(const ReducedClassdef &rc)
{
        if (buffer!=NULL)
        {
                ::free(anon_heap, buffer);
                buffer = NULL;
        }

        if (rc.getTotalDescriptor()!=NULL)
        {
            totalsize   = rc.getTotalSize();
            desc_starts = strlen(rc.getName());

            buffer = (char *) ::malloc(anon_heap, totalsize + 1);

            if (buffer != NULL)
                    memcpy(buffer, rc.getTotalDescriptor(), totalsize + 1);
        }
}

ReducedClassdef::~ReducedClassdef()
{
        if (buffer!=NULL)
        {
                ::free(anon_heap, buffer);
                buffer = NULL;
        }
}

char *ReducedClassdef::getDescriptor() const
{
        if (buffer!=NULL)
                return (buffer+desc_starts);
        else return NULL;
}

char *ReducedClassdef::getName() const
{
        ::buffer = "";
        for (unsigned int n=0;n<(desc_starts);n++)
        {
                ::buffer.push_back(buffer[n]);
        }

        return const_cast<char*>(::buffer.c_str());
}

// -------------------------------------------------------------------- Classdef
// ---------------------------------------------- Classdef::getReducedClassdef()
static char *containsClassdefReference(char *typestr)
{
        int length = LengthOfTypeString(typestr);

        for (; length>0; --length)
                if (*(typestr++) == tp_class)
                        break;

        if (length>0)
                return typestr;
        else    return NULL;
}


char* Classdef::getReducedClassdef(void)
/*
        This function just writes a 'signature' of a classdef, putting in there
        all field names and types.
        If one of the members is a pointer to a class or an embedded class, then
        we write the name of the class.
*/
{
        Namedobj* m = member;
        char *whcld;
        int typelength;

        assert(signature == HELLO_BABE);
        assert(this==myself);

        // First of all, copy the name of the class in buffer
        buffer = typedef_obj->name;
        buffer.push_back('|');

        while(m != NULL)
        {
                // Copy the name of the field
                buffer += m->name;
                buffer += '|';

                // Copy the type of the field
                if ((whcld = containsClassdefReference(m->type)) != NULL)
                {
                        char *wh = m->type;

                        // Copy type string
                        while(wh!=whcld)
                                buffer.push_back(*(wh++));

                        // Copy name of class
                        buffer += (*(Classdef* *) whcld)->typedef_obj->name;

                        buffer.push_back('|');
                }
                else
                {
                        typelength = LengthOfTypeString(m->type);
                        for(unsigned int n=0;n<typelength;++n)
                                buffer.push_back(*(m->type + n));
                        buffer.push_back('|');
                }

                m = m->next;
        }

        return const_cast<char *>(buffer.c_str());
}

#endif
