// sch_evol.h
/*
        Data declarations for schema evolution needs.
*/



/*
        This is used when saving and loading the container.
        * The list of reduced classdef's
          is generated while looking for pointers. When a TypeClass CNSwizz node
          is added to the CNSwizzList, we also store
          the descriptor of the class in the ReducedClassdef table at the very end
          of the container on disk.
        * The list of reduced classdef's
          is built again when the container is loaded in memory. Its information
          is used in order to assure that the objects in this container are of
          the same version of the class which is stored now in the foreign
          container. It is also used to rebuild the class if the foreign
          container is missing.
*/

class ReducedClassdef {
  private:
        char * buffer;
        int desc_starts;
        int totalsize;
  public:
        ReducedClassdef() : buffer(NULL), totalsize(0) {};
        ReducedClassdef(const char *&desc);
        ReducedClassdef(const ReducedClassdef &);
        ~ReducedClassdef();

        char *getName() const;
        char *getDescriptor() const;
        char *getTotalDescriptor() const { return buffer; };
        const int  &getTotalSize() const { return totalsize; };
};


