//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "umodifsh.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TModifyBox *ModifyBox;
extern Inspect *inspection;
//---------------------------------------------------------------------------
TModifyBox::TModifyBox(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
namedobj_type TModifyBox::getWhichOne(void)
{
        TNamedobjList::iterator where;

        where = inspection->objlist.find(list->Text.c_str());
        return where->second;
}

std::string TModifyBox::getNewValue()
{
        return Edit2->Text.c_str();
}

void TModifyBox::Button3Click(TObject *Sender)
{
        ModalResult = 1;
}
//---------------------------------------------------------------------------

void TModifyBox::FormShow(TObject *Sender)
{
        // Prepare window
        Height = 100;
        Button3->Top = Button1->Top;


        if (!inspection->objlist.empty())
        {
          TNamedobjList::iterator l= inspection->objlist.begin();
          list->Items->Clear();

          // Init list
          for(;l!=inspection->objlist.end();++l)
                list->Items->Append((l->first).c_str());
          list->Text = list->Items->Strings[0];


          // Init buttons
          Edit1->Enabled   = false;
          Edit1->Text = "";
          Edit2->Text = "";
          Edit2->Enabled   = false;
          Label2->Enabled  = false;
          Label3->Enabled  = false;
          Button2->Enabled = false;

          list->Enabled    = true;
          Button1->Enabled = true;
          Button1->Visible = true;

          Button3->Left    = 16;
        } else {
          MessageDlg("Sorry, no public objects in this container",
                        mtWarning,
                        System::Set<TMsgDlgBtn, mbYes, mbHelp> () << mbOK, 0);
          list->Enabled    = false;
          Button1->Enabled = false;
          Button1->Visible = false;
          Button3->Left    = (Width / 2) - (Button3->Width / 2);
          Button3->SetFocus();
        }
}
//---------------------------------------------------------------------------
void TModifyBox::Button1Click(TObject *Sender)
{
        namedobj_type obj;
        TNamedobjList::iterator where;

        // Does it exist ?
        if ((where=(inspection->objlist.find(list->Text.c_str()))) != inspection->objlist.end())
        {
                bool simple;

                // Init buttons
                Edit1->Enabled   = true;
                Edit2->Enabled   = true;
                Label2->Enabled  = true;
                Label3->Enabled  = true;
                Button2->Enabled = true;
                Label1->Enabled  = false;
                list->Enabled    = false;
                Button1->Enabled = false;

                // Prepare window
                Height = 233;
                Button3->Top = 168;

                // Prepare the current value
                obj         = where->second;
                Edit1->Text = inspection->printVal(*obj, simple).c_str();
        }
        else MessageDlg("Namedobj not found", mtError, System::Set<TMsgDlgBtn, mbYes, mbHelp> () << mbOK, 0);
}

//---------------------------------------------------------------------------

void TModifyBox::Button2Click(TObject *Sender)
{
        ModalResult = 2;
}
//---------------------------------------------------------------------------

