//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <vector>
#include <sstream>
#include "ushell.h"
#include "uabout.h"
#include "umodifsh.h"
#include "uinspect.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1  * Form1;
Inspect * inspection = NULL;

using std::vector;
using std::string;
using std::ostringstream;

extern vector<string> args;
const bool NOTCR = false;
const bool ERRORS_FOUND = true;

//---------------------------------------------------------------------------
TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void TForm1::BitBtn2Click(TObject *Sender)
{
        RichEdit1->CopyToClipboard();
        BitBtn2->Enabled = false;
        Copy1->Enabled   = false;
}
//---------------------------------------------------------------------------
void TForm1::RichEdit1SelectionChange(TObject *Sender)
{
        BitBtn2->Enabled = true;
        Copy1->Enabled   = true;
}
//---------------------------------------------------------------------------
void TForm1::BitBtn1Click(TObject *Sender)
{
        // This button fires the start of the real program -- the inspection

        // Cleaning
        RichEdit1->Visible        = false;
        RichEdit1->Enabled        = false;
        RichEdit1->Lines->Text    = "";
        msgStatus("Inspecting ...");
        delete inspection;

        // Inspect
        inspection = new Inspect(Edit1->Text.c_str());
        inspection->totalDump();

        if (inspection->getSuccess())
        {
          // Prepare the searching facilities
          if (ComboBox1->Items->Count==0)
          {
            unsigned int i = 0;
            while (*(inspHEADER[i])!='\0')
                ComboBox1->Items->Add(inspHEADER[i++]);
            ComboBox1->Text = ComboBox1->Items->Strings[0];
          }

          interfaceOn();
        } else interfaceOff(ERRORS_FOUND);
}
//---------------------------------------------------------------------------
void puttext(const std::string &x, bool cr)
{
        // Add the text
        Form1->RichEdit1->Lines->Text = Form1->RichEdit1->Lines->Text + x.c_str();

        // Add cr ?
        if (cr)
                Form1->RichEdit1->Lines->Text = Form1->RichEdit1->Lines->Text + '\n';
}
//----------------------------------------------------------------------------

void TForm1::Button1Click(TObject *Sender)
{
        unsigned int FoundAt;

        // Search
        if ((FoundAt=RichEdit1->FindText(ComboBox1->Text,0,
                                         RichEdit1->Text.Length(),
                                         TSearchTypes() << stMatchCase)
            )!=-1)
        {
                RichEdit1->SetFocus();
                RichEdit1->SelStart  = FoundAt;
                RichEdit1->SelLength = ComboBox1->Text.Length();
        }
        else Application->MessageBox("Sorry, Not found.",
                                     "Inspector", MB_OK | MB_ICONERROR);
}
//---------------------------------------------------------------------------


void TForm1::Exit1Click(TObject *Sender)
{
        exit(EXIT_SUCCESS);
}
//---------------------------------------------------------------------------


void TForm1::OpenClick(TObject *Sender)
{
        // Load a DLL name into the Field
        if (OpenDialog1->Execute())
                Edit1->Text  = OpenDialog1->FileName;
}

//---------------------------------------------------------------------------
void TForm1::FormCreate(TObject *Sender)
{
        // Window Width
        Constraints->MinWidth = Width;
        Constraints->MinWidth = Width;
        Constraints->MaxWidth = Width;
        Constraints->MaxWidth = Width;

        // Window Height
        Constraints->MinHeight = Height;
        Constraints->MinHeight = Height;
        Constraints->MaxHeight = Height;
        Constraints->MaxHeight = Height;

        // Put the argument of the application as the content of the edit box
        if (args.size() > 0)
        {
                Edit1->Text = args[0].c_str();
                BitBtn1Click(this);
        }
        else
        {
                Edit1->Text = "";
                interfaceOff();
        }


}

//---------------------------------------------------------------------------
void TForm1::About1Click(TObject *Sender)
{
        AboutBox->ShowModal();
}

//---------------------------------------------------------------------------
void TForm1::Modify1Click(TObject *Sender)
// Modify the values in the current container
{
        int result;

        // Call the third window, in order to know what the user wants to
        // modify
        result = ModifyBox->ShowModal();

        // Now, modify it
        if (result == 2)
        {
                inspection->Modify(ModifyBox->getWhichOne(), ModifyBox->getNewValue());
                RichEdit1->Lines->Text    = "";
                inspection->totalDump();
        }
}

//---------------------------------------------------------------------------
void TForm1::msgStatus(const string &t)
{
        stat->Panels->Items[0]->Text = t.c_str();
}

void TForm1::msgProgress(const string &x)
{
        stat->Panels->Items[1]->Text = x.c_str();
        Application->ProcessMessages();
}

void putProgress(long int done, long int remaining)
{
        ostringstream o;

        o << done << '/' << remaining;

        Form1->msgProgress(o.str());
}

void TForm1::BitBtn6Click(TObject *Sender)
{
        // Cerrarlo todo
        delete inspection;

        interfaceOff();
}
//---------------------------------------------------------------------------

void TForm1::interfaceOff(bool error)
{
        msgProgress("");
        ComboBox1->Enabled = false;
        Button1->Enabled   = false;
        RichEdit1->Enabled = true;
        RichEdit1->Visible = true;
        BitBtn4->Enabled   = false;
        Modify1->Visible   = false;
        BitBtn6->Enabled   = false;
        if (error)
                msgStatus("Ready - with errors");
        else    msgStatus("Ready");
}

void TForm1::interfaceOn()
{
        msgProgress("");
        ComboBox1->Enabled = true;
        Button1->Enabled   = true;
        RichEdit1->Enabled = true;
        RichEdit1->Visible = true;
        BitBtn4->Enabled   = true;
        BitBtn6->Enabled   = true;
        Modify1->Visible   = true;
        msgStatus("Ready");
}
