#include "header.h"



typedef int int4;			// It must be explicit where disk formats are concerned.

typedef unsigned char uchar;

typedef int4 container_id;		// Container id's

typedef uchar *ins_type;		// A pointer to a Pentium instruction

typedef void (*machinecode_type)(void);	// A nameless "void (void)" function.
                                        // Use this for user-level compiled code

typedef ins_type funcblock_type;	// A pointer to the entry point of a
                                        // Barbados-compiled function. Use this
                                        // for all internal functions and code
                                        // under construction.

typedef int timestamp_type;

typedef void (*PtrProcessor_fn)(void **addr);
typedef void* (*PtrFinder_fn)(void *addr);
typedef int (*cmp_fn)(const void*, const void*);






/*---------- Meta-classes (NamedObj, Any, Type, Directory): -----------*/

typedef enum { unknown_storage,
		static_storage, perprocess_storage, perthread_storage, local_static,
		member_storage, inherit_storage,
		auto_storage, parameter_storage, const_storage, 	
		straight_fn, member_fn,	oneinstr_fn, virtual_fn, inline_fn,
		typedef_storage, macro_storage, keyword_storage
	} storage_enum;

typedef enum { debug_visibility/*see everything*/, private_visibility,
                protected_visibility, public_visibility }
	    visibility_enum;

typedef enum { tp_error='!', 
	    // Datums:
	    tp_void='v', tp_bool='b', tp_char='c', tp_uchar='B',
	    tp_short='2', tp_ushort=':', tp_int='i', tp_uint='u',
            tp_long='l', tp_ulong='L',
            tp_float='f', tp_double='g', tp_longdouble='G',
	    tp_int64='8', tp_container='C',

	    // Building blocks:
	    tp_class='{', tp_pointer='*', tp_reference='&', tp_enumerated='e',
            tp_array='[', tp_dynarray='A',
	    tp_function='(', tp_terminated=')', tp_ptrmemberfn='m',
            tp_volatile='~', tp_const='K',

} tp_enum;
	    /* NB:- tp_class covers classes, unions and structs.   */
	    /* 'tp_enumerated' is the only one in the datum section */
	    /* which requires additional info (a 4-byte ptr). */
	    /* NB2:- 'tp_long' is a different type to 'tp_int' even */
	    /* though they are both 32-bit integers: this is to be  */
	    /* compatible with programs that overload functions     */
	    /* with int's and long's. */


typedef unsigned char* Type;   // Points to byte-size `tp_enum's.
class Classdef;
class Namedobj;
class Any;
class Directory;
class Make;
class DebugInfo;


class Classdef {                // Classes, structs & unions
public:
	int4 RoundupSize;	// = size + 4 and rounded up to next allowable
        			// tile size.  -1=pure virtual class.
	#define HELLO_BABE  0xe110babe
	int4 signature;		// Should equal HELLO_BABE.
				// Used for checking that malloc blocks are not corrupt.
	int4 size;		// Number of bytes used by an instance of this class
	int4 def_len;		// Length of definition block
	Classdef *myself;       // Points to this.  Used for checking whether a
				// class definition is swizzled or not.
	Namedobj *typedef_obj;
        void **Friends;		// A dynamic array of pointers to Namedobj's
        			// or classdef's.
	Namedobj *member;       // The root of the linked list of members
        PtrFinder_fn ptrfinder; // A function that finds all pointers in an object.
                                // See the documentation on 'Pointer-finder functions'.
	void** VirtualFns;	// During construction, this is a dynamic array. After
				// construction, it stores the length of the array with
				// the array following directly on after this object.
				// The reason for this rather complicated system is that
				// during swizzling, we want to swizzle a class definition
				// in a single transaction and avoid half-swizzled class
				// -definitions;  and by putting the virtual-fn table into
				// the same physical heap tile, we take advantage of the
				// tile-based swizzling; and it lets us perform a virtual
                                // function call with just a single dereference.
        char* getReducedClassdef(void);
        bool ValidClassdef() { return ((int)signature & ~1) == HELLO_BABE; }
};



#define each_dir_obj(dir)	    h=dir->_It1(); (int)--h >= 0; ) for (obj=dir->_It2(h); obj; obj=obj->next


class Directory {
public:
	Namedobj **Hash;
	uint Hash_len, NumEntries;
	void Resize(uint newsize);
	void InsertSimple(Namedobj *obj);
	bool DeleteSimple(Namedobj *obj);
	uint CalcHash(str name);

public:
	Directory *parent;
	container_id parent_cid;

public:
	void init(Directory* dir);
	/* Initialise a new directory: a child of 'dir'. */

	void Insert(Namedobj *obj);
	bool Delete(Namedobj *obj);
	/* Insert & delete named_obj's into this directory. */

	Namedobj* Find(str name);
	/* Find the first object of this name in this directory. */

	Namedobj* FindDirObj(str name, bool include_dirrefs, bool include_containers);
	Directory *FindDirectory(str name);
	/* Find the first directory/container object of this name. */

	Namedobj** FindExistingObjp(str name,
			Type type, bool AllowOverload, uint *overload_versionp);
	/* Search this directory for an object with the same name. */
	/* If we find one, then either we need to overwrite it or  */
	/* overload the name.  If we need to overwrite it, then    */
	/* return a pointer to the pointer we need to update. Else */
	/* return a pointer to a NULL. */

	Namedobj** SetFind(str name, Namedobj **A);
	/* Find ALL objects of this name in this directory,	*/
	/* and append them to the array A (default value=NULL).	*/
	/* Return 'A'. */

	Namedobj* SearchMeAndChildren(str name, char errormsg[]);
	Namedobj** SetSearchMeAndChildren(str name, Namedobj** A);
	/* As above, but if it doesn't find anything then it also */
	/* goes to the second level: it searches the immediate	  */
	/* child directories of the current directory. If it does */
	/* find at least one object in the current directory then */
	/* it stops there.  Used for resolving identifiers found  */
	/* in source-code. */

	Namedobj* ObjFromUname(str name);
	/* Look up the object with this uname. The uname is the name	*/
	/* with the '::' notation for member functions and the '	*/
	/* notation for overloaded functions. */

	bool Empty() { return Hash_len == 0; }
	/* Is this directory empty? */

        uint &getHashLen(void) { return Hash_len; }
        Namedobj** &getHash(void) { return (Namedobj **)Hash; }
        /* Get information about the directory without allowing modification */

	uint _It1() { return Hash_len; }
	Namedobj* _It2(uint h) { return Hash[h]; }
	/* This is for iterators. */

};


class Any {
public:
	Type type;
	void * value;
};


class Ostream {
public:
	str buf;			// The destination buffer
	str buf_end;			// How far can we write in this buffer?
	str s;				// Where are we up to?  buf <= s <= buf_end
	bool line_buffering;		// Flush on each newline
	int (*flush)(void);		// What do we do to flush it?  returns yes=success
};


class Namedobj {
public:
	str name;			// The name
	Type type;		        // The type
	storage_enum storage;		// The storage class.
	visibility_enum visibility;	// public/private/protected.
	char overload_version;          // For making overloaded names unique.
	class Make *make;		// Make information.
	void *owner;			// Either a classdef or a directory.
	Namedobj *next;		        // (For a linked lists of obj's)
};

// Namedobj's are created in name.cpp's CreateObj(), compdecl's CreateAutoObj()
// and in compLex's initialisation of the keyword array.
// The only storage class which uses an unadorned Namedobj is typedef_storage.


class StaticNamedobj : public Namedobj {
public:                                 // for static_storage & local_static
        void* location;
};


class FieldNamedobj : public Namedobj {
public:                                 // for member_storage & inherit_storage
        int offset;
};


class MacroNamedobj : public Namedobj {
public:                                 // for macro_storage
        str macro;
};


class LocalStaticNamedobj : public StaticNamedobj {
public:                                 // for local_static
        LocalStaticNamedobj *nextlocal;
};


class FunctionNamedobj : public Namedobj {
public:                                 // For all function storage-classes
        union {
            funcblock_type fn;          // Use this for static_fn & member_fn's
	    int virtualfn_idx;		// Use this for virtual_fn's
	    struct {			// Use this for oneinstr_fn's
		char o;
		char tp;
	    } ipr;
        } u;
        char CallingConvention;         // Currently unused
        int MinimumArity;               // For default parameters
        char* DefaultParameters;        // The data for default parameters.
                                        // For the first default parameter,
                                        // take the first <n> bytes of this
                                        // buffer. For the second, take the
                                        // next <m>, and so on.
                                        // So far we only implement constant
                                        // values, not expressions as we should.
        Classdef **Throws;              // A list of exceptions that can be thrown
};


class IntNamedobj : public Namedobj {   // for enums & keywords
public:
        int constval;
};



class Make {
public:
	Namedobj *obj;                  // The object that it's for.
	struct {                        // Instructions for recompilation
	    str s;			//  - the C++ text
            DebugInfo *dinfo;           //  - debug mapping information
	    Directory *dir;	        //  - the directory.  For non-members,
                                        // this is just obj->owner.
	} source;                       //
	timestamp_type compile_stamp;   // When was it last compiled?
	timestamp_type interface_stamp; // When was the interface last changed?
	timestamp_type check_stamp;     // When was it last checked?
	int NoOfCompilations;           // How many times compiled this make?
	Make *next;                     // For the free list and container makes
	Make **depends_on;              // The list of entities it depends on.
};



#define BARBADOS_SIGNATURE 0xBABAD200   // This should change with any Barbados
                                        // big change in the format of Conim's
                                        // disk. The last byte is the Barb
                                        // format of containers in disk version.
#include <time.h>

struct ContainerHeader {
        int container_signature;        // It must equal BARBADOS_SIGNATURE
	void* base_address;		// What address is this relative to?
	int4 lin_start;			// The offset from the header to
					// the CNSwizzList and the ReducedClassdefList.
	time_t interface_change;	// What time did the interface last change?
	time_t remake;			// What time was the container last recompiled?
        time_t timestamp;               // What time was the container saved ?
	Directory dir;			// The root object
};







/*----------------------- Global variables: --------------------*/

extern uchar /* Type's: */
		any_typstr[], ostream_typstr[], tyex_typstr[],
		direc_typstr[], container_typstr[], dirref_typstr[],
		bool_typstr[], ptrclassdef_typstr[], bitmap_typstr[],
		voidvoidptr_typstr[], voidptr_typstr[], string_typstr[],
		uint_typstr[], int_typstr[], typetype_typstr[],
		voidvoidfn_typstr[], containerheader_typstr[],
                file_typstr[], *classdef_typstr;
extern uchar namedobj_typstr[], staticnamedobj_typstr[],
                macronamedobj_typstr[], functionnamedobj_typstr[];
extern Classdef *AnyStruct, *OstreamStruct, *DirecStruct, *TypeStruct,
		*ClassdefStruct, *NamedobjStruct, *BitmapStruct,
                *ContainerHeaderStruct;
extern int enum_value;
extern Namedobj* debug_obj;
extern int debugging;
extern long L;
extern bool PredefinitionPhase;
extern bool ClosingDownPhase;


#define GetDimension(dim,type)  dim = *(*(int**)&type)++
#define PutDimension(dim,type)  *(*(int**)&type)++ = dim
#define GetPtr(ptr,type)        ptr = *(*(Classdef ***)&type)++
#define GetPtrE(ptr,type)       ptr = *(*(Namedobj***)&type)++
#define PutPtr(ptr,type)        *(*(void***)&type)++ = ptr

#define AssgPtr(l,r)            memcpy(l, r, sizeof(str))
#define CompPtr(l,r)            memcmp(l, r, sizeof(str))
#define DynVector(dyn)          (*(void**)dyn)
#define DynLength(dyn)          (*(int*)((void**)dyn + 1))



size_t TypeSize(Type type);
size_t TypeSizeWord(Type type);
int LengthOfTypeString(Type type);
Type EndOfTypeString(Type r);
Type TypeAppend(Type d, Type suffix);
bool TypeEqual(Type a, Type b);
bool TypesNearlyEqual_i(Type *ap, Type *bp);
bool TypesNearlyEqual(Type a, Type b);
tp_enum TpToSigned(tp_enum tp);
void TypeCopy(Type dest, Type src);
bool EqualFootprint(Type func, Type footprint);
bool TypeValidated(Type type);
bool TypeIsBigStruct(Type type);		// a tp_class which is > 4 bytes
int TpSize(tp_enum tp);				// classes return '9999'.
bool TpIsIntegral(tp_enum tp);
bool TpIsUnsigned(tp_enum tp);
char TpGroup(tp_enum tp);
/* What kind of tp is this?  'i'=integral, 'f'=fpu, '\0'=other. */
/* Enums are counted as '\0'. */

Classdef * TypeToClassdef(Type type);
Type TypeFunctionReturnType(Type type);
int TypeFunctionArity(Type type);
int EncodeBitField(int offset, int bit_offset, int bit_width);
void DecodeBitField(int x, int *offsetp, int *bit_offsetp, int *bit_widthp);
void OutputType(Ostream* out, Type type);
str StorageToString(storage_enum storage);
str TypeToString(Type type, char dest[], int sizeofdest);
void InitProvisionalTypstrs();
bool IsCharArray(Namedobj* obj);
bool IsDirectory(Namedobj* obj, bool include_dirref, bool include_containers);
bool IsConstructor(Namedobj *obj);
bool IsDestructor(Namedobj *obj);
bool TypeHasConstructor(Type type);
bool TypeHasDestructor(Type type);
FunctionNamedobj* ClassDefaultConstructor(Classdef *classdef, Namedobj **any_constructor);
bool BisBaseOfD(Classdef *bclass, Classdef *dclass, int *offset);
        /* Returns true if the 1st parameter is equal to or a base class  */
        /* of the second parameter.  Return also via '*offset' the offset */
        /* of the base class (quite often zero). */


uint SizeofObj(str name, Type type, storage_enum storage);
	/* What size would we need for this named object? */


#define each_member(classdef)   Namedobj* obj=classdef->member; obj; obj=obj->next
#define objLocation          (((StaticNamedobj*)obj)->location)




/*--------------- Finding pointers: ---------------*/

void CallPtrFinder(PtrFinder_fn ptrfinder, void *address, PtrProcessor_fn fn);
void FindPtrs(void* p, Type typestr);
Type FindPtrsInTypstr(Type typestr);

void* WriteSwizzledToCorrect(void* ptr, PtrProcessor_fn fn);
	/* I don't think I need this one. */

uint MsizeSwizzled(void* ptr);
	/* What is the size of this block? ptr has already passed through 'fn'. */

void FindPtrsInFuncblock(funcblock_type funcblock, PtrProcessor_fn fn);
	/* This is actually implemented inside COMPCODE.CPP which is the */
	/* only module that understands Pentium machine-code. */

void ProcessRelativePtr(int* ptr, PtrProcessor_fn fn);
	/* Process this pointer-relpointer with function 'fn'. */




#define WordAlign(w)    (w = ((w-1) | 3) + 1)
#define WordAlignPtr(w) (w = (str)((((int)w-1) | 3) + 1))





/*----- Misc: -----*/

#undef max
#undef min
int max(int a, int b);
int min(int a, int b);
str my_strncpy(str s, str t, int count);
void stop(void);
void debug(int n);
bool streq(str a, str b);




/*----- Error reporting: -----*/

enum err_enum { err_none, err_make, err_maybe, err_certain, err_runtime,
                err_pleaselinksrc } ;

typedef struct error_node {
	err_enum err;
	str message;     // The error-message
	str src;         // The str we are currently compiling
	str pos;         // The position in this str
} *error_type;


extern struct error_node Error;
void ErrorType(str src, str mess, ...);
void ErrorRun(str mess, ...);
void ErrorWarning(str mess, ...);
void ErrorMake(str mess, ...);



/*-------- Ostreams: ----------*/
#define BITMAP_CHAR	4

extern Ostream* cout;

bool OstreamFlush(Ostream* out);
int OstreamPutch(Ostream* out, int ch);
int OstreamPuts(Ostream* out, str s);
int OstreamPrintf(Ostream* out, const str fmt, ...);


/*-------- Stdout: ---------*/
int  flush_stdout(void);
void flush_display(void);
void InitStdio(void);
int  Pr(const str fmt, ...);
void CoutPuts(str s);
bool IoMessage(char* title, char icon, char* text);


#define printf	    Pr




/*--------- Debug output: --------*/
void Trace(str format, ...);
void TraceMode(bool to_file);



/*-------- The heap: ---------*/

extern class Heap *default_heap, *anon_heap;

void* malloc(class Heap*, uint size);
void* calloc(class Heap*, uint size, uint num);
void* realloc(class Heap*, void* mem, uint size);
void  free(class Heap*, void *mem);
char* strdup(class Heap*, str s);
uint  msize(void*);
/* In Barbados, we have many heaps (each open container is a heap). 	*/
/* Therefore, in order to avoid confusion, every call to malloc/	*/
/* realloc/etc. must explicitly specify which heap we want.  No file in */
/* the Barbados project should have any of the original calls to these  */
/* functions (with the exception of TFC).  				*/
/*	If you just want some temporary ie. non-persistent memory, then */
/* pass 'anon_heap' to the function.  If you want to create an object	*/
/* in the user's current container, use 'default_heap'.			*/
/*	This system avoids the problems we were having before of how to */
/* force the compiler to link with our versions of 'malloc' etc. instead*/
/* of the LIBC versions. */


void HeapCheck(container_id cid);
void ConimRealCloseAll();



/*--------- Keeping breakpoints up-to-date: ---------*/
void DebugBodyDeleted(Namedobj* obj);
void DebugBodyRecompiled(Namedobj* obj);
void DebugDeleteObj(Namedobj* obj);
void DebugCloseContainer(class Conim *conim);



