#include "barbados.h"
#include "graph2d.h"
#include "memory.h"
#include "source.h"
#include "browse.h"
#include "bitmap.h"
#include "name.h"



static graph_type G;
static int depth;
static bool JustFunctions;


static void RecurseOn(Make *M)
/* Add this entity to the graph. */
{       Make **dp;

	if (GraphAddVertex(G, M, M->obj->name,
		    (M->obj->storage == typedef_storage) ? 1 : 2)) {
	    if (M->depends_on == NULL)
		return;
	    for (dp=M->depends_on; *dp; dp++) {
		if (JustFunctions) {
		    Namedobj* obj = (*dp)->obj;

		    if (obj->storage != straight_fn)
			continue;
		}
		depth++;
		if (depth < 10)
		    RecurseOn(*dp);
		depth--;
		GraphAddEdge(G, M, *dp, 15);
	    }
	}
}


interface void BrowseObj(Namedobj* obj, bool _JustFunctions)
/* Construct and display a dependency graph from 'obj'. */
{       bitmap_type bm;

	SourceLinkSource(Conim::Ptr_to_conim(obj), no);
	G = GraphNew();
	depth = 0;
	JustFunctions = _JustFunctions;
	if (obj->make)
	    RecurseOn(obj->make);
	bm = GraphToBitmap(G);
	BM_Display(bm);
}


interface void BrowseWord(str word, bool JustFunctions)
{       char errormsg[512];
	Namedobj* obj;

	obj = curdir->SearchMeAndChildren(word, errormsg);
	if (obj)
	    BrowseObj(obj, JustFunctions);
}


interface void BrowseConims(void)
/* Display a graph of all open containers. */
{       bitmap_type bm;

	G = Conim::LinkGraph();
	bm = GraphToBitmap(G);
	CoutPuts(BM_Output(bm));
	BM_Free(bm);
}