#include "editor.h"


class C_Editor : public EditorWin {
	bool HistoryAtStartOf(Line* ln);
	bool HistoryUp();
	bool HistoryDown();
	void HistoryClear();
	Line*HistoryDisplay(Line* lower);
	void HistoryInsert(Line* ln, bool goto_bottom);
	void HistoryMode();

public:
	bool NotifyCompileable;
        TfcFont font;

	C_Editor(str caption, int width, int height);
	void Paragrapher(Paragrapher_type P);
	bool MoveUp(Line* ln);
	bool MoveDown(Line* ln);
	int DefineState(Line *ln);
        void Save();
	/* Editor stuff. */
	
	bool Include(str filename);
	/* Insert the text file with this name into the editor. */

	void ClearErrorLines();
	/* Clear all error lines in the current compileable entity. */

	void ClearOutputLines(void);
	/* Clear all <<< output lines near the current location. */

        void GetPhraseAtCursor(char dest[], int sizeofdest);
        /* If there's a 1-line selection, take that, otherwise take the */
        /* word at the cursor. */

	Line* NewLine();
	/* Construct a special CLine. */

	TfcFont thisfont() { return font; }
	/* Return the current default font. */

	void InsertLineB(Line* ln, bool abovecurrent, str s, char type, bool moveto);
	/* Insert this line either above or below the current line. */
	/* Then, if requested, we move onto this line.  No undo info*/
	/* is created. */

	void DeleteLineB(Line* ln);
	/* Delete this line from the editor and call its destructor. */
	/* Don't create any undo info. */

        bool Keystroke(int key);
        /* Catch a keystroke on its way through. */
};


extern C_Editor* CompilerEditor;

