/*** COMPILER.H :   The internal header file for the compiler ***/
/***                super-module.  Used by COMP*.CPP.         ***/

#ifndef MODULES_H
#include "modules.h"
#endif

#ifndef IPR_H
#include "ipr.h"
#endif





#define op_sing(c) (token_enum)(c-142)
#define op_assg(c) (token_enum)(c-131)
#define op_doub(c) (token_enum)(c-128)
#define op_shft(c) (token_enum)(c-136)
#define op_unry(c) (token_enum)(c-103)

#define sizeofarray(a)  (sizeof(a) / sizeof(a[0]))
#undef EOF
#define EOF	    ((token_enum)-1)




typedef enum { undefd_tok,
	/*-----Expression things: */ identifier,
	int_const, long_const, float_const, char_const, string_const,
	open_round, close_round, open_square, close_square, open_brace,
	close_brace, semi_colon, ternary, dot, comma, arrowtok,
	colon, double_colon,
	/*-----keyword commands: */ kw_keywords,
	kw_new, kw_delete,  kw_while, kw_for, kw_if, kw_do, kw_switch,
	kw_return, kw_case, kw_default, kw_else, kw_goto, kw_continue, kw_break,
	/*-----Declaration words: */ kw_declare,
	kw_public, kw_private, kw_protected, kw_friend,
        kw_typedef, kw_extern, kw_static, kw_virtual, kw_inline,
        kw_enum, kw_struct, kw_union, kw_class,
        kw_operator, kw_bool, kw_char, kw_short, kw_int, kw_long, kw_float,
        kw_double, kw_void, kw_container, kw_signed, kw_unsigned, kw_int64,
	kw_const, kw_volatile, kw_type,
	/*-----Operators: */
	kw_sizeof, kw_typeof, kw_true, kw_false,
	kws_identifier_path, kws_instruction, kws_directory, last_token,
        op_init=-14, op_funccall=-15
} token_enum;



typedef struct {
	Type type;
	int ref;
} type_plus_ref;


typedef int instr_offset;




/*------ Program Trees: -------*/


struct ForStatement : public Statement {
	Statement* Init, *Body;
	Expr *Test, *Incr;
};


struct WhileStatement : public Statement {
	Expr* Test;
	Statement* Body;
};


struct DoStatement : public Statement {
	Expr* Test;
	Statement* Body;
};


struct GotoStatement : public Statement {
	str label;
	Statement* destination;
};


struct CaseStatement : public Statement {
	int tag;
	Statement* Body;
};



#define kws_code    kw_struct






/*------------- COMPLEX.C --------------*/

extern struct token_struct {
	int x;                          // What char in buf are we up to?
	int4 int_val;
	long long_val;
	double float_val;
	Namedobj *stdlib_obj;          	// Resolved via Stdlib
        Namedobj *curdir_obj;		// Resolved via curdir
        Namedobj *local_obj;		// Resolved via local objects
        Namedobj *pathobj;		// For pushed-back kws_identifier's.
	str src;                        // What character does it start on?
	token_enum en;                  // -ve's are operators, +ve's are as above.
        struct token_struct *next;      // For lookahead and pushback
	char buf[100];                  // What's the full text of the token?
} tok;



void LexicalInit(void);
void LexicalClose(void);
token_enum NextToken(void);
void Gobble(token_enum expected);
void SkipTo(token_enum t);
void CompileBegin(str s);
token_enum LookAhead(void);
void PushTokenBack(token_enum new_tok, Namedobj *pathobjs, str src);
void FreeMacroExpansions();

void ErrorParse(str src, str mess, ...);
void ErrorType(str src, str mess, ...);



/*------------- COMPEXPR.C --------------*/

/* Type's: */
extern uchar     err_typstr[], void_typstr[], char_typstr[], int_typstr[],
		    long_typstr[], float_typstr[], string_typstr[],
		    direc_typstr[], typetype_typstr[],
		    any_typstr[], ostream_typstr[],
		    bool_typstr[], seg_id_typstr[], dirseg_typstr[],
		    voidptr_typstr[], bitmap_typstr[], file_typstr[],
                    ambiguous_typstr[], virtualfntable_typstr[];


/* Special operators: */
#define op_instr    open_brace
#define ostr_const  kw_struct
#define direc_const kws_directory
#define op_output   kw_default
//#define op_funccall   open_round


#define expr_to_tr(e)   *(type_plus_ref*)&(e)->type


Type GetArrayOfType(Type type, int dim);
Type GetPointerToType(Type type);
type_plus_ref GetTypePlusRef(Type type);
Type CopyIntoTypebuf(Type type);

Expr* ExprGetRvalue(Expr* e);
Expr* ExprGetLvalue(Expr* e);
Expr* ExprConvert(Expr* e, type_plus_ref tr);
Expr* ExprRvalue(Expr* e);
Expr* ExprDuplicate(Expr* e);
Expr* ExprDeref(Expr* e);
void DecorateExpr(Expr* e);
Expr* GenerateFunctionCast(void);
void CheckFunctionReturningBigStruct(Expr* e);
Expr* ReturnRefExpr();
void MethodInit(void);
Expr* NewMemberAddress(Namedobj *obj, str src);
void InsertDestructorCalls();              // Also checks for skipping initialisations


typedef void (*ParamChecker_fn)(exprf_type ef);

ParamChecker_fn FindParamCheckerFn(Namedobj* method);
void SetParamCheckerFn(Namedobj* method, ParamChecker_fn CheckFn);




/*------------------ COMPRESOLVE.CPP: ------------------*/

extern struct Resolved_node {
        int offset;		// Usually 0, used for multiple inheritance.
        Namedobj** list;        // If there are multiple objects of the same name
        			// (overloaded functions), then this will contain
                                // all applicable functions, including the one
                                // that was returned formally. But if there is
                                // only one applicable object, this will be NULL.
        Namedobj *obj;		// Filled out if any object is found.
} ResolveInfo;

extern char ResolveErrormsg[512];	// Filled out in case of ambiguity


// In name.cpp there is:
//	Namedobj* NameLocalResolve(str name);

Namedobj* ResolveMember(Classdef* classdef, str name,
		visibility_enum visibility);	// For class members
Namedobj* ResolveGlobal(str name);		// Ignores locals & members
Namedobj* Resolve(str name);			// Locals,members,globals
Namedobj* ResolveTok(Classdef* classdef);	// An optimised Resolve().
	// These all return a single Namedobj*, and additional information
        // via 'ResolveInfo'.

Namedobj ** qcopyobjlist(Namedobj ** list);
        /* Copy a dynamic array of namedobjs into the compiler heap. 	*/
        /* Do this because we want the compiler memory allocation	*/
        /* to apply to this set.  However, note it means you can't	*/
        /* add to or delete from or free this dynamic array. 		*/
        /* It frees the list you pass it. */

bool IsPublicBaseClass(Classdef* base, Classdef* derived);
	/* Is 'base' a public or protected base class of 'derived'? */




/*------------- COMPPARS.C --------------*/

extern FunctionNamedobj* MainEntity;
//extern Namedobj PathObj;
extern Classdef* this_class;
extern Type expression_type;
extern StaticNamedobj* two_dots_obj;
extern AutoNamedobj* this_obj;
extern type_plus_ref tr;


bool AtTypeExpression(void);
Expr* ParseExpr(bool StopAtComma);
Expr* ParseIntExpr(bool StopAtComma);
int ParseAndEvaluateIntExpr(bool StopAtComma);
void AddInitialisingExpr(Expr* e);
void ParseInitialisation(Namedobj* obj);
Expr* ParseConstructorExpr(Type type, Expr* this_expr);
Namedobj* ParseConformingArray(Directory *declaration_directory,
                str name, Type type, storage_enum storage, int options);
        /* Like above, but we don't have 'obj' yet because we don't know */
        /* what size the array will be.  Parse the data and then declare */
        /* 'obj' accordingly. */

void ParseFunctionDefinition(FunctionNamedobj* obj);
void DeleteIdentifier(Namedobj* obj);
Expr* DestructorCall(Type type, Expr* ptre, Expr* calle, bool array_delete);
void ParseOperatorName(char dest[]);
Namedobj* ParsePath(void);
Namedobj* FindTypedefObj(Type type);
int AllocateLocalStatic(uint size, Type type);
int SizeOfFunction(FunctionNamedobj* obj);
Expr* ExprCopyOfTypestring(Type type, bool store_in_code);
Expr* NewExprIdentifier(Namedobj *obj);
Expr* NewExprIdentifier(AutoNamedobj *obj);
Expr* NewExprIdentifier(Resolved_node *res);
Expr* NewExprVoidptr(void *v);
Expr* ErrorExpr(void);
Expr* PushSPPlusExpr(int framesize, int typesize);

void *qmalloc(int n);
bool qptrcheck(void* p);
void* NewStatement(token_enum statement);
void ExprTreeClear(void);

machinecode_type Compile(str s);





/*------------- COMPDECL.C --------------*/

extern storage_enum storage, default_storage;
extern str UndefinedFunctionCallSrc;
extern Namedobj* UndefinedFunctionCall;
extern str param_name[100];		// The parameter names
extern unsigned int pn_idx;		// An index into the above
extern Directory* declaration_directory;
extern Namedobj *context_fn;		// What function are we now defining?
extern Classdef *context_class;	        // What class's namespace are we 'in'?
extern int auto_offset, max_auto_offset;// For storage of auto variables
extern Classdef* declarator_class;


bool TypeValidated(Type type);
void ParseDeclaration(void);
Type ParseTypeExpression(void);
void DeclareInit(void);
size_t TypeSize(Type type);
size_t TypeSizeWord(Type type);
int LengthOfTypeString(Type type);
Type ParseBaseType(Type type);

AutoNamedobj* CreateTemporaryVariable(Type type);
	/* Create a temporary local variable of this type. */




/*-------- COMPCODE.CPP: -------*/

void FuncblockAdjustObj(funcblock_type funcblock, Namedobj* obj);
        /* This obj has been moved, so update the back-pointer to it from the */
        /* debug header inside the funcblock. */




/*-------- Miscellaneous -------*/

void* Fprt(Type type);     
	    /* Returns the address of an outputter function for this type. */

int GetFany_project(void);
int GetFdynarray(int n);    /* 0=access fn,   1=length fn */
int GetFrval2lval(void);

void PureVirtual();

void DebuggerEnterLocalsIntoScope();

