/* Debug.h:   This file allows all modules concerned with debugging     */
/* to communicate with each other.  Note also there is another          */
/* header file: Exception.h which uses the CONTEXT and EXCEPTION_REPORT */
/* classes from <winnt.h>. Only join, debugeng and debuggui use this.   */


class DebugInfo {
public:
	int size;
        struct linemap_node {
	    int LineNo;
            uchar *Code;
        } *linemap;
	struct localvarmap_node {
            str name;
            storage_enum storage;	    // auto or localstatic?
            int offset;
            char type[1];
            localvarmap_node* Next();
        } *localvarmap;
};


typedef struct bpcode_node *bpcode_type;


typedef struct disassembledins_node {
	str mnemonic;
	unsigned int mod;
	int reg;
	unsigned int rm;
	unsigned int sib;
	bool imm_present;
	bool sib_present;
	bool modregrm_present;
	bool _16bit;
	bool direction;
	unsigned int imm;
	unsigned int disp;
	int base;
	int scaler;
	int index;
} *disassembledins_type;


struct FrameNode {
        ins_type ins;   // The instruction pointer in the fn
        void** BP;      // The value of BP at the level of this fn
};




/*------------ The engine provides: -------------*/

bool DebugDeleteCodeBreakpoint(ins_type ins);
	/* Delete this bpc, specified by instruction location. */

bool DebugInsertCodeBreakpoint(ins_type ins, Namedobj* obj, DebugInfo* dinfo);
	/* Delete this bpc, specified by instruction location. */

bool FindCodeBreakpoint(ins_type ins);
	/* Is there a breakpoint at this machine-code location? */

bool DebugInsertBreakpoint(Namedobj* obj, int LineNo, DebugInfo* dinfo);
	/* Create a breakpoint at this location.  Supply the dinfo if you have it. */
	/* If it fails then it returns the reason in b_errno. */

bool DebugDeleteBreakpoint(Namedobj* obj, int LineNo);
	/* Delete the breakpoint at this location. */

bool FindBreakpoint(Namedobj* obj, int LineNo);
	/* Is there a breakpoint at this source-code location? */

void DebugInit(void);
	/* Initialise the debugger. */

str DebugDisassemble(char buf[], ins_type ins);
	/* Do a disassembly of this instruction, keeping in mind that we might need */
	/* to uncover some breakpoints to get it. */

ins_type* DebugDisassembleToStruct(ins_type ins, disassembledins_type I);
	/* Do a struct-disassembly of this instruction, uncovering breakpoints */
	/* as necessary. */

ins_type DebugNextInstruction(ins_type ins);
	/* Uncover breakpoints as necessary and disassemble this instruction. */

typedef void (*foundins_fn)(ins_type ins);

Namedobj* DebugInsToObj(ins_type ip);
	/* Map a code location to an object. */

int DebugInsToLineNo(DebugInfo* dinfo, ins_type ins);
	/* Map an instruction to a line-number. */

void DebugFindFollowers(ins_type *SameLine, foundins_fn processor);
	/* Find all instructions of different lines reachable directly from 'ins'. */

void DebugFindCalls(ins_type *_SameLine, foundins_fn _processor);
	/* Find all CALL destinations called from _SameLine. */

void DebugFindParent(FrameNode* Frame, foundins_fn InsertTempBP);
	/* Find the instruction that will be executed straight after we return. */

void L_assert(bool condition);
        /* if not condition, enter the debugger. */

extern char exception_message[16384];
        /* A description of the exception. */

extern FrameNode Frame;
        /* A description of one level of the call stack. */

extern void* StartOfUserStack;
	/* Anything above this address should be ignored by Barbados. */



/*------------ The GUI provides: ----------*/

void Debugger(Namedobj* obj, DebugInfo* dinfo, int LineNo, FrameNode *Frame);
	/* Display the debug window with this context and get input. */

void DebugHideWindows(void);
	/* Hide all debug windows. */

void DebugGuiDeleteObj(Namedobj* obj);
	/* Uninstalls the source-code from the cache */
	/* when the source-code changes. */

void MemDisplay(void *mem);
        /* Display memory */



/*-------------- The disassembler provides: -------------*/

ins_type NextInstruction(ins_type instruction);
	/* Given an instruction, work out where the next instruction begins. */

str Disassemble(char buf[], ins_type instruction);
	/* Display this instruction as a str. */

extern str Reg8ToString[];
	/* Mapping the 0..8 registers to names. */

void DisassembleToStruct(ins_type ins, disassembledins_type S);
	/* Break this instruction up into its components. */

Namedobj* InsToObj(ins_type ip);
        /* This obj has been moved, so update the back-pointer to it from the */
        /* debug header inside the funcblock. */

