#include <string.h>
#include <ctype.h>
#include "barbados.h"
#include "runlib.h"
#include "memory.h"
#include "name.h"



static struct {
	str s;
	bool case_sensitive;
	bool whole_word;
	bool search_subdirs;
	Make *obj_make;
} searcher;
static bool just_names;
static struct ss_node {
	container_id cid;
	str pwdp;
	bool processed;
} *SearchedContainers;
static char pwd[200], *pwdp;
static int SS_idx;
static str grepline;

static void GrepRecurse(Directory* directory);




static void InstallSearcher(str s)
/* Install this str into 'searcher'.   */
/* The str consists of the search term */
/* with embedded option characters.       */
{       char ch;

	searcher.case_sensitive = no;
	searcher.whole_word = no;
	searcher.search_subdirs = yes;
	if (s[1] == ':') {
	    ch = s[0];
	    if (ch == 'i')
		searcher.case_sensitive = searcher.whole_word = yes;
	    else if (ch == '.')
		searcher.search_subdirs = no;
	    searcher.s = s + 2;
	}
	else searcher.s = s;
}



static bool MatchHere(str s)
/* Does this str match here with 'searcher'? */
#undef toupper
{       str t;

	if (searcher.whole_word)
	    if (isalnum(s[-1]))
		return no;
	if (searcher.case_sensitive) {
	    for (t=searcher.s; *t; )
		if (*t++ != *s++)
		    return no;
	}
	else {
	    for (t=searcher.s; *t; )
		if (toupper(*t++) != toupper(*s++))
		    return no;
	}
	if (searcher.whole_word)
	    if (isalnum(*s))
		return no;
	return yes;
}


static str GrabLine(str s0, str s)
/* 's0' contains a multi-line str.  Find the line that */
/* 's' occurs on, and strdup it. */
{       str d0, d;

	while (s > s0 and s[-1] != '\n')
	    s--;
	while (*s == ' ' or *s == '\t')
	    s++;
	d0 = d = (str)malloc(anon_heap, 81);
	while (*s and *s != '\n' and d-d0 < 80)
	    *d++ = *s++;
	*d++ = '\0';
	return d0;
}



static bool Match(str s)
/* Does this str include 'searcher'? */
{       str s0=s;

	if (grepline)
	    free(anon_heap, grepline);
	while (*s)
	    if (MatchHere(s++)) {
		grepline = GrabLine(s0, s);
		return yes;
	    }
	return no;
}


static bool MatchD(Namedobj* obj)
/* Does this object depend on 'searcher.obj_make'? */
{       int i;

	if (obj->make == NULL)
	    return no;
	if (obj->make->depends_on == NULL)
	    return no;
	for (i=0; obj->make->depends_on[i]; i++)
	    if (obj->make->depends_on[i] == searcher.obj_make)
		return yes;
	return no;
}



static str mins(str a, str b)
/* Return the lower of these two pointer values. */
{
	return (a < b) ? a : b;
}


static void ReachedSeg(container_id cid)
/* Indicate that we've reached this container with a path-name */
/* length of 'pwdp'. */
{       int i, size;

	for (i=0; i < SS_idx; i++)
	    if (SearchedContainers[i].cid == cid) {
		SearchedContainers[i].pwdp = mins(SearchedContainers[i].pwdp, pwdp);
		return;
	    }
	size = sizeof(struct ss_node) * (SS_idx+1);
	size = (size | 255) + 1;
	SearchedContainers = (struct ss_node*)realloc(anon_heap, SearchedContainers, size);
	SearchedContainers[SS_idx].cid = cid;
	SearchedContainers[SS_idx].pwdp = pwdp;
	SearchedContainers[SS_idx].processed = no;
	SS_idx++;
}


static bool ShouldSearchContainer(container_id cid)
/* Have we searched this container yet? If not, return */
/* 'yes' and mark it as searched. */
{       int i;

	for (i=0; i < SS_idx; i++) {
	    if (SearchedContainers[i].cid == cid) {
		if (SearchedContainers[i].processed)
		    return no;
		if (SearchedContainers[i].pwdp < pwdp)
		    return no;
		SearchedContainers[i].processed = yes;
		return yes;
	    }
	}
	return no;
}


static void GrepEnterDirec(Directory* dir, Namedobj* obj)
/* Enter this directory, given to us by 'obj', */
/* and recurse on it. */
{       str old_pwdp;

	if (pwdp + strlen(obj->name) + 2 >= pwd + sizeof(pwd))
	    return;
	old_pwdp = pwdp;
	strcpy(pwdp, obj->name);
	while (*pwdp) pwdp++;
	*pwdp++ = '/';
	*pwdp = '\0';
	GrepRecurse(dir);
	pwdp = old_pwdp;
	*pwdp = '\0';
}


static void PrintOccurrence(str name, str line)
/* We've discovered a match.  Print it.  If line==NULL, */
/* it means we've found it in a name.  Otherwise, print */
/* 'line'. */
{
	Pr("%s%s%*s%s\n", pwd, name, 40 - strlen(pwd) - strlen(name), "", line ? line : "");
}



static void GrepRecurse(Directory* dir)
{       container_id cid;
        void* location;
	Namedobj* obj;
	int dimension;
	Conim *conim;
	Type type;
	uint h;
	str s;

	/* Look at the objects in this directory first: */
	for (each_dir_obj(dir)) {
	    if (searcher.s ? Match(obj->name) : MatchD(obj))
		PrintOccurrence(obj->name, NULL);
            if (obj->storage != static_storage)
                continue;
            location = ((StaticNamedobj*)obj)->location;
	    if (*obj->type == tp_container)
		ReachedSeg(*(container_id*)location);
	    if (not just_names) {
		type = obj->type;
		if (*type == tp_array) {
		    type++;
		    GetDimension(dimension, type);
		    s = (str)location;
		}
		else if (*type == tp_pointer) {
		    type++;
		    s = *(str*)location;
		}
		else continue;
		if (*type != tp_char)
		    continue;
		if (s != NULL and Match(s))
		    PrintOccurrence(obj->name, grepline);
	    }
	}

	/* Look at subdirectories: */
	for (each_dir_obj(dir)) {
	    if (obj->storage == static_storage) {
                location = ((StaticNamedobj*)obj)->location;
		if (IsDirectory(obj, no, no)) {
		    GrepEnterDirec((Directory*)location, obj);
		}
		else if (*obj->type == tp_container and searcher.search_subdirs) {
		    cid = *(container_id*)location;
		    if (cid == 0)
			continue;
		    if (ShouldSearchContainer(cid)) {
			conim = Conim::OpenContainer(cid, READONLY);
			if (conim == NULL)
			    continue;
			GrepEnterDirec(conim->directory(), obj);
			CloseContainer(cid);
		    }
		}
	    }
	}
}


static void Grep(void)
/* Recursively descend this directory looking for 'searcher'. */
{
	SS_idx = 0;
	pwd[0] = '\0';
	pwdp = pwd;
	GrepRecurse(curdir);
	free(anon_heap, SearchedContainers);
	SearchedContainers = NULL;
}


interface void GrepO(str s)
/* Search the whole directory hierarchy, from curdir down, */
/* for an object named 's'. */
{
	InstallSearcher(s);
	just_names = yes;
	Grep();
}


interface void GrepS(str s)
/* Search the whole directory hierarchy, from curdir down, */
/* for source-code that mentions 's'.                      */
{
	InstallSearcher(s);
	just_names = no;
	Grep();
}


interface void GrepD(Namedobj* obj)
/* Search for objects which depend on 'obj'. */
{
	if (obj == NULL)
	    return;
	if (obj->make == NULL)
	    return;
	searcher.s = NULL;
	searcher.obj_make = obj->make;
	just_names = yes;
	Grep();
}

