#include <stdio.h>
#include "barbados.h"
#include "tfc.h"
#include "array.h"
#include "editor.h"
#include "c_editor.h"



static TfcPair* GetTopics()
{       static TfcPair *List;

        if (List)
            return List;
#define Add(s,t)        Array_Add(List,TfcPair(s,t))
        Add("Some useful Barbados commands",
                "\1dir();\1 \tSee a directory listing of the current directory. "
                "Punctuation in the listing tells you whether it's a "
                "subdirectory (has a slash), function (has round brackets), "
                "a macro (begins with a hash) and so on.\n\n"
                "\1directory D;\1 \tCreate a subdirectory with the name 'D' "
                "(substitute your desired name for D).\n\n"
                "\1mkdir(D);\1 \tCreate a subdirectory 'D' in a new container "
                "(i.e. create a new container with an empty subdirectory in it).\n\n"
                "\1edit(f);\1 \tRetrieve the source-code for the function/object "
                "'f' so you can edit and re-enter it.\n\n");
        Add("Barbados extensions to C++",
                "Barbados has added path-names to C++.  A path-name is a string "
                "of text which identifies an object by specifying the path you "
                "take from through subdirectories to get "
                "to the object.  The subdirectories are separated by slashes. "
                "The first character of a path-name must be a slash if you want "
                "to start from the root directory, otherwise it will start from "
                "the current directory (i.e. it works just like UNIX paths). "
                "Anywhere an identifier is referenced in C++, you can put a "
                "full path-name in Barbados C++.\n");
        Add("About Barbados (versions)",
                "You are running Barbados v0.1.\n\n\n\nBarbados was written by:\n\n"
                "Dr Tim Cooper  (tco@smarts.com.au)\n\nand:\n\nJose Baltasar "
                "Garcia Perez-Schofield (jgarcia@uvigo.es)\n");
        Add("C",
                "The C language is very small");
        Add("C++",
                "C++ is a bit too complicated");
        Add("Persistence",
                "Barbados has a form of persistence similar to 'orthogonal persistence'");
        Add("Support",
                "e-mail Dr Tim Cooper for support:\n\n\5tco@smarts.com.au\n");
#undef Add
	return List;
}


static str LookUp(str word)
/* Look up this word in the index. */
{
        if (strieq(word, "strcpy"))
            return "char *strcpy(char *dest, const char *src);\n\n"
                "Description\n\nCopies one string into another.\n"
                "Copies string src to dest, stopping after the terminating "
                "null character has been moved.\n\n"
                "Return Value\n"
                "strcpy returns dest.\n";
        else return "There's no help on that function.\n";
}


static str GettingStarted = "\2Getting Started\2\n\n"
        "\1The interactive compiler\1\n"
	"Barbados is an 'Integrated Persistent Programming Environment'.  At its "
        "heart is an incremental compiler (not interpreter!) for the C/C++ "
        "language.  When you first run Barbados, you will be put at a simple "
        "command-line prompt at which you type C/C++ statements.  (There is no "
        "welcome message - you just start typing immediately).  You can type:\n\n"
        "\5Any C or C++ expression, statement, declaration or function definition.\n"
        "\5Some preprocessor commands (#define and #undef).\n\n"
        "Whatever you type is immediately evaluated (i.e. compiled and executed) "
        "as soon as it is complete and you have hit the ENTER key.  However, "
        "(IMPORTANT) note that you must use the full C/C++ syntax, including "
        "the terminating ';' if required, before the text is compiled.  "
        "Otherwise Barbados will think you're still composing the command.\n\n\n"

        "\1Display of values\1\n"
	"If you type an expression, (an expression which returns a value), "
        "it will print the value on the screen immediately below.  It does "
        "this automatically, ie. there is no need to enter 'cout <<' or "
        "'printf()' when using Barbados in this 'immediate mode'.  (Of course, "
        "you will often want 'cout <<' inside functions).\n\n\n"

        "\1The combined command-line/full-screen editor\1\n"
	"If you enter a multi-line command, you can use the UP-ARROW to go "
        "back up and modify it before it gets compiled.  In this sense, "
        "Barbados acts as a full-screen editor over that short piece of "
        "text.  This is especially useful for when you enter function "
        "definitions.\n"
	"\tOnce a command is compiled/executed, you can't modify it in the "
        "normal way, but you can use the UP-ARROW to retrieve it from the "
        "'history'. The 'history' is a list of the most recently entered "
        "commands.  Hit the UP-ARROW until you see the command you want to "
        "retrieve, and then hit ENTER or simply start to modify it.\n\n\n"

        "\1Creating programs\1\n"
	"If you enter a function definition, that function is entered into "
        "the system.  (If you enter that function again, with modifications, "
        "it overwrites the old function definition.)\n"
        "\tYou can execute your function immediately by calling it, using "
        "the C++ syntax. For example, if the function is called 'fn' and "
        "takes no arguments, type simply:   fn();   This is how you run "
        "your programs - you do not need to create a 'main()' function.  "
        "But of course you can choose to call your top-level function "
        "'main', in this case you will run your program by typing "
        "\"main();\".\n\n";


static str TheBarbadosProject =
        "\2The Barbados Project - Our Grand Vision\2\n\n"
        "\5The initial idea from which Barbados grew was this: That "
        "files, and the disk-vs-memory distinction should be abolished, "
        "and instead programmers should be placed inside a directory "
        "hierarchy not of files but instead of C++ objects.\n\n"
        "This idea has many consequences:\n\n"
        "\1Persistence\1: We blur the distinction between files and "
        "objects and instead get the best of both worlds: Barbados "
        "objects are persistent, i.e. stick around even after you shut "
        "down the system, like files; but also they can be directly "
        "accessed, as C++ objects.\n\n"
        "\1An Interactive Compiler:\1 We blur the distinction between "
        "interpreter and compiler by creating an incremental (meaning "
        "you don't have to wait for compilations) and interactive "
        "(meaning you don't have to start execution at \"main\") "
        "compiler, which combines the best of both worlds: the "
        "immediate response of an interpreter with the speed and "
        "early error-detection of a compiler.\n\n"
        "\1The editor:\1 The Barbados editor blurs the distinction "
        "between command-line editor and full-screen editor by providing "
        "an editor with the best of both worlds:  immediate response and "
        "a log of past commands as we get with command-line interfaces, "
        "and multi-line editing and multi-level undo/redo, cut/copy/paste "
        "and all the other features we get with full-screen editors.\n\n"
        "\nAs a result, we get pure C++:\n\n"
        "\1Pure C++\1:  Users of Barbados need to learn C++, but they "
        "need to learn very little else.  The Barbados manual is tiny. "
        "We measure our success by what we have deleted, as much as by "
        "what we have added:  there are no more header files; no more "
        "project files; no more make-files; no more object files; no "
        "more linker phase.\n\n"
        "\1Programming-in-the-large:\1 Barbados was designed to support "
        "programming of very large systems (any size).  The abstraction "
        "of 'directories' is very important for organising large programs. "
        "It provides both a way of organising source-code along with "
        "version control, backups and so on, with memory-protection to "
        "prevent one part of the system corrupting another part.  Both "
        "programs and data are organised inside directories.\n\n"
        "Other advantages include:\n\n"
        "\1Advanced debugging:\1\n"
        "The very close cooperation, almost merging, of the debugger and "
        "compiler means that you can create 'watch' expressions using exactly "
        "the same language and context as the program being debugged: this "
        "refers to macros, identifier resolution (name-spaces), complexity "
        "of expressions, you can "
        "even create functions and use loops and statements inside the "
        "debugging context to help you debug.  It means that the debugger "
        "has access to the fine-grained data-structures used by the compiler, "
        "so you are able to debug optimised code: for example, the debugger "
        "knows where variables are, even if they have been allocated into "
        "registers or are sometimes left in registers.\n\n"
        "\1Convenient access to GUI objects:\1\n"
        "The acronym 'GUI' refers to \"graphical user interface\". GUI "
        "programming has different requirements to non-GUI programming: "
        "you need to be able to access icons, bitmaps, dialog boxes and so "
        "on.  In Barbados, an icon is just a C++ object. You can display "
        "it simply by typing '<iconname>.Display()'. In VisualC++, by contrast, "
        "you need to give it a filename, save it, associate an identifier with "
        "the file in the resource-script, compile the resource-script, link "
        "the icon into the program, then in your program you #include the "
        "header file with the identifier, map the identifier to an icon "
        "handle by 'loading' it, and then display it.\n\n"
        "\1A more open environment:\1\n"
        "Barbados users have access to the same directories, 'named objects', "
        "types and other data-structures used by the compiler.  (We call these "
        "classes which span both the internal and external world the "
        "'meta-classes').  Using these classes, the programmer or other 3rd "
        "parties can create add-on tools for example advanced data-structure "
        "browsers/visualisers, automated help authoring systems, advanced "
        "static-analysis tools (e.g. like Lint), artificial intelligence based "
        "debugging agents.  It is extensible in a way which Unix is, but "
        "typical Windows programs aren't.\n\n"
        "\1Scientific papers:\1\n"
        "\tComputer scientists can get more details from our web site:\n"
        "\n\thttp://www.smarts.com.au/~barbados\n\n";


interface void F1Pressed(void)
{       static bool InsideHelp=no;
        char buf[512];
	TfcPair* List;
        int result;
        str topic;

        if (InsideHelp) {
            ViewHelp("Help in help");
        }
        InsideHelp = yes;
        topic = 0;
        CompilerEditor->GetPhraseAtCursor(buf, sizeof(buf));
        List = GetTopics();
        result = DoDialog("Barbados Help",
                StaticText("What kind of help do you want?")
                -
                Control(buf, sizeof(buf), NULL, 20) / OkButton()
                -
                StaticText("or:") / (Button("Getting started", 2)
                -
                Button("The Barbados Project", 3))
                -
                FillerControl(0,10)
                -
                StaticText("or select a topic:")
                -
                ListControl(topic, List, 0) / Button("View",4)
        );

        switch (result) {
            case 1:     ViewHelp(LookUp(buf));
                        break;
            case 2:     ViewHelp(GettingStarted);
                        break;
            case 3:     ViewHelp(TheBarbadosProject);
                        break;
            case 4:     ViewHelp(topic);
                        break;
        }
        InsideHelp = no;
}


