/************************************************\
** MAIN.C:                                      **
**    This module starts up the system - it     **
** parses command-line options and calls the    **
** interface to begin operation.                **
\************************************************/

#include <string.h>
#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "barbados.h"
#include "c_editor.h"
#include "runlib.h"
#include "memory.h"
#include "join.h"


interface long L;





/*------------ Misc routines ------------*/

int max(int a, int b)
{
	return a > b ? a : b;
}

int min(int a, int b)
{
	return a < b ? a : b;
}


#ifdef assert
void assertion(bool c, str filename, int lineno)
{
	if (not c) {
	    FILE *assertfile;
	    assertfile = fopen("ASSERT.TXT", "at");
	    fprintf(assertfile, "%-8s %d\n", filename, lineno);
	    fclose(assertfile);
	    fprintf(stderr,"Error: %-8s %d\7\n", filename, lineno);
	    if (_getch() == 3)
		exit(3);
	}
}

#else

#include <conio.h>
void assert(bool c)
{
	if (not c)
	    fprintf(stderr,"Error!\7\n"), _getch();
}
#endif


str my_strncpy(str s, str t, int count)
/* Like strncpy but guaranteed to put a null at the end. */
{
	strncpy(s, t, count);
	s[count] = '\0';
	return s;
}






/*----------- Main() ------------*/

static str barfilename;


static void CopyFromClean()
{
	#define cf(cid)     CopyFile("C:\\PS\\CLEAN\\"#cid".ctr", "C:\\PS\\"#cid".ctr",no);
	cf(1);
	cf(131);
	cf(68);
	cf(753);
	cf(404);
	cf(205);
	cf(980);
	cf(278);
	CopyFile("C:\\PS\\CLEAN\\OWNERSHIP.DAT", "C:\\PS\\OWNERSHIP.DAT",no);
}


void ProcessOptions(int argc, str argv[])
{       str s;
	int i;

	AccessCheck = yes;
	barfilename = NULL;
	for (i=1; i < argc; i++) {
	    s = argv[i];
	    if (*s == '-') {
		s++;
		if (*s == 'A')
		    AccessCheck = no;
		else if (*s == 'C') {
		    CopyFromClean();
		}
		else if (*s == 'D') {
		    remove("C:\\PS\\OWNERSHIP.DAT");
		    remove("C:\\PS\\1.CTR");
		    remove("C:\\PS\\42.CTR");
		    remove("C:\\PS\\131.CTR");
		}
		else {
		    printf("Unknown option:  -%s\n", s);
		    exit(1);
		}
	    }
	    else barfilename = s;
	}
}


int main(int argc, str argv[])
{       extern int CompilerVersion, PersistenceVersion;
	extern void F1Pressed(void);
        extern void NameInit(void);
        char buf[512];

        Heap::CheckInitialised();

	//Initialise the heap class
	ProcessOptions(argc, argv);

	HeapCheck(0);
	NameInit();
	JoinInit();
	HeapCheck(0);

	CompilerEditor = new C_Editor("Barbados", 700, 600);
        if (barfilename)
            CompilerEditor->LoadFile(barfilename);
	//CompilerEditor->SetCursorBlinkRate(0, 0);
        //printf("Hit F1 for help\n");
        CompilerEditor->InsertLineB(NULL, no, "Hit F1 for help", 2, no);
        sprintf(buf, "Barbados Persistence mechanisms v%d", PersistenceVersion);
        CompilerEditor->InsertLineB(NULL, no, buf, 2, no);
        sprintf(buf, "Barbados Compiler v%d", CompilerVersion);
        CompilerEditor->InsertLineB(NULL, no, buf, 2, no);
        CompilerEditor->AddAccelerator(F1, F1Pressed);
	CompilerEditor->Edit();

	ClosingDownPhase = yes;
	Conim::DestroyAll();
	return 0;
}

