#include <string.h>
#include <memory.h>
#include <stdlib.h>
#include "barbados.h"
#include "memory.h"
#include "runlib.h"
//#include "mem.h"





interface bool AccessCheck;




/*------------------ User Heap functions ------------------*/
/* Summary: These functions provide heap functions for     */
/*              blocks that are to have read/write permissions.*/
/*              They are used by the user's 'mallocs' etc,     */
/*          and also by 'name' to create static areas and  */
/*              other areas where the system creates memory    */
/*              blocks writeable by the user (local statics &  */
/*              strings).  Checking of parameter validity, with*/
/*              free() and realloc() is done in RUN_LIBR.C.    */

interface void* malloc_user(uint size)
{       void* mem;

	mem = default_heap->malloc(size);
	if (mem == NULL)
	    return NULL;
	//AccessAddInterval(mem, size);
	return mem;
}


interface void free_user(void *mem)
{
	if (mem == NULL)            // Null frees are allowed.
	    return;
	//AccessDeleteInterval(mem, msize(mem));
	free(NULL, mem);
}


interface void* realloc_user(void* mem, uint size)
{
	if (mem == NULL)
	    return malloc_user(size);

	//AccessDeleteInterval(mem, msize(mem));

	mem = default_heap->realloc(mem, size);
	if (mem == NULL)
	    return NULL;

	//AccessAddInterval(mem, size);
	return mem;
}


interface void* calloc_user(uint num, uint size)
{	void *mem;

	mem = default_heap->calloc(num, size);
	//AccessAddInterval(mem, num*size);
	return mem;
}


interface str strdup_user(str s)
{       uint size;
	str d;

	size = strlen(s) + 1;
	d = (char*)default_heap->malloc(size);
	memcpy(d, s, size);
	//AccessAddInterval(d, size);
	return d;
}


interface void* operator_new_user(Type type)
{
        return default_heap->New(type);
	//AccessAddInterval(d, size);
}





/********************** Memory Access Checking ********************\
**                                                                **
** Summary: This sub-module attempts to prevent memory overwrites **
**              by keeping a database of what parts of memory can be  **
**              accessed.  It effectively tags every single word of   **
**              memory with a bit value representing 'modifiable' or  **
**              not. It incurs a significant speed overhead, but the  **
**              memory overhead is hopefully less than 10% of used    **
**              memory.                                               **
**                                                                **
** Interface: We have functions to initialise and close the       **
**              module, add intervals to the set, remove intervals    **
**              from the set, check single words or ranges, and a     **
**              short-cut method for moving the stack pointer.        **
**                                                                **
** Representation: We have a tree of nodes. Each node represents  **
**              a certain interval of memory. Each node has 16 kids,  **
**              which split the interval into 16 equally-spaced       **
**              sub-intervals. If a section is fully 'on', (i.e.      **
**              modifiable) we just represent it by a '1'-valued      **
**              pointer, if it is fully 'off' (i.e. mustn't touch)    **
**              it is represented by a NULL pointer. If it is mixed,  **
**              we have a pointer to the sub-node with the 16 kids,   **
**              or in the case of the bottom level we have 16 x 32-bit**
**              numbers, each bit corresponding to one word.          **
**                                                                **
\******************************************************************/



typedef struct mem_node {
	struct mem_node* mem[16];
} *mem_type;

typedef unsigned long ulong;

static struct {
	int *start;
	int *finish;
	int **ptr;
} Stack;

interface bool PurifyCheck;

static struct mem_node root_node;
static mem_type root=&root_node;


static ulong maxl(ulong a, ulong b)
{
	return a > b ? a : b;
}

static ulong minl(ulong a, ulong b)
{
	return a < b ? a : b;
}

#define MAX_DEPTH       7
#define get_long(m)	((uint)(m))


static void AccessCheckNode(mem_type *memp, int depth, mem_type allow)
/* If this node is all on or all off, we can replace it */
/* with a single 1 or NULL. */
{       int i;
	mem_type mem=*memp;

	assert(depth != 0);
	if (depth == 1) {
	    /* 'mem' is an array of bit vectors: */
	    ulong l;
	    l = allow ? -1L : 0L;
	    for (i=0; i < 16; i++)
		if ((ulong)mem->mem[i] != l)
		    return;
	}
	else {
	    for (i=0; i < 16; i++)
		if (mem->mem[i] != allow)
		    return;
	}
	*memp = allow;
	delete mem;
}


static mem_type AccessNewNode(mem_type allow, int depth)
/* Return a new node, initialised to 'allow'. */
{       mem_type r;
	int i;

	r = new mem_node;
	if (depth == 1 and allow)
	    allow = (mem_type)-1L;
	for (i=0; i < 16; i++)
	    r->mem[i] = allow;
	return r;
}


static void AccessDeleteNode(mem_type mem, int depth)
/* Free this node and all its children. */
{       int i;

	if (mem == NULL or mem == (mem_type)1)
	    return;
	if (depth > 1)
	    for (i=0; i < 16; i++)
		AccessDeleteNode(mem->mem[i], depth-1);
	free(anon_heap, mem);
}


static void AccessRecurse(mem_type *memp, ulong mem_start, int depth,
		    ulong start, ulong finish, mem_type allow)
/* Given a mem_type, and information about what interval of memory  */
/* it corresponds to (mem_start, depth), add this interval to it.   */
/* 'depth' contains 0 to MAX_DEPTH:                                 */
/*          0=mem represents 64 bytes. Look at each of the 32 bits in   */
/*            'memp' to get the flags on each word - don't do           */
/*             mem->mem[i].                                             */
/*          1=mem represents 64*16 bytes, 16 lots of 64 bytes in the    */
/*              16 elements of mem->mem[i].                             */
/*          n=mem represents 64*(16^n) bytes.                           */
/*          7=mem represents 2^34 bytes. i.e. only the first 4 elements */
/*              of root->mem[] will be used. Root is always MAX_DEPTH.  */
/*                                                                  */
{       int i,a,b;
	ulong sub_mem_start,sub_mem_stop,sub_start,sub_stop;
	int depth4;
	ulong grain;
	mem_type mem=*memp;

	/* Short-cut: */
	if (start == finish)
	    return;

	/*** We are at the 64*16 byte level or above. ***/
	depth4 = depth * 4 + 2;
	grain = 1L << depth4;
	assert(start < finish and start >= mem_start);
	assert(depth == MAX_DEPTH or finish <= mem_start + 16*grain);
	a = (start - mem_start) >> depth4;
	b = (finish  - mem_start - 1) >> depth4;
	assert(0 <= a and a <= b and b < 16);
	depth--;

	/* Process each of the members, whether they be other */
	/* mem_type pointers or bit vectors. */
	for (i=a; i <= b; i++) {
	    sub_mem_start = mem_start + ((ulong)i << depth4);
	    sub_mem_stop = sub_mem_start + grain;
	    sub_start = maxl(start, sub_mem_start);
	    sub_stop = minl(finish, sub_mem_stop);
	    if (depth == 0) {
		/*** At the 'word' level, we use bit vectors. ***/
		ulong l, w, z;
		int aa, bb;

		aa = (sub_start - sub_mem_start) >> 1;
		bb = (sub_stop - sub_mem_start - 1) >> 1;
		assert(0 <= aa and aa <= bb and bb < 32);
		w = 1L << aa;
		z = 1L << bb;
		l = (ulong)mem->mem[i];
		if (allow)
		    for (; w <= z and w; w <<= 1)
			l |= w;
		else for (; w <= z and w; w <<= 1)
			l &= ~w;
		mem->mem[i] = (mem_type)l;
	    }
	    else if (sub_mem_start == sub_start and sub_stop == sub_mem_stop) {
		AccessDeleteNode(mem->mem[i], depth);   // Free sub-structures
		mem->mem[i] = allow;
	    }
	    else if (mem->mem[i] == allow)
		;
	    else {
		if (mem->mem[i] == NULL or mem->mem[i] == (mem_type)1)
		    mem->mem[i] = AccessNewNode(mem->mem[i], depth);
		AccessRecurse(&mem->mem[i], sub_mem_start, depth,
			    sub_start, sub_stop, allow);
	    }
	}

	/* Check if the node is now homogenous: */
	AccessCheckNode(memp, depth+1, allow);
}


interface void AccessAddInterval(void* m, uint len)
/* Add this interval of memory to the database of accessible memory. */
{
	if (not AccessCheck)
	    return;
	AccessRecurse(&root, 0, MAX_DEPTH, get_long(m), get_long(m)+len, (mem_type)1);
}


interface void AccessDeleteInterval(void* m, uint len)
/* Subtract this interval of memory to the database of accessible memory. */
{
	if (not AccessCheck)
	    return;
	AccessRecurse(&root, 0, MAX_DEPTH, get_long(m), get_long(m)+len, NULL);
}


interface bool AccessCheckAccess(void* m)
/* Is this address a modifiable address? */
{	
	return yes;
}


interface bool AccessCheckRange(void* m, uint len)
/* Does this range consist of modifiable addresses? */
{
	return AccessCheckAccess(m) and AccessCheckAccess((str)m+len-1);
}


interface void AccessAddStack(int *start, uint len, int **ptr)
/* A modular way of communicating the details of the   */
/* stack from the EXECUTE module to the MEM_ACCE module. */
{
	Stack.start = start;
	Stack.finish = start + len;
	Stack.ptr = ptr;
}


interface void InitAccess(void)
{
}


interface void CloseAccess(void)
{
}
