/************************************************\
** MISC.H:                                      **
**    Miscellaneous (general purpose) routines. **
** They are implemented in 'STARTUP.C' and used **
** by all modules.                              **
\************************************************/

#undef max
#undef min
int max(int a, int b);
int min(int a, int b);
str my_strncpy(str s, str t, int count);

extern int debugging;
void stop(void);
void debug(int n);
bool streq(str a, str b);
extern long L;

typedef int (*cmp_fn)(const void*, const void*);

extern bool PredefinitionPhase;
extern bool ClosingDownPhase;


/*----- Error reporting: -----*/

typedef enum { err_none, err_make, err_maybe, err_certain, err_runtime, err_pleaselinksrc } err_enum;

typedef struct error_node {
	err_enum err;
	str message;     // The error-message
	str src;         // The str we are currently compiling
	str pos;         // The position in this str
} *error_type;


extern struct error_node Error;
void ErrorType(str src, str mess, ...);
void ErrorRun(str mess, ...);
void ErrorWarning(str mess, ...);
void ErrorMake(str mess, ...);



/*-------- Ostreams: ----------*/
#define BITMAP_CHAR	4

extern Ostream* cout;

bool OstreamFlush(Ostream* out);
int OstreamPutch(Ostream* out, int ch);
int OstreamPuts(Ostream* out, str s);
int OstreamPrintf(Ostream* out, const str fmt, ...);


/*-------- Stdout: ---------*/
int  flush_stdout(void);
void flush_display(void);
void InitStdio(void);
int  Pr(const str fmt, ...);
void CoutPuts(str s);
bool IoMessage(char* title, char icon, char* text);


#define printf	    Pr




/*--------- Debug output: --------*/
void Trace(str format, ...);
void TraceMode(bool to_file);



/*-------- The heap: ---------*/

extern class Heap *default_heap, *anon_heap;

void* malloc(class Heap*, uint size);
void* calloc(class Heap*, uint size, uint num);
void* realloc(class Heap*, void* mem, uint size);
void  free(class Heap*, void *mem);
char* strdup(class Heap*, str s);
uint  msize(void*);
/* In Barbados, we have many heaps (each open container is a heap). 	*/
/* Therefore, in order to avoid confusion, every call to malloc/	*/
/* realloc/etc. must explicitly specify which heap we want.  No file in */
/* the Barbados project should have any of the original calls to these  */
/* functions (with the exception of TFC).  				*/
/*	If you just want some temporary ie. non-persistent memory, then */
/* pass 'anon_heap' to the function.  If you want to create an object	*/
/* in the user's current container, use 'default_heap'.			*/
/*	This system avoids the problems we were having before of how to */
/* force the compiler to link with our versions of 'malloc' etc. instead*/
/* of the LIBC versions. */


void HeapCheck(container_id cid);
void ConimRealCloseAll();



/*--------- Keeping breakpoints up-to-date: ---------*/
void DebugBodyDeleted(Namedobj* obj);
void DebugBodyRecompiled(Namedobj* obj);
void DebugDeleteObj(Namedobj* obj);
void DebugCloseContainer(class Conim *conim);



/*----Porting issues:----*/


#ifdef __BORLANDC__

//#include "Tdebug.mcr"

#else

#define strnicmp	_strnicmp
#define itoa		_itoa
#define stricmp		_stricmp
#define mkdir		_mkdir
#define ASSERT(a,b)
#define DEBUG(s)

#endif


