/*** MODULES.H : The top-level interface functions for each subsystem. ***/
#ifndef MODULES_H
#define MODULES_H




/*--------------- The Compiler: ------------*/

int SizeOfFunction(FunctionNamedobj* obj);

machinecode_type Compile(str s, Directory* context, char Invoker);
        // for the specified directory.  See below for 'Invoker' values.
void CompileAndRun(str source);         // Compiles in 'curdir'.


void MacroEnter(str name, int no_params, str value);
void MacroDelete(str name);
void MacroUsed(Namedobj* obj);


extern str CurrentSource;       // The current source str
extern bool CurrentSourceIsPersistent;   // Is the current source a temporary or persistent str?
extern FunctionNamedobj* MainEntity;
extern char CompilerInvoker;    // 'I'=immediate mode, 'D'=debugger,
                                // 'P'=predefinitions, 'M'=Make,
                                // 'R'=runtime compile("...")
/* The Immediate mode gets declarations echoed to the screen, no
other mode does.  The Debugger mode gets 'debug_visibility' in order
to see hidden members.  The Predefinitions mode is not expecting any
errors.  The Make and Runtime modes are so far equivalent.  */


void SetParamCheckerFn(Namedobj* obj, char Ch);
	/* Set this function to have a parameter-checker function. */
	/* Ch: 'f'=printf format checker;  'N'=null-terminator.	   */

void ConstructKeywordsInStdlib(Heap* Stdlib);





/*================== Memory and container management: =================*/

// Identifier of the Top container
extern const container_id ROOT;
extern const container_id CORRUPTLEVEL;

// Constant literals
extern const str PERSISTENT_ROOT;
extern const str DATA_FILE;
extern const str CONTAINER_EXT;
extern const str FILESURETOFAIL;
extern const str LOSTDIR;

// Public Functions
container_id	NewContainerId     (container_id parent = -1);
bool		DeleteContainerId  (container_id cid);
bool		MoveContainerId    (container_id cid, container_id newparent);
char*		CidToPath          (container_id cid, char *buf, int sizeofbuf);
container_id*	DiskListOfChildren (container_id cid);
container_id	RetParent          (container_id cid);
container_id	PathToCid          (char *);
bool		Fix                (void);
bool		CheckContainer     (container_id cid);
container_id	MaxId              (void);
void		FreeRes            (void);







/*----- Access Checking -----*/

extern bool PurifyCheck;                 // Memory access checking
void AccessAddInterval(void* m, uint len);
void AccessDeleteInterval(void* m, uint len);
bool AccessCheckAccess(void* m);
bool AccessCheckRange(void* m, uint len);
void AccessAddStack(int *start, uint len, int **ptr);


#endif

