#include <windows.h>
#include <stdio.h>
#include <sql.h>
#include <sqlext.h>
#include "SqlDatabase.h"


SqlDatabase::SqlDatabase(kstr filename, DbType type)
{
	ok = no;

	this->filename = strdup(filename);
	this->type = type;
	clearA(errorMsg);

	Connect();
}

void SqlDatabase::FillErrorMsg() {
	SQLINTEGER i = 0;
	SQLINTEGER native;
	SQLCHAR state[7];
	SQLCHAR text[256];
	SQLSMALLINT len;
	SQLRETURN ret;

	sprintf(errorMsg, "The driver reported the following diagnostics\n");
	do
	{
		ret = SQLGetDiagRec( SQL_HANDLE_DBC, session, ++i, state, &native, text, sizeof(text), &len );
		if (SQL_SUCCEEDED(ret))
		{
			sprintf(errorMsg, "%s%s : %d : %d : %s\n", errorMsg, state, (unsigned int)i, (unsigned int)native, text);
		}
	}
	while( ret == SQL_SUCCESS );
	i = 0;
	do
	{
		ret = SQLGetDiagRec( SQL_HANDLE_STMT, cursor, ++i, state, &native, text, sizeof(text), &len );
		if (SQL_SUCCEEDED(ret))
		{
			sprintf(errorMsg, "%s%s : %d : %d : %s\n", errorMsg, state, (unsigned int)i, (unsigned int)native, text);
		}
	}
	while( ret == SQL_SUCCESS );	
}

void SqlDatabase::Connect()
{
	char dsn[1024];
	if (this->TYPE_FDB == type)
		sprintf(dsn, "Driver={Microsoft Access Driver (*.mdb)};DSN='';DBQ=%s;Uid=Admin;Pwd=BART;", filename); 
	else
		sprintf(dsn, "Driver={Microsoft Access Driver (*.mdb)};DSN='';DBQ=%s;", filename); 

	rc = SQLAllocHandle(SQL_HANDLE_ENV, SQL_NULL_HANDLE, &env);
	if(rc == SQL_SUCCESS)
		rc = SQLSetEnvAttr(env, SQL_ATTR_ODBC_VERSION, (SQLPOINTER)SQL_OV_ODBC3, 0);
	if(rc == SQL_SUCCESS)
		rc = SQLAllocHandle(SQL_HANDLE_DBC, env, &session);
	if(rc != SQL_SUCCESS) {
		goto finish;
	}

	SQLCHAR retconstring[1024];
	rc = SQLDriverConnect(session, NULL, (SQLCHAR*)dsn, SQL_NTS, retconstring, 1024, NULL, SQL_DRIVER_NOPROMPT);

	switch(rc) {
		case SQL_SUCCESS:
		case SQL_SUCCESS_WITH_INFO:
			ok = yes;
			break;
		case SQL_INVALID_HANDLE:
		case SQL_ERROR:
			FillErrorMsg();
			goto finish;
		default:
			FillErrorMsg();
			break;
	}
	return;

finish:
	SQLDisconnect(session);
	SQLFreeHandle(SQL_HANDLE_DBC, session);
	SQLFreeHandle(SQL_HANDLE_ENV, env);
}

void SqlDatabase::DisConnect()
{
	if (ok) {
		SQLDisconnect(session);
		SQLFreeHandle(SQL_HANDLE_DBC, session);
		SQLFreeHandle(SQL_HANDLE_ENV, env);
	}
}

bool SqlDatabase::Select(str sql) {
	if (SQL_SUCCESS != SQLAllocHandle(SQL_HANDLE_STMT, session, &cursor)) {
		FillErrorMsg();
		cursor = NULL;
		return no;
	}
	if (SQL_SUCCESS != SQLExecDirect(cursor, (SQLCHAR*)sql, SQL_NTS)) {
		FillErrorMsg();
		SQLFreeHandle(SQL_HANDLE_STMT, cursor);
		cursor = NULL;
		return no;
	}
	return yes;
}

bool SqlDatabase::ReadRow() {
	if (NULL == cursor) {
		return no;
	}

	if (SQL_SUCCESS == SQLFetch(cursor)) {
		return yes;
	} else {
		SQLFreeHandle(SQL_HANDLE_STMT, cursor);
		cursor = NULL;
		return no;
	}
}

str SqlDatabase::Cell(int column, char dest[], int destsize) {
	if (NULL == session)
		return strcpy(dest, "");

	clearA(dest);
	SQLGetData(cursor, column, SQL_C_CHAR , dest, destsize, NULL);
	return dest;
}

int SqlDatabase::CellNumber(int column) {
	if (NULL == session)
		return 0;

	int number = 0;
	SQLGetData(cursor, column, SQL_C_LONG , &number, sizeof(number), NULL);
	return number;
}
