

/* Class that wraps export to Excel application */ 

#ifndef SQLDATABASE_H
#define SQLDATABASE_H

#include "header.h"

class SqlDatabase {
public:
	enum DbType {
		TYPE_MDB,
		TYPE_FDB,
		TYPE_TDF,
		TYPE_TDFX,
		TYPE_TTW,
		TYPE_UNKNOWN,
	};

	SqlDatabase(kstr filename, DbType type = TYPE_MDB); //open existing file

	~SqlDatabase() { DisConnect(); }

	bool Select(str sql);
	bool ReadRow();
	str Cell(int column, char dest[], int destsize);
	int CellNumber(int column);

	bool IsFdb() { return TYPE_FDB == type; }
	bool IsTdf() { return TYPE_TDF == type; }
	bool IsTdfx() { return TYPE_TDFX == type; }
	bool ok;
	str GetErrorMsg() { return errorMsg; }

protected:
	void Connect();
	void DisConnect();
	void FillErrorMsg();

private:
	void* env;
	void* session;
	void* cursor;
	short rc;

	char errorMsg[20000];

	str filename;
	DbType type;
};

#endif //SQLDATABASE_H
