/* $Id: easyrowcol.cpp 437 2005-10-14 05:00:17Z jla $ */



#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "tfc.h"
#include "list.h"
#include "excel.h"
#include "EasyRowCol.h"

EasyRowCol * _mainwindow;


EasyRowCol::EasyRowCol(str caption, int width, int height)
        : RowColumnWin(caption, width, height)
{
        Background = 14349822;
        Header = NULL;
        TotalColumns = 0;
        Export_Dlg = NULL;
        _mainwindow = this;
        HighlightBg = NOCOLOUR;
        HighlightFg = NOCOLOUR;
        DateLocale = 'E';
        WantRowNumbers = false;
}


EasyRowCol::EasyRowCol(EasyRowCol& orig)
: RowColumnWin(orig)
{
        Background = orig.Background;
        Header = NULL;
        TotalColumns = orig.TotalColumns;
        Export_Dlg = orig.Export_Dlg;
        _mainwindow = NULL;
        HighlightBg = orig.HighlightBg;
        HighlightFg = orig.HighlightFg;
        DateLocale = orig.DateLocale;
        WantRowNumbers = orig.WantRowNumbers;

        if (orig.Header) {
            for (int i = 0; i < ListSize(orig.Header); i++) {
                ListAdd(Header, TfcPair(strdup(orig.Header[i].name), strdup((str)orig.Header[i].data)));
            }
        }
        // We want to deep copy the rows, not the half assed copy
        ListFree(Rows); // Rows being freed here were the ones using the pointers from the orig.Rows, bad when you delete
        if (orig.Rows) {
            for (int i = 0; i < ListSize(orig.Rows); i++)
                ListAdd(Rows, new EasyRowColRow(*((EasyRowColRow*)orig.Rows[i])));
        }
}

EasyRowCol::~EasyRowCol()
{
        CleanUp();
}


void EasyRowCol::SetWantRowNumbers(bool want)
{
        WantRowNumbers = want;
}


void EasyRowCol::Clear()
{
        if (Rows) {
            for (int i = 0; i < ListSize(Rows); i++)
                delete ((EasyRowColRow*)Rows[i]);
            ListFree(Rows);
        }
        RowColumnWin::Clear();
}


void EasyRowCol::CleanUp()
{
        if (Header) {
            for (int i = 0; i < ListSize(Header); i++) {
                free(Header[i].name);
                free(Header[i].data);
            }
            ListFree(Header);
        }
        if (Rows) {
            for (int i = 0; i < ListSize(Rows); i++)
                delete ((EasyRowColRow*)Rows[i]);
            ListFree(Rows);
        }
}


void EasyRowCol::SetupData(TfcPair * Heading, EasyRowColRow ** Data)
{
        CleanUp();
        for (int i = 0; i < ListSize(Heading); i++)
            ListAdd(Header, TfcPair(strdup(Heading[i].name),
                                strdup((str)Heading[i].data)));

        TotalColumns = ListSize(Header);
        SetRows((void **) Data);
}


void EasyRowCol::SetupData(EasyRowColRow ** Data, int totcol)
{
        SetRows((void **) Data);
        TotalColumns = totcol;
}


void EasyRowCol::SetHeading(TfcPair * Heading)
{
        if (Header) {
            for (int i = 0; i < ListSize(Header); i++) {
                free(Header[i].name);
                free(Header[i].data);
            }
            ListFree(Header);
        }

        for (int i = 0; i < ListSize(Heading); i++)
            ListAdd(Header, TfcPair(strdup(Heading[i].name),
                                strdup((str)Heading[i].data)));

        TotalColumns = ListSize(Heading);
}


void * EasyRowCol::FindKeyRow(str key)
{       str comp;

        for (int i = 0; i < ListSize(Rows); i++) {
            comp = ((EasyRowColRow*)Rows[i])->GetKeyColumn();
            if (comp and streq(key, comp))
                return Rows[i];
        }
        return NULL;
}


int EasyRowCol::FindKeyRowI(str key)
{       str comp;

        for (int i = 0; i < ListSize(Rows); i++) {
            comp = ((EasyRowColRow*)Rows[i])->GetKeyColumn();
            if (comp and streq(key, comp))
                return i;
        }
        return -1;
}


void EasyRowCol::SetRow(str * listofcolval, int fColour, int bColour, int keycolumnindex)
{
		EasyRowColRow * newrow;
		
		newrow = new EasyRowColRow;
		newrow->SetColour(fColour, bColour);
		newrow->SetColumns(listofcolval, fColour, bColour, keycolumnindex);
		AddRow(newrow);
}


void EasyRowCol::SetRow(TfcPair * listofcols)
{
        EasyRowColRow * newrow;

        newrow = new EasyRowColRow;
        newrow->SetColumns(listofcols);
        AddRow(newrow);
}


void EasyRowCol::AddRow(EasyRowColRow * row, bool calibrate)
{
        if (row->MaxColumns() > TotalColumns)
            TotalColumns = row->MaxColumns();
        RowColumnWin::AddRow(row);
        if (calibrate)
            Calibrate(yes);
}


void EasyRowCol::InsertRow(EasyRowColRow * row, bool after, EasyRowColRow * rowanchor, bool calibrate/*=true*/)
{
        int anchorindex;

        if (row->MaxColumns() > TotalColumns)
            TotalColumns = row->MaxColumns();

        if (rowanchor) {
            anchorindex = ListFindP(Rows, rowanchor);
            if (anchorindex >= 0) {
                if (after)
                    ListInsN(Rows, anchorindex+1, row);
                else
                    ListInsN(Rows, anchorindex, row);
            }
        }        
        if (calibrate)
            Calibrate(yes);
}


void EasyRowCol::SetDateLocale(char locale)
{
        DateLocale = locale;
        assert(DateLocale == 'E' or DateLocale == 'U' or DateLocale == 'I');
}


TfcPair * EasyRowCol::GetHeading() const
{
        return Header;
}


kstr EasyRowCol::GetHeading(column_id cid, kstr *helpp, char *statusp)
{
        *helpp = "There is no help for you!";
        *statusp = 'D';

        if (Header == NULL) {
            if (cid < TotalColumns)
                return "";
            return NULL;
        }

        if (cid >= TotalColumns || cid >= ListSize(Header))
            return NULL;

        *helpp = (str) Header[cid].data;
        return Header[cid].name;
}


str EasyRowCol::GetField(void* row, column_id cid, char dest[], char status, int *fgcolor, int *bgcolor, char *alignment)
{
        if (WantRowNumbers) {
            if (cid == 0) {
                *alignment = 'C';
                ((EasyRowColRow*)row)->GetColours(fgcolor, bgcolor);
                sprintf(dest, "%d", paint_rownum+1);
            }
            else {
                *alignment = ((EasyRowColRow*)row)->GetColumnAlignment(cid-1);
                strcpy(dest, ((EasyRowColRow*)row)->GetColumnValues(cid-1, fgcolor, bgcolor));
            }
        }
        else {
            *alignment = ((EasyRowColRow*)row)->GetColumnAlignment(cid);
            strcpy(dest, ((EasyRowColRow*)row)->GetColumnValues(cid, fgcolor, bgcolor));
        }

        if (status == 'F' or status == 'X' or status == 'H') { // overwrite the colours?
            if (HighlightBg == NOCOLOUR)
                *bgcolor = CYAN;
            else
                *bgcolor = HighlightBg;
            if (HighlightFg == NOCOLOUR)
                *fgcolor = BLACK;
            else
                *fgcolor = HighlightFg;
        }

        return dest;
}


bool EasyRowCol::Keystroke(int key)
{
        switch(key) {
            case WINDOW_QUIT:
                        if (Export_Dlg != NULL)
                                FocusModelessDialog(Export_Dlg);
                        else
                                Hide();
                        return true;

            default:    return RowColumnWin::Keystroke(key);
        }
}


bool EasyRowCol::Mousestroke(int op, int x, int y)
{
        return RowColumnWin::Mousestroke(op, x, y);
}


static str reader;

static str MonthName[12] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };


static int getint(void)
/* Read an int off 's'. */
{       int r=0;
        
        if (not reader)
            return -1;

        while (*reader == ' ')
            reader++;
        if (not isdigit(*reader)) {
            for (r=0; r < 12; r++) {
                if (toupper(reader[0]) == MonthName[r][0]
                        and tolower(reader[1]) == MonthName[r][1]
                        and tolower(reader[2]) == MonthName[r][2]) {
                    reader += 3;
                    if (*reader == '/' or *reader == '-')
                        reader++;
                    return r + 1;
                }
            }
            reader++;
            return -1;
        }
        while (isdigit((int)*reader))
            r = r * 10 + (*reader++ - '0');
        if (*reader == '/' or *reader == '-' or *reader == ':' or *reader == '.')
            reader++;
        return r;
}



void EasyRowCol::ExportData(Excel *excel)
{
        int max;
        EasyRowColRow * row;
        str val;
        int n1, n2, n3;

        if (excel == NULL)
            return;

        max = ListSize(Rows);        

        TfcWaitBox("Exporting to Excel... Please Wait...");
        for (int i = 0; i < max; i++) {
            if (!TfcWaitBox("Exporting to Excel... Please Wait..."))
                return;
            row = (EasyRowColRow*) Rows[i];
            for (int j = 0; j < row->MaxColumns(); j++) {
                val = row->GetColumnValues(j);
                switch(row->GetColumnType(j)) {
                    case data_string:
                        excel->SetValue(val, i+1, j+1);
                        break;
                    case data_integer:
                        excel->SetValue(atoi(val), i+1, j+1);                    
                        break;
                    case data_decimal:
                        excel->SetValue(atof(val), i+1, j+1);
                        break;
                    case data_currency:
                        excel->SetCurrency(atof(val), i+1, j+1);                                                            
                        break;
                    case data_date:
                    case data_date2:
                        reader = val;
                        n1 = getint();
                        n2 = getint();
                        n3 = getint();
                        if (DateLocale == '\0')
                            DateLocale = 'E';
                        if (DateLocale == 'I')
                            excel->SetDate(n1, n2, n3, i+1, j+1);
                        else if (DateLocale == 'U')
                            excel->SetDate(n3, n1, n2, i+1, j+1);
                        else 
                            excel->SetDate(n3, n1, n2, i+1, j+1);
                        break;
                    case data_time:
                    case data_time2:
                        reader = val;
                        n1 = getint();
                        n2 = getint();
                        n3 = getint();
                        excel->SetTime(n1, n2, n3, i+1, j+1);
                        break;
                    default : // otherwise, treat as strings
                        excel->SetValue(val, i+1, j+1);
                        break;
                }
            }
        }
        TfcWaitBox(NULL);
}


void EasyRowCol::ExportDataToExcel()
{       
        try {
            Excel excel;
            ExportData(&excel);        
            excel.SetVisible();
        } catch (str s) {
            TfcMessage("Export to Excel", '!', "%s", s);
        }
}


void EasyRowCol::ExportDataToExcelFile()
{
        try {
            char filename[2048];
            *filename = 0;
            if (!TfcSelectFilename(yes,filename,sizeof(filename),"Excel files\0*.xls\0All files\0*.*\0","xls","Enter filename for EasyRowCol file"))
                return;        
            Excel excel;
            excel.SetHeading(ListSize(Rows), this);        
            ExportData(&excel);
            excel.Save(filename);
        } catch (str s) {
            TfcMessage("Export to Excel", '!', "%s", s);
        }
}


void EasyRowCol::ExportDataToExcelSimple()
{
        RowColumnWin::Export();
}


void EasyRowCol::ExportDataToFile()
{
        RowColumnWin::SaveAsCsv();
}


void EasyRowCol::SetHighlightColour(int fColour, int bColour)
{
        HighlightBg = bColour;
        HighlightFg = fColour;
}


/*not used:
static int EasyRowColToExcel()
{
        _mainwindow->ExportDataToExcel();
        return 10;
}*/


static int EasyRowColDialogToExcel()
{
        _mainwindow->ExportDataToExcel();
        return 10;
}


static int EasyRowColDialogToExcelFile()
{
        _mainwindow->ExportDataToExcelFile();
        return 10;
}


static int EasyRowColDialogToFile()
{
        _mainwindow->ExportDataToFile();
        return 10;        
}


static int EasyRowColDialogToExcelSimple()
{
        _mainwindow->ExportDataToExcelSimple();
        return 10;        
}


static int EasyRowColDialogCancel()
{
        return 10;
}


static void EasyRowColDialogDied()
{
        _mainwindow->Export_Dlg = NULL;
        _mainwindow->Hide();
}


void EasyRowCol::ExportDialogSimple()
{
        if (Export_Dlg)
            KillModelessDialog(Export_Dlg);

        Export_Dlg = CreateModelessDialog("Export to Excel",
                Button("Export to Excel", EasyRowColDialogToExcelSimple, TFC_DEFPUSHBUTTON)
                / Button("Save as *.csv/xml/etc", EasyRowColDialogToFile)
                / Button("Cancel", EasyRowColDialogCancel), nullcontrol, EasyRowColDialogDied);
}


void EasyRowCol::ExportDialog()
{
        if (Export_Dlg)
            KillModelessDialog(Export_Dlg);

        Export_Dlg = CreateModelessDialog("Export to Excel",
                Button("Export to Excel", EasyRowColDialogToExcel, TFC_DEFPUSHBUTTON)
                / Button("Export to Excel & Save", EasyRowColDialogToExcelFile)
                / Button("Save as *.csv/xml/etc", EasyRowColDialogToFile)
                / Button("Cancel", EasyRowColDialogCancel), nullcontrol, EasyRowColDialogDied);
}


data_enum EasyRowCol::StringToDataEnum(str headertype)
{
        data_enum type;
        if (headertype == NULL or strlen(headertype) == 0)
            type = data_none;
        else {
            if (stricmp(headertype, "string") == 0)
                type = data_string;
            else if (stricmp(headertype, "security") == 0)
                type = data_security;
            else if (stricmp(headertype, "broker") == 0)
                type = data_broker;
            else if (stricmp(headertype, "house") == 0)
                type = data_broker;
            else if (stricmp(headertype, "trader") == 0)
                type = data_trader;
            else if (stricmp(headertype, "client") == 0)
                type = data_client;
            else if (stricmp(headertype, "date") == 0)
                type = data_date;
            else if (stricmp(headertype, "date2") == 0)
                type = data_date2;
            else if (stricmp(headertype, "time") == 0)
                type = data_time;
            else if (stricmp(headertype, "time2") == 0)
                type = data_time2;
            else if (stricmp(headertype, "price") == 0)
                type = data_currency;
            else if (stricmp(headertype, "currency") == 0)
                type = data_currency;
            else if (stricmp(headertype, "volume") == 0)
                type = data_integer;
            else if (stricmp(headertype, "integer") == 0)
                type = data_integer;
            else if (stricmp(headertype, "decimal") == 0)
                type = data_decimal;
            else if (strbegins(headertype, "number")) {
                type = data_decimal;
            }
            else
                type = data_none;
        }
        return type;
}

/* ------------------------------------------------------------------------------------------ */


EasyRowColRow::EasyRowColRow()
{    
        Cells = NULL;
        fgColour = NOCOLOUR;
        bgColour = NOCOLOUR;
        keyindex = -1;

        pSpecialRowDataTypes = NULL;
        bSpecialRow = false;

        FirstValuesIndex = NULL;
        for (int i = 0; i < data_sentinel+1; i++) // +1 because enums starts from 0
            ListAdd(FirstValuesIndex, -1);

}


EasyRowColRow::EasyRowColRow(EasyRowColRow & orig)
{
        Cells = NULL;
        pSpecialRowDataTypes = NULL;
        fgColour = orig.fgColour;
        bgColour = orig.bgColour;
        keyindex = orig.keyindex;
        FirstValuesIndex = NULL;        
        bSpecialRow = orig.bSpecialRow;

        for (int i = 0; i < ListSize(orig.Cells); i++) 
            ListAdd(Cells, new EasyRowColCell(*(orig.Cells[i])));

        pSpecialRowDataTypes = (data_enum *) ListCopy(orig.pSpecialRowDataTypes);
        FirstValuesIndex = (int *) ListCopy(orig.FirstValuesIndex);
}


EasyRowColRow::~EasyRowColRow()
{
        for (int i = 0; i < ListSize(Cells); i++)
            delete Cells[i];            
        ListFree(Cells);

        ListFree(FirstValuesIndex);
        ListFree(pSpecialRowDataTypes);
}



void EasyRowColRow::SetColumns(str * listofcolval, int fColour, int bColour, int keycolumnindex)
{
        if (listofcolval == NULL)
            return;
            
        for (int i = 0; i < ListSize(listofcolval); i++) {
            if (keycolumnindex == -1 and i == 0)
                AddColumn(listofcolval[i], fColour, bColour, data_key); // first in the array is the key
            else if (keycolumnindex >= 0 and i == keycolumnindex)
                AddColumn(listofcolval[i], fColour, bColour, data_key);
            else
                AddColumn(listofcolval[i], fColour, bColour);    
        }    
}


void EasyRowColRow::SetColumns(TfcPair * listofcols)
{
        if (listofcols == NULL)
            return;
            
        for (int i = 0; i < ListSize(listofcols); i++) {        
            AddColumn(listofcols[i].name, 
                      ((CellProperties *) listofcols[i].data)->fgcolour, 
                      ((CellProperties *) listofcols[i].data)->bgcolour,
                      ((CellProperties *) listofcols[i].data)->datatype);        
        }
}


void EasyRowColRow::SetKeyColumn(int keycolumnindex)
{
        if (keycolumnindex < ListSize(Cells))
            keyindex = keycolumnindex;
}


str * EasyRowColRow::GetColumns()
/* caller must free results */
{
        str * List = NULL;
        for (int i = 0; i < ListSize(Cells); i++)
            ListAdd(List, Cells[i]->GetValues());
        return List;
}


void EasyRowColRow::SetColour(int fColour, int bColour)
{
        bgColour = bColour;
        fgColour = fColour;
}


void EasyRowColRow::AddColumn(str value, int fColour, int bColour, data_enum dtype, char alignment)
{
        EasyRowColCell * cell;
    
        if (fColour != NOCOLOUR and bColour != NOCOLOUR)
            cell = new EasyRowColCell(value, fColour, bColour, dtype, alignment);    
        else if (fColour != NOCOLOUR)
            cell = new EasyRowColCell(value, fColour, bgColour, dtype, alignment);
        else if (bColour != NOCOLOUR)
            cell = new EasyRowColCell(value, fgColour, bColour, dtype, alignment);
        else
            cell = new EasyRowColCell(value, fgColour, bgColour, dtype, alignment);
        ListAdd(Cells, cell);
        if (bSpecialRow) // special rows have their own datatype array (not rely on header)
            ListAdd(pSpecialRowDataTypes, dtype);

        if (dtype == data_key)
            keyindex = ListSize(Cells)-1;
        
        if (FirstValuesIndex[dtype] == -1)
            FirstValuesIndex[dtype] = ListSize(Cells) - 1;
}


bool EasyRowColRow::DeleteColumn(int n) 
{
        data_enum dtype;
        if (n >= ListSize(Cells))
            return false;

        dtype = Cells[n]->GetType();
        if (FirstValuesIndex[dtype] == n) { // if n is one of the first index types
            for (int i = n+1; i < ListSize(Cells); i++) 
                if (Cells[i]->GetType() == dtype) {
                    FirstValuesIndex[dtype] = i;
                    break;
                }
        }

        ListDelN(Cells, n);

        return true;
}


bool EasyRowColRow::UpdateColumnValue(int n, str newvalue, data_enum dType, int fColour, int bColour)
{
        if (n >= ListSize(Cells))
            return false;

        if (newvalue != NULL) // could be just updating colour
            Cells[n]->SetValue(newvalue, dType);
        if (fColour != NOCOLOUR and bColour != NOCOLOUR)
            Cells[n]->SetColour(fColour, bColour);
        else if (fColour != NOCOLOUR)
            Cells[n]->SetColour(fColour, bgColour);
        else if (bColour != NOCOLOUR)
            Cells[n]->SetColour(fgColour, bColour);
        
        if (FirstValuesIndex[dType] > n) // New first value index?
            FirstValuesIndex[dType] = n;

        return true;
}


char EasyRowColRow::GetColumnAlignment(int n)
{
        if (n >= ListSize(Cells))
            return 'L'; 
        return Cells[n]->GetAlignment();
}


str EasyRowColRow::GetColumnValues(int n, int *pfgColour, int *pbgColour)
{        
        str s = NULL;
        if (n >= ListSize(Cells)) {
            *pfgColour = fgColour;
            *pbgColour = bgColour;
            return " "; 
        }
        
        s = Cells[n]->GetValues(pfgColour, pbgColour);
        if (s)
            return s;
            
        return " ";
}


str EasyRowColRow::GetKeyColumn()
{
        if (keyindex >=0 and keyindex < ListSize(Cells)) {
            return Cells[keyindex]->GetValues();
        }
        for (int i = 0; i < ListSize(Cells); i++)
            if (Cells[i]->GetType() == data_key)
                return Cells[i]->GetValues();
        return NULL;
}


int EasyRowColRow::GetKeyColumnIndex()
{
        if (keyindex >=0 and keyindex < ListSize(Cells)) {
            return keyindex;
        }
        for (int i = 0; i < ListSize(Cells); i++)
            if (Cells[i]->GetType() == data_key)
                return i;
        return -1;
}


str EasyRowColRow::GetFirstDataColumn(data_enum dtype)
{
        if (FirstValuesIndex[dtype] >= 0)
            return Cells[FirstValuesIndex[dtype]]->GetValues();
        return NULL;
}


int EasyRowColRow::MaxColumns()
{
        return ListSize(Cells);
}


data_enum EasyRowColRow::GetColumnType(int index)
{
        if (index >= ListSize(Cells))
            return data_none;
        return Cells[index]->GetType();
}


void EasyRowColRow::GetColours(int *fColour, int *bColour)
{
        *bColour = bgColour;
        *fColour = fgColour;
}


data_enum * EasyRowColRow::GetSpecialDataTypes()
{
        return pSpecialRowDataTypes;
}



/* ------------------------------------------------------------------------------------------ */

EasyRowColCell::EasyRowColCell(str value, int fColour, int bColour, data_enum dType, char alignment)
{
        data = strdup(value);
        fgColour = fColour;
        bgColour = bColour;
        dataType = dType;
        Alignment = alignment;
}


EasyRowColCell::EasyRowColCell(EasyRowColCell & orig)
{
        data = strdup(orig.data);
        fgColour = orig.fgColour;
        bgColour = orig.bgColour;
        dataType = orig.dataType;
        Alignment = orig.Alignment;
}


EasyRowColCell::~EasyRowColCell()
{
        free(data);
        data = NULL;
}


char EasyRowColCell::GetAlignment() 
{
        return Alignment;
}


str EasyRowColCell::GetValues(int *pfgColour, int *pbgColour) 
{
        if (pfgColour)
            *pfgColour = fgColour;
        if (pbgColour)
            *pbgColour = bgColour;
        return data;
}


void EasyRowColCell::SetColour(int fColour, int bColour)
{
        fgColour = fColour;
        bgColour = bColour;
}


void EasyRowColCell::SetValue(str value, data_enum dType)
{
        if (data)
            free(data);
        data = strdup(value);
        dataType = dType;
}


void EasyRowColCell::GetColour(int *pfgColour, int *pbgColour)
{
        *pfgColour = fgColour;
        *pbgColour = bgColour;        
}


data_enum EasyRowColCell::GetType()
{
        return dataType;
}

