/* $Id: excel.cpp 437 2005-10-14 05:00:17Z jla $ */

#pragma warning (disable : 4786 4244 4018 4800 4100 4996 4512 4237 4239)


#include <ole2.h> // OLE2 Definitions
#include <stdio.h>
#include "excel.h"
#include "tfc.h"
#include "list.h"
#include "RowColumn.h"

extern wchar_t* ToWideStrdup(kstr buf);


class ExcelData {
public:
	enum {			// If you need more than these dimensions, then you need to use the "pre-specify dimensions" constructor.
		DEFAULT_COLUMNS = 128,		
		DEFAULT_ROWS = 65536
	};
	IDispatch*	Application;
	IDispatch*	Workbooks;
	IDispatch*	Workbook;
	IDispatch*	Sheets;
	IDispatch*	Worksheet;
	IDispatch*	ActiveSheet;
	long hWnd;

	VARIANT valArray;
	int maxRow;
	int maxCol;
	int initRows;
	int initCols;
	bool changed;
	bool useCache;

	char		currDigit[4];
	bool		loaded;
	bool		visible;

	ExcelData(int cols = DEFAULT_COLUMNS, int rows = DEFAULT_ROWS);
	~ExcelData();

	VARIANT GetCompactArray();
};

ExcelData::ExcelData(int cols, int rows) {
	ActiveSheet = NULL;
	Application = NULL;
	Sheets = NULL;
	Workbook = NULL;
	Workbooks = NULL;
	Worksheet = NULL;
	hWnd = 0;
	initRows = rows;
	initCols = cols;

	VariantInit(&valArray);
	valArray.vt = VT_ARRAY | VT_VARIANT;
	SAFEARRAYBOUND valb[2];
	valb[0].lLbound = 1; valb[0].cElements = initRows;
	valb[1].lLbound = 1; valb[1].cElements = initCols;
	valArray.parray = SafeArrayCreate(VT_VARIANT, 2, valb);
	long xrows;
	long xcols;
	//check if is cache working
	if (S_OK != SafeArrayGetUBound(valArray.parray, 1, &xrows) || 
		S_OK != SafeArrayGetUBound(valArray.parray, 2, &xcols))
	{
		useCache = no;
	}
	else
	{
		useCache = yes;
	}
	maxRow = 1;
	maxCol = 1;
	changed = no;

	visible = no;
	loaded = no;

	// Save default LocalInfo settings
	GetLocaleInfo(MAKELCID(MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),SORT_DEFAULT ),
				LOCALE_ICURRDIGITS ,
				currDigit,
				4);

	// Specify new currency digits after decimal point.
	SetLocaleInfo(MAKELCID(MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),SORT_DEFAULT ),
				LOCALE_ICURRDIGITS ,
				"4");
};

ExcelData::~ExcelData() {
	if (ActiveSheet) {
		ActiveSheet->Release();
		ActiveSheet = NULL;
	}
	if (Workbook) {
		Workbook->Release();
		Workbook = NULL;
	}
	if (Workbooks) {
		Workbooks->Release();
		Workbooks = NULL;
	}
	if (Application) {
		Application->Release();
		Application = NULL;
	}

	VariantClear(&valArray);

	// Restore local settings
	SetLocaleInfo(MAKELCID(MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),SORT_DEFAULT ),
				LOCALE_ICURRDIGITS ,
				currDigit);
};

VARIANT ExcelData::GetCompactArray()
{
	VARIANT compactArray;

	VariantInit(&compactArray);
	compactArray.vt = VT_ARRAY | VT_VARIANT;
	SAFEARRAYBOUND valb[2];
	valb[0].lLbound = 1; valb[0].cElements = maxRow;
	valb[1].lLbound = 1; valb[1].cElements = maxCol;
	compactArray.parray = SafeArrayCreate(VT_VARIANT, 2, valb);

	long aLong[2];
	VARIANT varData;
	for (int row=1; row < maxRow+1; row++)
	{
		for (int col=1; col < maxCol+1; col++)
		{
			aLong[1] = col;
			aLong[0] = row;
			if (S_OK !=  SafeArrayGetElement(valArray.parray, aLong, &varData))
				continue;
			if (VT_EMPTY != varData.vt)
				SafeArrayPutElement(compactArray.parray, aLong, &varData);
		}
	}

	return compactArray;
}

void VarFromString(kstr string, VARIANT& var)
{
	var.vt = VT_BSTR;
	wchar_t* wstring = ToWideStrdup(string);
	BSTR bsRet = SysAllocStringLen(NULL, lstrlen(string));
	wcscpy(bsRet, wstring);
	var.bstrVal = bsRet;
	free(wstring);
}


static size_t ourWcstombs(char *s, wchar_t *wide, size_t n)
{
	int r = wcstombs(s, wide, n);
	if (r >= 0)
		return r;
	for (int i=0; i < n; i++) {
		if (wide[i] == 8217)
			wide[i] = '\'';
	}
	r = wcstombs(s, wide, n);
	if (r >= 0)
		return r;
	strcpy(s, "?");
	return 1;
}


bool SetToArray(SAFEARRAY* sa, int col, int row, VARIANT val)
{
	HRESULT hr = S_OK;

	//preconditions
	long rows;
	long cols;
	if (S_OK != SafeArrayGetUBound(sa, 1, &rows)) return no;
	if (S_OK != SafeArrayGetUBound(sa, 2, &cols)) return no;
	if ( col > cols ) return no;
	if ( row > rows ) return no;
	if ( 1 > col ) return no;
	if ( 1 > row ) return no;

	long aLong[2];
	aLong[1] = col;
	aLong[0] = row;
	
	hr = SafeArrayPutElement(sa, aLong, &val);
	if (S_OK == hr) {
		return yes;
	} else if (DISP_E_BADINDEX == hr) {
		MessageBox(NULL, "The specified index was invalid.", "Error writing to excel", 0x10010);
		return no;
	} else if (E_INVALIDARG == hr) {
		MessageBox(NULL, "An argument is invalid.", "Error writing to excel", 0x10010);
		return no;
	} else if (E_OUTOFMEMORY == hr) {
		MessageBox(NULL, "Memory could not be allocated for the element.", "Error writing to excel", 0x10010);
		return no;
	} else {
		char msg[200];
		sprintf(msg, "Unexpected error: %d", hr); 
		MessageBox(NULL, msg, "Error writing to excel", 0x10010);
		return no;
	}

	return yes;
}

/* This function is replicated in RowColumn.cpp, but we repeat it here for 
apps which link with excel.cpp but not RowColumn.cpp. */   
static HRESULT AutoWrap(int autoType, VARIANT *pvResult, IDispatch *pDisp, LPOLESTR ptName, int cArgs...)
{
	if (!pDisp) {
		MessageBox(NULL, "NULL IDispatch passed to AutoWrap()", "Error", 0x10010);
		//exit(0);
		return 1;
	}

	// Variables used...
	DISPPARAMS dp = { NULL, NULL, 0, 0 };
	DISPID dispidNamed = DISPID_PROPERTYPUT;
	DISPID dispID;
	HRESULT hr;
	char buf[200];
	char szName[200];

	// Convert down to ANSI
	WideCharToMultiByte(CP_ACP, 0, ptName, -1, szName, 256, NULL, NULL);

	// Get DISPID for name passed...
	hr = pDisp->GetIDsOfNames(IID_NULL, &ptName, 1, LOCALE_USER_DEFAULT, &dispID);
	if (FAILED(hr)) {
		sprintf(buf, "IDispatch::GetIDsOfNames(\"%s\") failed w/err 0x%08lx", szName, hr);
		MessageBox(NULL, buf, "AutoWrap()", 0x10010);
		//exit(0);
		return hr;
	}

	// Allocate memory for arguments...
	VARIANT *pArgs = new VARIANT[cArgs+1];
	// Extract arguments...
	va_list marker;
	va_start(marker, cArgs);
	for (int i=0; i<cArgs; i++) {
		pArgs[i] = va_arg(marker, VARIANT);
	}

	// Build DISPPARAMS
	dp.cArgs = cArgs;
	dp.rgvarg = pArgs;

	// Handle special-case for property-puts!
	if (autoType & DISPATCH_PROPERTYPUT) {
		dp.cNamedArgs = 1;
		dp.rgdispidNamedArgs = &dispidNamed;
	}

	// Make the call!
	if (pvResult)
		VariantInit(pvResult);
	hr = pDisp->Invoke(dispID, IID_NULL, LOCALE_SYSTEM_DEFAULT, autoType, &dp, pvResult, NULL, NULL);
	/*if (FAILED(hr)) {
		sprintf(buf, "IDispatch::Invoke(\"%s\"=%08lx) failed w/err 0x%08lx", szName, dispID, hr);
		MessageBox(NULL, buf, "AutoWrap()", 0x10010);
		exit(0);
		return 0;
	}*/
	va_end(marker);

	delete [] pArgs;

	return hr;
}


Excel::Excel(int columns, int rows, bool useCache)
{
	if (0 == columns || 0 == rows)
		data = new ExcelData();
	else
		data = new ExcelData(columns, rows);
	ExcelData* eData = (ExcelData*)data;
	//if eData don't have working cache we can't use it!!
	if (eData->useCache)
		eData->useCache = useCache;

	// Initialize COM for this thread...
	CoInitialize(NULL);

	// Get CLSID for our server...
	CLSID clsid;
	HRESULT hr = CLSIDFromProgID(L"Excel.Application", &clsid);
	if (FAILED(hr))
		throw "I couldn't start Excel (perhaps it's not installed)";

	// Start server and get IDispatch...
	hr = CoCreateInstance(clsid, NULL, CLSCTX_LOCAL_SERVER, IID_IDispatch, (void **)&(eData->Application));
	if (FAILED(hr))
	{
		throw "I couldn't start Excel (perhaps it's not installed)";
		return;
	}

	// Turn the cursor into a busy cursor:
	TfcBusyPush();

	// Get Workbooks collection
	{
		VARIANT result;
		VariantInit(&result);
		AutoWrap(DISPATCH_PROPERTYGET, &result, eData->Application, L"Workbooks", 0);
		eData->Workbooks = result.pdispVal;
	}

	// Call Workbooks.Add() to get a new workbook...
	{
		VARIANT result;
		VariantInit(&result);
		AutoWrap(DISPATCH_PROPERTYGET, &result, eData->Workbooks, L"Add", 0);
		eData->Workbook = result.pdispVal;
	}

	// Get Excel application hWnd
	{
		VARIANT result;
		VariantInit(&result);
		AutoWrap(DISPATCH_PROPERTYGET, &result, eData->Application, L"Hwnd", 0);
		eData->hWnd = result.lVal;
	}

	// Get ActiveSheet object
	{
		VARIANT result;
		VariantInit(&result);
		AutoWrap(DISPATCH_PROPERTYGET, &result, eData->Application, L"ActiveSheet", 0);
		eData->ActiveSheet = result.pdispVal;
	}

	eData->loaded = yes;

	// Moved from ExcelImporter
	Headings = NULL;
	row = 1;
}

Excel::Excel(str filename)
{
	data = new ExcelData(10,10);
	ExcelData* eData = (ExcelData*)data;

	// Initialize COM for this thread...
	CoInitialize(NULL);

	// Get CLSID for our server...
	CLSID clsid;
	HRESULT hr = CLSIDFromProgID(L"Excel.Application", &clsid);
	if (FAILED(hr)){
		throw "I couldn't start Excel (perhaps it's not installed)";
		return;
	}

	// Start server and get IDispatch...
	hr = CoCreateInstance(clsid, NULL, CLSCTX_LOCAL_SERVER, IID_IDispatch, (void **)&(eData->Application));
	if (FAILED(hr))
		throw "I couldn't start Excel (perhaps it's not installed)";

	// Turn the cursor into a busy cursor:
	TfcBusyPush();

	// Get Workbooks collection
	{
		VARIANT result;
		VariantInit(&result);
		AutoWrap(DISPATCH_PROPERTYGET, &result, eData->Application, L"Workbooks", 0);
		eData->Workbooks = result.pdispVal;
	}

	// Open existing workbook
	{
		VARIANT result;
		VariantInit(&result);
		VARIANT fname;
		fname.vt = VT_BSTR;
		BSTR bs = SysAllocStringLen(NULL, lstrlen(filename));
		mbstowcs(bs, filename, lstrlen(filename));
		fname.bstrVal = bs;
		AutoWrap(DISPATCH_METHOD, &result, eData->Workbooks, L"Open", 1, fname);
		eData->Workbook = result.pdispVal;
		if (NULL == eData->Workbook) {
			TfcMessage("Reading from .xls", '!', "I was unable to open your file:\n\n%s", filename);
			return;
		}
	}

	// Get Excel application hWnd
	{
		VARIANT result;
		VariantInit(&result);
		AutoWrap(DISPATCH_PROPERTYGET, &result, eData->Application, L"Hwnd", 0);
		eData->hWnd = result.lVal;
	}

	// Get sheets collection
	{
		VARIANT result;
		VariantInit(&result);
		AutoWrap(DISPATCH_PROPERTYGET, &result, eData->Workbook, L"Sheets", 0);
		eData->Sheets = result.pdispVal;
	}

	// Get ActiveSheet object
	{
		VARIANT result;
		VariantInit(&result);
		AutoWrap(DISPATCH_PROPERTYGET, &result, eData->Application, L"ActiveSheet", 0);
		eData->ActiveSheet = result.pdispVal;
	}

	// Fill cache
	{
		//IDispatch* range = (IDispatch* )GetRange(1, 1, ExcelData::DEFAULT_COLUMNS, ExcelData::DEFAULT_ROWS);
		VARIANT result;
		VariantInit(&result);
		AutoWrap(DISPATCH_PROPERTYGET, &result, eData->ActiveSheet, L"UsedRange", 0);
		IDispatch* range = result.pdispVal;
		AutoWrap(DISPATCH_PROPERTYGET, &(eData->valArray), range, L"Value", 0);
		range->Release();
	}

	eData->maxCol = GetMaxColumn();
	eData->maxRow = GetMaxRow();
	eData->loaded = yes;

	// Moved from ExcelImporter
	Headings = NULL;
	ReadHeadings();
}


void Excel::AutoSize()
{
	IDispatch* range = (IDispatch* ) GetUsedRange();

	VARIANT result;
	VariantInit(&result);
	AutoWrap(DISPATCH_PROPERTYGET, &result, range, L"Columns", 0);
	IDispatch* pXlColumns = result.pdispVal;

	AutoWrap(DISPATCH_METHOD, NULL, pXlColumns, L"AutoFit", 0);

	pXlColumns->Release();
	range->Release();
}


void Excel::SetVisible()
{
	ExcelData* eData = (ExcelData*)data;

	VARIANT x;
	x.vt = VT_I4;
	x.lVal = 1;

	Flush();
	AutoWrap(DISPATCH_PROPERTYPUT, NULL, eData->Application, L"Visible", 1, x);

	eData->visible = yes;
}


void Excel::Save(str filename)
{
	ExcelData* eData = (ExcelData*)data;

	//move all data from cache to workbook
	Flush();

	// Save workbook to filename
	char s[200];
	VARIANT parm;
	sprintf(s, "%s", filename);
	SetFileAttributes(filename, FILE_ATTRIBUTE_NORMAL);
	// delete file with s\the same name - if exists
	remove(filename);
	VarFromString(s, parm);
	AutoWrap(DISPATCH_METHOD, NULL, eData->Workbook, L"SaveAs", 1, parm);
}


Excel::~Excel()
{
	ExcelData* eData = (ExcelData*)data;

	if (!eData->visible) /* WARNING!!! */
				  /*  If neither SetVisible nor Save methods were called, */
				  /*  all data will be discared */
	{
		VARIANT x;
		x.vt = VT_BOOL;
		x.boolVal = 0;
		// Turn alerts off
		AutoWrap(DISPATCH_PROPERTYPUT, NULL, eData->Application, L"DisplayAlerts", 1, x); 
		// Tell Excel to quit (i.e. App.Quit)
		AutoWrap(DISPATCH_METHOD, NULL, eData->Application, L"Quit", 0);
		// sametimes is Excell still in memory, therefore we force Terminate it.
		DWORD processId = 0;
		GetWindowThreadProcessId((HWND)eData->hWnd, &processId);
		if (processId) {
			HANDLE lhwndProcess = OpenProcess(PROCESS_TERMINATE, 0, processId);
			TerminateProcess(lhwndProcess, 0);
			CloseHandle(lhwndProcess);
		}
	}

	if (eData) {
		delete eData;
		eData = NULL;
	}

	// Uninitialize COM for this thread...
	CoUninitialize();

	// Other stuff:
	TfcBusyPop();
}


bool Excel::SetBackground(int colour, int row, int column)
{
	VARIANT result;  
	VariantInit(&result);

	IDispatch* range = (IDispatch*)GetRange(column, row, column, row);
	//get range interior
	IDispatch* pXlInterior;
	AutoWrap(DISPATCH_PROPERTYGET, &result, range, L"Interior", 0);
	pXlInterior = result.pdispVal;  //set interior colorindex 
	VARIANT var;
	var.lVal = colour;
	var.vt = VT_I4;
	AutoWrap(DISPATCH_PROPERTYPUT, NULL, pXlInterior, L"Color", 1, var);
	pXlInterior->Release();
	range->Release();
	return yes; 
}


bool Excel::SetFontColour(int colour, int row, int column)
{
	VARIANT result;
	VariantInit(&result);

	IDispatch* range = (IDispatch*)GetRange(column, row, column, row);
	//get range interior
	IDispatch *pXlFont;
	AutoWrap(DISPATCH_PROPERTYGET, &result, range, L"Font", 0);
	pXlFont = result.pdispVal;
	//set interior colorindex 

	VARIANT var;
	var.lVal = colour;
	var.vt = VT_I4;

	//set interior colorindex 
	AutoWrap(DISPATCH_PROPERTYPUT, NULL, pXlFont, L"Color", 1, var);
	pXlFont->Release();
	range->Release();

	return yes;
}


bool Excel::Set(int column, int row, int val, kstr format)
{
	//preconditions
	ExcelData* eData = (ExcelData*)data;
	if (NULL == eData) return no;

	// Write the value:
	VARIANT varData;
	varData.lVal = val;
	varData.vt = VT_I4;
	if (eData->useCache) {
		if (!SetToArray(eData->valArray.parray, column, row, varData))
		{
			VariantClear(&varData);
			return no;
		}
	} else {
		IDispatch* range = (IDispatch*) GetRange(column,row,column,row);
		AutoWrap(DISPATCH_PROPERTYPUT, NULL, range, L"Value", 1, varData);
		range->Release();
	}

	// Write format
	SetFormat(format, row, column);

	SetMax(column, row, format);

	return yes;
}


bool Excel::Set(int column, int row, double val, kstr format)
{
	//preconditions
	ExcelData* eData = (ExcelData*)data;
	if (NULL == eData) return no;

	// Write the value:
	VARIANT varData;
	varData.dblVal = val;
	varData.vt = VT_R8;
	if (eData->useCache) {
		if (!SetToArray(eData->valArray.parray, column, row, varData))
		{
			VariantClear(&varData);
			return no;
		}
	} else {
		IDispatch* range = (IDispatch*) GetRange(column,row,column,row);
		AutoWrap(DISPATCH_PROPERTYPUT, NULL, range, L"Value", 1, varData);
		range->Release();
	}

	// Write format
	SetFormat(format, row, column);

	SetMax(column, row, format);

	return yes;
}


bool Excel::Set(int column, int row, kstr formula, kstr format)
{
	//preconditions
	ExcelData* eData = (ExcelData*)data;
	if (NULL == eData) 
		return no;
	if (NULL == formula)
		return no;

	// Write the value:
	VARIANT varData;
	VarFromString(formula, varData);
	if (eData->useCache) {
		if (!SetToArray(eData->valArray.parray, column, row, varData))
		{
			VariantClear(&varData);
			return no;
		}
	} else {
		IDispatch* range = (IDispatch*) GetRange(column,row,column,row);
		AutoWrap(DISPATCH_PROPERTYPUT, NULL, range, L"Value", 1, varData);
		range->Release();
	}

	// Write format
	SetFormat(format, row, column);

	SetMax(column, row, format);

	return yes;
}

void Excel::Flush()
{
	//preconditions
	ExcelData* eData = (ExcelData*)data;
	if (NULL == eData) return;

	if (eData->changed && eData->useCache) {
		IDispatch* range = (IDispatch*)GetRange(1, 1, eData->maxCol, eData->maxRow);
		VARIANT compactArray = eData->GetCompactArray();
		AutoWrap(DISPATCH_PROPERTYPUT, NULL, range, L"Value", 1, compactArray);
		range->Release();
	}

	AutoSize();
	eData->changed = no;
}

void Excel::GetColumnLetter(int column, str dest)
{
	char* s0 = "AABCDEFGHIJKLMNOPQRSTUVWXYZ";

	if (column<27)
		sprintf(dest,"%c", s0[column]);
	else {
		int firstchar=0;
		int secondchar=column;
		while (secondchar>26) {
			firstchar++;
			secondchar-=26;
		}
		sprintf(dest,"%c%c", s0[firstchar], s0[secondchar]);
	}
}


void* Excel::GetRange(int Col1, int Row1, int Col2, int Row2)
{
	ExcelData* eData = (ExcelData*)data;

	char s[20], c1[5], c2[5];
	IDispatch* pXlRange;
	int tmp;

#define swap(a, b) tmp=a;a=b;b=tmp;
	swap(Col1,Col2);
	swap(Row1,Row2);
#undef swap

	GetColumnLetter(Col1, c1);
	GetColumnLetter(Col2, c2);

	sprintf(s,"%s%d:%s%d",c1,Row1,c2,Row2);

	BSTR bsRet = SysAllocStringLen(NULL, lstrlen(s));
	mbstowcs(bsRet, s, lstrlen(s));

	VARIANT parm;
	parm.vt = VT_BSTR;
	parm.bstrVal = bsRet;

	VARIANT result;
	VariantInit(&result);
	AutoWrap(DISPATCH_PROPERTYGET, &result, eData->ActiveSheet, L"Range", 1, parm);
	VariantClear(&parm);
	pXlRange = result.pdispVal;

	return pXlRange;
}




bool Excel::MoveToWorksheet(kstr SheetName)
{
	ExcelData* eData = (ExcelData*)data;

	// preconditions
	if (NULL == eData)
		return no;
	if (NULL == eData->Sheets)
		return no;

	// ?! need we flush cache, if we are on this sheet
	// Laco decided that yes
	Flush();

	char sheetname[512];
	{//test if we need change it
		VARIANT result;
		VariantInit(&result);
		AutoWrap(DISPATCH_PROPERTYGET, &result, eData->ActiveSheet, L"Name", 0);
		BSTR bs = result.bstrVal;
		ourWcstombs(sheetname, bs, sizeof(sheetname));
		if (strieq(sheetname, SheetName)) {
			return yes;
		}
	}

	// get old index, if we will not find new sheet, we will return to old one
	int oldIndex = 1;
	if (eData->ActiveSheet) {
		VARIANT result;
		VariantInit(&result);
		AutoWrap(DISPATCH_PROPERTYGET, &result, eData->ActiveSheet, L"Index", 0);
		oldIndex = result.lVal;
	}

	int iMax = 0;
	{//get sheets count
		VARIANT result;
		VariantInit(&result);
		AutoWrap(DISPATCH_PROPERTYGET, &result, eData->Sheets, L"Count", 0);
		iMax = result.lVal;
	}

	for (int i=0; i<iMax; i++)
	{// test all aheets for new name
		VARIANT result;
		VariantInit(&result);
		VARIANT itemn;
		itemn.vt = VT_I4;
		itemn.lVal = i+1;
		AutoWrap(DISPATCH_PROPERTYGET, &result, eData->Sheets, L"Item", 1, itemn);
		IDispatch*	ActiveSheet = result.pdispVal;
		AutoWrap(DISPATCH_PROPERTYGET, &result, ActiveSheet, L"Name", 0);
		BSTR bs = result.bstrVal;
		ourWcstombs(sheetname, bs, sizeof(sheetname));
		if (strieq(sheetname, SheetName)) {
			//remove old data
			if (eData->ActiveSheet)
				eData->ActiveSheet->Release();
			eData->ActiveSheet = ActiveSheet;

			//refresh cache
			IDispatch* range = (IDispatch* )GetUsedRange();
			AutoWrap(DISPATCH_PROPERTYGET, &(eData->valArray), range, L"Value", 1, NULL);
			range->Release();

			//clear chanched mark
			eData->changed = no;
			Headings = NULL;
			ReadHeadings();

			return yes;
		}
	}

	{//if you not find new sheet, set old back
		VARIANT result;
		VariantInit(&result);
		VARIANT itemn;
		itemn.vt = VT_I4;
		itemn.lVal = oldIndex;
		AutoWrap(DISPATCH_PROPERTYGET, &result, eData->Sheets, L"Item", 1, itemn);
	}

	return no;
}


bool Excel::MoveToWorksheet(int SheetNum/*=1*/, char name[256]/*=NULL*/)
{
	ExcelData* eData = (ExcelData*)data;

	// preconditions
	if (NULL == eData)
		return no;
	if (NULL == eData->Sheets)
		return no;

	// ?! need we flush cache, if we are on this sheet
	// Laco decided that yes
	Flush();

	bool needChange = yes;
	{//test if we need change it
		if (eData->ActiveSheet) {
			VARIANT result;
			VariantInit(&result);
			AutoWrap(DISPATCH_PROPERTYGET, &result, eData->ActiveSheet, L"Index", 0);
			int oldIndex = result.lVal;
			if (oldIndex == SheetNum) needChange = no;
		}
	}

	if (needChange)
	{// try change it
		VARIANT result;
		VariantInit(&result);

		VARIANT itemn;
		itemn.vt = VT_I4;
		itemn.lVal = SheetNum;
		AutoWrap(DISPATCH_PROPERTYGET, &result, eData->Sheets, L"Item", 1, itemn);
		IDispatch* ActiveSheet = result.pdispVal;
		if (NULL == ActiveSheet) //sorry, we can't change to null
			return no;

		if (eData->ActiveSheet)
			eData->ActiveSheet->Release();
		eData->ActiveSheet = ActiveSheet;

		//refresh cache
		IDispatch* range = (IDispatch* )GetUsedRange();
		AutoWrap(DISPATCH_PROPERTYGET, &(eData->valArray), range, L"Value", 1, NULL);
		range->Release();

		//clear chanched mark
		eData->changed = no;
	}

	// Find the name:
	if (name) {
		VARIANT result;
		VariantInit(&result);

		AutoWrap(DISPATCH_PROPERTYGET, &result, eData->ActiveSheet, L"Name", 0);
		BSTR bs = result.bstrVal;
		ourWcstombs(name, bs, 256);
	}

	Headings = NULL;
	ReadHeadings();
	return yes;
}


str Excel::GetString(int column, int row, char dest[], int sizeofdest)
{
	HRESULT hr = S_OK;

	//preconditions
	ExcelData* eData = (ExcelData*)data;
	if (NULL == eData)
		return NULL;
	long rows = 0;
	long columns = 0;
	if (S_OK != SafeArrayGetUBound(eData->valArray.parray, 1, &rows)) return NULL;
	if (S_OK != SafeArrayGetUBound(eData->valArray.parray, 2, &columns)) return NULL;
	if ( column > columns ) return NULL;
	if ( row > rows ) return NULL;
	if ( 1 > columns ) return NULL;
	if ( 1 > rows ) return NULL;

	long aLong[2];
	aLong[1] = column;
	aLong[0] = row;

	VARIANT varData;

	if (S_OK !=  SafeArrayGetElement(eData->valArray.parray, aLong, &varData)) return NULL;

	switch (varData.vt) {
		case VT_BSTR:	ourWcstombs(dest, varData.bstrVal, sizeofdest);
						return dest;
		case VT_R8:		if (varData.dblVal == (int)varData.dblVal)
							sprintf(dest, "%d", (int)varData.dblVal);
						else sprintf(dest, "%1.2f", varData.dblVal);
						return dest;
		case VT_EMPTY:	return strcpy(dest, "");
		case VT_DATE:	{
							SYSTEMTIME st;
							VariantTimeToSystemTime(varData.date, &st);
							sprintf(dest, "%02d/%02d/%d", st.wMonth, st.wDay, st.wYear);
							return dest;
						}
		default:		return NULL;
	}
}


double Excel::GetNumber(int column, int row)
{
	HRESULT hr = S_OK;

	//preconditions
	ExcelData* eData = (ExcelData*)data;
	if (NULL == eData) {
		return NoNum;
	}
	long rows = 0;
	long columns = 0;
	if (S_OK != SafeArrayGetUBound(eData->valArray.parray, 1, &rows)) return NoNum;
	if (S_OK != SafeArrayGetUBound(eData->valArray.parray, 2, &columns)) return NoNum;
	if ( column > columns ) return NoNum;
	if ( row > rows ) return NoNum;
	if ( 1 > columns ) return NoNum;
	if ( 1 > rows ) return NoNum;

	long aLong[2];
	aLong[1] = column;
	aLong[0] = row;

	VARIANT result;
	VariantInit(&result);
	if (S_OK !=  SafeArrayGetElement(eData->valArray.parray, aLong, &result)) return NoNum;

	if (result.vt == VT_R8)
		return result.dblVal;
	else if (result.vt == VT_I4)
		return result.intVal;
	else if (result.vt == VT_BSTR) {
		char tmp[256];
		ourWcstombs(tmp, result.bstrVal, sizeof(tmp));
		if ((*tmp < '0' or *tmp > '9') and *tmp != '-' and *tmp != '.')
			return NoNum;
		return atof(tmp);
	}
	else return NoNum;
}


int Excel::GetMaxColumn()
{
	ExcelData* eData = (ExcelData*)data;

	VARIANT result;
	VariantInit(&result);

	AutoWrap(DISPATCH_PROPERTYGET, &result, eData->ActiveSheet, L"UsedRange", 0);
	IDispatch* range = result.pdispVal;
	AutoWrap(DISPATCH_PROPERTYGET, &result, range, L"Columns", 0);
	IDispatch* columns = result.pdispVal;
	AutoWrap(DISPATCH_PROPERTYGET, &result, columns, L"Count", 0);
	int MaxColm = result.intVal;

	range->Release();
	columns->Release();

	return MaxColm;
}


int Excel::GetMaxRow()
{
	ExcelData* eData = (ExcelData*)data;

	VARIANT result;
	VariantInit(&result);

	AutoWrap(DISPATCH_PROPERTYGET, &result, eData->ActiveSheet, L"UsedRange", 0);
	IDispatch* range = result.pdispVal;
	AutoWrap(DISPATCH_PROPERTYGET, &result, range, L"Rows", 0);
	IDispatch* rows = result.pdispVal;
	AutoWrap(DISPATCH_PROPERTYGET, &result, rows, L"Count", 0);
	int MaxRow = result.intVal;

	range->Release();
	rows->Release();

	return MaxRow;
}

int Excel::GetSheetsCount()
{
	int count = 0;

	// preconditions
	ExcelData* eData = (ExcelData*)data;
	if (NULL == eData) {
		return count;
	}
	if (NULL == eData->Sheets) {
		return count;
	}

	VARIANT result;
	VariantInit(&result);

	AutoWrap(DISPATCH_PROPERTYGET, &result, eData->Sheets, L"Count", 0);
	count = result.intVal;

	return count;
}


void Excel::ReadHeadings(int headingRow)
{
	char tmp[512];
	int N;

	ListFreeFree(Headings, no);
	N = GetMaxColumn();
	for (int i=1; i <= N; i++) {
		str s = GetString(i,headingRow, tmp, sizeof(tmp));
		if (s == NULL)
			*tmp = '\0';
		ListAdd(Headings, strdup(tmp));
	}
	row = headingRow;
}

bool Excel::SetHeading(int row_num, void *parent)
{
	RowColumnWin *theSource = (RowColumnWin*)parent;
	int N = ListSize(theSource->ColumnIds);
	// Create a safearray of variants...
	VARIANT arr;
	arr.vt = VT_ARRAY | VT_VARIANT;
	{
		SAFEARRAYBOUND sab;
		sab.lLbound = 1;
		sab.cElements = N;
		arr.parray = SafeArrayCreate(VT_VARIANT, 1, &sab);
	}

	// Instruct the application not to use formatting.
	theSource->ForExcel = yes;
	for (int i=0; i<=ListSize(theSource->Rows); i++) {
		for (int n=0; n < N; n++) {
			char dummy2;
			kstr dummy1;
			kstr name = theSource->GetHeading(theSource->ColumnIds[n],&dummy1,&dummy2);
			int nameLen = lstrlen(name);
			BSTR bsName = SysAllocStringLen(NULL, nameLen);
			mbstowcs(bsName, name, nameLen);
			VARIANT tmp;
			tmp.vt = VT_BSTR;
			tmp.bstrVal = bsName;
			long indicesName[] = {n+1};
			SafeArrayPutElement(arr.parray, indicesName, (void *)&tmp);
		}
	}
	// Instruct the application not to use formatting.
	theSource->ForExcel = no;

	// Get Range object for the Range A1:O15...
	IDispatch* range = (IDispatch*)GetRange(1,row_num,N,row_num);

	// Set range with our safearray...
	AutoWrap(DISPATCH_PROPERTYPUT, NULL, range, L"Value", 1, arr);
	range->Release();
	VariantClear(&arr);

	return yes;
}

bool Excel::SetValue(kstr string, int row, int column)
{
	return Set(column, row, string?string:"");
}

bool Excel::SetValue(int val, int row, int column)
{
	return Set(column, row, val);
}

bool Excel::SetValue(double val, int row, int column)
{
	return Set(column, row, val);
}

bool Excel::SetStringValue(str s, int row, int column)
{
	/* We want to avoid e.g. "97E65" being interpreted as a number, or "7-1" being
	interpreted as a date.  "192.168.16.43" is also something that would normally get 
	interpreted as a number. */
	char tmp[1024];
	if (s == NULL)
		return no;
	if (*s >= '0' and *s <= '9') {
		*tmp = '\'';
		strcpy(tmp+1, s);
		s = tmp;
	}
	return Set(column, row, s);
}

bool Excel::IsLoaded()
{
	ExcelData* eData = (ExcelData*)data;
	return eData->loaded;
}

bool Excel::ReadRow()
{
	char tmp[512];

	row++;
	return GetString(1, row, tmp, sizeof(tmp)) != NULL;
}

str Excel::Cell(kstr heading, char dest[])
{
	kstr s;

	for (int each_aeli(s, Headings))
		if (strieq(heading, s))
			return GetString(i+1, row, dest, 256);

	return strcpy(dest, "");
}


double Excel::CellNumber(kstr heading)
{
	kstr s;

	for (int each_aeli(s, Headings)) {
		if (strieq(heading, s))
			return GetNumber(i+1, row);
	}

	return NoNum;
}


str Excel::Cell(int column, char dest[])
// 0=A, 1=B, 26=AA etc.
{
	return GetString(column+1, row, dest, 256);
}

void Excel::SetMax(int column, int row, kstr format)
{
	ExcelData* eData = (ExcelData*)data;
	if (NULL == eData)
		return;

	eData->changed = yes;
	if (eData->maxCol < column )
		eData->maxCol = column;
	if (eData->maxRow < row )
		eData->maxRow = row;
}

void* Excel::GetUsedRange()
{
	ExcelData* eData = (ExcelData*)data;
	if (NULL == eData)
		return NULL;
	if (NULL == eData->ActiveSheet)
		return NULL;

	VARIANT result;
	VariantInit(&result);
	AutoWrap(DISPATCH_PROPERTYGET, &result, eData->ActiveSheet, L"UsedRange", 0);
	IDispatch* range = result.pdispVal;

	return (void*)range;
}

bool Excel::SetFormat(kstr format, int row, int column)
{
	if (format) {
		IDispatch* range = (IDispatch*) GetRange(column,row,column,row);
		VARIANT var;
		VarFromString(format, var); 
		AutoWrap(DISPATCH_PROPERTYPUT, NULL, range, L"NumberFormat", 1, var);
		range->Release();
	}

	return yes;
}


class WordData {
public:
	IDispatch*	Application;
	IDispatch*	Documents;
	IDispatch*	Document;
	IDispatch*	Fields;
	IDispatch*	MailMerge;

	bool		loaded;
	bool		visible;

	WordData();
	~WordData();
};

WordData::WordData() {
	Application = NULL;
	Documents = NULL;
	Document = NULL;
	Fields = NULL;
	MailMerge = NULL;

	visible = no;
	loaded = no;
};

WordData::~WordData() {
	if (Fields) {
		Fields->Release();
		Fields = NULL;
	}
	if (Document) {
		Document->Release();
		Document = NULL;
	}
	if (Documents) {
		Documents->Release();
		Documents = NULL;
	}
	if (Application) {
		Application->Release();
		Application = NULL;
	}
	if (MailMerge) {
		MailMerge->Release();
		MailMerge = NULL;
	}
};

WinWord::WinWord(str filename)
{
	data = new WordData();
	WordData* eData = (WordData*)data;

	// Initialize COM for this thread...
	CoInitialize(NULL);

	// Get CLSID for our server...
	CLSID clsid;
	HRESULT hr = CLSIDFromProgID(L"Word.Application", &clsid);
	if (FAILED(hr)){
		throw "I couldn't start Word (perhaps it's not installed)";
		return;
	}

	// Start server and get IDispatch...
	hr = CoCreateInstance(clsid, NULL, CLSCTX_LOCAL_SERVER, IID_IDispatch, (void **)&(eData->Application));
	if (FAILED(hr))
		throw "I couldn't start Word (perhaps it's not installed)";

	// Turn the cursor into a busy cursor:
	TfcBusyPush();

	// Get Documents collection
	{
		VARIANT result;
		VariantInit(&result);
		AutoWrap(DISPATCH_PROPERTYGET, &result, eData->Application, L"Documents", 0);
		eData->Documents = result.pdispVal;
	}

	// Open existing document
	if (filename and filename[0]){
		VARIANT result;
		VariantInit(&result);
		VARIANT fname;
		fname.vt = VT_BSTR;
		BSTR bs = SysAllocStringLen(NULL, lstrlen(filename));
		mbstowcs(bs, filename, lstrlen(filename));
		fname.bstrVal = bs;
		AutoWrap(DISPATCH_METHOD, &result, eData->Documents, L"Open", 1, fname);
		eData->Document = result.pdispVal;
		if (NULL == eData->Document) {
			TfcBusyPop();
			TfcMessage("Reading from .docx", '!', "Can't open your file:\n\n%s\n\n"
				"Can you open the file yourself from the PC running EdvalPTN? (E.g. Server)\n"
				"Is the template stored in an inaccessible place? Server accessing your desktop?\n"
				"Template already open in Word? (close it and try again)\n", filename);
			return;
		}
	}

	eData->loaded = yes;
}

WinWord::~WinWord()
{
	WordData* eData = (WordData*)data;

	if (!eData->visible) /* WARNING!!! */
				  /*  If neither SetVisible nor Save methods were called, */
				  /*  all data will be discared */
	{
		VARIANT x;
		x.vt = VT_I4;
		x.lVal = 0;
		// Turn alerts off
		AutoWrap(DISPATCH_PROPERTYPUT, NULL, eData->Application, L"DisplayAlerts", 1, x); 
		// Tell Word to quit (i.e. App.Quit)
		x.vt = VT_BOOL;
		x.boolVal = 0;
		AutoWrap(DISPATCH_METHOD, NULL, eData->Application, L"Quit", 1, x);
	}

	if (eData) {
		delete eData;
		eData = NULL;
	}

	// Uninitialize COM for this thread...
	CoUninitialize();

	// Other stuff:
	TfcBusyPop();
}

void WinWord::Quit()
{
	WordData* eData = (WordData*)data;

	if (eData)
	{
		VARIANT x;
		x.vt = VT_I4;
		x.lVal = 0;
		// Turn alerts off
		AutoWrap(DISPATCH_PROPERTYPUT, NULL, eData->Application, L"DisplayAlerts", 1, x); 
		// Tell Word to quit (i.e. App.Quit)
		x.vt = VT_BOOL;
		x.boolVal = 0;
		AutoWrap(DISPATCH_METHOD, NULL, eData->Application, L"Quit", 1, x);

		delete eData;
		eData = NULL;
	}
}

void WinWord::SetVisible()
{
	WordData* eData = (WordData*)data;

	VARIANT x;
	x.vt = VT_I4;
	x.lVal = 1;

	if (AutoWrap(DISPATCH_PROPERTYPUT, NULL, eData->Application, L"Visible", 1, x))
		return;

	eData->visible = yes;
}

bool WinWord::IsLoaded()
{
	WordData* eData = (WordData*)data;
	return eData->loaded;
}

void WinWord::FieldsUpdate()
{
	WordData* eData = (WordData*)data;

	// Get fields collection
	{
		VARIANT result;
		VariantInit(&result);
		if (AutoWrap(DISPATCH_PROPERTYGET, &result, eData->Document, L"Fields", 0))
			return;
		eData->Fields = result.pdispVal;
		AutoWrap(DISPATCH_METHOD, NULL, eData->Fields, L"Update", 0);
	}

}

void WinWord::Print()
{
	WordData* eData = (WordData*)data;

	// Get fields collection
	{
		AutoWrap(DISPATCH_METHOD, NULL, eData->Document, L"PrintOut", 0);
	}
}

void WinWord::MailMerge(kstr mdbPath, bool toPrinter)
{
	WordData* eData = (WordData*)data;

	if (NULL == eData)
		return;
	if (NULL == eData->Document)
		return;

	if (NULL == eData->MailMerge)
	// Get MailMerge 
	{
		VARIANT result;
		VariantInit(&result);
		AutoWrap(DISPATCH_PROPERTYGET, &result, eData->Document, L"MailMerge", 0);
		eData->MailMerge = result.pdispVal;
	}

	if (NULL == eData->MailMerge)
		return;

	// Set MainDocumentType = wdFormLetters
	{
		VARIANT x;
		x.vt = VT_I4;
		x.lVal = 0; //wdFormLetters

		if (AutoWrap(DISPATCH_PROPERTYPUT, NULL, eData->MailMerge, L"MainDocumentType", 1, x))
			return;
	}

	// Open Datasource 
	{
		VARIANT result;
		VariantInit(&result);
		BSTR bsName = SysAllocStringLen(NULL, lstrlen(mdbPath));
		mbstowcs(bsName, mdbPath, lstrlen(mdbPath));
		VARIANT dsName;
		dsName.vt = VT_BSTR;
		dsName.bstrVal = bsName;
		if (AutoWrap(DISPATCH_METHOD, &result, eData->MailMerge, L"OpenDataSource", 1, dsName))
			return;
	}

	// Select destination
	{
		VARIANT x;
		x.vt = VT_I4;
		x.lVal = 0; //wdSendToNewDocument = 0
		if (toPrinter)
			x.lVal = 1; //wdSendToPrinter = 1

		if (AutoWrap(DISPATCH_PROPERTYPUT, NULL, eData->MailMerge, L"Destination", 1, x))
			return;
	}

	//Build Merged document 
	{
		VARIANT result;
		VariantInit(&result);
		if (AutoWrap(DISPATCH_METHOD, &result, eData->MailMerge, L"Execute", 0))
			return;
	}

	return;
}

void WinWord::SaveAsWebPage(str webfilename)
{
	WordData* eData = (WordData*)data;

	if (NULL == eData)
		return;
	if (NULL == eData->Document)
		return;

	// save it 
	{
		VARIANT result;
		VariantInit(&result);
		BSTR bsName = SysAllocStringLen(NULL, lstrlen(webfilename));
		mbstowcs(bsName, webfilename, lstrlen(webfilename));
		VARIANT dsName;
		dsName.vt = VT_BSTR;
		dsName.bstrVal = bsName;
		int wdFormatFilteredHTML = 10;
		VARIANT fileFormat;
		fileFormat.vt = VT_I4;
		fileFormat.intVal = wdFormatFilteredHTML;
		AutoWrap(DISPATCH_METHOD, &result, eData->Document, L"SaveAs", 2, fileFormat, dsName);
	}
}
