/* $Id: excel.h 200 2005-09-23 11:05:47Z cco $ */

/* Class that wraps export to Excel application */ 

#ifndef EXCEL_H
#define EXCEL_H

#include "header.h"



class Excel {
public:
	Excel(int columns = 0, int rows = 0, bool useCache = yes); //create new excel file with defined size
	Excel(str filename); //open existing file

	~Excel();

	// Writing
	bool Set(int column, int row, int val, kstr format=NULL);
	bool Set(int column, int row, double val, kstr format=NULL);
	bool Set(int column, int row, kstr formula, kstr format=NULL);
	bool SetValue(kstr string, int row, int column);
	bool SetValue(int val, int row, int column);
	bool SetValue(double val, int row, int column);
	bool SetCurrency(double val, int row, int column);
	bool SetDate(int Year, int Month, int Day, int row, int column);
	bool SetTime(int Hour, int Minute, int Sec, int row, int column);
	bool SetStringValue(str string, int row, int column);

	// Reading:
	bool MoveToWorksheet(kstr SheetName); // with Flush
	bool MoveToWorksheet(int SheetNum=1, char name[256]=NULL); // with Flush
	str GetString(int column, int row, char dest[], int sizeofdest);
	double GetNumber(int column, int row);
	int GetSheetsCount();
	int GetMaxColumn();
	int GetMaxRow();

	// Save
	void Save(str filename); // with Flush
	void Flush(); // move data from cache to excel file and AutoSize it

	// Other:
	void SetVisible();
	bool SetBackground(int colour, int row, int column);
	bool SetFontColour(int colour, int row, int column);
	bool SetFormat(kstr format, int row, int column);
	bool IsLoaded();

	// Headings style work
	kstr* Headings;
	void ReadHeadings(int row_num=1);
	bool SetHeading(int row_num, void * parent);
	bool ReadRow();
	str Cell(kstr heading, char dest[]);
	str Cell(int column, char dest[]);	// 0=A, 1=B, 26=AA etc.
	double CellNumber(kstr heading);
	int row;

protected:
	void AutoSize();
	void GetColumnLetter(int column, str dest);
	void* GetRange(int Col1, int Row1, int Col2, int Row2);
	void* GetUsedRange();
	void SetMax(int column, int row, kstr format=NULL);

private:
	void* data;
};

/*
----     Usage with new file: 
    Excel excel; // simple create Excel object
    
    excel.Set(1, 1, "integer value : "); 
    excel.Set(2, 1,                100); 

    excel.Set(1, 2,  "double value : "); 
    excel.Set(2, 2,              99.99); 

    excel.Save("new.xls");

    excel.SetVisible(); // call either this os excel.Save to store changes
                        // otherwise all data will be lost after excel object destructing

----     Usage with existing file: 
    Excel excel("old.xls"); // simple create Excel object and open old file

    excel.MoveToWorksheet(2); // move to second sheet
    double d = excel.GetNumber(2, 1); 
    str s = excel.GetString(1, 1);

    excel.SetVisible(); // call either this os excel.Save to store changes
                        // otherwise all data will be lost after excel object destructing


*/

class WinWord {
public:
	WinWord(str filename = 0);

	~WinWord();

	void SetVisible();
	bool IsLoaded();
	void FieldsUpdate();
	void Print();
	void Quit();
	void MailMerge(kstr mdbPath, bool toPrinter);
	void SaveAsWebPage(str webfilename);

private:
	void* data;
};

#endif
