/* $Id: tfc.cpp 912 2005-11-08 00:29:04Z jla $ */

// Legend for TFC Help text:
// \t
// \n - New line
// '  - Quotes
// \" - Quotes?
// '  - Quotes?
// \1Bold\1 (The \1 closes the formatting of this type)
// \2Italics\2
// \3red\3
// \4Large\4
// \5TAB\5

// had to up the windows version because functions that were
// supposedly available to win95, were not... It should still be
// win95 comptible, but we have to ensure that no functions that
// cannot handle are not included... i.e. read MSDN documentation
// carefully.
#undef  WINVER
#define WINVER            0x0400
#define _WIN32_WINNT 0x0400
/* We want to target the lowest-common-denominator, ie. Windows 95. */
#include <windows.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <conio.h>
#include <shlobj.h>             // only for TfcSelectDir().
#include <shlwapi.h>
#include <commctrl.h>
#include <tchar.h> 
#include <ctype.h>
#include "list.h"
#include "tfc.h"


#define ID_REBAR        1000
#define EN_ENTER        0x1234
#define EN_KEYPRESS     0x1235
#define CBN_STUPIDBUG   0x1236

/* functions we use from math.h */
extern "C" double sin(double);
extern "C" double cos(double);
extern "C" double sqrt(double);
#define MPL

#define RebarParent(x) GetParent(GetParent(x))

#define WM_NOTIFY_SYSCHAR WM_USER + 2

#pragma warning ( disable : 4101 )

#define each_scrollwin            ScrollWin *sw=ScrollWinRoot; sw; sw=sw->NextSw()
    // This iterates through all top-level scrollwins.


typedef int (__stdcall *wincallback_fn)(void);




interface int response;
interface int SelectKeyDown;
interface HINSTANCE hInstance;

static bool CtrlDown=0, ShiftDown=0;
static bool Button1Down, Button2Down;
static ScrollWin * ScrollWinRoot;
static MSG EventLoopMsg;
static HWND hDlgLaco;            // Added by Laco, a global variable for the modeless dialog boxes
static kstr MessageBoxHelp;
static const char* exeFilePath;



static void ChildWindowResized(HWND hWnd);
static void PerformMenuFunction(ScrollWin *SW, int idx);
static void SendMessageToDialog(struct dialog_node* Dlg, MSG *msg);
static void* CreateMaskBitmap(void* bmp, int width, int height, int mask_colour);


#define TFC_UNICODE
#define TFC_APPLICATION     32512


/*======================= Misc functions: =======================*/

interface void stop(void)
{
}


interface void assert_failed(kstr filename, int LineNo, kstr condition)
{
    stop();
    static int cnt;
    if (++cnt <= 3) {
        if (strbegins(filename, ".\\"))
            filename += 2;
        TfcMessage("Oops.. what happened?", '!', 
            "Something may be wrong. Your timetable is confusing!\n\n"
			"Send files to support@edval.com, with any steps to reproduce.\n"
			"Add details of settings, or screen you were in, if "
			"it happens again. Screenshots are 'always helpful'.\n"
			"I 'may' have fixed it though, so don't worry too hard ;-)\n\n"
			"Assert error module: %s:%d\n%s\nVersion: %s", 
						filename, 
						LineNo, 
						condition,
						TfcGetAppVersion());
    }
}


interface bool streq(kstr a, kstr b)
{
    return a == b or (a && b && strcmp(a,b) == 0);
}


interface bool strieq(kstr a, kstr b)
{
    return a == b or (a && b && stricmp(a,b) == 0);
}


interface bool strbegins(kstr bigstr, kstr smallstr, bool casesensitive)
{
    kstr smalls = smallstr;
    kstr bigs = bigstr;
    while (*smalls) {
        if (casesensitive) {
            if (*bigs != *smalls)
                return no;
            else bigs++, smalls++;
        }
        else {
            if (toupper(*bigs) != toupper(*smalls))
                return no;
            else bigs++, smalls++;
        }
    }
    return yes;
}


interface bool strbegins(wstr bigstr, wstr smallstr, bool casesensitive)
{
    wstr smalls = smallstr;
    wstr bigs = bigstr;
    while (*smalls) {
        if (casesensitive) {
            if (*bigs != *smalls)
                return no;
            else bigs++, smalls++;
        }
        else {
            if (toupper(*bigs) != toupper(*smalls))
                return no;
            else bigs++, smalls++;
        }
    }
    return yes;
}


static int imin(int a, int b) { return a < b ? a : b; }
static int imax(int a, int b) { return a > b ? a : b; }


static kstr DoNothingConverter(kstr s)
{
	return s; 
}


interface TfcDisplayStringConverter_fn TfcDisplayStringConverter = DoNothingConverter;


interface HINSTANCE TfcGetInstance()
{  return hInstance; }


interface bool TfcShiftStatus()
{   return ShiftDown = GetKeyState(VK_SHIFT) < 0; }


interface bool TfcCtrlStatus()
{   return CtrlDown = GetKeyState(VK_CONTROL) < 0; }


/* Don't use this font if you are printing. This is likely not to be TT, and
so will not scale correctly in print preview cells */
interface TfcFont TfcGetSystemFont()
{   static HFONT sysFont;

    if (sysFont == NULL)
        //sysFont = (HFONT)TfcFindFont(-8,TFC_TTONLY, "Times New Roman");
        sysFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
    return (TfcFont)sysFont;
}


interface str TfcFontName(TfcFont font, str buffer, int bufsize)
{   HFONT oldfont;
    HDC DC;

    DC = GetDC(NULL);
    oldfont = (HFONT) SelectObject(DC, font);
    GetTextFace(DC, bufsize, buffer);
    SelectObject(DC, oldfont);
    ReleaseDC(NULL, DC);

    return buffer;
}


interface str GetSystemFontName(str buffer, int bufsize)
{
    return TfcFontName((HFONT)TfcGetSystemFont(),buffer,bufsize);
}


static HDC ScreenDC()
/* This will only ever have the system font selected. */
{   static HDC hDC;

    if (hDC == NULL) {
        hDC = CreateCompatibleDC(NULL);
        SelectObject(hDC, (HFONT)TfcGetSystemFont());
    }
    return hDC;
}


interface HDC PlayDC()
/* Use this for playing around with fonts. */
{   static HDC hDC;

    if (hDC == NULL)
        hDC = CreateCompatibleDC(NULL);
    return hDC;
}


interface HDC ColourDC()
/* For some reason, neither PlayDC() nor ScreenDC() work for this purpose. */
{   
	if (ScrollWinRoot == NULL)
		return PlayDC();
	else return (HDC)ScrollWinRoot->FindDC();
}


interface str TfcGetUserName(char dest[])
{
	DWORD len = 80;
	GetUserName(dest, &len);
	return dest;
}

interface str TfcGetComputerName(char dest[])
{
	DWORD len = 80;
	GetComputerName(dest, &len);
	return dest;
}

class HashTable {
    struct hash_node {
        int key;
        void* obj;
        hash_node* next;
    } *table[107];
public:
    HashTable();

    void** GetObject(int key);
};


HashTable::HashTable()
{
    memset(table,0,sizeof(hash_node*)*107);
}


void** HashTable::GetObject(int key)
{   hash_node* n;
    int h;

    h = (unsigned)key % 107;
    for (n=table[h]; n; n=n->next)
        if (n->key == key)
            return &n->obj;
    n = new hash_node;
    n->key = key;
    n->next = table[h];
    n->obj = NULL;
    table[h] = n;
    return &n->obj;
}


static int RestrictBrushColour(tfccolourmode_enum colourmode, int colour)
/* Process the colourmode.  Assume that this colour is a brush colour, */
/* not a line or font colour. */
{
    if (colour == NOCOLOUR)
        return NOCOLOUR;
    if (colourmode == tfc_colour)
        return colour;
    else if (colourmode == tfc_shadesofgrey) {
        int bright=((colour&0xff) + ((colour>>8)&0xff) + ((colour>>16)&0xff)) / 6 + 0x80;
        return bright | (bright<<8) | (bright<<16);
    }
    else return WHITE;
}


static int RestrictPenColour(tfccolourmode_enum colourmode, int colour)
/* Process the colourmode.  Assume that this colour is a brush colour, */
/* not a line or font colour. */
{
    if (colour == NOCOLOUR)
        return NOCOLOUR;
    if (colourmode == tfc_colour)
        return colour;
    else if (colourmode == tfc_shadesofgrey) {
        int bright=((colour&0xff) + ((colour>>8)&0xff) + ((colour>>16)&0xff)) / 3;
        return bright | (bright<<8) | (bright<<16);
    }
    else return BLACK;
}


static HBRUSH GetBrush(tfccolourmode_enum colourmode, int colour)
{   static HashTable Br;
    HBRUSH* br;

    /* First process the colourmode: */
    colour = RestrictBrushColour(colourmode, colour);

    /* Standard brushes: */
    if (colour == 0)
        return (HBRUSH)GetStockObject(BLACK_BRUSH);
    else if (colour == 0xffffff)
        return (HBRUSH)GetStockObject(WHITE_BRUSH);
    else if (colour == NOCOLOUR)
        return (HBRUSH)GetStockObject(NULL_BRUSH);

    /* Do we already have it? */
    br = (HBRUSH*)Br.GetObject(colour);
    if (*br)
        return *br;

    /* Create it: */
    if (colour & 0xff000000) {
        int style = colour>>24;
        if (style <= 1)
            // Crappy Windows built-in hatch brush
            *br = CreateHatchBrush(HS_BDIAGONAL,RGB(128,128,128));
        else if (style == 2) {
            // Black hatch brush
            WORD hatchPattern[8] = { 0x22, 0x11, 0x44, 0x88, 0x22, 0x11, 0x44, 0x88 };
            HBITMAP hatchBitmap = CreateBitmap(8, 8, 1, 1, &hatchPattern);
            *br = CreatePatternBrush(hatchBitmap);
            DeleteObject(hatchBitmap);
        }
        else if (style == 3) {
            // Translucent
            *br = CreateSolidBrush(colour&0xffffff);
        }
    }
    else *br = CreateSolidBrush(colour);
    return *br;
}


static HPEN GetPen(tfccolourmode_enum colourmode, int colour, int width)
{   static HashTable Pen;
    HPEN* pen;

    /* First process the colourmode: */
    colour = RestrictPenColour(colourmode, colour);

    /* Standard colours: */
    if (colour == 0 and width == 1)
        return (HPEN)GetStockObject(BLACK_PEN);
    else if (colour == 0xffffff and width == 1)
        return (HPEN)GetStockObject(WHITE_PEN);
    else if (colour == NOCOLOUR and width == 1)
        return (HPEN)GetStockObject(NULL_PEN);

    /* Do we already have it? */
    pen = (HPEN*)Pen.GetObject(colour | (width<<24));
    if (*pen)
        return *pen;

    /* Create it: */
    *pen = CreatePen(PS_SOLID, width, colour);
    return *pen;
}


interface str TfcStrerror(int LastError)
/* Converts a GetLastError() code into a human-readable string. */
{   static str buf;

    if (buf)
        LocalFree(buf), buf = NULL;
    if (LastError == 0)
        LastError = GetLastError();
    FormatMessage(
        FORMAT_MESSAGE_ALLOCATE_BUFFER |
        FORMAT_MESSAGE_FROM_SYSTEM |
        FORMAT_MESSAGE_IGNORE_INSERTS,
        NULL,
        LastError,
        MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
        (str)&buf,
        0,
        NULL
    );
	if (buf == NULL) {
		buf = (char*)malloc(80);
		sprintf(buf, "Error 0x%x", LastError);
	}
    return buf;
}


static HBITMAP GetBitmapOrIcon(int id, int type, int w, int h,
                    HBITMAP **maskpp, int transparentCol=0)
{   static struct hash_node {
        struct hash_node *next;
        HBITMAP hBmp;
        HBITMAP hMask;
        int id;
        int typeandsize;
    } *Hash[107], *p;
    int typeandsize,hashkey;

    typeandsize = type ^ (w<<6);
    hashkey = ((unsigned int)(id ^ (typeandsize<<5))) % 107;
    for (p=Hash[hashkey]; p; p=p->next) {
        if (p->id == id and p->typeandsize == typeandsize) {
            if (maskpp)
                *maskpp = &p->hMask;
            return p->hBmp;
        }
    }
    p = new hash_node;
    p->id = id;
    p->typeandsize = typeandsize;
    if (id == TFC_EXCLAMATION)
        p->hBmp = (HBITMAP)LoadIcon(NULL, IDI_EXCLAMATION);
    else if (id == TFC_ASTERISK)
        p->hBmp = (HBITMAP)LoadIcon(NULL, IDI_ASTERISK);
    else if (id == TFC_HAND)
        p->hBmp = (HBITMAP)LoadIcon(NULL, IDI_HAND);
    else if (id == TFC_QUESTION)
        p->hBmp = (HBITMAP)LoadIcon(NULL, IDI_QUESTION);
    else p->hBmp = (HBITMAP)LoadImage(hInstance,
                MAKEINTRESOURCE(id),
                type,
                w,h,
                LR_DEFAULTCOLOR);
    p->hMask = NULL;
    p->next = Hash[hashkey];
    Hash[hashkey] = p;
    if (maskpp)
        *maskpp = &p->hMask;
    return p->hBmp;
}


static HBITMAP GetBitmap(int id, int &w, int &h, void* *bmpMskP=NULL, int transparentCol=0)
/* The caller must set cx and cy either to the desired values, or */
/* to zero.  If zero, then it means the caller wants to know the  */
/* size, so they're filled out to the true dimensions. */
{   HBITMAP bmp, *maskp;

	/* Find or create the bitmap: */
    if (w <= 1 or h <= 1)
        w = h = 0;
	bmp = GetBitmapOrIcon(id, IMAGE_BITMAP, w, h, &maskp, transparentCol);

    /* Get the dimensions if needed: */
    if (w == 0) {
        BITMAP bm;
        bm.bmWidth = bm.bmHeight = 32;
        GetObject(bmp, sizeof(bm), &bm);
        w = bm.bmWidth;
        h = bm.bmHeight;
    }

    /* Make a mask if necessary: */
    if (bmpMskP) {
        if (*maskp == NULL)
            *maskp = (HBITMAP)CreateMaskBitmap(bmp, w,h, transparentCol);
        *bmpMskP = *maskp;
    }

    return bmp;
}


static HBITMAP GetBitmap(int id)
{   int w=0,h=0;

    return GetBitmap(id, w,h, NULL,0);
}


static HICON GetIcon(int id, int cx/*=32 or 16*/)
{
    return (HICON)GetBitmapOrIcon(id, IMAGE_ICON, cx, cx, NULL);
}


interface void* TfcGetBitmap(int id, int &w, int &h, void **maskp, int transparentCol)
/* This function is really provided just for canvas.cpp. */
{
    return (void*)GetBitmap(id, w,h,maskp,transparentCol);
}


interface void TfcBitmapDimensions(int id, int *widthp, int *heightp)
{
    *widthp = *heightp = 0;
    GetBitmap(id, *widthp, *heightp);
}


static bool IsFixedFont(HFONT font)
{
	TEXTMETRIC tm;
	bool isFixed;
	HDC hDC;

	hDC = GetDC(NULL);
	HGDIOBJ old = SelectObject(hDC, font);

	GetTextMetrics(hDC, &tm);
	isFixed = !(tm.tmPitchAndFamily & TMPF_FIXED_PITCH);

	SelectObject(hDC, old);
	ReleaseDC(NULL,hDC);;

	return isFixed;
}


interface TfcFont TfcFindFont(int size, unsigned int Flags/*=0*/, char* Face/*=NULL*/)
/* Create a font with these properties or find an existing font */
/* if you've already created one.   If you specify 'size' as    */
/* negative, then this matches the Microsoft point size, e.g.   */
/* Times Roman 12 would be TfcFindFont(-12,0,"Times Roman").    */
{   struct fontcache_node {
        int key;
        str Face;
        void *wndFont;
    } *Cf = NULL;
    static struct fontcache_node *Cache;
    TfcFont font;
    int i, key;

    if (size < 0)
        size = MulDiv(size, GetDeviceCaps(PlayDC(), LOGPIXELSY), 72);
    key = size + (Flags << 16);
    if (Face == NULL)
        Face = "";

    for (each_oeli(Cf, Cache)) {
        if (Cf->key == key and streq(Cf->Face, Face))
            return Cf->wndFont;
    }
    wchar_t* FaceW = ToWideStrdup(Face);

    font = CreateFontW(
            size,                                     // height,
            0,                                        // average width
            0,                                        // angle of escapement
            0,                                        // base-line orientation angle
            (Flags & TFC_BOLD) ? FW_BOLD : FW_DONTCARE,// font weight
            (Flags & TFC_ITALIC) != 0,               // italics
            (Flags & TFC_UNDERLINE) != 0,             // underline
            no,                                       // strikeout
            //ANSI_CHARSET,                             // character set
            DEFAULT_CHARSET,
            Flags & TFC_TTONLY ? OUT_TT_ONLY_PRECIS : OUT_DEFAULT_PRECIS,
                                                      // output precision
            CLIP_DEFAULT_PRECIS,                      // clip precision
            DEFAULT_QUALITY,                          // output quality
            Flags & TFC_FIXED ? FIXED_PITCH | FF_DONTCARE : DEFAULT_PITCH,
                                                      // pitch and family
            FaceW                                      // face
    );

    // If the fixed font was required - check if the result is good for us
    if (!IsFixedFont((HFONT) font)) {
        DeleteObject(font);
        font = CreateFontW(
                size,                                     // height,
                0,                                        // average width
                0,                                        // angle of escapement
                0,                                        // base-line orientation angle
                (Flags & TFC_BOLD) ? FW_BOLD : FW_DONTCARE,// font weight
                (Flags & TFC_ITALIC) != 0,               // italics
                (Flags & TFC_UNDERLINE) != 0,             // underline
                no,                                       // strikeout
                ANSI_CHARSET,                             // character set
                Flags & TFC_TTONLY ? OUT_TT_ONLY_PRECIS : OUT_DEFAULT_PRECIS,// output precision
                CLIP_DEFAULT_PRECIS,                      // clip precision
                DEFAULT_QUALITY,                          // output quality
                Flags & TFC_FIXED ? FIXED_PITCH : DEFAULT_PITCH,
                                                                                                        // pitch and family
                FaceW);                                      // face
	}

    free(FaceW);

    Cf = (fontcache_node*)ListNext(Cache);
    Cf->key = key;
    Cf->Face = strdup(Face);
    Cf->wndFont = font;
    return font;
}


interface TfcFont TfcFindFont(int size, bool bold, bool italic, bool FixedWidth, char* Face)
{   unsigned int Flags;

    Flags = (bold ? TFC_BOLD : 0) |
            (italic ? TFC_ITALIC : 0) |
            (FixedWidth ? TFC_FIXED : 0);

    return TfcFindFont(size, Flags, Face);
}


interface int TfcFontHeight(TfcFont font)
{   TEXTMETRIC Metrics;
    HDC hDC;

    hDC = GetDC(NULL);
    SelectObject(hDC, font);
    GetTextMetrics(hDC, &Metrics);
    int height = Metrics.tmHeight;// - Metrics.tmInternalLeading;
    ReleaseDC(NULL,hDC);
    return height;
}


TfcFont TfcDefaultFont(bool bFixed)
{   static HFONT  hFFont = NULL, hVFont = NULL;
    HFONT *pFont;

    pFont = bFixed ? &hFFont : &hVFont;
    if (!*pFont)
        *pFont = (HFONT)TfcFindFont(0, bFixed ? TFC_FIXED : 0, (str)NULL);
    return (TfcFont)*pFont;
}


TfcFont TfcPrinterFont(TfcFont ModelFont, int iNewHeight, str Face)
/* Guarantees to return a TrueType font, that can be scaled to suit */
/* both the PrintPreview screen and the printer. */
{   LOGFONT       lf;
    unsigned int  Flags;

    if (not ModelFont)
        ModelFont = (HFONT)TfcGetSystemFont();

    GetObject(ModelFont, sizeof(LOGFONT), (LPVOID)&lf);

    Flags = (lf.lfWeight > FW_MEDIUM ? TFC_BOLD : 0) |
            (lf.lfItalic ? TFC_ITALIC : 0) |
            ((lf.lfPitchAndFamily & 3) == FIXED_PITCH ? TFC_FIXED : 0) |
            (lf.lfUnderline ? TFC_UNDERLINE : 0);
    Flags |= TFC_TTONLY;


    return TfcFindFont(iNewHeight, Flags, Face ? Face : lf.lfFaceName);
}


interface str TfcFontToString(TfcFont font, char dest[])
{   LOGFONT Logfnt;

    if (font == NULL)
        return strcpy(dest, "");
    GetObject(font, sizeof(Logfnt), &Logfnt);
    if (Logfnt.lfHeight > 100)
        return strcpy(dest, "");    // sanity check
    sprintf(dest, "%d-%d-%d-%d-%d-%x-%x-%s",
            Logfnt.lfHeight,
            Logfnt.lfWidth,
            Logfnt.lfWeight,
            Logfnt.lfItalic,
            Logfnt.lfCharSet,
            Logfnt.lfPitchAndFamily,
            Logfnt.lfOutPrecision,
            Logfnt.lfFaceName);
    return dest;
}


interface TfcFont TfcStringToFont(str s)
{   int lfItalic, lfCharSet, lfPitchAndFamily, lfOutPrecision;
    LOGFONT Logfnt;

    if (s == NULL or not (IsUTF8Digit(*s) or *s == '-'))
        return NULL;
    clearS(Logfnt);
    Logfnt.lfClipPrecision = 2;
    Logfnt.lfQuality = 1;
    sscanf(s, "%d-%d-%d-%d-%d-%x-%x-%[^\n]",
            &Logfnt.lfHeight,
            &Logfnt.lfWidth,
            &Logfnt.lfWeight,
            &lfItalic,
            &lfCharSet,
            &lfPitchAndFamily,
            &lfOutPrecision,
            Logfnt.lfFaceName);
    if (Logfnt.lfHeight > 100)
        return NULL;        // sanity check
    Logfnt.lfItalic = lfItalic;
    Logfnt.lfCharSet = lfCharSet;
    Logfnt.lfPitchAndFamily = lfPitchAndFamily;
    Logfnt.lfOutPrecision = lfOutPrecision;
    return CreateFontIndirect(&Logfnt);
}


int TfcContrastingColour(int colour)
{   int lum;

    lum = 80*(colour&0xff) + 100*((colour>>8)&0xff) + 50*((colour>>16)&0xff);
    if (lum >= 100 * 255)
        return BLACK;
    else return WHITE;
}


interface int TfcDarken(int c)
{   int r,g,b;

    r = c & 0xff;
    c >>= 8;
    g = c & 0xff;
    c >>= 8;
    b = c & 0xff;
    r /= 2;
    g /= 2;
    b /= 2;
    return r | (g << 8) | (b << 16);
}




/*======================= Litewin's and Drawing primitives: =======================*/

/* A Litewin is like a Windows window, i.e. a rectangular area        */
/* of the screen that responds to various messages, except that        */
/* it is very lightweight - only 12 bytes overhead (8 if you        */
/* have your own classes with virtual functions that inherit        */
/* from it).  Therefore it's appropriate to be used as lines in        */
/* an editor, cells in a spreadsheet and so on.                        */
/*        It provides all drawing primitives, and responds to        */
/* keystrokes and mouse input. */



void* Litewin::GetReady(TfcPaintDetails *paintDetails, int x, int y)
{
	GetPaintDetails(paintDetails, x,y);
	paintDetails->SetClipper();
	if (paintDetails->clipRegion.isEmpty())
		return NULL;
	return paintDetails->hDC;
}


static PBITMAPINFO CreateBitmapInfoStruct(HBITMAP hBmp, WORD cClrBits = 0)
{   PBITMAPINFO pbmi;
    BITMAP bmp;

    // Retrieve the bitmap's color format, width, and height.
    if (!GetObject(hBmp, sizeof(BITMAP), (LPSTR)&bmp)) {
        assert(false);
        return NULL;
    }

    // Convert the color format to a count of bits.
    if (cClrBits == 0)
        cClrBits = (WORD)(bmp.bmPlanes * bmp.bmBitsPixel);

    if (cClrBits == 1)
        cClrBits = 1;
    else if (cClrBits <= 4)
        cClrBits = 4;
    else if (cClrBits <= 8)
        cClrBits = 8;
    else if (cClrBits <= 16)
        cClrBits = 16;
    else if (cClrBits <= 24)
        cClrBits = 24;
    else cClrBits = 32;


    // Allocate memory for the BITMAPINFO structure. (This structure
    // contains a BITMAPINFOHEADER structure and an array of RGBQUAD
    // data structures.)
    if (cClrBits < 24)
        pbmi = (PBITMAPINFO) malloc(
                sizeof(BITMAPINFOHEADER) +
                sizeof(RGBQUAD) * (1<< cClrBits));
    else
        pbmi = (PBITMAPINFO) malloc(sizeof(BITMAPINFOHEADER));
        // There is no RGBQUAD array for the 24-bit-per-pixel format.


    // Initialize the fields in the BITMAPINFO structure.
    pbmi->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
    pbmi->bmiHeader.biWidth = bmp.bmWidth;
    pbmi->bmiHeader.biHeight = bmp.bmHeight;
    pbmi->bmiHeader.biPlanes = bmp.bmPlanes;
    pbmi->bmiHeader.biBitCount = cClrBits;
    if (cClrBits < 24)
        pbmi->bmiHeader.biClrUsed = (1<<cClrBits);

    // If the bitmap is not compressed, set the BI_RGB flag.
    pbmi->bmiHeader.biCompression = BI_RGB;

    // Compute the number of bytes in the array of color
    // indices and store the result in biSizeImage.
    // Width must be DWORD aligned unless bitmap is RLE compressed.
    pbmi->bmiHeader.biSizeImage = 16*((pbmi->bmiHeader.biWidth + 15) /16)
                                  * pbmi->bmiHeader.biHeight
                              * cClrBits / 8;
    // Set biClrImportant to 0, indicating that all of the
    // device colors are important.
    pbmi->bmiHeader.biClrImportant = 0;
    return pbmi;
}


static void RotateVertical(HDC DC, HDC hMemDC, HBITMAP hBmp,
                           RECT Rect, POINT OrigPt,
                           int isUpwards, int transparent)
/* Rotates bitmap, selected into hMemDC to 90 degrees angle */
/* and outputs it into DC */
{   int i,j, w_normal, w_rotate, offset ,height;
    int oldBkClr, oldTxtClr;
    HBITMAP hMaskBmp, hSBmp;
    char* pBits, *pRotated;
    BITMAPINFOHEADER* pbh;
    HDC hdcMem1, hdcMem2;
    HBITMAP hbmT, hbmT2;
    BITMAPINFO* pbi;

    pbi = CreateBitmapInfoStruct(hBmp,8);
    if (not pbi)
        return;
    pbh = (BITMAPINFOHEADER*)pbi;
    w_normal = 4*((pbh->biWidth + 3) /4);
    offset = w_normal - pbh->biWidth;
    w_rotate = 4*((pbh->biHeight + 3) /4);

    pBits =    (char*)GlobalAlloc(GMEM_FIXED, w_normal*pbh->biHeight+100);
    if (pBits == NULL) {
        free(pbi);
        return;
    }
    pRotated = (char*)GlobalAlloc(GMEM_FIXED, w_rotate*pbh->biWidth+100);
    if (pRotated == NULL) {
        GlobalFree(pBits);
        free(pbi);
        return;
    }

    if (not GetDIBits(hMemDC,hBmp,0,pbh->biHeight,pBits,pbi,DIB_RGB_COLORS)) {
        GlobalFree(pBits);
        GlobalFree(pRotated);
        free(pbi);
        return;
    }

               //    Rotate Bitmap
    if (isUpwards)            //  upwards
        for (j=0; j< pbh->biHeight; j++)
            for (i=0; i< pbh->biWidth; i++)
                pRotated[i*w_rotate + j] = pBits[(pbh->biHeight - j - 1)*w_normal + i] ;
    else
        for (j=0; j< pbh->biHeight; j++)
            for (i=0; i< pbh->biWidth; i++)
                pRotated[i*w_rotate + j] = pBits[(j+1)*w_normal  - offset - i - 1] ;

    height = pbh->biWidth;
    pbh->biWidth = pbh->biHeight;
    pbh->biHeight = height;

    if (transparent == NOCOLOUR)
        StretchDIBits(DC,OrigPt.x,OrigPt.y,
                  Rect.bottom, Rect.right,
                  0,0,
                  Rect.bottom, Rect.right,
                  pRotated,
                  pbi,
                  DIB_RGB_COLORS,
                  SRCCOPY);
    else {

        hdcMem1 = CreateCompatibleDC(NULL);
        hMaskBmp = CreateBitmap(pbh->biWidth, pbh->biHeight,1,1,NULL);
        hbmT = (HBITMAP) SelectObject(hdcMem1,hMaskBmp);

        SetBkColor(hdcMem1,transparent);
        StretchDIBits(hdcMem1,0,0,
                  Rect.bottom, Rect.right,
                  0,0,
                  Rect.bottom, Rect.right,
                  pRotated,
                  pbi,
                  DIB_RGB_COLORS,
                  SRCCOPY);

        oldBkClr = SetBkColor(DC,transparent == WHITE ? BLACK : WHITE);
        oldTxtClr = SetTextColor(DC,transparent);
        BitBlt(DC,OrigPt.x,OrigPt.y, pbh->biWidth, pbh->biHeight, hdcMem1,0,0,SRCPAINT);

        if (transparent == WHITE) {
            hdcMem2 = CreateCompatibleDC(DC);
            hSBmp = CreateCompatibleBitmap(DC,pbh->biWidth, pbh->biHeight);
            hbmT2 = (HBITMAP) SelectObject(hdcMem2,hSBmp);
            SetBkColor(hdcMem2,WHITE);
            StretchDIBits(hdcMem2,0,0,
                  Rect.bottom, Rect.right,
                  0,0,
                  Rect.bottom, Rect.right,
                  pRotated,
                  pbi,
                  DIB_RGB_COLORS,
                  SRCCOPY);

            SetBkColor(DC,BLACK);
            SetTextColor(DC,WHITE);
            BitBlt(DC,OrigPt.x,OrigPt.y, pbh->biWidth, pbh->biHeight, hdcMem2,0,0,SRCAND);
            SelectObject(hdcMem2,hbmT2);
            DeleteDC(hdcMem2);
            DeleteObject(hSBmp);
        }

        SetBkColor(DC,oldBkClr);
        SetTextColor(DC,oldTxtClr);
        SelectObject(hdcMem1,hbmT);
        DeleteDC(hdcMem1);
        DeleteObject(hMaskBmp);
    }

    DeleteObject(hBmp);
    DeleteDC(hMemDC);
    free(pbi);
    GlobalFree(pBits);
    GlobalFree(pRotated);
}

static bool IsUnicode(wchar_t* wbuf)
{
	for (int i=0; wbuf[i]; i++) {
		bool ascii  = (wbuf[i] < 0x7F) or (wbuf[i] >= 0x300 and wbuf[i] <= 0x36f);
		if (!ascii)
			return true;
	}
	return false;
}


void Litewin::DrawStringU(const wchar_t* wbuf, int n, TfcFont font,
				int x1, int y1, int x2, int y2,
				int foreground, int background, int flags)
{   TfcPaintDetails paintDetails;
    bool transparent=no;
    HBITMAP hBmp = NULL;
    int dt_flags;
    POINT orig;
    RECT Rect;
    HDC hDC;
    wstr s;

    if (GetReady(&paintDetails, x1,y1) == NULL)
		return;
	Rect.left = x1 + paintDetails.winX;
    Rect.top = y1 + paintDetails.winY;
    Rect.right = x2 + paintDetails.winX;
    Rect.bottom = y2 + paintDetails.winY;
    orig.x = Rect.left; 
	orig.y = Rect.top;

    if (flags & (TFC_UPWARDSTEXT|TFC_DOWNWARDSTEXT)) {
        // if draw vertical - draw into bitmap
        if (Rect.bottom < Rect.top)
            Rect.bottom ^= Rect.top, Rect.top ^= Rect.bottom, Rect.bottom ^= Rect.top;
        int h = Rect.bottom - Rect.top;
        Rect.bottom = Rect.right - Rect.left;
        Rect.right = h;
        Rect.left = Rect.top = 0;

        hDC = CreateCompatibleDC((HDC)paintDetails.hDC);
        hBmp = CreateCompatibleBitmap((HDC)paintDetails.hDC, Rect.right, Rect.bottom);
        assert(hBmp);
        SelectObject(hDC,hBmp);

        if (background == NOCOLOUR) {
            transparent = yes;
            background = foreground == WHITE ? BLACK : WHITE;//TfcContrastingColour(foreground);
            FillRect(hDC, &Rect, GetBrush(paintDetails.colourMode, background));
        }
    }
    else {
        hDC = (HDC)paintDetails.hDC;
    }

    SelectObject(hDC, font ? (HFONT)font : (HFONT)TfcGetSystemFont());
    s = wcschr((wchar_t*)wbuf, '\t');
    dt_flags = 0;
    if (flags & TFC_SINGLELINE)
        dt_flags |= DT_SINGLELINE;
    if (flags & TFC_WORDBREAK)
        dt_flags |= DT_WORDBREAK;
    if (flags & TFC_CENTRE)
        dt_flags |= DT_CENTER;
    else if (flags & TFC_RIGHTALIGN)
        dt_flags |= DT_RIGHT;
    else dt_flags |= DT_LEFT | DT_TOP;

    if (s and s-wbuf < n) {
        /* Win32 seems to leave the tabs un-filled-in. */
        DrawRectangle(x1, y1, x2, y2, background, NOCOLOUR);
    }
    else if (background != NOCOLOUR) {
        RECT Calc=Rect;
        DrawTextW(hDC, wbuf, n, &Calc, DT_CALCRECT | DT_NOPREFIX | dt_flags);
        if (Calc.bottom != Rect.bottom or Calc.right != Rect.right)
            FillRect(hDC, &Rect, GetBrush(paintDetails.colourMode, background));
    }
    n = wcslen(wbuf);
    SetTextColor(hDC, RestrictPenColour(paintDetails.colourMode, foreground));
    SetBkColor(hDC, RestrictBrushColour(paintDetails.colourMode, background));
    SetBkMode(hDC, (background == NOCOLOUR) ? TRANSPARENT : OPAQUE);
    DrawTextW(hDC, wbuf,n, &Rect, DT_NOPREFIX | dt_flags);

    if (flags & (TFC_UPWARDSTEXT|TFC_DOWNWARDSTEXT))
        RotateVertical((HDC)paintDetails.hDC, hDC, hBmp, Rect, orig, flags & TFC_UPWARDSTEXT,
                    transparent ? background : NOCOLOUR);
}


interface void Litewin::DrawStringU(kstr buf, int n, TfcFont font,
        int x1, int y1, int x2, int y2,
        int foreground, int background, int flags)
/* Draw this string in this rectangle.  If necessary, it first     */
/* clears the whole rectangle, because Windows doesn't necessarily */
/* use the whole rectangle. */
{
    assert(buf != NULL);

    int size = (n == -1) ? strlen(buf) : n;
    wchar_t* wbuf = (wchar_t*)malloc(sizeof(wchar_t)*(size+1));
    memset(wbuf , 0, sizeof(wchar_t)*(size+1));
    Utf8ToWide(buf, wbuf, size*2);
    DrawStringU(wbuf, n, font, x1, y1, x2, y2, foreground, background, flags);
    free(wbuf);
}


interface void Litewin::DrawString(kstr buf, int n, TfcFont font,
        int x1, int y1, int x2, int y2,
        int foreground, int background, int flags)
/* Draw this string in this rectangle.  If necessary, it first     */
/* clears the whole rectangle, because Windows doesn't necessarily */
/* use the whole rectangle. */
{   TfcPaintDetails paintDetails;
    bool transparent=no;
    int dt_flags;
    HBITMAP hBmp;
    POINT orig;
    RECT Rect;
    HDC hDC;
    str s;

    assert(buf != NULL);
    hBmp = NULL;
	HDC DC = (HDC)GetReady(&paintDetails, x1,y1);
	if (DC == NULL)
		return;
    Rect.left = x1 + paintDetails.winX;
    Rect.top = y1 + paintDetails.winY;
    Rect.right = x2 + paintDetails.winX;
    Rect.bottom = y2 + paintDetails.winY;
    orig.x = Rect.left; 
	orig.y = Rect.top;

    if (flags & (TFC_UPWARDSTEXT|TFC_DOWNWARDSTEXT)) {
        // if draw vertical - draw into bitmap
        if (Rect.bottom < Rect.top)
            Rect.bottom ^= Rect.top, Rect.top ^= Rect.bottom, Rect.bottom ^= Rect.top;
        int h = Rect.bottom - Rect.top;
        Rect.bottom = Rect.right - Rect.left;
        Rect.right = h;
        Rect.left = Rect.top = 0;

        hDC = CreateCompatibleDC(DC);
        hBmp = CreateCompatibleBitmap(DC,Rect.right, Rect.bottom);
        assert(hBmp);
        SelectObject(hDC,hBmp);

        if (background == NOCOLOUR) {
            transparent = yes;
            background = foreground == WHITE ? BLACK : WHITE;//TfcContrastingColour(foreground);
            FillRect(hDC, &Rect, GetBrush(paintDetails.colourMode, background));
        }
    }
    else {
        hDC = DC;
    }

    SelectObject(hDC, font ? (HFONT)font : (HFONT)TfcGetSystemFont());
    s = strchr((str)buf, '\t');
    dt_flags = 0;
    if (flags & TFC_SINGLELINE)
        dt_flags |= DT_SINGLELINE;
    if (flags & TFC_WORDBREAK)
        dt_flags |= DT_WORDBREAK;
    if (flags & TFC_CENTRE)
        dt_flags |= DT_CENTER;
    else if (flags & TFC_RIGHTALIGN)
        dt_flags |= DT_RIGHT;
    else dt_flags |= DT_LEFT | DT_TOP;

    if (s and s-buf < n) {
        /* Win32 seems to leave the tabs un-filled-in. */
        DrawRectangle(x1, y1, x2, y2, background, NOCOLOUR);
    }
    else if (background != NOCOLOUR) {
        RECT Calc=Rect;
        DrawText(hDC, buf, n, &Calc, DT_CALCRECT | DT_NOPREFIX | dt_flags);
        if (Calc.bottom != Rect.bottom or Calc.right != Rect.right)
            FillRect(hDC, &Rect, GetBrush(paintDetails.colourMode, background));
    }
    SetTextColor(hDC, RestrictPenColour(paintDetails.colourMode, foreground));
    SetBkColor(hDC, RestrictBrushColour(paintDetails.colourMode, background));
    SetBkMode(hDC, (background == NOCOLOUR) ? TRANSPARENT : OPAQUE);
    DrawText(hDC, buf, n, &Rect, DT_NOPREFIX | dt_flags);

    if (flags & (TFC_UPWARDSTEXT|TFC_DOWNWARDSTEXT))
        RotateVertical(DC, hDC, hBmp, Rect, orig, flags & TFC_UPWARDSTEXT,
                    transparent ? background : NOCOLOUR);
}


void Litewin::DrawString(kstr buf, TfcFont font, int x, int y, str pos,
            int foreground, int background)
{   int w,h;

    TextDimensions(buf,-1,font,&w,&h);
    if (*pos == '<')
        x -= w;
    else if (*pos == '|')
        x -= w/2;
    if (pos[1] == '^')
        y -= h;
    else if (pos[1] == '-')
        y -= y/2;
    DrawString(buf,-1,font,x,y,x+w,y+h,foreground,background);
}


interface void TextDimensionsW(void* DC, wstr buf, int n, TfcFont font, uint *widthp,
                         uint *heightp, int flags/*=0*/,
                         int maxwidth/*=32767*/)
{   HFONT hDCFont;
    RECT Rect;
    HDC hDC = (HDC) DC;
    wchar_t ex[2]; ex[0] = '!'; ex[1] = 0;

    assert(buf != NULL);
    if (hDC == NULL)
        hDC = PlayDC();

    Rect.left = 0;
    Rect.top = 0;
    Rect.right = maxwidth != -1 ? maxwidth : 32767;
    Rect.bottom = 32767;

    hDCFont = (HFONT) SelectObject(hDC, font ? (HFONT)font : (HFONT)TfcGetSystemFont());

    if (n == 0) {
        *widthp = 0;
        ::DrawTextW(hDC, ex, 1, &Rect, DT_CALCRECT |
                DT_LEFT | DT_NOPREFIX | DT_TOP | DT_SINGLELINE);
        *heightp = Rect.bottom;
    }
    else {
        int dt_flags = 0;
        if (flags & TFC_SINGLELINE)
            dt_flags |= DT_SINGLELINE;
        else dt_flags = DT_WORDBREAK;
        if (flags & TFC_CENTRE)
            dt_flags |= DT_CENTER;
        else dt_flags |= DT_LEFT | DT_TOP;
        ::DrawTextW(hDC, buf, n, &Rect, DT_CALCRECT |
                DT_LEFT | DT_TOP | DT_NOPREFIX | dt_flags);
        if (flags & TFC_UPWARDSTEXT || flags & TFC_DOWNWARDSTEXT) {
            *widthp = Rect.bottom;
            *heightp = Rect.right;
        }
        else {
            *widthp = Rect.right;
            *heightp = Rect.bottom;
        }
    }
    SelectObject(hDC, hDCFont);
}


void Litewin::TextDimensions(kstr buf, int n, TfcFont font, uint *widthp,
                         uint *heightp, int flags/*=0*/,
                         int maxwidth/*=32767*/)
{   HFONT hDCFont;
    RECT Rect;
    HDC hDC;

    assert(buf != NULL);
    if (this) {
		hDC = (HDC)FindDC();
        if (hDC == NULL)
            hDC = PlayDC();
    }
    else hDC = PlayDC();
	if (strlen(buf) > 512) {
		wstr wbuf = ToWideStrdup(buf);
		TextDimensionsW(hDC, wbuf, n, font, widthp, heightp, flags, maxwidth);
		free(wbuf);
	}
	else {
		wchar_t wbuf[1024];
		Utf8ToWide(buf, wbuf, 1024);
		TextDimensionsW(hDC, wbuf, n, font, widthp, heightp, flags, maxwidth);
	}
}


interface void Litewin::DrawRectangle(
					int x1, int y1, int x2, int y2,
					int colour, int border)
{   TfcPaintDetails paintDetails;
    RECT Rect;
	int mode;

	HDC DC = (HDC)GetReady(&paintDetails, x1,y1);
	if (DC == NULL)
		return;
    if ((colour & 0xff000000) and colour != NOCOLOUR) {
        Rect.left = x1 + paintDetails.winX;
        Rect.top = y1 + paintDetails.winY;
        Rect.right = x2 + paintDetails.winX;
        Rect.bottom = y2 + paintDetails.winY;
        int style = colour >> 24;
        if (style == 1) {
            mode = SetROP2(DC,R2_MASKPENNOT);
            SetBkMode(DC, TRANSPARENT);
            SetBkColor(DC, RestrictBrushColour(paintDetails.colourMode, colour));
            SetTextColor(DC, RGB(128,128,128));
        }
        else if (style == 2) {
            SetBkMode(DC, TRANSPARENT);
            mode = SetROP2(DC,R2_MASKPEN);
            SetBkColor(DC, RestrictBrushColour(paintDetails.colourMode, RGB(0,0,0)));
            SetTextColor(DC, RGB(255,255,255));
        }
        else if (style == 3) {
            mode = SetROP2(DC,R2_MERGEPEN);
        }
        else {
            mode = SetROP2(DC,R2_BLACK);
        }
        if (colour == COLOR_MENU)
            SelectObject(DC, (HBRUSH)(COLOR_MENU+1));
        else {
            SelectObject(DC, GetPen(paintDetails.colourMode, border, paintDetails.lineWidth));
            SelectObject(DC, GetBrush(paintDetails.colourMode, colour|0x1000000));
        }
        Rectangle(DC, x1 + paintDetails.winX, y1 + paintDetails.winY, x2 + paintDetails.winX, y2 + paintDetails.winY);
        SetROP2(DC,mode);
        if (border != NOCOLOUR) {
            // (tco) The ROP2 thingo seems to prevent a normal
            // pen being used to draw the border.
            SelectObject(DC, GetBrush(paintDetails.colourMode, NOCOLOUR));// null brush
            Rectangle(DC, x1 + paintDetails.winX, y1 + paintDetails.winY, x2 + paintDetails.winX, y2 + paintDetails.winY);
        }

    }
    else if (border == NOCOLOUR and (colour & 0xff000000) == 0) {
        Rect.left = x1 + paintDetails.winX;
        Rect.top = y1 + paintDetails.winY;
        Rect.right = x2 + paintDetails.winX;
        Rect.bottom = y2 + paintDetails.winY;
        if (colour == COLOR_MENU)
            FillRect(DC, &Rect, (HBRUSH)(COLOR_MENU+1));
        else FillRect(DC, &Rect, GetBrush(paintDetails.colourMode, colour));
    }
    else {
        SelectObject(DC, GetBrush(paintDetails.colourMode, colour));
        SelectObject(DC, GetPen(paintDetails.colourMode, border, paintDetails.lineWidth));
        if (colour & 0xff000000)
            SetBkMode(DC, TRANSPARENT);
        else SetBkMode(DC, OPAQUE);
        Rectangle(DC, x1 + paintDetails.winX, y1 + paintDetails.winY, x2 + paintDetails.winX, y2 + paintDetails.winY);
    }
}


void Litewin::DrawBlendRectangle(int x0, int y0, int x1, int y1, int colour1, int colour2,
            int clipy0/*=-9999*/, int clipy1/*=-9999*/)
/* A rectangle whose colour blends from colour1 (top) to colour2 (bottom). */
{   int y,R1,G1,B1,R2,G2,B2,R,G,B,colour,a,b;
	TfcPaintDetails paintDetails;

	HDC DC = (HDC)GetReady(&paintDetails, x0,y0);
	if (DC == NULL)
		return;
	x0 += paintDetails.winX;
    x1 += paintDetails.winX;
    y0 += paintDetails.winY;
    y1 += paintDetails.winY;
    if (paintDetails.colourMode == tfc_blackandwhite or paintDetails.colourMode == tfc_shadesofgrey)
        colour1 = colour2 = WHITE;
        // Keep in mind the difficulty to get info from Spread printouts
        // if we have shades of grey on a blended grey background.
    if (colour1 == colour2 or colour2 == NOCOLOUR) {
        RECT Rect;
        Rect.left = x0;
        Rect.top = y0;
        Rect.right = x1;
        Rect.bottom = y1;
        FillRect(DC, &Rect, GetBrush(paintDetails.colourMode, colour1));
        return;
    }
    R1 = colour1 & 0xff;
    G1 = (colour1 >> 8) & 0xff;
    B1 = colour1 >> 16;
    R2 = colour2 & 0xff;
    G2 = (colour2 >> 8) & 0xff;
    B2 = colour2 >> 16;
    if (clipy0 == -9999)
        clipy0 = y0;
    else clipy0 += paintDetails.winY;
    if (clipy1 == -9999)
        clipy1 = y1;
    else clipy1 += paintDetails.winY;
    for (y=clipy0; y < clipy1; y++) {
        if (y < y0)
            a = 0;
        else if (y >= y1)
            a = 256;
        else a = (y - y0) * 256 / (y1 - y0);
        b = 256 - a;
        R = (R2*a + R1*b) / 256;
        G = (G2*a + G1*b) / 256;
        B = (B2*a + B1*b) / 256;
        colour = R | (G<<8) | (B<<16);
        HPEN pen = CreatePen(PS_SOLID, 1, colour);
        HPEN prevpen = (HPEN) SelectObject(DC, pen);
        MoveToEx(DC, x0, y, NULL);
        LineTo(DC, x1, y);
        SelectObject(DC,prevpen);
        DeleteObject(pen);
    }
}

interface void Litewin::DrawPieSlice(
            int x1, int y1, int x2, int y2,
            double start, double stop,
            int colour, int border)
{   int x_1, x_2,y_1,y_2,cx,cy,rx,ry;
	TfcPaintDetails paintDetails;

	HDC DC = (HDC)GetReady(&paintDetails, x1,y1);
	if (DC == NULL)
		return;
    SelectObject(DC,
            (colour == NOCOLOUR) ? (HBRUSH)GetStockObject(NULL_BRUSH)
                : GetBrush(paintDetails.colourMode, colour));
    SelectObject(DC,
            (border == NOCOLOUR) ? (HPEN)GetStockObject(NULL_PEN)
                : GetPen(paintDetails.colourMode, border, paintDetails.lineWidth));
    if (colour & 0xff000000) {
        SetBkColor(DC, colour & 0xffffff);
        SetTextColor(DC, BLACK);
    }

#define PI 3.14159265358979323846
    cx = (x1+x2) / 2 + paintDetails.winX;
    cy = (y1+y2) / 2 + paintDetails.winY;
    rx = (x2-x1) / 2;
    ry = (y2-y1) / 2;
    x_2 = cx + rx * sin(start*PI/50);
    x_1 = cx + rx * sin(stop*PI/50);
    y_2 = cy - ry * cos(start*PI/50);
    y_1 = cy - ry * cos(stop*PI/50);

    if (x_2 == x_1 and y_2 == y_1)
        return;

    Pie(DC, x1 + paintDetails.winX, y1 + paintDetails.winY, x2 + paintDetails.winX, y2 + paintDetails.winY,
            x_1,
            y_1,
            x_2,
            y_2
    );
}


void Litewin::DrawCurve(int Ax, int Ay, int Bx, int By, TfcRect rect, int colour, int width)
{	TfcPaintDetails paintDetails;

	HDC DC = (HDC)GetReady(&paintDetails, Ax,Ay);
	if (DC == NULL)
		return;
    SelectObject(DC, GetPen(paintDetails.colourMode, colour, width*paintDetails.lineWidth));

    Arc(DC,
        paintDetails.winX + rect.left, paintDetails.winY + rect.top, paintDetails.winX + rect.right, paintDetails.winY + rect.bottom,
        paintDetails.winX + Ax, paintDetails.winY + Ay, paintDetails.winX + Bx, paintDetails.winY + By);
}


interface void Litewin::DrawEllipse(
					int x1, int y1, int x2, int y2,
					int colour, int border)
{   TfcPaintDetails paintDetails;

	HDC DC = (HDC)GetReady(&paintDetails, x1,y1);
	if (DC == NULL)
		return;
    x1 += paintDetails.winX;
    x2 += paintDetails.winX;
    y1 += paintDetails.winY;
    y2 += paintDetails.winY;
    if (x2 - x1 == 12) {
        /* Windows draws ugly 12-pixel circles, so I've done my own: */
        SelectObject(DC, GetPen(paintDetails.colourMode, colour, 1));
        static int B[12] = { 0,1,3,4,4,5,5,4,4,3,1,0 };
        int cx = (x1 + x2) / 2;
        for (int i=0; i < 12; i++) {
            MoveToEx(DC, cx-B[i]-1, i+y1, NULL);
            LineTo(DC, cx+B[i], i+y1);
            SetPixel(DC, cx-B[i]-1, i+y1, border);
            SetPixel(DC, cx+B[i], i+y1, border);
        }
        SetPixel(DC, cx-3, y1+1, border);
        SetPixel(DC, cx+2, y1+1, border);
        SetPixel(DC, cx-3, y2-2, border);
        SetPixel(DC, cx+2, y2-2, border);
    }
    else {
        SelectObject(DC,
                (colour == NOCOLOUR) ? (HBRUSH)GetStockObject(NULL_BRUSH)
                    : GetBrush(paintDetails.colourMode, colour));
        SelectObject(DC,
                (border == NOCOLOUR) ? (HPEN)GetStockObject(NULL_PEN)
                    : GetPen(paintDetails.colourMode, border, paintDetails.lineWidth));
        if (colour & 0xff000000) {
            SetBkColor(DC, colour & 0xffffff);
            SetTextColor(DC, BLACK);
        }
        Ellipse(DC, x1, y1, x2, y2);
    }
}


void Litewin::DrawPolygon(int colour, int border, int x1, int y1, ...)
/* A polygon filled with 'colour'.  Specify the points as a variable argument        */
/* list, terminated by TFC_ENDOFPOLY.  The last point is automatically linked        */
/* to the  first - don't specify the starting point twice. */
{   TfcPaintDetails paintDetails;
    POINT P[100];
    va_list args;
    int i=0;
    
	HDC DC = (HDC)GetReady(&paintDetails, x1,y1);
	if (DC == NULL)
		return;

    P[i].x = x1 + paintDetails.winX;
    P[i++].y = y1 + paintDetails.winY;

    va_start(args, y1);
    do {
        P[i].x = va_arg(args, int);
        if (P[i].x == TFC_ENDOFPOLY)
            break;
        P[i].y = va_arg(args, int);
        if (P[i].y == TFC_ENDOFPOLY) {
            TfcMessage("TFC Runtime error", 'x', "DrawPolygon(): You have an odd number of coords.");
            break;
        }
        P[i].x += paintDetails.winX;
        P[i].y += paintDetails.winY;
        i++;
    } forever;
    va_end(args);
    SelectObject(DC, GetBrush(paintDetails.colourMode, colour));
    SelectObject(DC, GetPen(paintDetails.colourMode, border, paintDetails.lineWidth));
    Polygon(DC, P, i);
}


void Litewin::DrawPolygon(int colour, int border, TfcPoint *List, int List_idx)
/* As above but specifies the points as an array of points. */
{   TfcPaintDetails paintDetails;
    POINT* P;
    
	HDC DC = (HDC)GetReady(&paintDetails, List[0].x, List[0].y);
	if (DC == NULL)
		return;
	P = new POINT[List_idx];
    for (int i=0; i < List_idx; i++) {
        P[i].x = List[i].x + paintDetails.winX;
        P[i].y = List[i].y + paintDetails.winY;
    }
    SelectObject(DC, GetBrush(paintDetails.colourMode, colour));
    SelectObject(DC, GetPen(paintDetails.colourMode, border, paintDetails.lineWidth));
    Polygon(DC, P, List_idx);

    delete[] P;
}


void Litewin::DrawRoundedPolyLine(int lineColour, int width, int x1, int y1, int radius1, ...)
/* A closed line with rounded corners.  Specify the points as a variable argument */
/* list, terminated by TFC_ENDOFPOLY.  The last point is automatically linked     */
/* to the first - don't specify the starting point twice. */
{   TfcPaintDetails paintDetails;
    va_list args;
	struct PointRadius : POINT {
		int radius;
	} P[100];
    POINT A,B,C;
    int n=0;
    
	HDC DC = (HDC)GetReady(&paintDetails, x1,y1);
	if (DC == NULL)
		return;

    SelectObject(DC, GetPen(paintDetails.colourMode, lineColour, width*paintDetails.lineWidth));

	// Get the args into our ring:
    P[n].x = x1 + paintDetails.winX;
    P[n].y = y1 + paintDetails.winY;
	P[n].radius = radius1;
	n++;
    va_start(args, radius1);
    do {
        P[n].x = va_arg(args, int);
        if (P[n].x == TFC_ENDOFPOLY)
            break;
        P[n].y = va_arg(args, int);
        if (P[n].y == TFC_ENDOFPOLY) {
            TfcMessage("TFC Runtime error", 'x', "DrawPolygon(): You have an odd number of coords.");
            break;
        }
		P[n].radius = va_arg(args, int);
        P[n].x += paintDetails.winX;
        P[n].y += paintDetails.winY;
        n++;
    } forever;
    va_end(args);

	// Check that the radii aren't too large:
	for (int i=0; i < n; i++) {
		PointRadius &A = i > 0 ? P[i-1] : P[n-1];
		PointRadius &B = P[i];
		int distance = (abs(A.x-B.x) + abs(A.y-B.y)) / 2;
		if (distance < A.radius)
			A.radius = distance;
		if (distance < B.radius)
			B.radius = distance;
	}

	// Draw the straight lines:
	for (int i=0; i < n; i++) {
		PointRadius A = i > 0 ? P[i-1] : P[n-1];
		PointRadius B = P[i];
		POINT E = A;
		POINT F = B;
		if (A.radius) {
			if (F.x > E.x)
				E.x += A.radius;
			else if (F.x < E.x)
				E.x -= A.radius;
			else if (F.y > E.y)
				E.y += A.radius;
			else if (F.y < E.y)
				E.y -= A.radius;
		}
		if (B.radius) {
			if (E.x > F.x)
				F.x += B.radius;
			else if (E.x < F.x)
				F.x -= B.radius;
			else if (E.y > F.y)
				F.y += B.radius;
			else if (E.y < F.y)
				F.y -= B.radius;
		}
		MoveToEx(DC, E.x, E.y, NULL);
		LineTo(DC, F.x, F.y);
	}

	// Draw the curves:
	SetArcDirection(DC, AD_CLOCKWISE);
	for (int i=0; i < n; i++) {
		int radius = P[i].radius;
		if (radius == 0)
			continue;
		POINT A = i > 0 ? P[i-1] : P[n-1];
		POINT B = P[i];
		POINT C = i + 1 < n ? P[i+1] : P[0];
		if ((A.y > B.y and C.x > B.x) or (A.x > B.x and C.y > B.y))
			Arc(DC, B.x,B.y,B.x+2*radius,B.y+2*radius, B.x,B.y+radius, B.x+radius,B.y);
		else if ((A.x < B.x and C.y > B.y) or (A.y > B.y and C.x < B.x))
			Arc(DC, B.x-2*radius,B.y,B.x,B.y+2*radius, B.x-radius,B.y, B.x,B.y+radius);
		else if ((A.y < B.y and C.x < B.x) or (A.x < B.x and C.y < B.y))
			Arc(DC, B.x-2*radius,B.y-2*radius,B.x,B.y, B.x,B.y-radius, B.x-radius,B.y);
		else if ((A.x > B.x and C.y < B.y) or (A.y < B.y and C.x < B.x))
			Arc(DC, B.x,B.y-2*radius,B.x+2*radius,B.y, B.x+radius,B.y, B.x,B.y-radius);
	}
}


void Litewin::DrawPixel(int x, int y, int colour)
/* Set a pixel. */
{   TfcPaintDetails paintDetails;
    
	HDC DC = (HDC)GetReady(&paintDetails, x,y);
	if (DC == NULL)
		return;
	SetPixel(DC, x + paintDetails.winX, y + paintDetails.winY, 
						RestrictPenColour(paintDetails.colourMode, colour));
}


void Litewin::DrawLine(int x0, int y0, int x1, int y1, int colour, int width)
/* Draw a line. */
{   TfcPaintDetails paintDetails;
    
	HDC DC = (HDC)GetReady(&paintDetails, x0,y0);
	if (DC == NULL)
		return;
	SelectObject(DC, GetPen(paintDetails.colourMode, 
								colour, width*paintDetails.lineWidth));
    MoveToEx(DC, x0 + paintDetails.winX, y0 + paintDetails.winY, NULL);
    LineTo(DC, x1 + paintDetails.winX, y1 + paintDetails.winY);
}


void Litewin::DrawLineWithArrow(int x0, int y0, int x1, int y1, int arrowheadSize, int colour, int width)
/* Draw a line. */
{   TfcPaintDetails paintDetails;
	double x,y,r,cosa,sina;
    
	HDC DC = (HDC)GetReady(&paintDetails, x0,y0);
	if (DC == NULL)
		return;
	x0 += paintDetails.winX;
	x1 += paintDetails.winX;
	y0 += paintDetails.winY;
	y1 += paintDetails.winY;

	// The line:
	SelectObject(DC, GetPen(paintDetails.colourMode, 
								colour, width*paintDetails.lineWidth));
    MoveToEx(DC, x0, y0, NULL);
    LineTo(DC, x1, y1);

	// The arrowhead:
	x = x0 - x1;
	y = y0 - y1;
	r = sqrt(x*x + y*y) / arrowheadSize;
	x /= r;
	y /= r;
	sina = 0.258819045;
	cosa = 0.965925826;	// 15 degrees
	//sina = 0.342020143;
	//cosa = 0.939692621;// 20 degrees
	//cosa = 0.866;
	//sina = 0.5;		// 30 degrees
	x0 = x1 + cosa*x - sina*y;
	y0 = y1 + sina*x + cosa*y;
    MoveToEx(DC, x0, y0, NULL);
    LineTo(DC, x1, y1);    
	x0 = x1 + cosa*x + sina*y;
	y0 = y1 - sina*x + cosa*y;
    MoveToEx(DC, x0, y0, NULL);
    LineTo(DC, x1, y1);
}


void Litewin::DrawBitmap(int x1, int y1, int x2, int y2, int bitmap_id,
				int sourcewidth, int sourceheight, int flags)
/* Draw a bitmap, scaled if necessary. */
{
    HBITMAP bitmap = GetBitmap(bitmap_id);
    if (bitmap == NULL || bitmap == INVALID_HANDLE_VALUE) {
        TfcMessage("TFC Runtime error", 'x',
                    "This EXE has no bitmap resource with id %d", bitmap_id);
        return;
    }
    DrawBitmap(x1,y1,x2,y2, (void*)bitmap, sourcewidth, sourceheight, flags);
}


void Litewin::DrawBitmap(int x1, int y1, int x2, int y2, void* hBitmap,
				int sourcewidth, int sourceheight, int flags)
{   TfcPaintDetails paintDetails;
    
	HDC DC = (HDC)GetReady(&paintDetails, x1,y1);
	if (DC == NULL)
		return;
	SetTextColor(DC, WHITE);
    SetBkColor(DC, BLACK);
    SetBkMode(DC, OPAQUE);
    if (sourcewidth == 0)
        sourcewidth = x2 - x1;
    if (sourceheight == 0)
        sourceheight = y2 - y1;
    HDC hdcMem = CreateCompatibleDC(DC);
    SelectObject(hdcMem, (HBITMAP)hBitmap);
	StretchBlt(
			DC,         // destination DC
			x1+paintDetails.winX, y1+paintDetails.winY,
			x2-x1, y2-y1,
			hdcMem,    // source device context
			0, 0,      // x and y upper left
			sourcewidth, sourceheight,
			SRCCOPY); // raster operation
    DeleteDC(hdcMem);
}


void Litewin::DrawMonoBitmap(int x1, int y1, int x2, int y2, int bitmap_id,
                int fg_colour, int bg_colour,
                int sourcewidth, int sourceheight, int flags)
/* Take a mono (2-colour) bitmap and display it with the desired colours. */
{   TfcPaintDetails paintDetails;
    
	HDC DC = (HDC)GetReady(&paintDetails, x1,y1);
	if (DC == NULL)
		return;
	SetTextColor(DC, fg_colour);
    SetBkColor(DC, bg_colour);
    SetBkMode(DC, OPAQUE);
    HBITMAP bitmap = GetBitmap(bitmap_id);
    HDC hdcMem = CreateCompatibleDC(DC);
    HGDIOBJ oldObject = SelectObject(hdcMem, bitmap);
    if (sourcewidth == 0)
        sourcewidth = x2 - x1;
    if (sourceheight == 0)
        sourceheight = y2 - y1;
    StretchBlt(
        DC,         // destination DC
        x1+paintDetails.winX, y1+paintDetails.winY,
        x2-x1, y2-y1,
        hdcMem,    // source device context
        0, 0,      // x and y upper left
        sourcewidth, sourceheight,
        SRCCOPY); // raster operation
    SelectObject(hdcMem, oldObject);
    DeleteDC(hdcMem);
}


void Litewin::GetFontRange(int *minheightp, int *maxheightp)
/* Work out the smallest and largest readable fonts. */
{
    HDC DC = (HDC)FindDC();
    if (DC == NULL)
        DC = ScreenDC();
    *maxheightp = GetDeviceCaps(DC, LOGPIXELSY) / 4;        // A quarter of an inch in height
    if (*maxheightp > 90)
        *minheightp = GetDeviceCaps(DC, LOGPIXELSY) / 16;        // For printers: A 10th of an inch in height
    else *minheightp = GetDeviceCaps(DC, LOGPIXELSY) / 8;        // For screens:  An 8th of an inch in height
}


void* Litewin::FindDC()
/* Skip upwards till you get to the top-level scrollwin. */
{
    if (parent == NULL)
        return NULL;
	return parent->FindDC();
}


void* ScrollWin::FindDC()
/* Skip upwards till you get to the top-level scrollwin. */
{
	if (hWnd and not hDC) {      // Never allocate a HDC without a HWND!
		hDC = GetDC((HWND)hWnd);
        SelectClipRgn((HDC)hDC, NULL);
    }
	return hDC;
}


ScrollWin* Litewin::FindSW()
/* Skip upwards till you get to the top-level scrollwin. */
{
    if (parent == NULL)
        return NULL;
	return parent->FindSW();
}


void ScrollWin::WakeUpWindows7()
/* Due to a bug in Windows7, we sometimes need to issue random paint commands */
{
	SetPixel((HDC)hDC, 0,0,0xc0c0c0);
}


void Litewin::MapXYToWindowCoords(int *pMapX, int *pMapY)
/* Map litewin coords to screen coords */
{   TfcPaintDetails paintDetails;
    
    GetPaintDetails(&paintDetails, *pMapX,*pMapY);
	*pMapX += paintDetails.winX;
	*pMapY += paintDetails.winY;
}


void Litewin::MapXYToScreenCoords(int *pMapX, int *pMapY)
/* Map litewin coords to screen coords */
{   HWND hParent;
	POINT XY;
    
	MapXYToWindowCoords(pMapX, pMapY);
	XY.x = *pMapX;
	XY.y = *pMapY;
    hParent = (HWND)_hWnd();
	if (hParent) {
        MapWindowPoints(hParent, HWND_DESKTOP, &XY, 1);
		*pMapX = XY.x;
		*pMapY = XY.y;
	}
}


void* Litewin::_hWnd()
/* Skip upwards until we reach a ScrollWin. */
{   Litewin *lw=parent;

	return (lw && lw != this) ? lw->_hWnd() : NULL;
}


void Litewin::PaintWhole()
/* Paint the whole rectangle. */
{   TfcPaintDetails paintDetails;
	TfcRect Rect;

    GetPaintDetails(&paintDetails,0,0);
	Rect = paintDetails.clipRegion;
	PaintWithUnscrollables(0, 0, Rect.right-Rect.left, Rect.bottom-Rect.top);
}





/*------------------------ ScrollWin's: ----------------------*/

void ScrollWin::GetClientWindowSize(int *width, int *height)
/* Return the true full windows size inclusive of resize bars, menus */
/* bars and window title */
{
    RECT WindowRect, ClientRect;
    int diffX, diffY;

    GetWindowRect((HWND)this->_hWnd(), &WindowRect);
    GetClientRect((HWND)this->_hWnd(), &ClientRect);

    diffX = (WindowRect.right - WindowRect.left) - (ClientRect.right - ClientRect.left);
    diffY = (WindowRect.bottom - WindowRect.top) - (ClientRect.bottom - ClientRect.top);

    *width  = WindowRect.right - WindowRect.left;
    *height = WindowRect.bottom - WindowRect.top;
}


bool ScrollWin::IsMaximised()
{
    return IsZoomed((struct HWND__ *)this->_hWnd()) != 0;
}


bool ScrollWin::IsMinimised()
{
    // (awa) Added this function for Problemo 6878.
    WINDOWPLACEMENT wndPl;
    GetWindowPlacement((HWND) hWnd, &wndPl);

    if ( wndPl.showCmd == SW_SHOWMINIMIZED )
        return true;

    return false;
}


void ScrollWin::GetClientWindowPosition(int *top, int *left)
{
    RECT WindowRect;

    GetWindowRect((HWND)this->_hWnd(), &WindowRect);
    *top  = WindowRect.top;
    *left = WindowRect.left;
}



/*------------------- Saving & restoring window positions: ---------------*/

TfcWindowPosition::TfcWindowPosition()
{
	top = 100;
	left = 100;
	width = 600;
	height = 500;
	maximised = no;
	defined = no;
}


void TfcWindowPosition::readFromString(kstr s)
{
	int m;
	defined = (s != NULL and *s != '\0');
	if (not defined)
		return;
	sscanf(s, "%d,%d,%d,%d,%d", &left, &top, &width, &height, &m);
	maximised = (m != 0);
}


void TfcWindowPosition::writeToString(char dest[])
{
	if (not defined)
		*dest = '\0';
	else sprintf(dest, "%d,%d,%d,%d,%d", left, top, width, height, int(maximised));
}


void TfcWindowPosition::sendToWindow(ScrollWin *win)
{
	if (not defined)
		return;
	int horzres = GetDeviceCaps((HDC)PlayDC(), HORZRES);
	int vertres = GetDeviceCaps((HDC)PlayDC(), VERTRES);
	int centreX = left + width/2;
	if (centreX < 0 or centreX > horzres)
		return;
	int centreY = top + height/2;
	if (centreY < 0 or centreY > vertres)
		return;
	SetWindowPos((struct HWND__ *)win->_hWnd(),
                 HWND_TOP,
                 left,
                 top,
                 width,
                 height,
                 0
                 );
    if (maximised)
        win->Maximise();
    else win->Restore();
}


void TfcWindowPosition::readFromWindow(ScrollWin *win)
{
    win->GetClientWindowSize(&width, &height);
    win->GetClientWindowPosition(&top, &left);
    maximised = win->IsMaximised();
	defined = yes;
}


static TfcRegistryKey AppRegistryKey;


interface void TfcSetAppRegistryBranch(kstr appName)
{
	AppRegistryKey = TfcRegistryKey(yes, TFC_CURRENT_USER, "Software", appName, NULL);
}


interface TfcRegistryKey& TfcGetAppRegistryBranch()
{
	if (AppRegistryKey == NULL)
		AppRegistryKey = TfcRegistryKey(no, TFC_CURRENT_USER, "Software", "TFC", NULL);
	return AppRegistryKey; 
}


void TfcWindowPosition::sendToRegistry(kstr subkeyName)
{	char tmp[512];

	if (not defined)
		return;
	writeToString(tmp);
	TfcRegistryKey key = TfcGetAppRegistryBranch().Subkey(yes, subkeyName);
	key.Set(tmp);
}


void TfcWindowPosition::readFromRegistry(kstr subkeyName)
{	char tmp[512];

	TfcRegistryKey key = TfcGetAppRegistryBranch().Subkey(yes, subkeyName);
	key.Get(tmp, sizeof(tmp));
	readFromString(tmp);
}


void TfcWindowPosition::saveToRegistry(ScrollWin *win, kstr subkeyName)
{
	readFromWindow(win);
	sendToRegistry(subkeyName);
}


bool TfcWindowPosition::restoreFromRegistry(ScrollWin *win, kstr subkeyName)
{
	readFromRegistry(subkeyName);
	if (not defined)
		return no;
	sendToWindow(win);
	return yes;
}





/*======================== ScrollWin's: ========================*/

/* A scrollwin is the TFC equivalent of a main Windows window,  */
/* i.e. WS_OVERLAPPED window, i.e. a window with title bar,     */
/* resizing frame and scrollbars. */


static uint CursorTimer;

void _stdcall TimerCursorOn(void* hWnd, uint message, uint Timer, long SysTime);
static bool DialogCommand(ScrollWin *sw, struct dialog_node *d, int id, int msg);

interface bool QuitEventLoop;  // Signal to exit the event loop (with all windows intact).
interface ScrollWin* CursorSw;
interface ScrollWin *WaitingForKeystroke;        // Signal to exit the event loop rather than process keystrokes.
static bool WaitingForAnyKeystroke;                // Used only by TfcYield.




ScrollWin* ScrollWin::SwFromWnd(void *hWnd)
{
    for (each_scrollwin) {
        if (sw->hWnd == hWnd)
            return sw;
    }
    return NULL;
}


static void OnPaint(void* _hWnd)
{   PAINTSTRUCT paintStruct;
    HWND hWnd=(HWND)_hWnd;
    int x1, y1, x2, y2;
    ScrollWin * sw;
    HDC hDC, OldDC;

    hDC = BeginPaint(hWnd, &paintStruct);
    if (hDC == NULL)
		return;
    sw = ScrollWin::SwFromWnd(hWnd);
	if (sw) {
        OldDC = (HDC)sw->hDC;
        sw->hDC = hDC;
        if (sw->isBufferOutput)
            sw->BufferPaints(hDC);
        if (sw->ShowState == tfc_dirtyshouldpaint) {
            sw->ShowState = tfc_shown;
            ShowWindow((HWND)sw->hWnd, SW_SHOW);
            DrawMenuBar((HWND)sw->hWnd);
            sw->RedrawStatusBar();
            sw->UpdateScrollbars(sw->scrollX, sw->scrollY);
        }

        /* Converting the windows coords to scrollwin coords: */
		sw->ShowState = tfc_shown;
        x1 = paintStruct.rcPaint.left + sw->scrollX;
        y1 = paintStruct.rcPaint.top - 20 - sw->DialogHeight + sw->scrollY;
        x2 = paintStruct.rcPaint.right + sw->scrollX;
        y2 = paintStruct.rcPaint.bottom - sw->DialogHeight + sw->scrollY;
        if (y1 < 0)
            y1 = 0;

		/* Painting it: */
		sw->PaintWithUnscrollables(x1, y1, x2, y2);

		//
        if (sw->isBufferOutput)
            sw->FlushBuffer();
        sw->hDC = OldDC;
        if (sw == CursorSw and sw->cursor.state)
            sw->CursorOn();
		SelectClipRgn(OldDC, NULL);
    }
    EndPaint(hWnd, &paintStruct);
}


void TfcPaintDetails::SetClipper()
{
	SelectClipRgn((HDC)hDC, NULL);
	IntersectClipRect((HDC)hDC, 
					clipRegion.left,clipRegion.top, 
					clipRegion.right,clipRegion.bottom);
}


TfcPaintDetails::~TfcPaintDetails()
{
	SelectClipRgn((HDC)hDC, NULL);
}


void ScrollWin::PaintWithUnscrollables(int x1, int y1, int x2, int y2)
{
	if ((scrollX == 0 and scrollY == 0) or (dontScrollX == 0 and dontScrollY == 0)) {
		// We can paint the simple way:
		Paint(x1, y1, x2, y2);
	}
	else {
		// We need to paint in multiple parts, to take care of the unscrollable areas:
		if (scrollX > 0 and dontScrollX > 0 and scrollY > 0 and dontScrollY > 0
					and x1 < scrollX + dontScrollX and y1 < scrollY + dontScrollY) {
			Paint(0,0, dontScrollX, dontScrollY);
		}
		if (scrollY > 0 and dontScrollY > 0 and y1 < scrollY + dontScrollY) {
			Paint(x1, y1 - scrollY, x2, imin(dontScrollY,y2 - scrollY));
			y1 = dontScrollY + scrollY;
		}
		if (scrollX > 0 and dontScrollX > 0 and x1 < scrollX + dontScrollX) {
			Paint(x1 - scrollX, y1, dontScrollX, y2);
			x1 = dontScrollX + scrollX;
		}
		Paint(x1, y1, x2, y2);
	}
}


void ScrollWin::GetPaintDetails(TfcPaintDetails *paintDetails, int x,int y)
/* Get the top left-hand corner of this Litewin in Windows coords. */
{
    if (parent == this) {
		paintDetails->winX = x < dontScrollX ? 0 : -scrollX;
		paintDetails->winY = y < dontScrollY ? DialogHeight : DialogHeight - scrollY;
		paintDetails->clipRegion.Init(x < dontScrollX ? 0 : dontScrollX,
							y < dontScrollY ? DialogHeight : DialogHeight + dontScrollY,
							32767,32767);
		/* This must be larger than the maximum x- or y- resolution of any */
		/* printer or other device which will use TFC. Printers are often  */
		/* > 12000 pixels in height (or width, in landscape mode). */
		if (!inPrint) {
			paintDetails->clipRegion.right = clientWidth;
			paintDetails->clipRegion.bottom = clientHeight + DialogHeight
							+ 26;
			// Tim 20100502: Add 26 as the possible height of a horizontal scrollbar.
		}
		paintDetails->colourMode = colourmode;
        if (inPrint) {
			paintDetails->lineWidth = clientWidth / 1000;
            if (paintDetails->lineWidth <= 0)
                paintDetails->lineWidth = 1;
        }
        else paintDetails->lineWidth = 1;
        if (hWnd and not hDC) {      // Never allocate a HDC without a HWND!
			hDC = GetDC((HWND)hWnd);
            SelectClipRgn((HDC)hDC, NULL);
        }
		paintDetails->hDC = hDC;
        if (hDC and isBufferOutput) {
            BufferPaints(hDC);
            paintDetails->hDC = hMemDC;
        }
    }
    else {
		// When do we get a scrollWin inside a Litewin?  At present, only 
		// as part of the PrintPreview feature.
        parent->GetPaintDetails(paintDetails, x,y);
		// We don't subtract 'scrollX/scrollY' because the print preview system
		// sets up a coordinate system mapping which deals with the scroll values.
		if (colourmode and colourmode < paintDetails->colourMode)
			paintDetails->colourMode = colourmode;
    }
}


void ScrollWin::RedrawMenuBar()
{
    DrawMenuBar((HWND)hWnd);
}


static void ScrollInfo2Byte(SCROLLINFO *sInfo)
/* In case of very large virtual windows, scale sInfo to fit in 2-byte int's. */
{
    while (sInfo->nMax > 32000) {
        sInfo->nMin >>= 1;
        sInfo->nMax >>= 1;
        sInfo->nPage >>= 1;
        sInfo->nPos >>= 1;
    }
}


interface bool ScrollWin::isVerticalScrollbar()
{
    return clientHeight <= realHeight and abs(clientHeight - realHeight) > 8;
}


interface void ScrollWin::UpdateScrollbars(int NewScrollX, int NewScrollY)
{   SCROLLINFO sInfo;

    int marginForSb = 17;  // To allow for a possible scrollbar
	if (hWnd == NULL) {
		scrollX = NewScrollX;
		scrollY = NewScrollY;
        return;
	}
    if (ScrollbarMode == 'N')
        return;

    /* Are the scroll positions still valid? */
    if (NewScrollX > realWidth - (clientWidth - marginForSb))
        NewScrollX = realWidth - (clientWidth - marginForSb);
    if (NewScrollX < 0)
        NewScrollX = 0;
    if (NewScrollY > realHeight - (clientHeight - marginForSb))
        NewScrollY = realHeight - (clientHeight - marginForSb);
    if (NewScrollY < - 0)
        NewScrollY = - 0;
    bool NeedsPaint = NewScrollX != scrollX or NewScrollY != scrollY;
    bool NeedsSinfo = realWidth != SbRealWidth or realHeight != SbRealHeight
                or clientWidth != SbClientWidth or clientHeight != SbClientHeight;
    if (not NeedsPaint and not NeedsSinfo)
        return;
    scrollX = NewScrollX;
	scrollY = NewScrollY;
    SbRealWidth = realWidth;
    SbRealHeight = realHeight;
    SbClientWidth = clientWidth;
    SbClientHeight = clientHeight;

    /* Update and redraw the scrollbars: */
    sInfo.cbSize = sizeof(sInfo);
    sInfo.fMask = SIF_ALL;
    sInfo.nMin = 0;
    sInfo.nMax = realHeight-1;
    sInfo.nPage = clientHeight;
    sInfo.nPos = scrollY;
    if (sInfo.nMax >= sInfo.nPage and sInfo.nMax < sInfo.nPage + 16 and ScrollbarMode == 'E')
        sInfo.nMax = sInfo.nPage-1, sInfo.nPos = scrollY = 0;
        // If it's only a smidgin over, then don't worry about the scrollbar.
        // Otherwise strange things happen when realWidth is close to clientWidth
        // e.g. infinite loops of vertical & horizontal scrollbars turning on & off.
    ScrollInfo2Byte(&sInfo);
    SetScrollInfo((HWND)hWnd, SB_VERT, &sInfo, yes);
    sInfo.nMax = realWidth-1;
    sInfo.nPage = clientWidth;
    sInfo.nPos = scrollX;
    if (sInfo.nMax >= sInfo.nPage and sInfo.nMax < sInfo.nPage + 16 and ScrollbarMode == 'E')
        sInfo.nMax = sInfo.nPage-1;
        // See above.
    ScrollInfo2Byte(&sInfo);
    SetScrollInfo((HWND)hWnd, SB_HORZ, &sInfo, yes);

    /* Is it now minimised? */
    if (clientWidth == 0 or clientHeight == 0)
        ShowState = tfc_minimised;

    /* Paint the window if necessary. */
    if (NeedsPaint and ShowState == tfc_shown) {
        PaintWhole();
        RedrawDialogBar();
        RedrawStatusBar();
    }
}


static int CtrlShift(int ch)
/* Add in the CTRL and SHIFT components of this message. */
{
    if (CtrlDown)
        ch = CTRL_(ch);
    if (ShiftDown)
        ch = SHIFT(ch);
    SelectKeyDown = ShiftDown;
    return ch;
}


static int GetExtended(uint vk)
{
    switch (vk) {
        case 33:    if (CtrlDown)
                        return ZOOM_IN;
                    else return CtrlShift(PG_UP);
        case 34:    if (CtrlDown)
                        return ZOOM_OUT;
                    else return CtrlShift(PG_DOWN);
        case 107:   return ZOOM_IN; // Numeric keypad +, not available on laptops
        case 109:   return ZOOM_OUT;// Numeric keypad -
        case 35:    return CtrlShift(END);
        case 36:    return CtrlShift(HOME);
        case 37:    return CtrlShift(LEFT);
        case 38:    return CtrlShift(UP);
        case 39:    return CtrlShift(RIGHT);
        case 40:    return CtrlShift(DOWN);
        case 45:    return CtrlShift(INS);
        case 46:    return CtrlShift(DEL);
        //case 16:    return SHIFT_DEPRESSED;
        case VK_F1: return CtrlShift(F1);
        case VK_F2: return CtrlShift(F2);
        case VK_F3: return CtrlShift(F3);
        case VK_F4:	return CtrlShift(F4);
        case VK_F5: return CtrlShift(F5);
        case VK_F6: return CtrlShift(F6);
        case VK_F7: return CtrlShift(F7);
        case VK_F8: return CtrlShift(F8);
        case VK_F9: return CtrlShift(F9);
        case VK_F10:return CtrlShift(F10);
        case VK_F11:return CtrlShift(F11);
        case VK_F12:return CtrlShift(F12);
        case 9:     return ShiftDown ? BACKTAB : TAB;
        case 145:   return SCROLL_LOCK;
        case 73:    if (CtrlDown)
                        return CTRL_I;
                    else
                        SelectKeyDown = no;
                    break;
    }
    return 0;
}


static int TranslateExtended(uint vk)
/* Either translate the current extended-key WM_KEYDOWN message */
/* into a WM_CHAR message, or directly interpret it as a TFC key-code. */
{   int key;

    key = GetExtended(vk);
    if (!key) {
        SelectKeyDown = no;
        TranslateMessage(&EventLoopMsg);
        return 0;
    }
    return key;
}


static bool PostKeyMessage(ScrollWin *sw, int key)
/* Send the following key-stroke or message-encoded-in-key-code */
/* to the specified ScrollWin.  Returns 'yes' if handled. */
{
    if (key == 0)
        return yes;
    else if (sw == NULL)
        return no;
    else if (sw->ProcessAccelerator(key))
        sw->FlushBuffer();
    else if (sw == WaitingForKeystroke or WaitingForAnyKeystroke)
        response = key;
    else {
        if (sw->ShowState == tfc_shown)
            sw->Keystroke(key);
        if (sw->IsValid()) // sw->Keystroke() might have done "delete this"
            sw->FlushBuffer();
    }
    return yes;
}


/*typedef void (*TfcMsgHandler_fn)(int msg, long wParam, long lParam);*/
static struct MsgHandler_node {
    TfcMsgHandler_fn Handler;
    UINT uMsg;
} *MsgHandlers;


interface uint TfcRegisterMsgHandler(str MessageName, TfcMsgHandler_fn Handler)
/* Register this function as a handler for the specified        */
/* message.  'MessageName' is any string up to 256 bytes long   */
/* which corresponds to what has been passed to the Win32       */
/* RegisterWindowMessage() function (=GlobalAddAtom?) by        */
/* another application.  (Returns the message id).              */
{
    MsgHandler_node *mh = (MsgHandler_node*)ListNext(MsgHandlers);
    mh->uMsg = RegisterWindowMessage(MessageName);
    mh->Handler = Handler;
    return mh->uMsg;
}



#ifndef RB_GETBARHEIGHT
#define RB_GETBARHEIGHT 1051
#endif
#ifndef RB_GETRECT
#define RB_GETRECT      1033
#endif


long _stdcall ScrollWinProc(void *_hWnd, uint uMsg, uint wParam, long lParam)
{   HWND hWnd = (HWND)_hWnd;
    int maxw, page, pos;
    ScrollWin *sw;
    int zDelta;
    RECT Rect;

    if (uMsg > WM_USER) {
        if (uMsg == TFC_CALLCALLBACK) {
            // (ksh) While a modal dialog box is active, messages are pumped and dispatched
            // internally, not by our message loop. This means thread messages are lost (no
            // window to dispatch them to). So we now send TFC_CALLCALLBACK to the top level
            // scrollwin via a call to (HWND)TfcTopLevelHwnd().
            // This will be updated in future to allow a dynamic registration function whereby
            // you can register a message and handler. That's why this bit is not in the switch -
            // it will have to check an array of run-time values.
            TfcCallback Callback((VoidData_fn)wParam, (void*)lParam);
            Callback(NULL,NULL);
            return 1;
        }
        MsgHandler_node *mh = NULL;
        for (int each_oeli(mh, MsgHandlers)) {
            if (mh->uMsg == uMsg)
                mh->Handler(uMsg, wParam, lParam);
        }
        return 1;
    }

    /* Most messages require a ScrollWin object: */
    if (hWnd)
        sw = ScrollWin::SwFromWnd(hWnd);
    else
        sw = NULL;

    /* Process the message: */
    switch (uMsg) {
        case WM_SETTEXT:
        case WM_GETTEXT:
            return DefWindowProcW(hWnd, uMsg, wParam, lParam);


        case WM_NOTIFY:
                    // the message indicates that the height of rebar was changed
                    // actions are almost the same as in WM_SIZE case
                    if (wParam == ID_REBAR) {
                         NMHDR *pnmh = (LPNMHDR)lParam;
                         if (pnmh->code == RBN_LAYOUTCHANGED or pnmh->code == RBN_HEIGHTCHANGE ) {     RECT Re;
                            GetClientRect((HWND)sw->hWnd, &Rect);
                            sw->DialogHeight = SendMessage((HWND)sw->hRebar,RB_GETBARHEIGHT,0,0)+2;
                            GetWindowRect((HWND)sw->hRebar, &Re);
                            sw->clientWidth = Rect.right;
                            sw->clientHeight = Rect.bottom - (sw->DialogHeight + sw->GetStatusBarHeight());
                            sw->RedrawStatusBar();
                            sw->UpdateScrollbars(sw->scrollX, sw->scrollY);
                            response = WINDOW_RESIZE;
                            if (sw->isBufferOutput and sw->hMemBuffer and
                               (sw->clientWidth != Rect.right or sw->clientHeight != Rect.bottom - sw->DialogHeight))
                            {    /* recreate the bitmap only if size was really changed */
                                    //DeleteObject((HBITMAP)sw->hMemBuffer);
                                    //sw->hMemBuffer = NULL;
                                    sw->ClearMemBuffer();
                            }
                            sw->Resized();
                            InvalidateRect(hWnd,NULL,yes);
                         }
                    }
                    return 0;

        case WM_PAINT:
                    OnPaint(hWnd);
                    break;

        case WM_KEYDOWN:
                    if (wParam == 16)
                        ShiftDown = yes;
                    else if (wParam == 17)
                        CtrlDown = yes;
                    return PostKeyMessage(sw, TranslateExtended(wParam));

        case WM_KEYUP:
                    if (wParam == 16) {
                        ShiftDown = no;
                        return 0;//PostKeyMessage(sw, SHIFT_UNDEPRESSED);
                    }
                    else if (wParam == 17)
                        CtrlDown = no;
                    TranslateMessage(&EventLoopMsg);
                    break;

        case WM_CHAR:
                    return PostKeyMessage(sw, wParam);

        case WM_SYSKEYDOWN:
                    TranslateMessage(&EventLoopMsg);
                    if (wParam == 16)
                        ShiftDown = yes;
                    else if (wParam == 17)
                        CtrlDown = yes;
                    else if (wParam == 121)
						PostKeyMessage(sw, ShiftDown ? SHIFT(F10) : CtrlDown ? CTRL_(F10) : F10);
                    else if ((lParam & (1<<29)) == 0) {
                        EventLoopMsg.message = WM_KEYDOWN;
                        PostKeyMessage(sw, TranslateExtended(wParam));
                        break;    // The Alt key is not actually down, we're
                        // only getting a SYSKEYDOWN because no window has the
                        // focus, and 'sw' is merely the active window.
                    }
                    else if (wParam == 115)
                        PostKeyMessage(sw, WINDOW_QUIT);
                    else if (wParam == 8)
                        PostKeyMessage(sw, UNDO);
                    else if (wParam == 37)
                        PostKeyMessage(sw, ALT_LEFT);
                    else if (wParam == 39)
                        PostKeyMessage(sw, ALT_RIGHT);
                    else if (wParam == 38)
                        PostKeyMessage(sw, ALT_UP);
                    else if (wParam == 40)
                        PostKeyMessage(sw, ALT_DOWN);
                    else if (sw->dialogbar)
                        SendMessageToDialog(sw->dialogbar, &EventLoopMsg);
                    break;

        case WM_SYSKEYUP:
                    TranslateMessage(&EventLoopMsg);
                    if (wParam == 16)
                        ShiftDown = no;
                    else if (wParam == 17)
                        CtrlDown = no;
                    if (sw->dialogbar)
                        SendMessageToDialog(sw->dialogbar, &EventLoopMsg);
                    break;

        case WM_SYSCHAR:
                    if (sw->dialogbar)
                    {   // Notify dialog about syschar message
                        EventLoopMsg.message = WM_NOTIFY_SYSCHAR;
                        SendMessageToDialog(sw->dialogbar, &EventLoopMsg);
                        EventLoopMsg.message = WM_SYSCHAR;
                        SetFocus(hWnd);
                    }
                    return DefWindowProc(hWnd, uMsg, wParam, lParam);
        case WM_MOUSEACTIVATE:
                    Button1Down = no;
                    Button2Down = no;
                    break;

        case WM_SETFOCUS:
                    CtrlDown = GetKeyState(VK_CONTROL) < 0;
                    ShiftDown = GetKeyState(VK_SHIFT) < 0;
                    if (CursorSw)
                        CursorSw->CursorOff();
                    if (sw and sw->cursor.ms_on) {
                        CursorSw = sw;
                        TimerCursorOn(hWnd, uMsg, 0, 0);
                    }
					sw->SetFocusToChildIfNecessary();
                    break;

        case WM_LBUTTONDOWN:
                    SetFocus((HWND) sw->hWnd);
                    SetCapture((HWND) sw->hWnd); // Capture mouse to receive all mouse messages
                    Button1Down = yes;
                    response = MOUSE_PRESS;
					sw->mousePos.x = LOWORD(lParam);
					sw->mousePos.y = HIWORD(lParam);
                    goto MOUSESTROKE;

        case WM_RBUTTONDOWN:
                    SetFocus((HWND) sw->hWnd);
                    SetCapture((HWND) sw->hWnd); // Capture mouse to receive all mouse messages
                    Button2Down = yes;
                    response = MOUSE2_PRESS;
                    goto MOUSESTROKE;

        case WM_LBUTTONUP:
                    ReleaseCapture(); // Release mouse capture
                    Button1Down = no;
                    response = MOUSE_RELEASE;
                    goto MOUSESTROKE;
        case WM_LBUTTONDBLCLK :
                    SetCapture(hWnd);
                    response = MOUSE_DOUBLECLICK;
                    goto MOUSESTROKE;
        case WM_RBUTTONUP:
                    ReleaseCapture(); // Release mouse capture
                    Button2Down = no;
                    response = MOUSE2_RELEASE;
                    goto MOUSESTROKE;

        case WM_MOUSEMOVE:
                    // to fix VFIVE-371 and VFIVE-657
                   if (Button1Down and not (wParam & MK_LBUTTON))
                   {
                        Button1Down = no;
                        return DefWindowProc(hWnd, uMsg, wParam, lParam);
                    }
                    else if (Button2Down and not (wParam & MK_RBUTTON))
                    {
                        Button2Down = no;
                        return DefWindowProc(hWnd, uMsg, wParam, lParam);
                    }
                    else if (not Button1Down and (wParam & MK_LBUTTON))
                    {
                        Button1Down = yes;
                        return DefWindowProc(hWnd, uMsg, wParam, lParam);
                    }
                    else if (not Button2Down and (wParam & MK_RBUTTON))
                    {
                        Button2Down = yes;
                        return DefWindowProc(hWnd, uMsg, wParam, lParam);
                    }
                    else if (Button1Down)
                    {
						if (sw and LOWORD(lParam) == sw->mousePos.x and HIWORD(lParam) == sw->mousePos.y)
							break;
                        response = MOUSE_DRAG;
                        goto MOUSESTROKE;
                    }
                    else if (Button2Down)
                    {
                        response = MOUSE2_DRAG;
                        goto MOUSESTROKE;
                    }
                    else if (sw and sw->ShowState == tfc_shown)
                    {
						int mouse_x, mouse_y;
						mouse_x = LOWORD(lParam);
						if (mouse_x > sw->dontScrollX)
							mouse_x += sw->scrollX;
						mouse_y = HIWORD(lParam) - sw->DialogHeight;
						if (mouse_y > sw->dontScrollY)
							mouse_y += sw->scrollY;
                        sw->Mousemove(mouse_x, mouse_y);
                    }
					break;

                    MOUSESTROKE:
                    if (sw == NULL)
                        break;
                    if (WaitingForAnyKeystroke)
                        break;

					int mouse_x, mouse_y;
					mouse_x = LOWORD(lParam);
					if (mouse_x > sw->dontScrollX)
						mouse_x += sw->scrollX;
					mouse_y = HIWORD(lParam) - sw->DialogHeight;
					if (mouse_y > sw->dontScrollY)
						mouse_y += sw->scrollY;
                    sw->Mousestroke(response, mouse_x, mouse_y);

                    sw->FlushBuffer();
					if (WaitingForKeystroke and sw != WaitingForKeystroke) {
						// If we get a mousestroke for window X, but we're inside a GetKey()
						// for window Y, what do we do?   Currently we send the mousestroke
						// to window X, but we don't return yet out of ScrollWin::GetKey().
						response = 0;
					}

					return DefWindowProc(hWnd, uMsg, wParam, lParam);

                    MOUSEWHEELSTROKE:
                    if (sw == NULL)
                        break;
                    // (awa) If ShowState is not shown, we could be processing a message *before*
                    // everything is initialised causing bad crashes.
                    if (sw->ShowState != tfc_shown)
                        break;
                    if (WaitingForAnyKeystroke)
                        break;

                    sw->Mousestroke(response,
                        (int) (short) HIWORD(wParam) < 0 ? 1 : -1,
                            0);

                    sw->FlushBuffer();

                    break;

#ifndef WM_MOUSEWHEEL
#define WM_MOUSEWHEEL   0x020A
#define WHEEL_DELTA     120
#endif
// This message is new with WinNT.
        case WM_MOUSEWHEEL:
                    if (sw == NULL)
                        break;
                    if (not sw->isVerticalScrollbar()) {
                        response = MOUSE_WHEEL;
                        goto MOUSEWHEELSTROKE;
                    }
                    zDelta = (short) HIWORD(wParam);
                    maxw = sw->realHeight;
                    page = sw->clientHeight;
                    pos = sw->scrollY;
                    // scrolls to 30 points
                    // as in WM_VSCROLL message
                    pos -= 30*(zDelta / WHEEL_DELTA);
                    if (pos > maxw - page)
                        pos = maxw - page;
                    if (pos < 0)
                        pos = 0;
                    sw->UpdateScrollbars(sw->scrollX, pos);
                    break;

        case WM_VSCROLL:
        case WM_HSCROLL:
                    if (sw == NULL)
                        break;
                    int scale, tmp;
                    if (uMsg == WM_VSCROLL) {
                        maxw = sw->realHeight;
                        page = sw->clientHeight;
                        pos = sw->scrollY;
                    }
                    else {
                        maxw = sw->realWidth;
                        page = sw->clientWidth;
                        pos = sw->scrollX;
                    }
                    scale = 1;
                    tmp = maxw;
                    while (tmp > 32000)
                        scale <<= 1, tmp >>= 1;
                    switch (LOWORD(wParam)) {
                        case SB_BOTTOM:
                                pos = maxw;
                                break;
                        case SB_TOP:
                                pos = 0;
                                break;
                        case SB_PAGEUP:
                                pos -= page;
                                break;
                        case SB_PAGEDOWN:
                                pos += page;
                                break;
                        case SB_LINEUP:
                                pos -= 30;
                                break;
                        case SB_LINEDOWN:
                                pos += 30;
                                break;
                        case SB_THUMBPOSITION:
                        case SB_THUMBTRACK:
                                pos = HIWORD(wParam) * scale;
                                break;
                        case SB_ENDSCROLL:
                                break;
                        default:
                                break;
                    }
                    if (pos > maxw - page)
                        pos = maxw - page;
                    if (pos < 0)
                        pos = 0;
                    if (uMsg == WM_VSCROLL)
                        sw->UpdateScrollbars(sw->scrollX, pos);
                    else
                        sw->UpdateScrollbars(pos, sw->scrollY);
                    break;

		case WM_HELP:
					if (MessageBoxHelp)
						ViewHelp(MessageBoxHelp);
					return true;

        case WM_SIZE:
                    if (sw == NULL)
                        break;        // It could be the initial WM_SIZE message.
                    if (wParam == SIZE_MINIMIZED)
                        break;
                    GetClientRect((HWND)sw->hWnd, &Rect);
                    sw->MoveRebar(&Rect);
                    sw->clientWidth = Rect.right;
                    sw->clientHeight = Rect.bottom - (sw->DialogHeight + sw->GetStatusBarHeight());
                    sw->RedrawStatusBar(true);
                    sw->UpdateScrollbars(sw->scrollX, sw->scrollY);
                    response = WINDOW_RESIZE;
                    if (sw->isBufferOutput and sw->hMemBuffer) {
                        //DeleteObject((HBITMAP)sw->hMemBuffer);
                        //sw->hMemBuffer = NULL;
                        sw->ClearMemBuffer();
                    }
                    // restore clipping with new scroll and DialogHeight
                    sw->Resized();
                    break;

        case WM_COMMAND:
                    if (lParam) {
                        if (IsDialogMessage(hWnd, &EventLoopMsg)) {
                            DialogCommand(sw, sw->dialogbar, lParam,HIWORD(wParam));
                            return 0;
                        }
                        else return DefWindowProc(hWnd, uMsg, wParam, lParam);
                    }
                    else {
                        response = (short)LOWORD(wParam);
                        if (sw)
                            PerformMenuFunction(sw, (short)LOWORD(wParam));
                    }
                    break;

        case WM_GETDLGCODE:
                    return DLGC_WANTALLKEYS;
                    // This allows us to put scrollwins inside dialog boxes (en_scrollwin)
                    // and still have them respond to keystrokes in their normal way.

        case WM_CLOSE:
                    PostKeyMessage(sw, WINDOW_QUIT);
                    return 0;

        case WM_DESTROY:
        case WM_QUIT:
                    PostKeyMessage(sw, WINDOW_QUIT);
                    return 1;

        default:    return DefWindowProc(hWnd, uMsg, wParam, lParam);
    }
    return 1;
}


ScrollWin::ScrollWin(kstr _title, int _clientWidth, int _clientHeight, int flag, ScrollWin *OwnerSw)
{   RECT Rect;

    /* Clear all fields: */
    cursor.ms_on = cursor.ms_off = 300;
    cursor.state = no;
    cursor.rect.top = cursor.rect.bottom = 0;
    hWnd = NULL;
    hDC = NULL;
    hRebar = NULL;
    dialogbar = NULL;
    DialogHeight = 0;
    inPrint = no;
	printJob = NULL;
    parent = this;
    realWidth = 0;
    realHeight = 0;
    scrollX = 0;
    scrollY = 0;
	dontScrollX = dontScrollY = 0;
    Background = BLACK;
    ShowState = tfc_hiddenshouldshow;
    colourmode = tfc_colour;
    menu = NULL;
    Accelerator = NULL;
    isBufferOutput = no;
    hMemDC = NULL;
    hDC = NULL;             // It's initialised when we first use the DC.
    hMemBuffer = NULL;
    SbRealWidth = SbRealHeight = 0;
    SbClientWidth = SbClientHeight = 0;
    dropCallback = NULL;
    dropData = NULL;
    ScrollbarMode = 'E';
    hStatus = NULL;
	owner = OwnerSw;

    /* Set it up: */
    clientWidth = _clientWidth;
    clientHeight = _clientHeight;

    /* Is it a sub-scrollwin? */
    if (_title == NULL) {
        hWnd = NULL;
        windowTitle = NULL;
		pageTitle = NULL;
        return;
    }
    else windowTitle = strdup(_title);
	pageTitle = strdup(_title);

    /* Create the window: */
    Rect.top = Rect.left = 0;
    Rect.right = clientWidth;
    Rect.bottom = clientHeight;
    AdjustWindowRect(&Rect, WS_OVERLAPPEDWINDOW, no);

    hWnd = CreateWindow("TfcSwin", windowTitle,
                    flag & TFC_NORESIZE ? WS_POPUPWINDOW | WS_CAPTION | WS_MINIMIZEBOX : WS_OVERLAPPEDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    Rect.right, Rect.bottom,
					OwnerSw ? (HWND)OwnerSw->hWnd : NULL,
                    NULL, hInstance, NULL);
                /* Don't show it until the application is ready to show it. */

    SetTopmost(flag & TFC_TOPMOST);
    SetTitle(windowTitle);

    /* Force sizing to update scrollbars correctly*/
    if (flag & TFC_NORESIZE)
        PostMessage((HWND)hWnd,WM_SIZE,SIZE_RESTORED, MAKELPARAM(clientWidth, clientHeight));

    /* Put it in the linked list: */
    next = ScrollWinRoot;
    ScrollWinRoot = this;
}

void* (*TfcDropStart)(void* hWnd, TfcCallback callback);
void* (*TfcSWDropStart)(ScrollWin* sw, TfcCallback dropCallback);
void (*TfcDropStop)(void* droptarget);


ScrollWin::ScrollWin(ScrollWin &orig)
{
    cursor = orig.cursor;
    hWnd = NULL;
    hDC = NULL;
    hRebar = NULL;
    dialogbar = NULL;
    DialogHeight = 0;
    hStatus = NULL;
    inPrint = orig.inPrint;
    parent = this;
    realWidth = orig.realWidth;
    realHeight = orig.realHeight;
    scrollX = orig.scrollX;
    scrollY = orig.scrollY;
    Background = orig.Background;
    ShowState = tfc_hiddenshouldshow;
    colourmode = orig.colourmode;
    isBufferOutput = orig.isBufferOutput;
    hMemDC = NULL;
    hMemBuffer = NULL;
    menu = NULL;
    Accelerator = NULL;
    SbRealWidth = SbRealHeight = 0;
    SbClientWidth = SbClientHeight = 0;
    clientWidth = orig.clientWidth;
    clientHeight = orig.clientHeight;
    windowTitle = orig.windowTitle ? strdup(orig.windowTitle) : strdup("");
    pageTitle = orig.pageTitle ? strdup(orig.pageTitle) : strdup("");
    dropCallback = NULL;
    dropData = NULL;
    ScrollbarMode = orig.ScrollbarMode;
	owner = NULL;
}


ScrollWin::~ScrollWin()
/* Delete this scrollwin.  But the caller must free it, since the caller alloc'd it. */
{   ScrollWin * *pp;

    /* Avoid dangling references: */
    if (this == CursorSw)
        CursorSw = NULL;

    /* Unattached ScrollWin's have nothing to free. */
    if (hWnd == NULL)
        return;

    if (dropData) {
        TfcDropStop(dropData);
        dropData = NULL;
    }

    /* Get rid of the object from the linked list:
     * Note that this MUST happen before DestroyWindow below, so that the
     * WM_DESTROY to the window element does not trigger clean-up code on
     * this object (again) */
    for (pp=&ScrollWinRoot; *pp != NULL; pp=&(*pp)->next) {
        if (*pp == this)
            goto FOUND;
    }
    assert(false);
    return;
    FOUND:
    *pp = next;

    /* Destroy the menu: */
    if (menu) {
        ::SetMenu((HWND)hWnd, NULL);    // We will destroy the menu, not Windows.
        ::DestroyMenu((HMENU)menu);
    }

    /* Get rid of the window: */
    DeleteDC((HDC)hDC);
    BufferPaints(NULL);
    DestroyWindow((HWND)hWnd);
    if (ScrollWinRoot == NULL)
        PostMessage(NULL, 2045, 0,0);    // We send any old message, just to
        // ensure that the EventLoop doesn't hang with no message coming in.

    if (hStatus) {
        DestroyWindow((HWND) hStatus);
        ListFree(sbox);
    }
}


void ScrollWin::SetTopmost(bool set)
{
    SetWindowPos((HWND)hWnd, set?HWND_TOPMOST:HWND_NOTOPMOST,
                    0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
}


void ScrollWin::AttachToWindow(void* _hWnd)
/* Attach this scrollwin to this window.  Leave it in  */
/* the 'suppress paints' state so that the application */
/* can create the data before displaying. */
{   RECT Rect;

    assert(hWnd == NULL);
    hWnd = _hWnd;
    next = ScrollWinRoot;
    ScrollWinRoot = this;
    hDC = GetDC((HWND)hWnd);
    ShowState = tfc_dirtyshouldpaint;
    ::InvalidateRect((HWND)hWnd, NULL, yes);
    GetClientRect((HWND)hWnd, &Rect);
    clientWidth = Rect.right;
    clientHeight = Rect.bottom - DialogHeight;
    UpdateScrollbars(scrollX, scrollY);
    menu = (TfcMenu*)::GetMenu((HWND)hWnd);

    if (windowTitle)
        SetTitle(windowTitle);
     RestoreRebar();

     if (dropCallback)
        TfcSWDropStart(this,  dropCallback);

}


void ScrollWin::DetachFromWindow()
{   ScrollWin **swp;

    assert(hWnd != NULL);
    /* Avoid dangling references: */
    if (this == CursorSw)
        CursorSw = NULL;
    for (swp=&ScrollWinRoot; *swp; swp=&((*swp)->next)) {
        if (*swp == this) {
            *swp = next;
            break;
        }
    }
    if (hDC) {
        ReleaseDC((HWND) hWnd, (HDC)hDC);
        hDC = NULL;
    }

    if (dropData) {
        TfcDropStop(dropData);
        dropData = NULL;
    }

    menu = NULL;
    DetachRebar();
    hWnd = NULL;
}


int ScrollWin::GetLogPixelsY(int *iScreen, int *iCurrent)
/* (ksh) We need this to scale screen fonts to printer fonts    */
/* Return LOGPIXELSY for current DC (printer if printing)       */
{   int iReturn;

    iReturn = GetDeviceCaps((HDC)FindDC(), LOGPIXELSY);
    if (iCurrent)
        *iCurrent = iReturn;
    if (iScreen)
        *iScreen = GetDeviceCaps(PlayDC(), LOGPIXELSY);
    return iReturn;
}


bool ScrollWin::Keystroke(int key)
{
    return no;
}


void ScrollWin::BufferPaints(void* DC)
/* Draw into a memory DC and then to screen, to reduce flashes. */
{
    if (DC and isBufferOutput) {
        if (!hMemDC)
            hMemDC = (HDC)CreateCompatibleDC( (HDC) DC);
        if (!hMemBuffer and clientWidth > 0 and clientHeight > 0)
        {
            hMemBuffer = CreateCompatibleBitmap((HDC)DC,clientWidth,DialogHeight + clientHeight);
            oldObject = SelectObject((HDC)hMemDC, (HBITMAP)hMemBuffer);
        }
    }
    else {
        if (hMemBuffer)
            DeleteObject((HBITMAP)hMemBuffer);
        if (hMemDC)
            DeleteDC((HDC)hMemDC);
        hMemBuffer = NULL;
        hMemDC = NULL;
    }
}

void ScrollWin::ClearMemBuffer()
{
    SelectObject((HDC)hMemDC, oldObject);
    DeleteObject((HBITMAP)hMemBuffer);
    hMemBuffer = NULL;
    oldObject = NULL;
}


void ScrollWin::FlushBuffer()
// Outputs memory buffer to screen
{   TfcPaintDetails paintDetails;

    if (not isBufferOutput)
        return;

    isBufferOutput = no;
    GetPaintDetails(&paintDetails, 0,0);
	HDC DC = (HDC)paintDetails.hDC;
    isBufferOutput = yes;
    BitBlt(DC,
           paintDetails.winX + scrollX,
		   paintDetails.winY + scrollY,
		   clientWidth,
		   clientHeight,
           (HDC) hMemDC,
           0,DialogHeight,
           SRCCOPY);
}


void ScrollWin::Move(int x0, int y0, int width, int height)
{
    MoveWindow((HWND)hWnd,x0,y0,width,height,TRUE);
}


void ScrollWin::PaintWhole()
{
    PaintWithUnscrollables(
            scrollX,
            scrollY > 0 ? scrollY : 0,
            scrollX + clientWidth,
            scrollY + clientHeight);
    if (cursor.state)
        CursorOn();
    if (isBufferOutput)
        FlushBuffer();
}


void ScrollWin::Resized()
/* The width and height of this scrollwin rectangle have changed. */
/* Tell the Tfc module about it. */
{
    UpdateScrollbars(scrollX, scrollY);
}


void ScrollWin::InvalidateRect(int x1, int y1, int x2, int y2)
/* Paint this rectangle, specified in ScrollWin coordinates. */
{   RECT rcInvalid;
    HWND realWnd;

    if (ShowState != tfc_shown)
        return;
    if (y2 < scrollY or y1 > scrollY+clientHeight or x2 < scrollX)
        return;
    rcInvalid.left = x1 - scrollX;
    rcInvalid.top = y1 - scrollY + DialogHeight;
    rcInvalid.right = x2 - scrollX;
    rcInvalid.bottom = y2 - scrollY + DialogHeight;
    if (rcInvalid.right > clientWidth) // 98 might ignore you
        rcInvalid.right = clientWidth;
    if (rcInvalid.bottom > clientHeight + DialogHeight)
        rcInvalid.bottom = clientHeight + DialogHeight;
    realWnd = (HWND)(hWnd ? hWnd : parent->_hWnd());
    if (realWnd)
        ::InvalidateRect(realWnd, &rcInvalid, no);
}


void ScrollWin::SuppressPaints()
/* Either suppress paints or allow paints. */
{
    if (ShowState != tfc_shown)
        return;
    if (parent != this)
        return;
    ShowState = tfc_dirtyshouldpaint;
	if (hWnd)
        ::InvalidateRect((HWND)hWnd, NULL, no);
}


void ScrollWin::Focus(bool bUncoverApp /*= false*/)
/* Set the keyboard focus to this window.                                      */
/* If bUncoverApp, bring TfcTopLevelHwnd() to the foreground of all apps too */
{
    // (awa) Problemo 6878. Restore window if minimised.
    if (IsMinimised())
        Restore();

    if (ShowState == tfc_dirtyshouldpaint)
        Resized();

    ShowWindow((HWND)hWnd, SW_SHOW);
    ShowState = tfc_shown;
    SetFocus((HWND)hWnd);

    if (bUncoverApp && ScrollWinRoot != NULL) {
        // (awa) Make an attempt to bring the window to the front,
        // but due to a new microsoft philosophy this function will
        // more often then not fail. And so will the one inside the 'if'.
        // If you really want an app focussed then the best way is to
        // call this function from the currently focussed app. This
        // has been done in SendToApp.
        HWND hWnd = (HWND)TfcTopLevelHwnd(no);
        // (Laco) sametimes SetForegroundWindow is not working well
        //if (SetForegroundWindow(hWnd) == 0)
        BringWindowToTop(hWnd);
    }
}


void ScrollWin::SetFocusToChildIfNecessary()
/* We were getting a bug that if the app has a main ScrollWin plus
a 2nd ScrollWin in front of the main ScrollWin, and you change to another 
app and then back again, focus gets set to the main ScrollWin window 
rather than the ScrollWin which is supposed to be in front. */
{
	if (this == NULL)
		return;
	for (each_scrollwin) {
		if (sw->owner == this and not sw->IsMinimised() and sw->ShowState != tfc_hidden) {
			sw->Focus();
			break;
		}
	}
}


void ScrollWin::Hide()
/* Make it temporarily disappear. */
{
    ShowWindow((HWND)hWnd, SW_HIDE);
    ShowState = tfc_hidden;
}


void ScrollWin::Minimise()
/* Minimise it. */
{
    ShowWindow((HWND)hWnd, SW_MINIMIZE);
    ShowState = tfc_minimised;
}


void ScrollWin::Maximise()
/* Minimise it. */
{
    ShowWindow((HWND)hWnd, SW_MAXIMIZE);
}


void ScrollWin::Restore()
/* Restore it. */
{
    ShowWindow((HWND)hWnd, SW_RESTORE);
}


void ScrollWin::Show()
/* Make it appear. */
{
    if (ShowState == tfc_dirtyshouldpaint)
        Resized();
    else if (ShowState == tfc_minimised)
        ShowWindow((HWND)hWnd, SW_RESTORE);
    ShowWindow((HWND)hWnd, SW_SHOW);
    ShowState = tfc_shown;
}


void _stdcall TimerCursorOff(void* hWnd, uint message, uint Timer, long SysTime)
{
    if (Timer != CursorTimer)
        return;
    KillTimer(NULL, CursorTimer), CursorTimer = 0;
    if (CursorSw and CursorSw->hWnd and
            CursorSw->cursor.ms_on > 10 and CursorSw->cursor.ms_off > 10) {
        CursorSw->CursorOff();
        if (CursorSw->cursor.ms_on > 10)
            CursorTimer = SetTimer(NULL, 0, CursorSw->cursor.ms_off, (TIMERPROC)TimerCursorOn);
    }
}


void _stdcall TimerCursorOn(void* hWnd, uint message, uint Timer, long SysTime)
{
	KillTimer(NULL, CursorTimer), CursorTimer = 0;
    if (CursorSw and CursorSw->hWnd) {
        CursorSw->CursorOn();
        if (CursorSw->cursor.ms_off > 10)
            CursorTimer = SetTimer(NULL, 0, CursorSw->cursor.ms_on, (TIMERPROC)TimerCursorOff);
    }
}


void ScrollWin::SetCursor(TfcRect rect)
/* Set the cursor to this rectangle.  ScrollWin scrolls this */
/* rectangle into view and automatically makes it flash on   */
/* and off. */
{   int marginX, marginY, NewScrollX, NewScrollY;


    /* If we had a previous cursor, then remove it. */
    if (CursorSw)
        CursorSw->CursorOff();

    cursor.rect = rect;

    /* Make sure the cursor is visible. */
    marginX = (realHeight <= clientHeight) ? 0 : 40;
    marginY = 20;
    // tco> If there are no scrollbars then don't scroll.
    NewScrollX = scrollX;
    NewScrollY = scrollY;
    if (rect.right - NewScrollX > clientWidth - marginX)
        NewScrollX = rect.right - clientWidth + marginX;
    if (rect.bottom - NewScrollY > clientHeight - marginY)
        NewScrollY = rect.bottom - clientHeight + marginY;
    if (rect.left - NewScrollX < marginX)
        NewScrollX = rect.left - marginX;
    if (rect.top - NewScrollY < marginY)
        NewScrollY = rect.top - marginY;
    if (NewScrollX < 0)
        NewScrollX = 0;
    if (NewScrollY < 0)
        NewScrollY = 0;
    UpdateScrollbars(NewScrollX, NewScrollY);

    /* Set focus to this window: */
    CursorSw = this;
    while (CursorSw != CursorSw->parent)
        CursorSw = (ScrollWin*)CursorSw->parent;
    if (cursor.ms_on == 0)
        ;
    else if (cursor.ms_off)
        TimerCursorOn(NULL, WM_TIMER, 0, 0);
    else CursorSw->CursorOn();
}


void ScrollWin::CursorOn()
{
    cursor.state = yes;
    if (inPrint)
        return;
    CursorPaint();
    FlushBuffer();
}


void ScrollWin::CursorOff()
{
    if (cursor.state) {
        cursor.state = no;
        if (inPrint)
            return;
        if (ShowState == tfc_shown and cursor.rect.top < cursor.rect.bottom) {
            Paint(cursor.rect);
            FlushBuffer();
        }
    }
}


void ScrollWin::SetMousePos(int x, int y)
/* Moves the mouse cursor to a new position */
{
	MapXYToScreenCoords(&x,&y);
    ::SetCursorPos(x,y);
}


void ScrollWin::SetTitle(kstr _title)
/* Sets the window title. Often represents a screen/report type, or a */
/* printing job-name. */
{   wchar_t wide[512];

    if (windowTitle != _title) {
        free(windowTitle);
        windowTitle = strdup(_title);
    }

    Utf8ToWide(windowTitle, wide, sizeof(wide));
    SetWindowTextW((HWND)hWnd, wide);
}


void ScrollWin::SetPageTitle(str name)
/* Sets the page title.  Can be the same as the window title, but it might */
/* also represent the contents of a significant toolbar dropdown. */
{
    free(pageTitle);
    if (name)
        pageTitle = strdup(name);
    else pageTitle = NULL;
}


void ScrollWin::PaintCursorIfNeeded(int x0, int y0, int x1, int y1)
/* If this area intersects the cursor rectangle */
/* and the cursor is on, paint the cursor.        */
{
    if (cursor.state and cursor.rect.top < y1 and cursor.rect.bottom > y0
            and cursor.rect.left < x1 and cursor.rect.right > x0) {
        CursorPaint();
        SelectClipRgn((HDC)hDC, NULL);       // So subsequent WM_PAINT's aren't
        // affected by leftover clip regions.
    }
}


void ScrollWin::ReadyForMessages()
/* Update any dirty window. */
{
    for (each_scrollwin) {
        if (sw->ShowState == tfc_hiddenshouldshow) {
            ShowWindow((HWND)sw->hWnd, SW_SHOW);
            sw->ShowState = tfc_shown;
        }
        else if (sw->ShowState == tfc_dirtyshouldpaint) {
            ::InvalidateRect((HWND)sw->hWnd, NULL, yes);
            sw->ShowState = tfc_shown;
        }
    }
}


int ScrollWin::GetKey()
/* Process all events until a keystroke or mouse event arrives */
/* for this window. */
{
    if (WaitingForAnyKeystroke and response) {   // Finish off 'TfcYield()'.
        WaitingForAnyKeystroke = no;
        return response;
    }
    ReadyForMessages();
    response = 0;
    WaitingForKeystroke = this;
    while (GetMessage(&EventLoopMsg, NULL, 0, WM_USER-1)) {
		if (hDlgLaco == 0 or not IsDialogMessage(hDlgLaco,&EventLoopMsg))
			DispatchMessage(&EventLoopMsg);
        if (response)
            break;
    }
    WaitingForKeystroke = NULL;
    if (response == 0)
        response = WINDOW_QUIT;
    return response;
}


void ScrollWin::EventLoop()
/* Process all events until all windows have been killed. */
{
    ReadyForMessages();
    QuitEventLoop = no;
    WaitingForAnyKeystroke = no;
    WaitingForKeystroke = NULL;
    while (ScrollWinRoot and not QuitEventLoop) {
        if (GetMessage(&EventLoopMsg, NULL, 0, 0) != 1)
            break;
        /* Note: (a) if we have no scrollwins, or QuitEventLoop is true, */
        /* then GetMessage() could very well hang, so better call it after */
        /* testing the above.    (b) Kieran moved TFC_CALLCALLBACK */
        /* processing into ScrollWinProc(), with messages posted   */
        /* to the top level window. */
        if (hDlgLaco == 0 or not IsDialogMessage(hDlgLaco,&EventLoopMsg))
            DispatchMessage(&EventLoopMsg);
    }
    QuitEventLoop = no;
}


void ScrollWin::SetClientSize(int newWidth, int newHeight)
{   int  NCheight, NCwidth;
    RECT WinRect;

    if (!newWidth)
        newWidth = clientWidth;
    if (!newHeight)
        newHeight = clientHeight + DialogHeight;

    GetWindowRect((HWND)_hWnd(),&WinRect);
    GetWindowRect((HWND) hWnd, &WinRect);
    NCheight = WinRect.bottom-WinRect.top - clientHeight - DialogHeight;
    NCwidth  = WinRect.right-WinRect.left - clientWidth;

    MoveWindow((HWND) hWnd,
            WinRect.left,
            WinRect.top,
            newWidth + NCwidth,
            newHeight + NCheight,
            TRUE);

    GetWindowRect((HWND)_hWnd(),&WinRect);
}



static void _stdcall FlashTimerProc(HWND hwnd,UINT uMsg, UINT idEvent, DWORD dwTime)
{   int N, invert;

    N = idEvent >> 1;
    invert = idEvent & 1;

    KillTimer(hwnd, idEvent);

    if (not N)
        return;

    FlashWindow(hwnd,invert);
    if (not invert)
        N--;
    invert = not invert;

    SetTimer(hwnd, invert | (N<<1), 500, (TIMERPROC) FlashTimerProc);
}


void ScrollWin::Flash(int N)
// flash window N times
{
    SetTimer((HWND)hWnd, 1 | (N<<1), 500, (TIMERPROC) FlashTimerProc);
}


void ScrollWin::Beep()
// Do BEEP
{
    MessageBeep(MB_ICONEXCLAMATION);
}





/*--------------- BitmapWin's: ---------------*/

BitmapWin::BitmapWin(int width, int height)
{
	HDC screenDC = ColourDC();
	hDC = CreateCompatibleDC(screenDC);
    hBitmap = CreateCompatibleBitmap(screenDC, width, height);
    SelectObject((HDC)hDC, (HBITMAP)hBitmap);
}


void* BitmapWin::getBitmap()
{
    DeleteDC((HDC)hDC);
	hDC = NULL;
	return hBitmap;
}


void BitmapWin::GetPaintDetails(TfcPaintDetails *paintDetails, int x, int y)
{
	paintDetails->hDC = hDC;
	paintDetails->winX = 0;
	paintDetails->winY = 0;
	paintDetails->clipRegion.Init(0,0,32767,32767);
	paintDetails->colourMode = tfc_colour;;
	paintDetails->lineWidth = 1;
}


BitmapWin::~BitmapWin()
{
    DeleteObject(hBitmap);
	hBitmap = NULL;
}




/*--------------- RowWin's: ---------------*/

/* A RowWin is a window that inherits from ScrollWin and adds        */
/* extra functionality for splitting the window into a sequence */
/* of 'rows'.  Each row can be a different width or height to   */
/* the others.  They are maintained in a linked list by this    */
/* module.  You must go via this module's functions to                */
/* manipulate this linked list. */


void RowWin::Paint(int x1, int y1, int x2, int y2)
/* Paint this region of this RowWin.  The coordinates are given in ScrollWin coordinates. */
{   Row *row;

    if (ShowState != tfc_shown)
        return;
    if (root == NULL)
        goto SKIP;

    /*** Setting up: ***/
    row = focus;
    if (row == NULL)
        row = root;

    /*** Get 'y' and 'row' to the row visible at the top of the rectangle: ***/
    while (row->y > y1) {
        if (row->prev == NULL)
            break;
        row = row->prev;
    }
    while (row->y + row->height < y1) {
        if (row->next == NULL)
            break;
        row = row->next;
    }
    if (inPrint) {
        // if printing hardcopy, don't print a partial row.
        if (row->y < y1)
            row = row->next;
    }

    /*** Display each line: ***/
    until (row == NULL or row->y >= y2) {
        if (inPrint and row->y + row->height > y2)
            break;  // if printing hardcopy, don't print partial rows.
        row->Paint(x1, 0, x2, row->y + row->height <= y2 ? row->height : y2 - row->height);
        row = row->next;
    }
    SKIP:

    /*** Display blank areas around the printable area: ***/
    if (realHeight < y2)
        DrawRectangle(x1, realHeight, x2, y2, Background, NOCOLOUR);

    /* The derived Row class will decide what to do with
        any display area to the right of 'realWidth'. */
}


Row* RowWin::Insert(Row *AfterThis, Row *New)
/* Insert a row at the current position.  If AfterThis == NULL, */
/* it means insert at the very top. */
{   int width,height;
    Row *row;

    /* Put in the 'sw' pointer: */
    New->parent = this;
    New->Measure(&width,&height);
    New->width = width;
    New->height = height;

    /* Insert it into the linked list: */
    if (AfterThis == NULL) {
        New->next = root;
        if (root)
            root->prev = New;
        root = New;
        New->prev = NULL;
        if (focus == NULL)
            focus = New;
    }
    else {
        New->next = AfterThis->next;
        New->prev = AfterThis;
        if (New->next)
            New->next->prev = New;
        if (New->prev)
            New->prev->next = New;
    }

    /* Update the 'Y' of everything below: */
    for (row=New; row; row=row->next) {
        if (row->prev)
            row->y = row->prev->y + row->prev->height;
        else row->y = 0;
    }

    /* Update the global width and height: */
    realHeight += New->height;
    if (New->width > realWidth)
        realWidth = New->width;

    /* Invalidate the screen: */
    InvalidateRect(0, New->y, realWidth, realHeight);

    return New;
}


Row *RowWin::Delete(Row *New)
/* Delete this row. Since the caller alloc'd it, the caller must then free it. */
/* In case this gets complicated for the caller, we return the same row. */
{   Row *row;
    int i;

    /* Delete it from the linked list: */
    if (New->prev)
        New->prev->next = New->next;
    else root = New->next;
    if (New->next)
        New->next->prev = New->prev;

    /* Update the Y-values of all following rows: */
    for (row=New->next; row; row=row->next) {
        if (row->prev == NULL)
            row->y = 0;
        else row->y = row->prev->y + row->prev->height;
    }

    /* Update any references to it (they become the following row or NULL): */
    PointerHasChanged(New, New->next);
    if (focus == New)
        focus = New->next;

    /* Update the ScrollWin rectangle: */
    realHeight -= New->height;
    if (realWidth == New->width) {
        i = 0;
        for (row=root; row; row=row->next) {
            if (row->width > i) {
                i = row->width;
                if (i == realWidth)
                    goto STILL_AS_WIDE;
            }
        }
        realWidth = i;
        STILL_AS_WIDE:;
    }

    /* Invalidate the screen: */
    if (ShowState == tfc_shown)
        InvalidateRect( scrollX, New->y,
                        scrollX + clientWidth,
                        scrollY + clientHeight);
    Resized();

    return New;
}


Row *RowWin::Replace(Row *Old, Row *New)
/* Replace 'Old' with 'New'.  Since the caller alloc'd Old, the caller must then free it. */
/* In case this gets complicated for the caller, we return Old. */
{   int i, RepaintHeight;
    bool size_changed;
    Row *row;

    /* Replace it in the linked list: */
    if (Old->prev)
        Old->prev->next = New;
    else root = New;
    if (Old->next)
        Old->next->prev = New;
    New->prev = Old->prev;
    New->next = Old->next;

    /* Update the Y-values of all the following rows (if necessary): */
    RepaintHeight = realHeight;
    if (Old->y + New->height != (New->next?New->next->y:realHeight)) {
        size_changed = yes;
        for (row=New; row; row=row->next) {
            if (row->prev == NULL)
                row->y = 0;
            else row->y = row->prev->y + row->prev->height;
            realHeight = row->y + row->height;
        }
    }
    else {
        size_changed = no;
        New->y = Old->y;
    }
    if (realHeight > RepaintHeight)
        RepaintHeight = realHeight;

    /* Replace any references to Old: */
    PointerHasChanged(Old, New);
    if (focus == Old)
        focus = New;

    /* Update the ScrollWin rectangle: */
    if (New->width > realWidth) {
        realWidth = New->width;
        size_changed = yes;
    }
    else if (Old->width == realWidth) {
        i = 0;
        for (row=root; row; row=row->next) {
            if (row->width > i) {
                i = row->width;
                if (i == realWidth)
                    goto STILL_AS_WIDE;
            }
        }
        realWidth = i;
        size_changed = yes;
        STILL_AS_WIDE:;
    }

    /* Invalidate the screen: */
    if (ShowState != tfc_shown)
        ;
    else if (size_changed) {
        InvalidateRect(0, Old->y, 32767, RepaintHeight);
        Resized();
    }
    else InvalidateRect(0, Old->y, 32767, Old->y + Old->height);

    return Old;
}


void RowWin::Resized()
/* Recalculate the RowWin parameters given that rows have changed dimensions */
/* (outside RowWin::ReplaceRow()). */
{   Row *row;

    SuppressPaints();
    realWidth = 0;
    realHeight = 0;
    for (row=root; row; row=row->next) {
        if (row->prev == NULL)
            row->y = 0;
        else row->y = row->prev->y + row->prev->height;
        realHeight = row->y + row->height;
        if (row->width > realWidth)
            realWidth = row->width;
    }
}


void RowWin::Clear()
/* We want to clear all the rows and start afresh. */
{
    SuppressPaints();
    realHeight = 0;
    realWidth = 0;
    scrollX = 0;
    scrollY = 0;

    // The RowWin owns the lines.
    while (root) {
        focus = root->next;
        delete root;
        root = focus;
    }
}


bool RowWin::Mousestroke(int op, int x, int y)
/* Map the ScrollWin position to a RowWin position. */
{   Row *row;

    if (root == NULL)
        return no;
    row = focus;
    if (row == NULL)
        row = root;
    while (row->y > y) {
        if (row->prev == NULL) {
            return row->Mousestroke(op, -1, -1);
        }
        row = row->prev;
    }
    while (row->y + row->height < y) {
        if (row->next == NULL) {
            return row->Mousestroke(op, x, 9999999);
        }
        row = row->next;
    }
    return row->Mousestroke(op, x, y - row->y);
}


bool RowWin::Keystroke(int op)
/* Map the ScrollWin position to a RowWin position. */
{
    if (focus)
        return focus->Keystroke(op);
    else return no;
}


Row *RowWin::FindRow(int Y)
/* Which row exists at this y-value? */
{   Row *row;

    if (root == NULL)
        return NULL;
    row = focus;
    if (row == NULL)
        row = root;
    while (row->y > Y) {
        if (row->prev == NULL)
            return NULL;
        row = row->prev;
    }
    while (row->y + row->height <= Y) {
        if (row->next == NULL)
            return NULL;
        row = row->next;
    }
    return row;
}


void RowWin::Measure(int *widthp, int *heightp)
/* Get the width and height */
{
    *widthp = realWidth;
    *heightp = realHeight;
}


void Row::GetPaintDetails(TfcPaintDetails *paintDetails, int x0, int y0)
{
	parent->GetPaintDetails(paintDetails, x0,y0);
	paintDetails->winY += y;
	if (paintDetails->clipRegion.top < paintDetails->winY)
		paintDetails->clipRegion.top = paintDetails->winY;
	if (paintDetails->clipRegion.bottom > paintDetails->winY + height)
		paintDetails->clipRegion.bottom = paintDetails->winY + height;
}


void Row::SetCursor(int x1, int y1, int x2, int y2)
/* Create a cursor. */
{   RowWin* RW=(RowWin*)parent;
    TfcRect Rect;

    RW->focus = this;
    Rect.left = x1;
    Rect.top = y1 + y;
    Rect.right = x2;
    Rect.bottom = y2 + y;
    RW->SetCursor(Rect);
}


RowWin::RowWin(char *_title, int _clientWidth, int _clientHeight, ScrollWin *OwnerSw)
		: ScrollWin(_title, _clientWidth, _clientHeight, 0, OwnerSw)
{
    root = NULL;
    focus = NULL;
}


RowWin::~RowWin()
{
    Clear();
}









/*============================= GridWins: =============================*/

void GridWin::Paint(int x0, int y0, int x1, int y1)
{   int i,j,i0,i1,j0,j1,iw,jw,itmp,jtmp,cx0,cx1,cy0,cy1;

    /* Do we need to recalc the measurements? */
    MakeMeasurements();

    /* What cells are involved? */
    for (i0=0; i0 < numcols; i0++)
        if (Column[i0+1] > x0)
            break;
    for (i1=numcols-1; i1 > 0; i1--)
        if (Column[i1] < x1)
            break;
    for (j0=0; j0 < numrows; j0++)
        if (Row[j0+1] > y0)
            break;
    for (j1=numrows-1; j1 > 0; j1--)
        if (Row[j1] < y1)
            break;

    /* Paint them: */
    for (j=j0; j <= j1; j++) {
        for (i=i0; i <= i1; i++) {
            cx0 = Column[i];
            for (itmp=i+1; itmp < ListSize(A[j]) and (A[j][itmp] == EXTENDED_FROM_LEFT
                        or A[j][itmp] == EXTENDED_FROM_ABOVELEFT); itmp++)
                ;
            cx1 = Column[itmp];
            cy0 = Row[j];
            for (jtmp=j+1; jtmp < numrows and i < ListSize(A[jtmp]) and A[jtmp][i] == EXTENDED_FROM_ABOVE; jtmp++)
                ;
            cy1 = Row[jtmp];
            if (A[j] == NULL or i >= ListSize(A[j]) or A[j][i] == NULL) {
                DrawRectangle(cx0,cy0,cx1,cy1,Background,NOCOLOUR);
            }
            else if (not A[j][i]->Exists()) {
                for (iw=i; (A[j][iw] == EXTENDED_FROM_LEFT or A[j][iw] == EXTENDED_FROM_ABOVELEFT)
                         and iw > 0; iw--)
                    ;
                for (jw=j; (A[jw][iw] == EXTENDED_FROM_ABOVE or A[j][iw] == EXTENDED_FROM_ABOVELEFT)
                        and jw > 0; jw--)
                    ;
				if (jw >= j0 and jw <= j1 and iw >= i0 and iw <= i1)
					continue;		// This will have been already painted.
                cx0 = Column[iw];
                cy0 = Row[jw];
                if (A[jw][iw] == NULL)
                    DrawRectangle(cx0,cy0,cx1,cy1,Background,NOCOLOUR);
                else {
                    A[jw][iw]->Paint(0,0, cx1-cx0, cy1-cy0);
                }
            }
            else {
                A[j][i]->Paint(0,0, cx1-cx0, cy1-cy0);
            }
		 }
	
		if ( focus.j == j and highlightFocusedRow)
		{		
			HighlightFocusedRow();
		}		
	}
	
    /* Do we need to repaint the cursor? */
    PaintCursorIfNeeded(x0,y0,x1,y1);

    /* Paint the empty areas: */
    if (numrows and Row[numrows] < y1)
        DrawRectangle(x0, Row[numrows], x1, y1, Background, NOCOLOUR);
    if (numcols and Column[numcols] < x1)
        DrawRectangle(Column[numcols], y0, x1, y1, Background, NOCOLOUR);
}


void GridWin::CursorPaint()
{   GridCell* cell;

    if (focus.i < 0 or focus.i >= numcols or focus.j < 0 or focus.j >= numrows)
        return;
    cell = Get(focus.i, focus.j);
    if (cell == NULL)
        DrawRectangle(Column[focus.i], Row[focus.j], Column[focus.i+1], Row[focus.j+1], NOCOLOUR, RED);
    else if (not cell->Exists())
        ;
    else 
	{
		//Highlight here so that user not experience delay between turning on the cursor and highlighting the row
		if ( highlightFocusedRow) 
			HighlightFocusedRow();	
		cell->CursorPaint();
	}
}


GridWin::GridWin(kstr _title, int _clientWidth, int _clientHeight, 
					int _Background, tfcgridgrowmode_enum _GrowMode,
					ScrollWin *Owner)
			: ScrollWin(_title, _clientWidth, _clientHeight, 0, Owner)
{
    A = NULL;
    Row = NULL;
    Column = NULL;
    Hidden = NULL;
    numrows = numcols = 0;
    Background = _Background;
    GrowMode = _GrowMode;
    focus.i = focus.j = 0;
	prevfocus.i = prevfocus.j = 0;
    movefocus.i = movefocus.j = 0;
    SetCursorBlinkRate(300, 300);
    FontHeight = 16;
    MeasurementsDirty = yes;
	highlightFocusedRow = false;
}


void GridWin::CalcColumnX()
/* Calculate the X-values for columns. */
{
	int j, i2, i, x, w, *Old, x0, x1;

    if (MeasurementsDirty)
        return;
    if (numcols == 0)
        return;
    Old = Column;
    if (GrowMode != tfc_colshugcells)
        Column = (int*)ListCopy(Old);   // Columns expand, but don't shrink.
    else Column = NULL;
    ListFree(Column);					// We need this to make all the columns zero.
	ListSetSize(Column, numcols+2);
    x = 0;
    for (i=0; i < numcols; i++) {
        if (ListHasP(Hidden, (void*)i)) {
            Column[i+1] = Column[i] + 3;
            x = Column[i+1];
            continue;
        }
        Column[i] = x;
        for (j=0; j < numrows; j++) {
            if (A[j] == NULL or i >= ListSize(A[j]))
                continue;
            for (i2=i; i2+1 < numcols and A[j][i2+1] == EXTENDED_FROM_LEFT; i2++) {
                if (Column[i2+1] < x)
                    Column[i2+1] = x;
            }
            if (A[j][i]->Exists())
                w = A[j][i]->req_width;
            else w = 0;
            if (Column[i2+1] < x + w)
                Column[i2+1] = x + w;
        }
        x = Column[i+1];
    }
    if (GrowMode == tfc_colsfillwidth) {
		int JustifyExtra = clientWidth - Column[numcols];
		for (i=0; i <= numcols; i++)
			Column[i] += JustifyExtra * Column[i] / Column[numcols];
    }
    x0 = x1 = -1;
    for (i=0; i <= numcols; i++) {
        if (i >= ListSize(Old) or Column[i] != Old[i]) {
            x1 = i;
            if (x0 == -1)
                x0 = i;
        }
    }
    if (x0 != -1 and ShowState == tfc_shown) {
        x0 = Column[x0] < Old[x0] ? Column[x0] : Old[x0];
        x1 = Column[x1] > Old[x1] ? Column[x1] : Old[x1];
        Paint(x0-1, 0, x1, Row[numrows]);
    }
    ListFree(Old);
    realWidth = Column[numcols];
}


void GridWin::CalcRowY()
/* Calculate the X-values for columns. */
{
	int j, j2, i, y, h, *Old, y0, y1;

    if (MeasurementsDirty)
        return;
    if (A == NULL or numrows == 0)
        return;
    Old = Row;
    Row = NULL;
    ListIdx(Row, numrows+1);
    y = 0;
    for (j=0; j < numrows; j++) {
        Row[j] = y;
        if (A[j] == NULL)
            continue;
        for (i=0; i < numcols; i++) {
            if (i >= ListSize(A[j]))
                continue;
            for (j2=j; j2+1 < numrows and i < ListSize(A[j2+1])
                        and A[j2+1][i] == EXTENDED_FROM_ABOVE; j2++) {
                if (Row[j2+1] < y)
                    Row[j2+1] = y;
            }
            if (A[j][i]->Exists())
                h = A[j][i]->req_height;
            else h = 0;
            if (Row[j2+1] < y + h)
                Row[j2+1] = y + h;
        }
        y = Row[j+1];
    }
    y0 = y1 = -1;
    for (j=0; j <= numrows; j++) {
        if (j >= ListSize(Old) or Row[j] != Old[j]) {
            y1 = j;
            if (y0 == -1)
                y0 = j;
        }
    }
    if (y0 != -1 and ShowState == tfc_shown) {
        y0 = (y0 >= ListSize(Old) and Old[y0] < Row[y0]) ? Old[y0] : Row[y0];
        y1 = (y1 >= ListSize(Old) and Old[y1] > Row[y1]) ? Old[y1] : Row[y1];
        Paint(0, y0-1, Column[numcols], y1);
    }
    ListFree(Old);
    realHeight = Row[numrows];
}

void GridWin::HighlightFocusedRow()
{
}

void GridWin::MakeMeasurements()
{
    if (MeasurementsDirty) {
        MeasurementsDirty = no;
        CalcRowY();
        CalcColumnX();
    }
}


void GridWin::RemeasureCells()
/* Loop through each cell and requery for req_width and req_height */
{   int x,y;

    for (y=0; y < numrows; y++) {
        if (y >= ListSize(A))
            continue;
        for (x=0; x < numcols; x++) {
            if (x >= ListSize(A[y]))
                continue;
            GridCell *GridCell=A[y][x];
            if (not GridCell->Exists())
                continue;
            GridCell->Measure(&GridCell->req_width, &GridCell->req_height);
        }
    }
}


void GridWin::Set(int i, int j, GridCell *cell)
/* Assign this cell to this location. If the location is already occupied */
/* by a value, we call the destructor on the existing value. */
{   int oldwidth, oldheight, new_width, new_height;

    /* Are the coords out-of-bounds? */
    if (i < 0 or i > numcols + 9999 or j < 0 or j > numrows + 9999)
        return;

    /* Put the pointer into A[][]: */
    ListIdx(A, j);
    ListIdx(A[j], i);
    if (A[j][i]->Exists()) {
        oldwidth = A[j][i]->req_width;
        oldheight = A[j][i]->req_height;
        delete A[j][i];
    }
    else oldwidth = oldheight = 0;
    A[j][i] = cell;

    /* Initialise Column[] and Row[]: */
    if (numcols <= i) {
        numcols = i + 1;
        ListIdx(Column, numcols);
    }
    if (numrows <= j) {
        numrows = j + 1;
        ListIdx(Row, numrows);
    }

    /* Initialise the cell: */
    if (not cell->Exists()) {
        new_width = new_height = 0;
        goto RETURN;
    }
    cell->parent = this;
    cell->i = i;
    cell->j = j;
    new_width = cell->req_width;
    new_height = cell->req_height;

    /* Adjust the Row[] and Column[]s: */
    RETURN:
    if (oldwidth < new_width) {
        if (ShowState == tfc_shown and not MeasurementsDirty)
            CalcColumnX();
        else MeasurementsDirty = yes;
    }
    if (oldheight < new_height) {
        if (ShowState == tfc_shown and not MeasurementsDirty)
            CalcRowY();
        else MeasurementsDirty = yes;
    }
    if (ShowState == tfc_shown) {
        MakeMeasurements();
        if (cell->Exists())     // Paint just this cell:
            cell->Paint(0, 0, cell->Width(), cell->Height());
    }
}


void GridWin::SetExtended(int x, int y, GridCell *cell, int sx, int sy)
/* Set a multi-cell cell. */
{   int dx,origy;

	for (dx=1; dx < sx; dx++) {
        Set(x+dx,y,EXTENDED_FROM_LEFT);
		if (y + 1 < ListSize(A) and x+dx < ListSize(A[y+1])) {
			if (A[y+1][x+dx] == EXTENDED_FROM_ABOVE)
				A[y+1][x+dx] = NULL;		// If the caller is naughty and overwrites part
				// of a spanning cell but not all of it, such that we get EXTENDED_FROM_ABOVE pointing
				// to EXTENDED_FROM_LEFT, then we get all kinds of problems including crashes.
		}
	}
    origy = y;
    for ( ; sy > 1; sy--) {
        y++;
        Set(x,y,EXTENDED_FROM_ABOVE);
        for (dx=1; dx < sx; dx++)
            Set(x+dx,y,EXTENDED_FROM_ABOVELEFT);
    }
    Set(x,origy,cell);            // Paint it last so that the painter knows it's a spanning cell.
}


void GridWin::EnableFocusedRowHighlighting(bool enable)
{
	highlightFocusedRow = enable;
	prevfocus.i = prevfocus.j = 0 ;
}


GridCell* GridWin::TakeOwnership(int i, int j)
/* Remove this cell from this grid, replacing it with a NULL. */
/* Returns the cell, which you now own. */
{   GridCell* cell;

    SuppressPaints();
    MeasurementsDirty = yes;
    cell = Get(i,j);
    if (cell == NULL)
        return cell;
    A[j][i] = NULL;
    return cell;
}


void GridWin::TakeOwnershipAndClear()
/* Clear the grid without calling the destructor. The caller now */
/* owns all the cells, i.e. the caller has the responsibility of */
/* freeing them. */
{   int j;

    SuppressPaints();
    CursorOff();
    for (j=0; j < numrows; j++) {
        if (j >= ListSize(A) or A[j] == NULL)
            continue;
        ListFree(A[j]);
    }
    ListFree(A);
    numrows = numcols = 0;
    ListFree(Row);
    ListFree(Column);
    focus.i = focus.j = 0;
}


void GridWin::DeleteRow(int y)
/* Delete this one row. */
{   int i,j;

    SuppressPaints();
    CursorOff();
	GridCell **row = A[y];
	ListDelN(A, y);
    for (i=0; i < numcols; i++) {
        if (i >= ListSize(row) or not row[i]->Exists())
            continue;
        delete row[i];
    }
    ListFree(row);
    numrows--;
    for (j=y; j < numrows; j++) {
        if (j >= ListSize(A) or A[j] == NULL)
            continue;
        for (i=0; i < numcols; i++) {
            if (i >= ListSize(A[j]) or not A[j][i]->Exists())
                continue;
            A[j][i]->j--;
        }
    }
	if (focus.j >= numrows)
		focus.j--;
}


void GridWin::Clear()
/* Clear all cells in this grid. Call the destructor on each of them. */
{   int i,j;

    SuppressPaints();
    CursorOff();
    for (j=0; j < numrows; j++) {
        if (j >= ListSize(A) or A[j] == NULL)
            continue;
        for (i=0; i < numcols; i++) {
            if (i >= ListSize(A[j]) or not A[j][i]->Exists())
                continue;
            delete A[j][i];
        }
        ListFree(A[j]);
    }
    ListFree(A);
    numrows = numcols = 0;
    ListFree(Row);
    ListFree(Column);
    focus.i = focus.j = 0;
}


int GridWin::GetKey(int i, int j)
{
    Focus();
    MoveTo(i,j);
    return ScrollWin::GetKey();
}


int GridWin::GetKey()
{
    return ScrollWin::GetKey();
}


void GridWin::MoveTo(int i, int j)
{   GridCell *cell;

	if (focus.i == i and focus.j == j)
		return;
    movefocus.i = i;
    movefocus.j = j;
    cell = Sink(i,j);
    if (cell)
        i = cell->i, j = cell->j;
    focus.i = i;
    focus.j = j;
    CalcCursorRect();
}


void GridWin::CalcCursorRect()
/* Recalculate the cursor rectangle. */
{   TfcRect rect;

    if (ListSize(A) == 0)
        return;
	if (focus.i < 0 or focus.j < 0)
		return;
    if (focus.j >= ListSize(A))
        focus.j = ListSize(A)-1;
    if (focus.i >= ListSize(A[focus.j]))
        focus.i = ListSize(A[focus.j])-1;
    int j = focus.j;
    int i = focus.i;
    rect.left = Column[i];
    rect.top = Row[j];
    do {
        i++;
    } while (i < ListSize(A[j]) and A[j][i] == EXTENDED_FROM_LEFT);
    do {
        j++;
    } while (j < ListSize(A) and i < ListSize(A[j]) and A[j][i] == EXTENDED_FROM_ABOVE);
    rect.right = Column[i];
    rect.bottom = Row[j];
    ScrollWin::SetCursor(rect);
}


void GridWin::MoveTo(GridCell* cell)
{
    if (not cell->Exists())
        return;
    MoveTo(cell->i, cell->j);
}


GridCell* GridWin::Get(int i, int j)
{
    if (j < 0 or i < 0)
        return NULL;
    if (j >= ListSize(A) or A[j] == NULL)
        return NULL;
    if (i >= ListSize(A[j]))
        return NULL;
    if (not A[j][i]->Exists())
        return NULL;
    return A[j][i];
}


GridCell* GridWin::GetRaw(int i, int j)
{
    if (j < 0 or i < 0)
        return NULL;
    if (j >= ListSize(A) or A[j] == NULL)
        return NULL;
    if (i >= ListSize(A[j]))
        return NULL;
    return A[j][i];
}


void GridWin::Measure(int *widthp, int *heightp)
/* Get the width and height */
{
    *widthp = Column[numcols];
    *heightp = Row[numrows];
}


GridWin::GridWin(GridWin &orig)
    : ScrollWin(orig)
/* Do a deep-copy. */
{   int i,j;

    Row = (int*)ListCopy(orig.Row);
    Column = (int*)ListCopy(orig.Column);
    Hidden = (int*)ListCopy(orig.Hidden);
    A = (GridCell***)ListCopy(orig.A);
    realWidth = orig.realWidth;
    realHeight = orig.realHeight;
    GrowMode = orig.GrowMode;
    MeasurementsDirty = yes;
    numrows = orig.numrows;
    numcols = orig.numcols;
    ShowState = tfc_shown;
    focus.i = focus.j = 0;
    for (j=0; j < ListSize(A); j++) {
        if (A[j] == NULL)
            continue;
        A[j] = (GridCell**)ListCopy(A[j]);
        for (i=0; i < ListSize(A[j]); i++) {
            if (A[j][i]->Exists()) {
                A[j][i] = (GridCell*)A[j][i]->DuplicateMe();
                A[j][i]->parent = this;
            }
        }
    }
	dontScrollX = orig.dontScrollX;
	dontScrollY = orig.dontScrollY;
	highlightFocusedRow = orig.highlightFocusedRow;
}


Litewin* GridWin::DuplicateMe()
{
    return new GridWin(*this);
}


GridWin::~GridWin()
{   int i,j;

    ListFree(Row);
    ListFree(Column);
    ListFree(Hidden);
    for (j=0; j < ListSize(A); j++) {
        if (A[j] == NULL)
            continue;
        for (i=0; i < ListSize(A[j]); i++) {
            if (A[j][i]->Exists())
                delete A[j][i];
        }
        ListFree(A[j]);
    }
    ListFree(A);
}


void GridCell::GetPaintDetails(TfcPaintDetails *paintDetails, int x, int y)
/* Get the top left-hand corner of this Litewin in Windows coords. */
{   GridWin *grid=(GridWin*)parent;
    int itmp,jtmp;

    if (not Exists())
        return;
    parent->GetPaintDetails(paintDetails, grid->Column[i]+x, grid->Row[j]+y);

	for (itmp=i+1; itmp < grid->numcols and itmp < ListSize(grid->A[j])
                    and grid->A[j][itmp] == EXTENDED_FROM_LEFT; itmp++)
        ;
    for (jtmp=j+1; jtmp < grid->numrows and i < ListSize(grid->A[jtmp])
                     and grid->A[jtmp][i] == EXTENDED_FROM_ABOVE; jtmp++)
        ;
	TfcRect rect;
	rect.left = grid->Column[i] + paintDetails->winX;
    rect.top = grid->Row[j] + paintDetails->winY;
    rect.right = grid->Column[itmp] + paintDetails->winX;
    rect.bottom = grid->Row[jtmp] + paintDetails->winY;
	paintDetails->clipRegion.intersect(rect);
	paintDetails->winX += grid->Column[i];
    paintDetails->winY += grid->Row[j];
}


int GridCell::Width()
{   GridWin *grid=(GridWin*)parent;
    int itmp;

    if (not Exists())
        return 0;
    for (itmp=i+1; itmp < ListSize(grid->A[j]) and
                (grid->A[j][itmp] == EXTENDED_FROM_LEFT
                or grid->A[j][itmp] == EXTENDED_FROM_ABOVELEFT); itmp++)
        ;
    return grid->Column[itmp] - grid->Column[i];
}


int GridCell::Height()
{   GridWin *grid=(GridWin*)parent;
    int jtmp;

    if (not Exists())
        return 0;
    for (jtmp=j+1; jtmp < grid->numrows and i < ListSize(grid->A[jtmp]) and
                (grid->A[jtmp][i] == EXTENDED_FROM_ABOVE
                or grid->A[jtmp][i] == EXTENDED_FROM_ABOVELEFT); jtmp++)
        ;
    return grid->Row[jtmp] - grid->Row[j];
}


void GridCell::CursorPaint()
{   int w=Width(), h=Height();

    DrawRectangle(0, 0, w, h, NOCOLOUR, RED);
    DrawRectangle(1, 1, w-1, h-1, NOCOLOUR, RED);
}


void GridCell::Resize(int newwidth, int newheight)
/* Change the size. */
{   GridWin *grid=(GridWin*)parent;

    if (req_width != newwidth) {
        req_width = newwidth;
        grid->CalcColumnX();
    }
    if (req_height != newheight) {
        req_height = newheight;
        grid->CalcRowY();
    }
}


GridCell* GridWin::Sink(int i, int j)
/* Map this (x,y) value to a cell that exists.        */
/* Return NULL if it isn't part of any extended cell. */
{
    if (i >= numcols or j >= numrows or i < 0 or j < 0)
        return NULL;
    if (i >= ListSize(A[j]))
        return NULL;
    while (i > 0 and (A[j][i] == EXTENDED_FROM_ABOVELEFT
                    or A[j][i] == EXTENDED_FROM_LEFT))
        i--;
    while (j > 0 and i < ListSize(A[j]) and A[j][i] == EXTENDED_FROM_ABOVE)
        j--;
    if (i < 0 or j < 0 or A[j][i] <= (void*)0x4)
        return NULL;
    return A[j][i];
}


GridCell* GridWin::GetFromXY(int x, int y, int *ip, int *jp)
/* Get the cell at this pixel location.  You can either use the */
/* the formal return value or the 'i,j' return values. If (x,y) */
/* is below the last row or to the right of the rightmost       */
/* column, then return NULL and return i=j=-1. */
{   int i,j;

    *ip = *jp = -1;
    for (i=0; i < numcols; i++)
        if (Column[i+1] > x)
            goto FOUND_X;
    return NULL;
    FOUND_X:
    for (j=0; j < numrows; j++)
        if (Row[j+1] > y)
            goto FOUND_Y;
    return NULL;
    FOUND_Y:
    *ip = i;
    *jp = j;
    if (j > ListSize(A) or i > ListSize(A[j]))
        return NULL;
    else return Sink(i,j);
}


bool GridWin::Mousestroke(int op, int x, int y)
/* Process mouse input. */
{   GridCell *cell;
    int i,j;

    if (op == MOUSE_PRESS)
        Focus();
    cell = GetFromXY(x,y, &i,&j);
    if (not cell->Exists())
        return no;
    if (not cell->Mousestroke(op, x-Column[cell->i], y-Row[cell->j])) {
        MoveTo(cell->i,cell->j);
        return yes;
    }
    return no;
}


static bool MoveInGrid(GridWin *grid, int dx, int dy)
/* Returns 'yes' for success, ie. keystroke handled. */
{   int i=grid->movefocus.i, j=grid->movefocus.j;
    GridCell *current, *newbie;

    current = grid->Sink(i, j);
    do {
        i += dx;
        j += dy;
        newbie = grid->Sink(i,j);
    } while (newbie == current
            and i >= 0 and i < grid->numcols
            and j >= 0 and j < grid->numrows);
    if (i < 0)
        i = 0;
    else if (i >= grid->numcols)
        i = grid->numcols - 1;
    if (j < 0)
        j = 0;
    else if (j >= grid->numrows)
        j = grid->numrows - 1;
    grid->MoveTo(i,j);
    return yes;
}


bool GridWin::Keystroke(int key)
/* Process a keystroke. */
{   GridCell *cell;

    cell = Get(focus.i, focus.j);
    if (not cell->Exists() or not cell->Keystroke(key)) {
        switch (key) {
            case UP:    MoveInGrid(this, 0, -1);
                        return yes;
            case DOWN:  MoveInGrid(this, 0, 1);
                        return yes;
            case LEFT:  MoveInGrid(this, -1, 0);
                        return yes;
            case RIGHT: MoveInGrid(this, 1, 0);
                        return yes;
            case HOME:  MoveTo(Sink(0,focus.j));
                        return yes;
            case END:   MoveTo(Sink(numcols-1,focus.j));
                        return yes;
            case PG_UP: MoveInGrid(this, 0, -5);
                        return yes;
            case PG_DOWN:MoveInGrid(this, 0, 5);
                        return yes;
            default:    return no;
        }
    }
    return yes;
}


void GridWin::Resized()
/* The display dimensions have changed.  What are we going to */
/* do about it? */
{   int i,j;

    if (ShowState == tfc_shown)
        ShowState = tfc_dirtyshouldpaint;
    if (clientHeight > 1500)
        FontHeight = 160;            // It's obviously a printout.
    for (j=0; j < numrows; j++) {
        for (i=0; i < numcols; i++) {
            if (i >= ListSize(A[j]))
                continue;
            GridCell *cell = A[j][i];
            if (cell->Exists())
                cell->Measure(&cell->req_width, &cell->req_height);
        }
    }
    CalcColumnX();
    CalcRowY();
    CalcCursorRect();
}


/*void GridWin::Print(control c)
{   ScrollWin **List=NULL;

    if (this->_hWnd() == NULL) {
        ListAdd(List, this);
        PrintScrollWins(List, windowTitle, nullcontrol);
    }
    else {
        GridWin *tempgrid = (GridWin*)DuplicateMe();
        //tempgrid->Background = WHITE;
        tempgrid->AddPrintHeader();
        ListAdd(List, tempgrid);
        PrintScrollWins(List, windowTitle, c, '\0');
        delete tempgrid;
    }
}*/








/*------------------ Callbacks: ----------------*/

int TfcCallback::operator()(ScrollWin *sw, control c)
{
    switch (type) {
        case IntCtrlGlobal:
                if (u.IntCtrlGlobal) return u.IntCtrlGlobal(c);
                return 0;
        case IntGlobal:
                if (u.IntGlobal) return u.IntGlobal();
                return 0;
        case VoidCtrlGlobal:
                if (u.IntCtrlGlobal) u.IntCtrlGlobal(c);
                return 0;
        case VoidGlobal:
                if (u.VoidGlobal) u.VoidGlobal();
                return 0;
        case IntCtrlMember:
                if (sw) return (sw->*u.IntCtrlMember)(c);
                return 0;
        case IntMember:
                if (sw) return (sw->*u.IntMember)();
                return 0;
        case VoidCtrlMember:
                if (sw) (sw->*u.IntCtrlMember)(c);
                return 0;
        case VoidDataMember:
                if (sw) (sw->*u.VoidDataMember)(data);
                return 0;
        case VoidMember:
                if (sw) (sw->*u.VoidMember)();
                return 0;
        case IntData:
                if (u.IntData) return u.IntData(data);
                return 0;
        case VoidData:
                if (u.VoidData) u.VoidData(data);
                return 0;
        case VoidCanvas:
                if (u.VoidCanvas) u.VoidCanvas((CanvasObj*)sw);
                return 0;
        case VoidCtrlDataGlobal:
                if (u.VoidCtrlDataGlobal) u.VoidCtrlDataGlobal(c, data);
                return 0;
        case IntCtrlDataGlobal:
                if (u.IntCtrlDataGlobal) return u.IntCtrlDataGlobal(c, data);
                return 0;
        case ReturnVal:
                return u.ReturnVal;
        case DoNothing:
                return 0;
        default:assert(false);
                return 0;
    }
}


int TfcCallback::operator()(ScrollWin *sw, CanvasObj *obj)
{
    switch (type) {
        case IntGlobal:
                return u.IntGlobal();
        case VoidGlobal:
                u.VoidGlobal();
                return 0;
        case IntMember:
                return (sw->*u.IntMember)();
        case VoidMember:
                (sw->*u.IntMember)();
                return 0;
        case VoidDataMember:
                (sw->*u.VoidDataMember)(data);
                return 0;
        case IntData:
                return u.IntData(data);
        case VoidData:
                u.IntData(data);
                return 0;
        case IntCanvas:
                return u.IntCanvas(obj);
        case VoidCanvas:
                u.IntCanvas(obj);
                return 0;
        case ReturnVal:
                return u.ReturnVal;
        case DoNothing:
                return 0;
        default:assert(false);;
                return 0;
    }
}


bool TfcCallback::operator()(ScrollWin* sw, void* data, int dataLength,  int x, int y)
{
    if (type == DropGlobal)
        return u.Drop(data, dataLength, x, y);
    if (type == DropMember)
        return (sw->*u.DropMember)(data, dataLength, x, y);
    this->data = data;
    return this->operator()(sw, NULL) != 0;
}





/*------------------ Dialog Boxes: ----------------*/

typedef enum { en_unknown, en_statictext, en_string, en_int, en_float,
    en_customedit, en_list, en_set, en_grouping, en_grid,
    en_enumerated, en_boolean, en_textbutton, en_menubutton,
    en_staticbitmap, en_staticicon,
    en_bitmapbutton, en_iconbutton,
    en_colourbutton, en_togglebutton,
    en_scrollwin, en_enclosure,
    en_swapper, en_tabcontrol,
    en_filler, en_combo, en_trackbar,
    en_setsingle } en_enum;


typedef enum {  align_right=0, align_left=1, align_centre=2,
            align_bottom=0, align_top=1, align_expand=3 } align_enum;
    // The default in both cases is 1, but the grouping operators
    // take the maximum of the children.


typedef struct controlprivate_node {
    en_enum en;
    char alignx;
    char aligny;
    char disabled;
    int x, y;
    int cx, cy;
    TfcCallback IfChanged;
    controlprivate_node *next;
    int id;
    char* name;
    dialog_node* dlgOwner;
    union {
        struct {
            char* buf;
            int sizeofbuf;
            uint flags;
        } s;
        struct {
            int *ip;
            int maxm, minm;
        } i;
        struct {
            double *fp;
            double maxm, minm;
        } f;
        struct {
            bool *bp;
        } b;
        struct {
            void *ip;
            TfcPair *list;
            char sizeofi;
        } l;
        struct {
            char *flags;
            str *A;
            int A_len;
        } set;
        struct {
            void* vp;
            char sizeofv;
            int value;
        } e;
        struct {
            void *data;
            void (*DataToString)(void *data, char* buf);
            void (*StringToData)(char* buf, void *data);
        } c;
        struct {
            control a;
            control b;
            char o;        // '-'=a on top of b,  '|'=a to the left of b
        } g;
		controlprivate_node ***grid;	// grid[y][x] is a cell.
        struct {
            HBITMAP normal;
            HBITMAP depressed;
            int cx;
            int cy;
        } bitmap;
        struct {
            control sub;
        } enclosure;
        struct {
            int iMin;
            int iMax;
            int iSelMin;
            int iSelMax;
            int iPos;
        } trackbar;
        struct {
            struct controlprivate_node **Subs;
            int Selected;
            bool visible;
        } swapper;
        struct {
            tabcontrol_type Tabs;
            int Selected;
            int height;
        } tabcontrol;
        struct {
            char* buf;
            int sizeofbuf;
            str* list;
            int sizeoflist;
            /* (aha) I put this sizeoflist var in because
               !*@!^#!@*#R%$!@# (int*)list[-1] gets *ucked up!!
             */
        } combo;
        ScrollWin *sw;
        HMENU menu;
    } u;
    controlprivate_node();
} *control_type;


typedef struct dialog_node {
    control_type head;
    control_type tail;
    control_type tree_root;
    control_type defaultcontrol;
    char* title;
    int id;
    int ReturnVal;
    TfcCallback OnExit;
    int baseX, baseY;
    int Width;
    int Height;
    bool IsDialogBar;
    bool IsModeless;
    int refcount;   // Are we in the middle of processing a command for this dlg?
    HDC hDC;
    DLGTEMPLATE *Template;
    ScrollWin *Owner;
    HWND hWnd;
    void* drop;
    struct dialog_node *next;
} *dialog_type;


static dialog_type dialog_root;
static int DlgMarginX=6, DlgMarginY=6;                // In pixels
static int DlgMarginDX, DlgMarginDY;                // In dialog units
static int GridDlgMarginX=16;
static int baseX, baseY;

static int DataToIndex(TfcPair* list, void* data);

static bool CHANGE_MESSAGES = no;
void EnableChangeMessages() { CHANGE_MESSAGES = yes; }
void DisableChangeMessages() { CHANGE_MESSAGES = no; }

static control castcontrol(struct controlprivate_node *_priv)
{   control c;

    c.priv = _priv;
    return c;
}


controlprivate_node::controlprivate_node()
{
    alignx = align_left;
    aligny = align_top;
    name = NULL;
    y = 0xbabe;        // Marks it as 'unplaced'.
    disabled = no;
    id = 0;
    dlgOwner = NULL;
}


interface control nullcontrol;


/* Note that as the application builds up the tree of controls, */
/* we calculate sizes as we go.  But we actually place the        */
/* controls in a special recursive function called when the        */
/* control tree is complete. */
#undef MAX
#define MAX(A,B)        (((A)>(B))?(A):(B))


interface control operator-(control a, control b)
{   controlprivate_node *c;

    if (not a.priv)
        return b;
    else if (not b.priv)
        return a;
    c = new controlprivate_node;
    c->en = en_grouping;
    c->u.g.a = a;
    c->u.g.b = b;
    c->u.g.o = '-';
    c->name = strdup("-");
    c->cx = MAX(a.priv->cx, b.priv->cx);
    c->cy = a.priv->cy + b.priv->cy;
    if (a.priv->en != en_filler and b.priv->en != en_filler)
        c->cy += DlgMarginY;
    c->alignx = MAX(a.priv->alignx, b.priv->alignx);
    c->aligny = MAX(a.priv->aligny, b.priv->aligny);
    return castcontrol(c);
}


interface control operator|(control a, control b)
{   controlprivate_node *c;

    if (a.priv == NULL)
        return b;
    else if (b.priv == NULL)
        return a;
    c = new controlprivate_node;
    c->en = en_grouping;
    c->u.g.a = a;
    c->u.g.b = b;
    c->u.g.o = '|';
    c->name = strdup("|");
    c->cy = MAX(a.priv->cy, b.priv->cy);
    c->cx = a.priv->cx + b.priv->cx;
    if (a.priv->en != en_filler and b.priv->en != en_filler)
        c->cx += DlgMarginX;
    c->alignx = MAX(a.priv->alignx, b.priv->alignx);
    c->aligny = MAX(a.priv->aligny, b.priv->aligny);
    return castcontrol(c);
}


interface control operator/(control a, control b)
/* A high-precedence alternative to operator|. */
{
    return operator|(a,b);
}


static void ControlsToList(controlprivate_node *a, char operatr, controlprivate_node **&List)
// The original caller must set List=NULL. 'List' then becomes the out parameter.
// This function takes ownership of 'a' and all its memory.
{	
	if (a->en == en_grouping and a->u.g.o == operatr) {
		ControlsToList(a->u.g.a.priv, operatr, List);
		ControlsToList(a->u.g.b.priv, operatr, List);
		delete a;
	}
	else ListAdd(List, a);
}


static int ControlRowHeight(controlprivate_node **A)
{	controlprivate_node *cell;
	int maxh=0;

	for (int each_aeli(cell, A))
		if (cell and cell->cy > maxh)
			maxh = cell->cy;
	return maxh;
}


static int ControlColumnWidth(controlprivate_node ***AA, int x)
{	controlprivate_node** A, *cell;
	int maxw=0;

	for (int each_aeli(A, AA)) {
		cell = A[x];
		if (cell and cell->cx > maxw)
			maxw = cell->cx;
	}
	return maxw;
}


interface control GridLayout(control a)
// If 'a' is a sequence of '|'-separated rows, separated by '-'s, then
// we interpret it as a grid and arrange the controls accordingly.
{   controlprivate_node *c, *row, **List;
	int w,numcols,numrows;

	if (a.priv == NULL)
		return a;
    c = new controlprivate_node;
    c->en = en_grid;
	List = NULL;
	ControlsToList(a.priv, '-', List);
	c->u.grid = NULL;
	ListSetSize(c->u.grid, numrows=ListSize(List));
	numcols = 0;
	for (int each_aeli(row, List)) {
		c->u.grid[i] = NULL;
		ControlsToList(row, '|', c->u.grid[i]);
		w = ListSize(c->u.grid[i]);
		if (w > numcols)
			numcols = w;
	}
	for (int each_aeli(row, List))
		ListSetSize(c->u.grid[i], numcols);
	ListFree(List);
    c->name = strdup("g");
    c->cx = 0;
	for (int x=0; x < numcols; x++)
		c->cx += ControlColumnWidth(c->u.grid, x) + GridDlgMarginX;
    c->cy = 4;
	for (int y=0; y < numrows; y++)
		c->cy += ControlRowHeight(c->u.grid[y]) + 4;
    c->alignx = align_left;
    c->aligny = align_top;
    return castcontrol(c);
}


interface int cwidth(controlprivate_node *priv)
{
    return priv->cx;
}


interface control StaticText(const char* name)
{   RECT Rect={0,0,999,999};
    controlprivate_node *c;

    c = new controlprivate_node;
    c->en = en_statictext;
    c->name = strdup(TfcDisplayStringConverter(name));
    wchar_t* wtext = ToWideStrdup(c->name);
    SelectObject(ScreenDC(), TfcGetSystemFont());
    DrawTextW(ScreenDC(), wtext, -1, &Rect, DT_CALCRECT);
    free(wtext);
    c->cx = Rect.right + 1;  /* was 10 */
    c->cy = Rect.bottom + 4;
    return castcontrol(c);
}


interface control StaticBitmap(int bitmap_id, int cx, int cy)
{   controlprivate_node *c;

    c = new controlprivate_node;
    c->en = en_staticbitmap;
    c->IfChanged = 0;
    c->u.bitmap.normal = GetBitmap(bitmap_id);
    c->u.bitmap.depressed = c->u.bitmap.normal;

    // retrieve dimensions of the bitmap
    if (cx == 0) {
        BITMAP bm;
        bm.bmWidth = bm.bmHeight = 32;
        GetObject(c->u.bitmap.normal, sizeof(bm), &bm);
        c->cx = bm.bmWidth;
        c->cy = bm.bmHeight;
    } else {
        c->cx = cx;
        c->cy = cy;
        // store bitmap's dimensions
        SetBitmapDimensionEx(c->u.bitmap.normal,cx,cy,NULL);
    }
    c->u.bitmap.cx = c->cx;
    c->u.bitmap.cy = c->cy;

    return castcontrol(c);
}


interface control StaticIcon(int icon_id)
{   controlprivate_node *c;

    c = new controlprivate_node;
    c->en = en_staticicon;
    c->u.bitmap.normal = (HBITMAP)GetIcon(icon_id, 16);
    c->u.bitmap.depressed = c->u.bitmap.normal;
    c->IfChanged = 0;
    if (TFC_HAND <= icon_id && TFC_ASTERISK >= icon_id) {
        c->cx = 33;
        c->cy = 33;
    } else {
        c->cx = 17;
        c->cy = 17;
    }
    return castcontrol(c);
}


interface control BitmapButton(int bitmap_id,
            int pressedbitmap_id, int cx, int cy, TfcCallback IfChanged)
{
	controlprivate_node *c = new controlprivate_node;
	c->en = en_bitmapbutton;
    int bitmapWidth = cx ? cx - 2: cx;
    int bitmapHeight = cy ? cy - 2 : cy;
	c->u.bitmap.normal = GetBitmap(bitmap_id, bitmapWidth, bitmapHeight);
    c->cx = bitmapWidth + 4;
    c->cy = bitmapHeight + 4;
	c->u.bitmap.cx = bitmapWidth;
	c->u.bitmap.cy = bitmapHeight;
    c->u.bitmap.depressed = pressedbitmap_id == bitmap_id ?
            c->u.bitmap.normal : GetBitmap(pressedbitmap_id);
	c->IfChanged = IfChanged;
	return castcontrol(c);
}


interface control BitmapButton(int bitmap_id, int pressedbitmap_id, TfcCallback IfChanged)
{
    return BitmapButton(bitmap_id,pressedbitmap_id, 0,0,IfChanged);
}


interface control IconButton(int icon_id, TfcCallback IfChanged)
{
	return IconButton(icon_id, 16, IfChanged);
}


interface control IconButton(int icon_id, int size, TfcCallback IfChanged)
{
	controlprivate_node *c = new controlprivate_node;
	c->en = en_iconbutton;
	c->IfChanged = IfChanged;
	c->u.bitmap.normal = (HBITMAP)GetIcon(icon_id, size - 2);
	c->u.bitmap.depressed = c->u.bitmap.normal;
    // increase button size to display icon exactly as required
    // as we do in bitmap buttons
	c->cx = size + 6;
	c->cy = size + 6;
	return castcontrol(c);
}


static void ColourChooser(controlprivate_node *cpn)
{   int* colp = cpn->u.i.ip;

    *colp = TfcChooseColour("Select a colour", *colp);
    InvalidateRect(GetDlgItem(GetActiveWindow(),cpn->id),NULL,true);
    UpdateWindow(GetDlgItem(GetActiveWindow(),cpn->id));
}


interface control ColourControl(int *colour, TfcCallback IfChanged)
{   controlprivate_node *c;

    c = new controlprivate_node;
    c->en = en_colourbutton;
    c->name = strdup("Colour");
    c->u.i.ip = colour;
    if (IfChanged.IsNull()==yes)
        c->IfChanged = TfcCallback(ColourChooser, c);
    else
        c->IfChanged = IfChanged;
    c->cx = 20;
    c->cy = 20;
    return castcontrol(c);
}

// (awa) I got sick of not having this control.
interface control TrackBarControl(int nMinValue, int nMaxValue, int nWidth, int nHeight, TfcCallback IfChanged)
{
    controlprivate_node *c = new controlprivate_node;
    control cc;

    c->en   = en_trackbar;
    c->name = strdup("Trackbar Control");
    c->cx = nWidth;
    c->cy = nHeight;

    c->u.trackbar.iMin = nMinValue;
    c->u.trackbar.iMax = nMaxValue;
    c->u.trackbar.iSelMin = nMinValue;
    c->u.trackbar.iSelMax = nMaxValue;
    c->u.trackbar.iPos = 0;

    c->IfChanged = IfChanged;

    cc.priv = c;

    return cc;
}


interface control Control(char* buf, int sizeofbuf, kstr name, int width,
			        TfcCallback IfChanged, uint flags, int height)
{   controlprivate_node *c;
    control cc;

    c = new controlprivate_node;
    c->en = en_string;
    c->u.s.buf = buf;
    c->u.s.sizeofbuf = sizeofbuf;
    c->IfChanged = IfChanged;
    c->u.s.flags = flags;
    c->name = NULL;
    c->cx = width * 8;
    if (flags & TFC_MULTILINE)
        c->cy = height * 16;
    else
        c->cy = 20;
    if (flags & TFC_GREYED)
        c->disabled = yes;
    cc.priv = c;

    if (name) {   /* The title is a separate control. */
        c->alignx = align_expand;
        cc = StaticText(name) | cc;
    }

    return cc;
}


interface control ToggleButton(kstr name, bool* status, TfcCallback IfPressed, uint flags)
{   RECT Rect={0,0,999,999};
    controlprivate_node *c;

    c = new controlprivate_node;
    c->en = en_togglebutton;
    c->name = strdup(TfcDisplayStringConverter(name));
    c->IfChanged = IfPressed;
    DrawText(ScreenDC(), c->name, -1, &Rect, DT_CALCRECT);
    c->cx = Rect.right +  10;
    c->cy = Rect.bottom + 6;
    if (c->cx < 64 and not (flags & TFC_SKINNYBUTTON))
        c->cx = 64;
    if (c->cy < 24 and not (flags & TFC_SHORTBUTTON))
        c->cy = 24;
    if (flags & TFC_GREYED)
        c->disabled = yes;
    c->u.s.flags = flags;
    c->u.b.bp = status;
    return castcontrol(c);
}

interface control Button(kstr name, TfcCallback IfPressed, uint flags)
{   RECT Rect={0,0,999,999};
    controlprivate_node *c;

    c = new controlprivate_node;
    c->en = en_textbutton;
	c->name = strdup(TfcDisplayStringConverter(name));
    c->IfChanged = IfPressed;
    DrawText(ScreenDC(), c->name, -1, &Rect, DT_CALCRECT);
    c->cx = Rect.right +  10;
    c->cy = Rect.bottom + 6;
    if (c->cx < 64 and not (flags & TFC_SKINNYBUTTON))
        c->cx = 64;
    if (c->cy < 24 and not (flags & TFC_SHORTBUTTON))
        c->cy = 24;
    if (flags & TFC_GREYED)
        c->disabled = yes;
    c->u.s.flags = flags;
    return castcontrol(c);
}


interface control MenuControl(kstr name, TfcMenu *menu, uint flags)
{   RECT Rect={0,0,999,999};
    controlprivate_node *c;

    c = new controlprivate_node;
    c->en = en_menubutton;
    c->name = strdup(TfcDisplayStringConverter(name));
    c->IfChanged = 0;
    c->u.menu = (HMENU)menu;
    DrawText(ScreenDC(), c->name, -1, &Rect, DT_CALCRECT);
    c->cx = Rect.right +  10;
    c->cy = Rect.bottom + 6;
    if (c->cx < 64 and not (flags & TFC_SKINNYBUTTON))
        c->cx = 64;
    if (c->cy < 24 and not (flags & TFC_SHORTBUTTON))
        c->cy = 24;
    return castcontrol(c);
}


interface control Control(bool *bp, kstr name, TfcCallback IfChanged)
{   RECT Rect={0,0,999,999};
    controlprivate_node *c;

    c = new controlprivate_node;
    c->en = en_boolean;
    c->name = strdup(TfcDisplayStringConverter(name));
    c->IfChanged = IfChanged;
    c->u.b.bp = bp;
    DrawText(ScreenDC(), c->name, -1, &Rect, DT_CALCRECT);
    c->cx = Rect.right + 20;
    c->cy = Rect.bottom + 4;
    return castcontrol(c);
}


interface control Control(int *ip, kstr name, int minm, int maxm, TfcCallback IfChanged)
{   controlprivate_node *c;
    control cc;

    c = new controlprivate_node;
    c->en = en_int;
    if (name)
        c->name = strdup(name);
    else c->name = NULL;
    c->IfChanged = IfChanged;
    c->u.i.ip = ip;
    c->u.i.minm = minm;
    c->u.i.maxm = maxm;
    c->cx = 50;
    c->cy = 20;
    cc.priv = c;
    if (name)              /* The title is a separate control. */
        cc = StaticText(name) | cc;
    return cc;
}


interface control Control(double *fp, kstr name, double minm, double maxm, TfcCallback IfChanged)
{   controlprivate_node *c;
    control cc;

    c = new controlprivate_node;
    c->en = en_float;
    c->name = strdup(name);
    c->IfChanged = IfChanged;
    c->u.f.fp = fp;
    c->u.f.minm = minm;
    c->u.f.maxm = maxm;
    c->cx = 85;
    c->cy = 18;
    cc.priv = c;
    if (name)              /* The title is a separate control. */
        cc = StaticText(name) | cc;
    return cc;
}


interface control CustomControl(void* data, char* name, int width,
                    void (*DataToString)(void *data, char* buf),
                    void (*StringToData)(char *buf, void *data),
					TfcCallback IfChanged)
{   controlprivate_node *c;
    control cc;

    c = new controlprivate_node;
    c->en = en_customedit;
    c->u.c.DataToString = DataToString;
    c->u.c.StringToData = StringToData;
    c->u.c.data = data;
    c->IfChanged = IfChanged;
    c->name = NULL;
    c->cx = width * 8;
    c->cy = 20;
    cc.priv = c;
    if (name) {   /* The title is a separate control. */
        //c->alignx = align_expand;
        cc = StaticText(name) | cc;
    }
    return cc;
}


interface control Control(ScrollWin *sw)
{   controlprivate_node *c;
    control cc;

    if (sw == NULL)
        return nullcontrol;
    c = new controlprivate_node;
    c->en = en_scrollwin;
    c->name = NULL;
    c->IfChanged = 0;
    c->u.sw = sw;
    c->cx = sw->clientWidth;
    c->cy = sw->clientHeight;
    if (sw->realWidth == 0 or sw->realHeight == 0)
        sw->Resized();
    cc.priv = c;
    return cc;
}


static int Return1(control c) { return 1; }

interface control OkButton()
{
    return Button("Ok", Return1, TFC_DEFPUSHBUTTON);
}


static int ReturnN1(control c) { return -1; }

interface control CancelButton()
{
    return Button("Cancel", ReturnN1);
}

#undef isupper
static int strwidth(kstr s)
/* A crude, crude measure of the width of a string. */
{   
	int n=0;

	while (s && *s) {
		if (*s == 'W' or *s == 'M')
			n += 6;
		else if (*s == 'w' or *s == 'm')
			n += 4;
		//else if (isupper(*s))
		else if (*s >= 'A' && *s <= 'Z')
			n += 4;
		else if (strchr("1|iIl!;:,. /(){}[]'`", *s))
			n += 1;
		else n += 2;
		// Unicode characters default to 2, but it's
		// represented by 2 to 4 narrow chars, so its quite wide actually
		s++;
	}
	return n;
}


interface control ComboControl(char *buf, int sizeofbuf,
          str *Suggestions,
          int width/*in chars*/,
          str heading/*can be NULL*/,
          TfcCallback IfChanged)
{   RECT Rect={0,0,999,999};
    controlprivate_node *c;
    char buffer[255];
    str longest;
    control cc;
    int llen,i;
    str* item = NULL;

    c = new controlprivate_node;
    c->en = en_combo;
    c->name = strdup("");
    c->IfChanged = IfChanged;
    c->u.combo.buf = buf;
    c->u.combo.sizeofbuf = sizeofbuf;
    c->u.combo.list = Suggestions;
    c->u.combo.sizeoflist = ListSize(Suggestions);

    if (width == -1) {
        // width not specified - calculate it
        longest = "Hello", llen=10;
        for (each_oeli(item, Suggestions))
            if (*item and (int)strwidth(*item) > (int)llen)
                longest = *item, llen = strwidth(*item);
        i = strlen(longest);
        if (i > 30)
            i = 30;     // Don't allow ridiculously long entries.
    }
    else {
        longest = buffer;
        for (i=0; i<width; )
            longest[i++] = '0';
        longest[i] = '\0';
    }
    DrawText(ScreenDC(), longest, i, &Rect, DT_CALCRECT);
    c->cx = Rect.right + 28;
    c->cy = Rect.bottom + 8;
    cc.priv = c;

    if (heading) {   /* The title is a separate control. */
        c->alignx = align_expand;
        cc = StaticText(heading) | cc;
    }
    return cc;
}


interface control ListControlWithSize(void *ip, int sizeofi,
    TfcPair *list/*dynamic array*/, TfcCallback IfChanged)
{   RECT Rect={0,0,999,999};
    controlprivate_node *c;
    TfcPair *pair;
    kstr longest;
    int llen,i;

    assert(sizeofi == 1 or sizeofi == 4);
    pair = NULL;
    c = new controlprivate_node;
    c->en = en_list;
    c->name = strdup("");
    c->IfChanged = IfChanged;
    c->u.l.ip = ip;
    c->u.l.sizeofi = sizeofi;
    c->u.l.list = list;
    longest = "Hello", llen=10;
    for (each_oeli(pair, list))
        if ((int)strwidth(pair->name) > (int)llen)
            longest = pair->name, llen = strwidth(pair->name);
    i = strlen(longest);
    if (i > 128)
        i = 128;     // Don't allow ridiculously long entries.

    DrawText(ScreenDC(), longest, i, &Rect, DT_CALCRECT);
    c->cx = Rect.right + 28;
    c->cy = Rect.bottom + 8;
    return castcontrol(c);
}


interface control SetControl(char flags[], char* A[], int A_len, TfcCallback IfChanged, str NormalWidthString, bool SetSingle)
/* Normally, A_len gives the number of elements in A[].  But if */
/* A_len==-1, it means A is a NULL-terminated array, and if        */
/* A_len==-2 (the default), it means A is a TFC array. */
{   RECT Rect={0,0,999,999};
    controlprivate_node *c;
    str longest;
    int llen,i;

    c = new controlprivate_node;
    if (SetSingle)
        c->en = en_setsingle;
    else
        c->en = en_set;
    c->name = strdup("");
    c->IfChanged = IfChanged;
    c->u.set.flags = flags;
    c->u.set.A = A;
    if (A_len == -1) {
        for (i=0; A[i]; i++)
            ;
        A_len = i;
    }
    else if (A_len == -2)
        A_len = ListSize(A);
    c->u.set.A_len = A_len;
    if (NormalWidthString) {
        longest = NormalWidthString;
        llen = strwidth(longest);
    }
    else {
        longest = "GimmeABreakMan";
        llen=-1;
    }
    for (i=0; i < A_len; i++)
        if ((int)strwidth(A[i]) > (int)llen)
            longest = A[i], llen = strwidth(A[i]);
    DrawText(ScreenDC(), longest, -1, &Rect, DT_CALCRECT);
    c->cx = Rect.right + 24;
    c->cy = Rect.bottom * 7;
    c->aligny = align_expand;
    return castcontrol(c);
}


interface control SetControl(bool flags[], char* A[], int A_len, TfcCallback IfChanged, str NormalWidthString, bool SetSingle)
{
    assert(sizeof(bool) == sizeof(char));
    return SetControl((char*)flags,A,A_len,IfChanged, NormalWidthString, SetSingle);
}


interface control EnumControlWithSize(void *vp, int sizeofv, int value,
            char* name, TfcCallback IfChanged)
{   RECT Rect={0,0,999,999};
    controlprivate_node *c;

    assert(sizeofv == 1 or sizeofv == 4);
    c = new controlprivate_node;
    c->en = en_enumerated;
    c->name = strdup(TfcDisplayStringConverter(name));
    c->IfChanged = IfChanged;
    c->u.e.vp = vp;
    c->u.e.sizeofv = sizeofv;
    c->u.e.value = value;
    DrawText(ScreenDC(), c->name, -1, &Rect, DT_CALCRECT);
    c->cx = Rect.right + 24;
    c->cy = Rect.bottom;
    return castcontrol(c);
}


interface control Enclosure(char *name, control sub)
{   controlprivate_node *c;

    if (sub.priv == NULL)
        return nullcontrol;

    c = new controlprivate_node;
    c->en = en_enclosure;
    cwidth(sub.priv);
    c->name = strdup(name);
    c->u.enclosure.sub = sub;
    c->cx = sub.priv->cx + 4 * DlgMarginX;
    c->cy = sub.priv->cy + 2 * DlgMarginY + 18;
    c->alignx = c->aligny = align_expand;
    return castcontrol(c);
}


control FillerControl(int x, int y)
{   controlprivate_node *c;

    c = new controlprivate_node;
    c->en = en_filler;
    c->name = NULL;
    c->cx = x;
    c->cy = y;
    return castcontrol(c);
}


interface control Swapper(control *Subs, int Default)
{   controlprivate_node *c, *sub = NULL;
    int i;

    c = new controlprivate_node;
    c->en = en_swapper;
    c->name = NULL;
    c->u.swapper.Subs = (control_type*)(void*)Subs;
    c->u.swapper.Selected = Default;
    c->u.swapper.visible = yes;
    c->cx = c->cy = 0;
    for (each_aeli(sub, (control_type*)Subs)) {
        if (sub == NULL)
            continue;
        if (sub->cx > c->cx)
            c->cx = sub->cx;
        if (sub->cy > c->cy)
            c->cy = sub->cy;
    }
    return castcontrol(c);
}


control Swapper(int Num, int Default, /* Num controls */...)
{   control *Subs=NULL;
    va_list args;
    int i;

    va_start(args, Default);
    for (i=0; i < Num; i++)
        ListAdd(Subs, va_arg(args, control));
    va_end(args);
    return Swapper(Subs, Default);
}


interface control TabControl(tabcontrol_type Tabs, int Default)
/* Although this is an interface function, most users will call the        */
/* variable-argument-list version of this function (which then calls        */
/* this version). */
{   controlprivate_node *c, *sub;
    RECT Rect={0,0,999,999};
    tabcontrol_type tab = NULL;
    int i;

    c = new controlprivate_node;
    c->en = en_tabcontrol;
    c->name = NULL;
    c->u.tabcontrol.Tabs = Tabs;
    c->u.tabcontrol.Selected = (Default>=0 and Default<ListSize(c->u.tabcontrol.Tabs)) ? Default : 0;

    /* Calculate height of Tabs */
    DrawText(ScreenDC(), "Simple text", -1, &Rect, DT_CALCRECT);
    c->u.tabcontrol.height = Rect.bottom + 12;

    c->cx = c->cy = 0;
    for (each_oeli(tab, Tabs)) {
        sub = tab->sub;
        if (sub == NULL)
            continue;
        if (sub->cx > c->cx)
            c->cx = sub->cx;
        if (sub->cy > c->cy)
            c->cy = sub->cy;
    }

    c->cx += 4 * DlgMarginX;                                // left\right margin
    c->cy += 4 * DlgMarginY + c->u.tabcontrol.height;        // top\bottom margin

    return castcontrol(c);
}


void* TfcTopLevelHwnd(bool AllowDlgHwnds)
// This function is typically used to identify owners for dialog boxes 
// (and scrollwins).  It returns an HWND - but this is cast as a (void*) 
// for the benefit of modules that don't #include <windows.h>.  The rules
// are:
//
//	1. If the foreground HWND is a ScrollWin, return that.
//	2. If the foreground HWND is a TFC dialog box and we allow that, 
//			then return that.
//  3. If there's a TFC dialog box, and we allow that, return that.
//  4. If there's a visible ScrollWin, return that.
//
// Note that you must not return the HWND of a subwindow, e.g. 
// a Control(ScrollWin *sw) control embedded in a dialog box, because
// then fn's like TfcMessage() will fail to work.
{   void* hForeWnd , *hWnd;

    hForeWnd = (void*)GetForegroundWindow();
    hWnd = NULL;
    for (each_scrollwin) {
		if (sw->windowTitle) {		// i.e. it's not an embedded ScrollWin
            if (sw->_hWnd() == hForeWnd)
                return sw->_hWnd();
			else if (sw->ShowState != tfc_hidden and hWnd == NULL)
                hWnd = sw->_hWnd();
		}
    }
	if (AllowDlgHwnds) {
		for (dialog_node *dlg=dialog_root; dlg; dlg=dlg->next) {
			if (dlg->hWnd == hForeWnd)
				return dlg->hWnd;
			else if (dlg->hWnd)
				hWnd = dlg->hWnd;
		}
	}
	return hWnd;
}


interface ScrollWin* TfcTopLevelSW()
{   ScrollWin *fallback=NULL;
	void* hForeWnd;

    hForeWnd = (void*)GetForegroundWindow();
    for (each_scrollwin) {
		if (sw->windowTitle) {		// i.e. it's not an embedded ScrollWin
            if (sw->_hWnd() == hForeWnd)
                return sw;
			else if (sw->ShowState != tfc_hidden)
                fallback = sw;
		}
    }
	return fallback;
}


interface int compar_pairs(TfcPair *A, TfcPair *B)
{
    return stricmp(A->name, B->name);
}


#ifdef __BORLANDC__
/* Borland Builder */
static void TfcInitCommonControls(DWORD ctrlClasses)
{   static int initialised=0;

    if (ctrlClasses == 0) {
        if (initialised != -1) {
            InitCommonControls();
            initialised = -1;
        }
    }
    else {
        if ((initialised & ctrlClasses) == ctrlClasses)
            return;
        INITCOMMONCONTROLSEX InitStruct;
        InitStruct.dwSize = sizeof(INITCOMMONCONTROLSEX);
        InitStruct.dwICC = ctrlClasses;
        InitCommonControlsEx(&InitStruct);
        initialised |= ctrlClasses;
    }
}

static HWND TfcCreateStatusWindow(LONG Style, LPCTSTR lpszText, HWND hwndParent,UINT wID)
{
return CreateStatusWindow(Style, lpszText, hwndParent,wID);
}


#else

/* VC++ */
static void TfcInitCommonControls(DWORD ctrlClass)
{   typedef BOOL (WINAPI* TfcInit_fn) (INITCOMMONCONTROLSEX *lpCtrl);
    static DWORD gCommCtrlsInitialized = 0;
    INITCOMMONCONTROLSEX data;
    HINSTANCE hCommCtrl;
    TfcInit_fn ptrInit;

    ctrlClass &= 0x000004FF;    // cut unused bits

    // We'll initialize controls once
    if (ctrlClass && !(gCommCtrlsInitialized & ctrlClass) ) {

        /* Something that happens here is necessary for the
        call to GetModuleHandle() to succeed.  It's very strange. */
        char buf[512];
        strcpy(buf, "\1");
        TfcSelectFilename(yes, buf, sizeof(buf), "*\0*\0", "txt");

        hCommCtrl = GetModuleHandle("comctl32.dll");
        if (hCommCtrl) {
            ptrInit = (TfcInit_fn) GetProcAddress(hCommCtrl, "InitCommonControlsEx");
            if (ptrInit) {
                data.dwSize = sizeof(INITCOMMONCONTROLSEX);
                data.dwICC  = ctrlClass;
                if (ptrInit(&data) )
                    gCommCtrlsInitialized |= ctrlClass;
            }
        }
        //InitCommonControls();
        gCommCtrlsInitialized = 0xFFFFFFFF;
    }
}


static HWND TfcCreateStatusWindow(LONG Style, LPCTSTR lpszText, HWND hwndParent,UINT wID)
{   typedef HWND (WINAPI* TfcStatus_fn) (LONG Style, LPCTSTR lpszText, HWND hwndParent,UINT wID);
    TfcStatus_fn ptrStatus;
    HINSTANCE hCommCtrl;
    HWND hResult;

    // Create the status bar.
    hResult = (HWND) CreateWindowEx(
        0,                       // no extended styles
        STATUSCLASSNAME,         // name of status bar class
        (LPCTSTR) NULL,          // no text when first created
        SBARS_SIZEGRIP |         // includes a sizing grip
        WS_CHILD | WS_VISIBLE,                // creates a child window
        0, 0, 0, 0,              // ignores size and position
        hwndParent,              // handle to parent window
        (HMENU) wID,            // child window identifier
        hInstance,                   // handle to application instance
        NULL);                   // no window creation data

    return hResult;
}

#endif


interface control TabControl(int Num, int Default, ...)
{   tabcontrol_type Tabs=NULL, tab;
    va_list args;
    int i;

    /* Initialize common controls library */
    TfcInitCommonControls(ICC_TAB_CLASSES);

    va_start(args, Default);
    for (i=0; i < Num; i++) {
        tab = (tabcontrol_type)ListNext(Tabs);
        tab->name = va_arg(args, char *);
        tab->sub = va_arg(args, controlprivate_node*);
    }
    va_end(args);
    return TabControl(Tabs, Default);
}


control AlignXCentre(control a)
{   controlprivate_node *c=a.priv;

    if (c)
        c->alignx = align_centre;
    return a;
}


control AlignXRight(control a)
{   controlprivate_node *c=a.priv;

    if (c)
        c->alignx = align_right;
    return a;
}


control AlignXLeft(control a)
{   controlprivate_node *c=a.priv;

    if (c)
        c->alignx = align_left;
    return a;
}


control AlignXExpand(control a)
{   controlprivate_node *c=a.priv;

    if (c) {
        c->alignx = align_expand;
        if (c->en == en_grouping and c->u.g.b.priv->alignx == align_left)
            c->u.g.b.priv->alignx = align_right;
    }
    return a;
}


control AlignYCentre(control a)
{   controlprivate_node *c=a.priv;

    if (c)
        c->aligny = align_centre;
    return a;
}


control AlignYTop(control a)
{   controlprivate_node *c=a.priv;

    if (c)
        c->aligny = align_top;
    return a;
}


control AlignYBottom(control a)
{   controlprivate_node *c=a.priv;

    if (c)
        c->aligny = align_bottom;
    return a;
}


control AlignYExpand(control a)
{   controlprivate_node *c=a.priv;

    if (c)
        c->aligny = align_expand;
    return a;
}

static void DialogFree(dialog_type dlg);

void control::CloseDialog(int ok)
{


    /* Grouping controls don't get dlgOwner defined: */
    do {
        if (priv == NULL)
            return;
        if (priv->dlgOwner)
            break;
        if (priv->en != en_grouping)
            return;
        priv = priv->u.g.a.priv;
    } forever;



    /* Do it: */
    EndDialog(priv->dlgOwner->hWnd, ok);

    /* if dialog is modeless - delete it */
    if (not priv->dlgOwner->IsModeless)
        return;
    dialog_type dlg = priv->dlgOwner;
    GlobalUnlock(dlg->Template);
    GlobalFree(dlg->Template);
    DestroyWindow(dlg->hWnd);
    DialogFree(dlg);
    delete dlg;
}



/*------ Change context of control ------*/

void control::SetList(TfcPair* newlist)
{   RECT Rect={0,0,999,999};
    TfcPair* pair = NULL;
    wchar_t wbuf[2048];
    kstr longest;
    int llen, i;

    if (priv->en == en_grouping)
        priv = priv->u.g.b.priv;            // It might be a (label,edit) pair.
    if (priv->en != en_list)
        return;
    priv->u.l.list = newlist;
    // reinitialize the data in combo box

    HWND hDlg = priv->dlgOwner ? priv->dlgOwner->hWnd : GetActiveWindow();
    HWND hCombo = GetDlgItem(hDlg,priv->id);
    if (hCombo == NULL)
        return;
    longest = "Hello", llen=10;
    SendMessage(hCombo, CB_RESETCONTENT, 0, 0);
    for (each_oeli(pair, priv->u.l.list))
    {
        Utf8ToWide(pair->name, wbuf, sizeof(wbuf));
        SendMessageW(hCombo, CB_ADDSTRING, 0, (LPARAM)wbuf);
        if ((int)strwidth(pair->name) > (int)llen)
            longest = pair->name, llen = strwidth(pair->name);
    }

    /* Reset the drop down width - NOT the CONTROL */
    i = strlen(longest);
    if (i > 30)
        i = 30;     // Don't allow ridiculously long entries.
    DrawText(ScreenDC(), longest, i, &Rect, DT_CALCRECT);   // obtain the width in pixels
    SendMessage(hCombo, CB_SETDROPPEDWIDTH, (WPARAM)Rect.right + 28, 0);

    /* Set selected */
    i = (priv->u.l.sizeofi == 4) ? *(int*)priv->u.l.ip : *(char*)priv->u.l.ip;
    SendMessage(hCombo, CB_SETCURSEL,
                    (WPARAM)DataToIndex(priv->u.l.list, (void*)i), 0);
}


void control::SetList(str *newlist, char *newflags)
/* for ComboControls and SetControl */
{   RECT Rect={0,0,999,999};
    str longest,s = NULL;
    int llen, i;
    wchar_t wbuf[2048];

    if (priv->en == en_grouping)
        priv = priv->u.g.b.priv;            // It might be a (label,edit) pair.
    //assert(priv->en == en_combo);
    HWND hDlg = priv->dlgOwner ? priv->dlgOwner->hWnd : GetActiveWindow();
    HWND hControl = GetDlgItem(hDlg,priv->id);

    if (priv->en == en_combo) {
        priv->u.combo.list = newlist;
        priv->u.combo.sizeoflist = ListSize(newlist);
        // reinitialize the data in combo box
        if (hControl == NULL)
            return;
        longest = "Hello", llen=10;
        SendMessage(hControl, CB_RESETCONTENT, 0, 0);
        for (each_aeli(s, priv->u.combo.list))
        {
            if (s)
            {
                Utf8ToWide(s, wbuf, sizeof(wbuf));
                SendMessageW(hControl, CB_ADDSTRING, 0, (LPARAM)wbuf);
                if ((int)strwidth(s) > (int)llen)
                    longest = s, llen = strwidth(s);
            }
        }
        /* Reset the drop down width - NOT the CONTROL */
        i = strlen(longest);
        if (i > 30)
            i = 30;     // Don't allow ridiculously long entries.
        DrawText(ScreenDC(), longest, i, &Rect, DT_CALCRECT); // obtain the width in pixels
        SendMessage(hControl, CB_SETDROPPEDWIDTH, (WPARAM)Rect.right + 28, 0);
        //SetWindowText(hControl,priv->u.combo.buf);

        Utf8ToWide(priv->u.combo.buf, wbuf, sizeof(wbuf));
        SetWindowTextW(hControl, wbuf);
    }
    else if (priv->en == en_set || priv->en == en_setsingle) 
    {
        priv->u.set.A = newlist;
        priv->u.set.A_len = ListSize(newlist);
        if (newflags)   // Assume use old flags array unless new one provided
            priv->u.set.flags = newflags;
        if (hControl == NULL)
            return;
        SendMessage(hControl, LB_RESETCONTENT, 0, 0);
        if (priv->en == en_setsingle)
        {
            for (i=0; i < priv->u.set.A_len; i++) 
            {
                SendMessage(hControl, LB_ADDSTRING, 0, (LPARAM)priv->u.set.A[i]);
                if (priv->u.set.flags[i])
                    SendMessage(hControl, LB_SETCURSEL, (WPARAM)(i), 0);
            }
        }
        else
        {
            for (i=0; i < priv->u.set.A_len; i++) 
            {
                SendMessage(hControl, LB_ADDSTRING, 0, (LPARAM)priv->u.set.A[i]);
                SendMessage(hControl, LB_SETSEL, (WPARAM)priv->u.set.flags[i], (LPARAM)i);
            }
            SendMessage(hControl, LB_SETCURSEL, (WPARAM)0, 0);
        }
    }
    
}


void control::SetText(const char* newname)
{   HWND hDlg;

    if (!priv)
        return;
    if (newname == NULL)
        return;
    if (priv->en == en_grouping)
        priv = priv->u.g.b.priv;            // It might be a (label,edit) pair.
    // If dialog is modeless we takes control's parent reference
    // Otherway, modal dialog window shold be active
    hDlg = priv->dlgOwner ? priv->dlgOwner->hWnd : GetActiveWindow();

    //SetWindowText(GetDlgItem(hDlg, priv->id), newname);

    int l = strlen(newname);
    wchar_t wbuf[1024];
    assert(l < arraymax(wbuf));
    memset(wbuf, 0, sizeof(wchar_t)*(l+1));
    Utf8ToWide(newname, wbuf, sizeof(wbuf));
    SetWindowTextW(GetDlgItem(hDlg, priv->id), wbuf);

    // (awa) This was a hack for morgan stanley which allows the buffer
    // to be updated when doing a set text. It's silly not to do so.
    if (priv->en == en_string) {
        if (strlen(newname) < priv->u.s.sizeofbuf)
            strcpy((char *)priv->u.s.buf, newname);
        else {
            memmove(priv->u.s.buf, newname, priv->u.s.sizeofbuf);
            ((char *)priv->u.s.buf)[priv->u.s.sizeofbuf - 1] = '\0';
        }
    }
}


str control::GetText(str dest, int sizeofdest)
{
    if (priv->en == en_grouping)
        priv = priv->u.g.b.priv;            // It might be a (label,edit) pair.
    HWND hDlg = priv->dlgOwner ? priv->dlgOwner->hWnd : GetActiveWindow();

    wchar_t* wbuf = (wchar_t*)malloc(sizeof(wchar_t)*sizeofdest);
    GetWindowTextW(GetDlgItem(hDlg, priv->id), wbuf, sizeofdest*sizeof(wchar_t));
    WideToUtf8(wbuf, dest, sizeofdest);
    free(wbuf);

    return dest;
}


int control::Width()
{
    return priv->cx;
}


int control::Height()
{
    return priv->cy;
}

int control::Value()
{
    if (priv->en == en_trackbar)
        return priv->u.trackbar.iPos;
    return 0;
}


void control::SelectTab(int tab)
{   HWND hDlg, hControl;
    NMHDR hdr;

    if (priv == NULL)
        return;
    if (priv->en != en_tabcontrol)
        return;
    hDlg = priv->dlgOwner ? priv->dlgOwner->hWnd : GetActiveWindow();
    hControl = GetDlgItem(hDlg, priv->id);
    TabCtrl_SetCurSel(hControl, tab);
    hdr.hwndFrom = hControl;
    hdr.idFrom = priv->id;
    hdr.code = TCN_SELCHANGE;
    SendMessage(hDlg, WM_NOTIFY, priv->id, (LPARAM)&hdr);
}


int control::WhichTabIsSelected()
{
    if (priv == NULL)
        return 0;
    if (priv->en != en_tabcontrol)
        return 0;
    return priv->u.tabcontrol.Selected;
}


static int DataToIndex(TfcPair* list, void* data)
/* Give a TfcPair list and a data item, work out what index */
/* this item corresponds to. -1=dunno. */
{   TfcPair *pair = NULL;
    int i;

    for (each_oeli(pair, list))
        if (pair->data == data)
            return i;
    return -1;
}


void control::Refresh()
/* Updates a set control if the application has changed the bool array. */
{   HWND hDlg, hControl;

    if (priv == NULL)
        return;
    hDlg = priv->dlgOwner ? priv->dlgOwner->hWnd : GetActiveWindow();
    hControl = GetDlgItem(hDlg,priv->id);
    if (priv->en == en_set || priv->en == en_setsingle) 
    {
        for (int i=0; i < priv->u.set.A_len; i++)
            SendMessage(hControl, LB_SETSEL, (WPARAM)priv->u.set.flags[i], (LPARAM)i);
        SendMessage(hControl, LB_SETCURSEL, (WPARAM)0, 0);
        return;
    }
    if (priv->en == en_togglebutton) {
        InvalidateRect(hControl,NULL,yes);
        UpdateWindow(hControl);
    }
}


control control::GetLeft()
{
	if (priv->en != en_grouping)
		return nullcontrol;
	return control(priv->u.g.a);
}


control control::GetRight()
{
	if (priv->en != en_grouping)
		return nullcontrol;
	return control(priv->u.g.b);
}


static str ftoascii(double f, char dest[], controlprivate_node *c)
// Decimals are always displayed if needed.  If not needed, then we look at 'decimals'.
{
    if (f == NoNum)
        *dest = '\0';
    else if (f > 1e9 or f < -1e9)
        sprintf(dest, "%g", f);
	else if (int(f) == f and int(c->u.f.maxm) == c->u.f.maxm)
		sprintf(dest, "%1.0f", f);
    else sprintf(dest, "%1.*f", (int(f*1000+0.5) % 10 == 0) ? 2 : 3, f);
    return dest;
}


void control::SetValue(double newval)
{   char buf[512];
    HWND hDlg;

    if (priv->en == en_grouping)
        priv = priv->u.g.b.priv;            // It might be a (label,edit) pair.
    if (priv->en != en_float)
        return;
    hDlg = priv->dlgOwner ? priv->dlgOwner->hWnd : GetActiveWindow();
    GetWindowText(GetDlgItem(hDlg, priv->id), buf, sizeof(buf));
    if (*buf ? newval == atof(buf) : newval == NoNum)
        return;
    SetWindowText(GetDlgItem(hDlg, priv->id), ftoascii(newval,buf, priv));
}


void control::SetValue(int newval)
{   char buf[512];
    HWND hDlg;

    // this can happen if the parent window
    // which calls the SearchByNameOrCode function
    // is removed from under it.
    if (priv == NULL)
        return;

	controlprivate_node *priv = this->priv;
    if (priv->en == en_grouping)
        priv = priv->u.g.b.priv;            // It might be a (label,edit) pair.

    hDlg = priv->dlgOwner ? priv->dlgOwner->hWnd : GetActiveWindow();
    if (priv->en == en_int) {
        GetWindowText(GetDlgItem(hDlg, priv->id), buf, sizeof(buf));
        if (newval == atoi(buf))
            return;

        // (awa) 17 Feb 2005. Updated this so the underlying value
        *(int*)priv->u.i.ip = newval;
		if (newval == NoNum)
			*buf = '\0';
        else sprintf(buf, "%d", newval);
        SetWindowText(GetDlgItem(hDlg, priv->id), buf);
    }
    else if (priv->en == en_list) {
        int newitem=(int)newval;
        if (priv->u.l.sizeofi == 4)
            *(int*)priv->u.l.ip = newitem;
        else *(char*)priv->u.l.ip = newitem;
        HWND hList = GetDlgItem(hDlg, priv->id);
        SendMessage(hList, CB_SETCURSEL, DataToIndex(priv->u.l.list, (void*)newitem), 0);
    }
    else if (priv->en == en_boolean) {
        bool bnewval=newval!=0;
        CheckDlgButton(hDlg, priv->id, bnewval);
        *priv->u.b.bp = bnewval;
    }
    else if (priv->en == en_float)
        SetValue((double)newval);
    else if (priv->en == en_trackbar) {
        priv->u.trackbar.iPos = newval;

        // (awa) Repaint Trackbar
        SendMessage(GetDlgItem(hDlg, priv->id), TBM_SETPOS, (WPARAM) TRUE, (LPARAM) newval);
		::SetFocus(GetDlgItem(hDlg, priv->id));
        return;
    }
    else assert(false);
}


void control::SetEnumValue(int n, void* varp)
{
    /* (aha) Please, please... I think if you allow the ability to have nullcontrols,
       then control functions should at least check for nulls (?)*/
    if (priv == NULL)
        return;
    if (priv->en == en_enumerated) {
        if (!varp or priv->u.e.vp == varp) {
            if (priv->u.e.sizeofv == 1) // update value
                *(char*)priv->u.e.vp = n;
            else *(int*)priv->u.e.vp = n;
            if (!priv->dlgOwner) // something's wrong with dialog - we can't access the control
                return;
            CheckDlgButton(priv->dlgOwner->hWnd, priv->id,
                    priv->u.e.value == n ? BST_CHECKED : BST_UNCHECKED);
            if (priv->u.e.value == n)
                priv->IfChanged(priv->dlgOwner->Owner, castcontrol(priv));
        }
    }
    else if (priv->en == en_grouping) {
        priv->u.g.a.SetEnumValue(n, varp);
        priv->u.g.b.SetEnumValue(n, varp);
    }
}


void control::ChangeIcon(int icon_id)
{
	if(priv == NULL)
		return;

	controlprivate_node *priv = this->priv;
    // It might be a (label,edit) pair.
	if(priv->en == en_grouping)
        priv = priv->u.g.b.priv;

	int type;
	int cx = 0;
    int cy = 0;
    if (priv->en == en_staticicon || priv->en == en_iconbutton)
	{
		type = IMAGE_ICON;
        cx = priv->cx - (priv->en == en_iconbutton ? 6 : 3);
        cy = priv->cy - (priv->en == en_iconbutton ? 6 : 3);
	}
	else if (priv->en == en_staticbitmap || priv->en == en_bitmapbutton)
	{
		type = IMAGE_BITMAP;
        cx = priv->u.bitmap.cx - (priv->en == en_bitmapbutton ? 0 : 3);
        cy = priv->u.bitmap.cy - (priv->en == en_bitmapbutton ? 0 : 3);
	}
	else
	{
		assert(false);
		return;
	}

	HWND hDlg = priv->dlgOwner ? priv->dlgOwner->hWnd : GetActiveWindow();
	priv->u.bitmap.normal = (HBITMAP)GetBitmapOrIcon(icon_id, type, cx, cy, NULL);
    priv->u.bitmap.depressed = priv->u.bitmap.normal;
	                            
	if (priv->en == en_staticicon || priv->en == en_staticbitmap)
    {
		SendDlgItemMessage(hDlg, priv->id, STM_SETIMAGE,
                (WPARAM)type, (LPARAM)priv->u.bitmap.normal);
    }
    else if(priv->en == en_iconbutton || priv->en == en_bitmapbutton)
    {
		SendDlgItemMessage(hDlg, priv->id, BM_SETIMAGE,
                (WPARAM)type, (LPARAM)priv->u.bitmap.normal);
    }

	InvalidateRect(GetDlgItem(hDlg, priv->id), NULL, false);
}


void control::SetGrey(bool greyed)
{
    if (!priv)
        return;
    priv->disabled = greyed;
    if (priv->en == en_grouping) {
        priv->u.g.a.SetGrey(greyed);
        priv->u.g.b.SetGrey(greyed);
    }
    else {
        if (priv->id) {
            HWND hDlg;
            hDlg = priv->dlgOwner ? priv->dlgOwner->hWnd : GetActiveWindow();
            EnableWindow(GetDlgItem(hDlg, priv->id), not greyed);
        }
    }
}


bool control::IsEnabled()
{
    return priv != NULL and not priv->disabled;
}


void control::SetFocus()
{
	// if you like use it from response = ::GetKey()
	// don't forget after SetFocus set response to 0
	// for example look CtrlFPressed()
	controlprivate_node *c = priv;
	if (c->en == en_grouping)
		c = c->u.g.b.priv;
	if (c and c->dlgOwner) {
		HWND hWnd = GetDlgItem(c->dlgOwner->hWnd, c->id);
		::SetFocus(hWnd);
	}
}


bool control::TextInList(str field, bool case_sensitive)
{   str s, *list;
    int max;

    if (priv == NULL)
        return false;

    switch (priv->en) {
        case en_combo:
            /* (aha) I put this sizeoflist var in because
               !*@!^#!@*#R%$!@# (int*)list[-1] gets *ucked up!!
             */
            list = priv->u.combo.list;
            max = priv->u.combo.sizeoflist;
            break;
        case en_set:
        case en_setsingle:
            list = priv->u.set.A;
            max = priv->u.set.A_len;
            break;
        default:
            list = NULL;
            max = 0;
            break;
    }
    if (list) {
        for (int i=0; i < max; i++) {
            s = list[i];
            if (s == NULL or s == (char*)0x2080) {// I don't know why, but this happens
                assert(false);
                return false;
            }
            if (case_sensitive and streq(field, s))
                return true;
            else if (strieq(field, s))
                return true;
        }
    }
    return false;
}



static dialog_type DlgBeingBuilt;
static int PopupMenuChoice;


static int compar_width(controlprivate_node **a, controlprivate_node **b)
{
    return (*a)->cx - (*b)->cx;
}


bool PatternMatchAlign(controlprivate_node *c)
/* Make small adjustments to the 'cx' field of c's children in order */
/* to improve the appearance of the dialog box by aligning fields.   */
/* Returns 'yes' if it changes something. */
{   controlprivate_node *names[50], *d, *tmp;
    bool something_done;
    int n, i, w;

    /* First get a list of the static-text parts: */
    n = 0;
    while (c->en == en_grouping and c->u.g.o == '-') {
        d = c->u.g.b.priv;
        c = c->u.g.a.priv;
        if (d->en == en_grouping and d->u.g.o == '-') {
            tmp = c;
            c = d;
            d = tmp;
        }
        if (d->en != en_grouping)
            continue;
        while (d->en == en_grouping and d->u.g.o == '|')
            d = d->u.g.a.priv;
        if (d->en == en_statictext) {
            names[n++] = d;
            if (n >= arraymax(names) - 2)
                break;
        }
    }
    d = c;
    while (d->en == en_grouping and d->u.g.o == '|')
        d = d->u.g.a.priv;
    if (d->en == en_statictext)
        names[n++] = d;
    if (n <= 1)
        return no;

    /* Now determine a good alignment: */
    qsort(names, n, sizeof(names[0]), (cmp_fn)compar_width);
    i = n * 9 / 10;
    if (i == n)
        i--;
    w = names[i]->cx;
    while (i < n-1 and names[i]->cx < w * 10 / 9)
        i++;
    w = names[i]->cx;

    /* Now set them all to use this alignment if possible: */
    something_done = no;
    for (i=0; i < n; i++) {
        if (names[i]->cx < w and names[i]->cx > w / 2) {
            names[i]->cx = w;
            something_done = yes;
        }
    }
    return something_done;
}


static void RecursePatternMatchAlign(controlprivate_node *c)
/* Apply some small adjustments to the size of each control        */
/* in order to improve the appearance of the dialog box.         */
{   controlprivate_node *a,*b;
    int i;

    if (c == NULL)
        return;
    switch (c->en) {
        case en_grouping:
                a = c->u.g.a.priv;
                b = c->u.g.b.priv;
                if (c->u.g.o == '-')
                    PatternMatchAlign(c);        // Payload.
                RecursePatternMatchAlign(a);
                RecursePatternMatchAlign(b);
                if (c->u.g.o == '-') {
                    c->cx = (a->cx > b->cx) ? a->cx : b->cx;
                    c->cy = a->cy + b->cy;
                    if (a->en != en_filler and b->en != en_filler)
                        c->cy += DlgMarginDY;
                }
                else {
                    c->cy = (a->cy > b->cy) ? a->cy : b->cy;
                    c->cx = a->cx + b->cx;
                    if (a->en != en_filler and b->en != en_filler)
                        c->cx += DlgMarginDX;
                }
                break;

        case en_enclosure:
                a = c->u.enclosure.sub.priv;
                RecursePatternMatchAlign(a);
                c->cx = a->cx + 4 * DlgMarginDX;
                c->cy = a->cy + 2 * DlgMarginDY + 18*4/baseX;
                break;

        case en_swapper:
                control_type sub;
                sub = NULL;
                c->cx = c->cy = 0;
                for (each_aeli(sub, c->u.swapper.Subs)) {
                    RecursePatternMatchAlign(sub);
                    if (sub == NULL)
                        continue;
                    if (sub->cx > c->cx)
                        c->cx = sub->cx;
                    if (sub->cy > c->cy)
                        c->cy = sub->cy;
                }
                break;

        case en_tabcontrol:
                tabcontrol_type tab;
                tab = NULL;
                c->cx = c->cy = 0;
                for (each_oeli(tab, c->u.tabcontrol.Tabs)) {
                    if (tab->sub == NULL)
                        continue;
                    RecursePatternMatchAlign(tab->sub);
                    if (tab->sub->cx > c->cx)
                        c->cx = tab->sub->cx;
                    if (tab->sub->cy > c->cy)
                        c->cy = tab->sub->cy;
                }
                c->cx += 4 * DlgMarginDX;
                c->cy += 4 * DlgMarginDY + c->u.tabcontrol.height;
                break;

        default:
            break;
    }
}


static void RecursePlaceControls(controlprivate_node *c, const RECT *ParentRect)
/* Set the 'x' and 'y' fields of 'c' and all its child controls */
/* within the rectangle 'Rect'.  And put 'c' into 'Dlg'. */
{   RECT Rect, ChildRect;

	extern control cdbg;

    /*** Check that we have a strict tree: ***/
    if (c->y != 0xbabe) {
        assert(false);        // We've already placed this control!!
        return;
    }

    if (DlgBeingBuilt->IsDialogBar and c->en == en_statictext)
        c->aligny = align_centre;

    /*** Align the control: ***/
    if (c->alignx == align_left) {
        Rect.left = ParentRect->left;
        Rect.right = ParentRect->left + c->cx;
    }
    else if (c->alignx == align_right) {
        Rect.right = ParentRect->right;
        Rect.left = ParentRect->right - c->cx;
    }
    else if (c->alignx == align_centre) {
        Rect.left = (ParentRect->left + ParentRect->right - c->cx) / 2;
        Rect.right = Rect.left + c->cx;
    }
    else /* expand */ {
        Rect.left = ParentRect->left;
        Rect.right = ParentRect->right;
        c->cx = Rect.right - Rect.left;
    }
    if (c->aligny == align_top) {
        Rect.top = ParentRect->top;
        Rect.bottom = ParentRect->top + c->cy;
    }
    else if (c->aligny == align_right) {
        Rect.bottom = ParentRect->bottom;
        Rect.top = ParentRect->bottom - c->cy;
    }
    else if (c->aligny == align_centre) {
        Rect.top = (ParentRect->top + ParentRect->bottom - c->cy) / 2;
        Rect.bottom = Rect.top + c->cy;
    }
    else /* expand */ {
        Rect.top = ParentRect->top;
        Rect.bottom = ParentRect->bottom;
        c->cy = Rect.bottom - Rect.top;
    }
    c->x = Rect.left;
    c->y = Rect.top;


    /*** Some stuff depends on the type of control: ***/
    switch (c->en) {
        case en_grouping:
            if (c->u.g.o == '-') {
                /*** Putting one on top of the other: ***/
                ChildRect = Rect;
                if (c->u.g.a.priv->aligny == align_expand) {
                    // Place the bottom one first.
                    ChildRect.top = Rect.bottom - c->u.g.b.priv->cy;
                    RecursePlaceControls(c->u.g.b.priv, &ChildRect);
                    ChildRect.bottom = ChildRect.top - DlgMarginDY;
                    ChildRect.top = Rect.top;
                    RecursePlaceControls(c->u.g.a.priv, &ChildRect);
                }
                else {
					// Place the top one first.
					ChildRect.bottom = Rect.top + c->u.g.a.priv->cy;
					RecursePlaceControls(c->u.g.a.priv, &ChildRect);
					ChildRect.top = ChildRect.bottom + DlgMarginDY;
					ChildRect.bottom = Rect.bottom;
					RecursePlaceControls(c->u.g.b.priv, &ChildRect);
				}
            }
            else {
                /*** Putting one beside the other: ***/
                ChildRect = Rect;
                if (c->u.g.a.priv->alignx == align_expand) {
                    // Place the right one first.
                    ChildRect.left = Rect.right - c->u.g.b.priv->cx;
                    RecursePlaceControls(c->u.g.b.priv, &ChildRect);
                    ChildRect.right = ChildRect.left - DlgMarginDX;
                    ChildRect.left = Rect.left;
                    RecursePlaceControls(c->u.g.a.priv, &ChildRect);
                }
                else {
                    // Place the left one first.
                    ChildRect.right = Rect.left + c->u.g.a.priv->cx;
                    RecursePlaceControls(c->u.g.a.priv, &ChildRect);
                    ChildRect.left = ChildRect.right + DlgMarginDX;
                    ChildRect.right = Rect.right;
                    RecursePlaceControls(c->u.g.b.priv, &ChildRect);
                }
            }
            break;

        case en_grid:
			{	int *X, *Y, numcols, numrows;
				controlprivate_node *cell;
				int marginX,marginY;

				if (c->u.grid == NULL)
					break;
				X = Y = NULL;
				ListSetSize(Y, numrows=ListSize(c->u.grid));
				ListSetSize(X, numcols=ListSize(c->u.grid[0]));
				for (int y=0; y < numrows; y++) {
					for (int x=0; x < numcols; x++) {
						cell = c->u.grid[y][x];
						if (cell and cell->cx > X[x])
							X[x] = cell->cx;
						if (cell and cell->cy > Y[y])
							Y[y] = cell->cy;
					}
				}
				marginX = GridDlgMarginX * 4 / baseX;
				marginY = DlgMarginY * 8 / baseY;
				for (int x=0; x < numcols; x++)
					X[x] += marginX;
				for (int y=0; y < numrows; y++)
					Y[y] += marginY;
				for (int y=1; y < numrows; y++)
					Y[y] += Y[y-1];
				for (int x=1; x < numcols; x++)
					X[x] += X[x-1];
				for (int y=0; y < numrows; y++) {
					for (int x=0; x < numcols; x++) {
						cell = c->u.grid[y][x];
						if (cell == NULL)
							continue;
						ChildRect.top = Rect.top + (y>0?Y[y-1]:0);
						ChildRect.left = Rect.left + (x>0?X[x-1]:0);
						ChildRect.bottom = Rect.top + Y[y];
						ChildRect.right = Rect.left + X[x];
						RecursePlaceControls(cell, &ChildRect);
					}
				}
            	ListFree(X);
				ListFree(Y);
			}
			break;

        case en_enclosure:
            Rect.left += 2*DlgMarginDX;
            Rect.right -=  2*DlgMarginDX;
            Rect.bottom -= 2*DlgMarginDY;
            Rect.top += 18 * 8 / baseY;
            RecursePlaceControls(c->u.enclosure.sub.priv, &Rect);
            break;

        case en_swapper:
            control_type sub;
            sub = NULL;
            int i;

            for (each_aeli(sub, c->u.swapper.Subs)) {
                if (sub == NULL)
                    continue;
                RecursePlaceControls(sub, ParentRect);
            }
            break;

        case en_tabcontrol:
            Rect.left   += 2*DlgMarginDX;
            Rect.right  -= 2*DlgMarginDX;
            Rect.bottom -= 2*DlgMarginDY;
            Rect.top    += 2*DlgMarginDY + c->u.tabcontrol.height;
            tabcontrol_type tab;
            tab = NULL;
            for (each_oeli(tab, c->u.tabcontrol.Tabs)) {
                if (tab->sub == NULL)
                    continue;
                RecursePlaceControls(tab->sub, &Rect);
            }
            break;

        case en_filler:
            break;
    }
}


static void RecurseLinearise(dialog_type dlg, controlprivate_node *c)
/* Put all controls into a linked list, ordered according */
/* to how we want the TAB keys to go. */
{
    if (c == NULL)
        return;
    switch (c->en) {
        case en_grouping:
            RecurseLinearise(dlg, c->u.g.a.priv);
            RecurseLinearise(dlg, c->u.g.b.priv);
            break;

		case en_grid:
			for (int y=0; y < ListSize(c->u.grid); y++) {
				int numcols = ListSize(c->u.grid[y]);
				for (int x=0; x < numcols; x++) {
					controlprivate_node* cell = c->u.grid[y][x];
					if (cell)
						RecurseLinearise(dlg, cell);
				}
			}
			break;

        case en_enclosure:
            RecurseLinearise(dlg, c->u.enclosure.sub.priv);
            goto ADD_TO_LIST;

        case en_swapper:
            control_type sub;
            sub = NULL;
            int i;

            for (each_aeli(sub, c->u.swapper.Subs))
                RecurseLinearise(dlg, sub);
            goto ADD_TO_LIST;

        case en_tabcontrol:
            tabcontrol_type tab;
            tab = NULL;
            for (each_oeli(tab, c->u.tabcontrol.Tabs))
                RecurseLinearise(dlg, tab->sub);
            goto ADD_TO_LIST;

        case en_filler:
            break;

        default:
            ADD_TO_LIST:
            if (dlg->head == NULL)
                dlg->head = c;
            if (dlg->tail)
                dlg->tail->next = c;
            dlg->tail = c;
            c->next = NULL;
            c->id = dlg->id++;
            break;
    }
}


bool ScrollWin::IsValid()
/* Is this ScrollWin still in the ScrollWinRoot list?      */
/* You can call this to check on the status of ScrollWin's */
/* that might have already been deleted (an unusual way to */
/* use a function perhaps). */
{
    for (each_scrollwin)
        if (sw == this)
            return yes;
    return no;
}


static void RecurseFreeControls(controlprivate_node *c)
/* Free all controls. */
{
    if (c == NULL)
        return;
    switch (c->en) {
        case en_grouping:
            RecurseFreeControls(c->u.g.a.priv);
            RecurseFreeControls(c->u.g.b.priv);
            if (c->name) // '|'and '-' simbols also must be freed,
                free(c->name);
            break;

		case en_grid:
			for (int y=0; y < ListSize(c->u.grid); y++) {
				int numcols = ListSize(c->u.grid[y]);
				for (int x=0; x < numcols; x++) {
					controlprivate_node* cell = c->u.grid[y][x];
					if (cell)
						RecurseFreeControls(cell);
				}
			}
			break;

        case en_enclosure:
            if (c->name)
                free(c->name);
            RecurseFreeControls(c->u.enclosure.sub.priv);
            break;

        case en_swapper:
            control_type sub;
            sub = NULL;
            int i;

            for (each_aeli(sub, c->u.swapper.Subs))
                RecurseFreeControls(sub);
            break;

        case en_tabcontrol:
            tabcontrol_type tab;
            tab = NULL;
            for (each_oeli(tab, c->u.tabcontrol.Tabs))
                RecurseFreeControls(tab->sub);
            break;

        case en_scrollwin:
            if (c->u.sw->IsValid())
                c->u.sw->DetachFromWindow();
            break;

        default:
            if (c->name)
                free(c->name);
            break;
    }
    delete c;
}


static void DialogFree(dialog_type dlg)
/* The purpose of this function is to (a) free the tree of controls, */
/* and (b) remove the dialog_node from the linked list and free it.  */
/* The window is closed and the template is freed in the callers.    */
{   dialog_type *dlgp;

    RecurseFreeControls(dlg->tree_root);
    for (dlgp=&dialog_root; *dlgp; ) {
        if (*dlgp == dlg)
            *dlgp = dlg->next;
        else dlgp=&(*dlgp)->next;
    }
}


static control_type CtlFromId(ScrollWin* sw, int id)
{   control_type c;

    if (sw == NULL)
        return NULL;
    for (c=sw->dialogbar->head; c; c=c->next) {
        if (c->id == id)
            return c;
    }
    return NULL;
}

static int CBDataToIndex(TfcPair* list, int data)
{   TfcPair *pair = NULL;
    int i;

    for (each_oeli(pair, list))
       if (data == (int) (pair->data))
            return i;
    return -1;
}


static bool IsCallbackMessage(control_type c, int Msg, TfcCallback& callback, HWND hwnd)
/*   The function analyses message that comes from control. */
/*    Return value: */
/*  true -  the message is meaningful and should be transferred to user*/
/*  false - user's callback shouldn't be called */
/*  Callback function is stored in callback variable */
{   static int Selected=-1;
    int Result, i=0;
    char buf[160];
    wchar_t wbuf[512];

    switch (c->en) {
        case en_colourbutton:
        case en_bitmapbutton:
        case en_textbutton:
        case en_iconbutton:
                    if (Msg == EN_ENTER)
                        return no;
                    break;
        case en_string:
        case en_float:
        case en_int:
					if (CHANGE_MESSAGES and EN_CHANGE)
						break;
                    if (Msg == EN_KILLFOCUS or Msg == EN_ENTER)
                        break;
                    return false;
        case en_trackbar:
                    break;
        case en_combo:
                    switch (Msg) {
                        case CBN_EDITCHANGE :
                            if (!SendMessage(hwnd,CB_GETDROPPEDSTATE,0,0))
                                return no;
                            GetWindowTextW(hwnd,wbuf,arraymax(wbuf));
                            SendMessage(hwnd,CB_SHOWDROPDOWN,0,0);
                            SetWindowTextW(hwnd,wbuf);
                            SendMessage(hwnd,CB_SETEDITSEL,0,MAKELPARAM(wcslen(wbuf), wcslen(wbuf)));
                            return false;
                        case CBN_SELENDOK :
                            i = 0;
                            GetWindowTextW(hwnd, wbuf, arraymax(wbuf));
                            Result = SendMessage(hwnd, CB_GETCURSEL, 0, 0);
                            while (i++ <= Result)    /*ignore thouse items in combo list that are NULL*/
                                if (!c->u.combo.list[i-1])
                                    Result++;
                            if (Result != -1)
                            {
                                Utf8ToWide(c->u.combo.list[Result], wbuf, sizeof(wbuf));
                                SetWindowTextW(hwnd, wbuf);
                            }
                            break;
                        case EN_ENTER :
                            GetWindowTextW(hwnd,wbuf,arraymax(wbuf));
                            SendMessage(hwnd,CB_SHOWDROPDOWN,0,0);
                            SetWindowTextW(hwnd,wbuf);
                            SendMessage(hwnd,CB_SETEDITSEL,0,MAKELPARAM(wcslen(wbuf), wcslen(wbuf)));
                        case CBN_KILLFOCUS :
                            break;
                        case CBN_DROPDOWN :
                            PostMessage(GetParent(hwnd),WM_COMMAND,MAKEWPARAM(c->id,CBN_STUPIDBUG),(LPARAM) hwnd);
                            return no;
                        case CBN_STUPIDBUG: // This message appear because of microsoft bug -
                                            // when combo box is dropped down, it shows selection
                                            // on first item that begins from real selection name
                            Result = SendMessage(hwnd, CB_GETCURSEL, 0, 0);
                            SendMessage(hwnd,CB_SETCURSEL,Result,0L);
                            return no;

                        default :
                            return false;
                    }
                   break;

        case en_list:
                    GetWindowText(hwnd,buf,sizeof(buf));
                    if (*buf == '\0')
                        strcpy(buf, " ");   // CB_FINDSTRINGEXACT can't seem
                        // to cope with empty-strings.
                    Result = SendMessage(hwnd,CB_FINDSTRINGEXACT,Selected+1,(LPARAM)(LPCSTR)buf);
                    if (Result == CB_ERR)
                        Result = SendMessage(hwnd,CB_FINDSTRING,Selected+1,(LPARAM)(LPCSTR)buf);

                    switch (Msg) {
                        case EN_KEYPRESS :
                           if (Result != CB_ERR) {
                                SendMessage(hwnd,CB_SETCURSEL,Result,0L);
                                SetWindowText(hwnd,c->u.l.list[Result].name);
                                SendMessage(hwnd,CB_SETEDITSEL,0,
                                    MAKELPARAM(strlen(buf), strlen(c->u.l.list[Result].name)));
                                SendMessage(hwnd,CB_SETTOPINDEX,Result,0L);
                            }
                            return no;
                        case CBN_CLOSEUP  :
                            SendMessage(hwnd,CB_SETCURSEL,Result,0L);
                            break;
                        case CBN_SELENDOK :
                            break;
                        case CBN_KILLFOCUS :
                        case EN_ENTER :
                            SendMessage(hwnd,CB_SHOWDROPDOWN,0,0L);
                            SendMessage(hwnd,CB_SETCURSEL,Result,0L);
                            break;
                        case CBN_DROPDOWN :
                            PostMessage(GetParent(hwnd),WM_COMMAND,MAKEWPARAM(c->id,CBN_STUPIDBUG),(LPARAM) hwnd);
                            return no;
                        case CBN_STUPIDBUG:
                            SendMessage(hwnd,CB_SETCURSEL,Result,0L);
                            return no;

                        default : return no;
                    }
                    break;
    }
    callback = c->IfChanged;
    return yes;
}


static bool DialogCommand(ScrollWin* sw, dialog_type dlg, int id, int msg)
{   TfcCallback callback;
    wchar_t wbuf[512];
    HWND hList,bWnd;
    control_type c;
    wchar_t* pwbuf;
    int i,j,result;
    char buf[512];
    RECT Rect;
    double fp;
    str s,b;

    if (dlg->hWnd == NULL)
        return no;
    dlg->refcount++;
    for (c=dlg->head; c; c=c->next) {
        if (c->id == id) {
            if (not IsCallbackMessage(c,msg, callback, GetDlgItem(dlg->hWnd,id)))
                continue;
            switch (c->en) {
                case en_string:
                    {
                        int length = strlen(c->u.s.buf)+ 1;
                        b = (char*)malloc(length);
                        strcpy(b, c->u.s.buf);

                        wchar_t* wstr = new wchar_t[c->u.s.sizeofbuf];
                        GetDlgItemTextW(dlg->hWnd, id, wstr, c->u.s.sizeofbuf);
                        if (!WideToUtf8(wstr, c->u.s.buf,  c->u.s.sizeofbuf))
                        {
                            strcpy(c->u.s.buf, "");
                            TfcMessage("String too long!", 'x', "The string you entered is too long!");
                            SetDlgItemTextW(dlg->hWnd, id, L"");
                        }

                        delete [] wstr;
                        if (msg != EN_ENTER and !strcmp(c->u.s.buf, b))
                        {// call calback only if control was changed
                            free(b);
                            break;
                        }
                        if (callback(sw, castcontrol(c)))
                            SetWindowText(GetDlgItem(dlg->hWnd, c->id), c->u.s.buf);
                        free(b);
                        break;
                    }

                case en_int:
                    GetDlgItemText(dlg->hWnd, id, buf, sizeof(buf));
					if (IsUTF8Digit(*buf)) {
						i = j = atoi(buf);
						if (i < c->u.i.minm)
							i = c->u.i.minm;
						else if (i > c->u.i.maxm)
							i = c->u.i.maxm;
					}
					else i = j = NoNum;
                    if (msg != EN_ENTER and *c->u.i.ip == i and i == j) // call calback only if control was changed
                        break;
                    *c->u.i.ip = i;
					if (i == NoNum)
						SetDlgItemText(dlg->hWnd, id,"");
                    else SetDlgItemInt(dlg->hWnd, id,i,yes);
                    dlg->ReturnVal = callback(sw, castcontrol(c));
                    break;

                case en_float:
                    GetDlgItemText(dlg->hWnd, id, buf, sizeof(buf));
                    if ((*buf != '-' and *buf != '.' and not IsUTF8Digit(*buf)) or
                        (*buf == '-' and not IsUTF8Digit(buf[1]))) {
                        *c->u.f.fp = NoNum;
                    }
                    else {
                        fp = atof(buf);
                        if (msg != EN_ENTER and *c->u.f.fp == fp)
                            break;
                        *c->u.f.fp = fp;
                        if (*c->u.f.fp < c->u.f.minm)
                            *c->u.f.fp = c->u.f.minm;
                        else if (*c->u.f.fp > c->u.f.maxm)
                            *c->u.f.fp = c->u.f.maxm;
                    }
                    SetDlgItemText(dlg->hWnd, id, ftoascii(*c->u.f.fp, buf, c));
                    callback(sw, castcontrol(c));
                    break;

                case en_customedit:
                    GetDlgItemText(dlg->hWnd, id, buf, sizeof(buf));
                    c->u.c.StringToData(buf, c->u.c.data);
                    if (msg == 512)
						dlg->ReturnVal = c->IfChanged(sw, castcontrol(c));
                    break;

                case en_togglebutton:
                case en_boolean:
                    CheckDlgButton(dlg->hWnd, id, not IsDlgButtonChecked(dlg->hWnd, id));
                    *c->u.b.bp = IsDlgButtonChecked(dlg->hWnd, id) != 0;
                    dlg->ReturnVal = c->IfChanged(sw, castcontrol(c));
                    break;

                case en_colourbutton:
                case en_textbutton:
                case en_iconbutton:
                case en_bitmapbutton:
                    SetFocus(GetDlgItem(dlg->hWnd,id));  // We need to send
                    // a WM_KILLFOCUS message to the existing control in
                    // order to get e.g. a list box's contents processed
                    // into the application variables.  Without this line,
                    // hitting ENTER after typing a value into a list box
                    // would result in the dialog box closing without taking
                    // this value.
                    dlg->ReturnVal = c->IfChanged(sw, castcontrol(c));
                    break;        // The action might have been to close the
                    // dialog window, so don't assume any d's or c's
                    // exist anymore!

                case en_trackbar:
                    //SetFocus(GetDlgItem(dlg->hWnd,id));
                    c->u.trackbar.iPos = SendMessage(GetDlgItem(dlg->hWnd,id), TBM_GETPOS, 0, 0);
                    dlg->ReturnVal = c->IfChanged(sw, castcontrol(c));
                    break;

                case en_menubutton:
                    bWnd = dlg->IsDialogBar ? (HWND)c->id : GetDlgItem(dlg->hWnd, c->id);
                    GetWindowRect(bWnd, &Rect);
                    PopupMenuChoice = 553;
                    TrackPopupMenu(c->u.menu, TPM_LEFTALIGN | TPM_LEFTBUTTON,
                                Rect.left, Rect.bottom, 0, dlg->hWnd, NULL);
                    if (PopupMenuChoice != 553)
                        PerformMenuFunction(sw, PopupMenuChoice);
                    break;

                case en_combo:
                    GetWindowTextW(GetDlgItem(dlg->hWnd, c->id), wbuf, arraymax(wbuf));
                    WideToUtf8(wbuf, buf, sizeof(buf));
                    if (msg == EN_ENTER or strcmp(buf,c->u.combo.buf) != 0) {// buffer was changed
                        assert(c->u.combo.sizeofbuf > strlen(buf));
                        // If this fails, it's because you've put a long
                        // string into the list for a small combo box.
                        strcpy(c->u.combo.buf,buf);
                        dlg->ReturnVal = c->IfChanged(sw, castcontrol(c));
                    }
                    break;

                case en_list:
                    hList = GetDlgItem(dlg->hWnd, c->id);
                    result = SendMessageW(hList, CB_GETCURSEL, 0, 0);
                    if (result == -1)
                        result = *(int*)c->u.l.ip;
                    else {
                        pwbuf = ToWideStrdup(c->u.l.list[result].name);
                        SetWindowTextW(hList,pwbuf);
                        free(pwbuf);
                        result = (int)c->u.l.list[result].data;
                    }
                    if (c->u.l.sizeofi == 4) {
                        if (msg == EN_ENTER or *(int*)c->u.l.ip != result) {
                            *(int*)c->u.l.ip = result;
                            dlg->ReturnVal = c->IfChanged(sw, castcontrol(c));
                        }
                    }
                    else {
                        if (msg == EN_ENTER or *(char*)c->u.l.ip != result) {
                            *(char*)c->u.l.ip = result;
                            dlg->ReturnVal = c->IfChanged(sw, castcontrol(c));
                        }
                    }
                    SendMessage(hList, CB_SETCURSEL, CBDataToIndex(c->u.l.list,result), 0);
                    break;

                case en_set:
                case en_setsingle:
                    hList = GetDlgItem(dlg->hWnd, c->id);
                    s = c->u.set.flags;
                    result = no;
                    for (i=0; i < c->u.set.A_len; i++) {
                        if (s[i] != (char)SendMessage(hList, LB_GETSEL, (WPARAM)i, 0))
                            s[i] = not s[i], result = yes;
                    }
                    if (result)
                        dlg->ReturnVal = c->IfChanged(sw, castcontrol(c));
                    break;

                case en_enumerated:
                    if (c->u.e.sizeofv == 1)
                        *(char*)c->u.e.vp = c->u.e.value;
                    else *(int*)c->u.e.vp = c->u.e.value;
                    dlg->ReturnVal = c->IfChanged(sw, castcontrol(c));
                    break;
            }
        }
    }
    dlg->refcount--;
    return c != NULL;
}



static void RecurseShowOrHide(control_type c, bool show)
{   dialog_type Dlg;
    HWND hWnd;

    if (c == NULL)
        return;
    switch (c->en) {
        case en_grouping:
            RecurseShowOrHide(c->u.g.a.priv, show);
            RecurseShowOrHide(c->u.g.b.priv, show);
            break;

		case en_grid:
			for (int y=0; y < ListSize(c->u.grid); y++) {
				int numcols = ListSize(c->u.grid[y]);
				for (int x=0; x < numcols; x++) {
					controlprivate_node* cell = c->u.grid[y][x];
					if (cell)
						RecurseShowOrHide(cell, show);
				}
			}
			break;

        case en_enclosure:
            RecurseShowOrHide(c->u.enclosure.sub.priv, show);
            goto SHOW_OR_HIDE;

        case en_swapper:
            control_type sub;
            sub = NULL;
            int i;

            c->u.swapper.visible = show;
            for (each_aeli(sub, c->u.swapper.Subs))
                RecurseShowOrHide(sub, show and i == c->u.swapper.Selected);
            break;

        case en_tabcontrol:
            tabcontrol_type tab;
            tab = NULL;
            for (each_oeli(tab, c->u.tabcontrol.Tabs))
                if (i == c->u.tabcontrol.Selected)
                    RecurseShowOrHide(tab->sub, show);
            goto SHOW_OR_HIDE;

        default:
            SHOW_OR_HIDE:
            Dlg = c->dlgOwner;
            if (Dlg == NULL) hWnd = NULL;
            else hWnd = GetDlgItem(Dlg->hWnd, c->id);
            if (hWnd)
                ShowWindow(hWnd, show ? SW_SHOW : SW_HIDE);
            break;
    }
}


static void RecurseScaleControls(control_type c)
/* Recursively convert pixel units to dialog units. */
/* 'baseX' equals the average width of the dialog   */
/* font, and 'baseY' is the height. */
{
    if (c == NULL)
        return;
    c->cx = c->cx * 4 / baseX;
    c->cy = c->cy * 8 / baseY;

    switch (c->en) {
        case en_grouping:
            RecurseScaleControls(c->u.g.a.priv);
            RecurseScaleControls(c->u.g.b.priv);
            break;

		case en_grid:
			for (int y=0; y < ListSize(c->u.grid); y++) {
				int numcols = ListSize(c->u.grid[y]);
				for (int x=0; x < numcols; x++) {
					controlprivate_node* cell = c->u.grid[y][x];
					if (cell)
						RecurseScaleControls(cell);
				}
			}
			break;

        case en_enclosure:
            RecurseScaleControls(c->u.enclosure.sub.priv);
            break;

        case en_swapper:
            control_type sub;
            sub = NULL;
            int i;

            for (each_aeli(sub, c->u.swapper.Subs))
                RecurseScaleControls(sub);
            break;

        case en_tabcontrol:
            c->u.tabcontrol.height = c->u.tabcontrol.height * 8 / baseY;
            tabcontrol_type tab = NULL;
            for (each_oeli(tab, c->u.tabcontrol.Tabs))
                RecurseScaleControls(tab->sub);
            break;
    }
}


interface void SwapperSelect(control swapper, int Selected)
{   control_type c = NULL;
    int i;

    if (swapper.priv == NULL)
        return;
    if (swapper.priv->en != en_swapper)
        return;
    for (each_aeli(c, swapper.priv->u.swapper.Subs))
        RecurseShowOrHide(c, i == Selected and swapper.priv->u.swapper.visible);
    swapper.priv->u.swapper.Selected = Selected;
}


static dialog_type WndToDlg(HWND hWnd)
{   dialog_type dlg;

    for (dlg=dialog_root; dlg; dlg=dlg->next)
        if (dlg->hWnd == hWnd)
            return dlg;
    for (dlg=dialog_root; dlg; dlg=dlg->next)
        if (dlg->hWnd == NULL)
            return dlg;     // We need this for the WM_INITDIALOG msgs.
    return NULL;
}


static void ModelessIsClosing(HWND hWnd)
{   dialog_type dlg;

    dlg = WndToDlg(hWnd);
    if (dlg == NULL or dlg->hWnd == NULL)
        return;
    if (not dlg->IsModeless)
        return;
    if (dlg->refcount) {
        /* We're in the middle of processing a command for this dialog */
        /* box, it would be premature to delete it now. Mark it as     */
        /* ready to close by giving it a nonzero return value and let  */
        /* DialogProc() clean it up. */
        if (dlg->ReturnVal == 0)
            dlg->ReturnVal = -1;
        return;
    }

    GlobalUnlock(dlg->Template);
    dlg->hWnd = NULL;
    DestroyWindow(hWnd);
    dlg->OnExit(dlg->Owner,NULL);
    DialogFree(dlg);
    GlobalFree(dlg->Template);
    delete dlg;
}


void DrawButtonEdge(bool isSelected, HDC hDC,RECT rect)
{
	DrawEdge(hDC, &rect, !isSelected ? BDR_RAISEDINNER :BDR_SUNKENINNER, BF_RECT);
}



static void DrawControl(controlprivate_node *c, LPDRAWITEMSTRUCT lpdis)
/* This function is useful for ColourControl,  */
/* BitmapButton and IconButton functions.       */
{
    RECT rect;
    wchar_t *wtext;
	HPEN   GrayPen, DarkGrayPen;
	HBRUSH brush;

	switch(c->en)
	{
        case en_tabcontrol:
            brush = CreateSolidBrush(GetSysColor(COLOR_MENU));
            FillRect(lpdis->hDC, &lpdis->rcItem, brush);
            SetBkColor(lpdis->hDC, GetSysColor(COLOR_MENU));
	        wtext = ToWideStrdup(c->u.tabcontrol.Tabs[lpdis->itemID].name);
            rect = lpdis->rcItem;
            rect.top += DlgMarginY - 1;
            rect.bottom += DlgMarginY;
	        DrawTextW(lpdis->hDC, wtext, -1, &rect, DT_CENTER | DT_VCENTER);
	        free(wtext);
            DeleteObject(brush);
            break;

		case en_colourbutton:
			brush       = CreateSolidBrush(*c->u.i.ip);
			SelectObject(lpdis->hDC, brush);
			GrayPen     = CreatePen( PS_SOLID, 1, RGB(198, 198, 198) );
			DarkGrayPen = CreatePen( PS_SOLID, 1, RGB(128, 128, 128) );
			SelectObject(lpdis->hDC, brush);
			SelectObject(lpdis->hDC,
			             (lpdis->itemState & ODS_SELECTED) ?
			             DarkGrayPen : GrayPen);
			Ellipse(lpdis->hDC,
			        lpdis->rcItem.left + 2,
			        lpdis->rcItem.top + 2,
			        lpdis->rcItem.right - 2,
			        lpdis->rcItem.bottom - 2
			);
			SelectObject(lpdis->hDC,
			             (lpdis->itemState & ODS_SELECTED) ?
			             GrayPen : DarkGrayPen);
			Arc(lpdis->hDC,
			    lpdis->rcItem.left + 2,
			    lpdis->rcItem.top + 2,
			    lpdis->rcItem.right - 2,
			    lpdis->rcItem.bottom - 2,
			    lpdis->rcItem.left + 2,
			    2 + (lpdis->rcItem.bottom - lpdis->rcItem.top - 4) * 3 / 4,
			    lpdis->rcItem.right + 2,
			    2 + (lpdis->rcItem.bottom - lpdis->rcItem.top - 4) / 4
			);
			DeleteObject(brush);
			DeleteObject(GrayPen);
			DeleteObject(DarkGrayPen);
			break;

		case en_enclosure:
			// This code will never get called, unless we re-instate the "OWNERDRAW" version
			// of enclosures.
			SelectObject( lpdis->hDC, GetStockObject(BLACK_PEN) );
			MoveToEx(lpdis->hDC, lpdis->rcItem.left + DlgMarginX, lpdis->rcItem.top + 8, NULL);
			LineTo(lpdis->hDC, lpdis->rcItem.right - DlgMarginX, lpdis->rcItem.top + 8);
			LineTo(lpdis->hDC, lpdis->rcItem.right - DlgMarginX, lpdis->rcItem.bottom - DlgMarginY);
			LineTo(lpdis->hDC, lpdis->rcItem.left + DlgMarginX, lpdis->rcItem.bottom - DlgMarginY);
			LineTo(lpdis->hDC, lpdis->rcItem.left + DlgMarginX, lpdis->rcItem.top + 8);
			RECT   Rect;
			Rect       = lpdis->rcItem;
			Rect.left += 5 * DlgMarginX;
			wchar_t *wtext = NULL;

			if(c->name)
				wtext = ToWideStrdup(c->name);

			DrawTextW(lpdis->hDC, wtext, -1, &Rect,
			          DT_LEFT | DT_NOPREFIX | DT_TOP | DT_SINGLELINE);
			free(wtext);
			break;
	}
}


static void InitControl(controlprivate_node* c, dialog_type dlg)
{   wchar_t wbuf[4096], *wbufp;
    tabcontrol_type tab = NULL;
    char buf[512], *flags;
    TfcPair* pair = NULL;
    HWND hControl, hDlg;
    str* item = NULL;
    TC_ITEM tci;
    void* data;
    NMHDR hdr;
    int i;


    // Retrieve handle of the control
    hDlg = dlg->hWnd;
    hControl = GetDlgItem(hDlg, c->id);

    //TfcFont font = TfcFindFont(-8,TFC_TTONLY, "Times New Roman");
    SendMessageW(hControl, WM_SETFONT, (WPARAM) TfcGetSystemFont(), true);

    // Do specific initialization for each type of control
    switch (c->en) {
        case en_statictext:
                    Utf8ToWide(c->name, wbuf, sizeof(wbuf));
                    SetDlgItemTextW(hDlg, c->id, wbuf);
                    break;

        case en_togglebutton:
        case en_boolean:
                    if (*c->u.b.bp)
                        CheckDlgButton(hDlg, c->id, yes);
                    //else leave it unchecked.
                    break;

        case en_combo:
                    SendMessage(hControl, CB_SETEXTENDEDUI, 1, 0);
                    SendMessage(hControl, CB_RESETCONTENT, 0, 0);
                    SendMessage(hControl, CB_LIMITTEXT, c->u.combo.sizeofbuf-1, 0);
                    for (each_oeli(item, c->u.combo.list))
                    {
                        if (*item) {
                            Utf8ToWide(*item, wbuf, sizeof(wbuf));
                            SendMessageW(hControl, CB_ADDSTRING, 0, (LPARAM)(wbuf));
                                // i'm not sure that string above will work with all version of windows
                               //  when *item == NULL .
                        }
                    }
                    Utf8ToWide(c->u.combo.buf, wbuf, sizeof(wbuf));
                    SetWindowTextW(hControl, wbuf);
                    break;

        case en_list:
                    SendMessage(hControl, CB_SETEXTENDEDUI, 1, 0);
                    SendMessage(hControl, CB_RESETCONTENT, 0, 0);
                    for (each_oeli(pair, c->u.l.list)) {
                        Utf8ToWide(pair->name, wbuf, sizeof(wbuf));
                        SendMessageW(hControl, CB_ADDSTRING, 0,
                                    (LPARAM)wbuf);
                    }
                    data = (c->u.l.sizeofi == 4) ?
                            (void*)*(int*)c->u.l.ip : (void*)*(char*)c->u.l.ip;
                    SendMessage(hControl, CB_SETCURSEL,
                            (WPARAM)DataToIndex(c->u.l.list, data), 0);
                    break;

        case en_trackbar:
                    SendMessage(hControl, TBM_SETRANGE,
                        (WPARAM) TRUE,                   // redraw flag
                        (LPARAM) MAKELONG(c->u.trackbar.iMin, c->u.trackbar.iMax));  // min. & max. positions

                    SendMessage(hControl, TBM_SETPAGESIZE,
                        0, (LPARAM) 8);                  // new page size

                    SendMessage(hControl, TBM_SETSEL,
                        (WPARAM) FALSE,                  // redraw flag
                        (LPARAM) MAKELONG(c->u.trackbar.iSelMin, c->u.trackbar.iSelMax));

                    SendMessage(hControl, TBM_SETPOS,
                        (WPARAM) TRUE,                   // redraw flag
                        (LPARAM) c->u.trackbar.iPos);
                    break;

        case en_set:
        case en_setsingle:
                    flags = c->u.set.flags;
                    if (hControl == NULL)
                        return;
                    SendMessage(hControl, LB_RESETCONTENT, 0, 0);
                    for (i=0; i < c->u.set.A_len; i++) {
                        Utf8ToWide(c->u.set.A[i], wbuf, sizeof(wbuf));
                        SendMessageW(hControl, LB_ADDSTRING, 0, (LPARAM)wbuf);
                        SendMessage(hControl, LB_SETSEL, (WPARAM)flags[i], (LPARAM)i);
                    }
                    SendMessage(hControl, LB_SETCURSEL, (WPARAM)0, 0);
                    break;

        case en_enumerated:
                    if ((c->u.e.sizeofv==1 ? *(char*)c->u.e.vp:*(int*)c->u.e.vp)
                             == c->u.e.value)
                        CheckDlgButton(hDlg, c->id, yes);
                    else
                        CheckDlgButton(hDlg, c->id, no); // need to be called.
                                                         // Otherwise, callback is not correctly called
                    break;

        case en_bitmapbutton:
			SendDlgItemMessage(hDlg, c->id, BM_SETIMAGE,
                    (WPARAM)IMAGE_BITMAP, (LPARAM)c->u.bitmap.normal);
			break;

		case en_staticbitmap:
			SendDlgItemMessage(hDlg, c->id, STM_SETIMAGE,
                    (WPARAM)IMAGE_BITMAP, (LPARAM)c->u.bitmap.normal);
			break;

        case en_iconbutton:
			SendDlgItemMessage(hDlg, c->id, BM_SETIMAGE,
                    (WPARAM)IMAGE_ICON, (LPARAM)c->u.bitmap.normal);
			break;

		case en_staticicon:
			SendDlgItemMessage(hDlg, c->id, STM_SETIMAGE,
                    (WPARAM)IMAGE_ICON, (LPARAM)c->u.bitmap.normal);
			break;

        case en_swapper:
                    SwapperSelect(castcontrol(c), c->u.swapper.Selected);
                    break;

        case en_tabcontrol:
                    // Hide all controls for first time
                    for (each_oeli(tab, c->u.tabcontrol.Tabs))
                        RecurseShowOrHide(tab->sub, 0);

                    //Set tabs & names
                    tci.mask = TCIF_TEXT;
                    tci.iImage = -1;
                    for (each_oeli(tab, c->u.tabcontrol.Tabs)) {
                        tci.pszText = tab->name;
                        TabCtrl_InsertItem(hControl, i, &tci);
                    }
                    TabCtrl_SetCurSel(hControl, c->u.tabcontrol.Selected);

                    hdr.hwndFrom = hControl;
                    hdr.idFrom = c->id;
                    hdr.code = TCN_SELCHANGE;
                    SendMessage(hDlg, WM_NOTIFY, c->id, (LPARAM)&hdr);
                    break;

        case en_string:
                    wbufp = ToWideStrdup(c->u.s.buf);
                    SetDlgItemTextW(dlg->hWnd,c->id, wbufp);
                    
                    // (awa) This nicely stops us from ever going over our buffer size. One of those simple things
                    // we should have done a long time ago.
                    SendMessage(hControl, EM_LIMITTEXT, c->u.s.sizeofbuf - 1, (LPARAM)0x0000);

                    free(wbufp);
                    break;

        case en_int:
                    if (*c->u.i.ip == NoNum)
						SetDlgItemText(hDlg,c->id,"");
					else SetDlgItemInt(hDlg,c->id,*c->u.i.ip ,true);
                    break;

        case en_float:
                    SetDlgItemText(hDlg, c->id, ftoascii(*c->u.f.fp, buf, c));
                    break;

        case en_customedit:
                    c->u.c.DataToString(c->u.c.data, buf);
                    SetDlgItemText(hDlg, c->id, buf);
                    break;

        case en_scrollwin:
                    c->u.sw->AttachToWindow(hControl);
                    break;
    }
}

static void SetWindowLongData(HWND hControl, controlprivate_node *c, char* className);

static LRESULT CALLBACK DialogBoxProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{   HWND hTabControl;
    dialog_type dlg;
    control_type c;
    int returnval;

    switch (uMsg) {


        case WM_INITDIALOG:
                dlg = WndToDlg(hWnd);
                dlg->hWnd = hWnd;
                SetWindowText(hWnd, dlg->title);

                // Drag'n drop support
                dlg->drop = TfcDropStart(hWnd, NULL);

                /* For some reason, */
                /* the CreateDialogIndirect() fails if the DLGTEMPLATE has      */
                /* certain titles in it, e.g. "Replace" or "Find (or Replace)"*/
                /* and so I just set the title after creation. */
                //SendMessage(hwndEdit, EM_SETSEL, 0, 0);
                for (c=dlg->head; c; c=c->next)
                    c->dlgOwner = dlg;      // Must set these all up before
                    // calling InitControl() in case a callback refers to
                    // other controls.
                for (c=dlg->head; c; c=c->next) {
                    InitControl(c, dlg);
                    if (c->en == en_list)
                       SetWindowLongData(GetDlgItem(hWnd,c->id),c,"COMBOBOX");
                }


                if (dlg->defaultcontrol)
                    PostMessage(hWnd, WM_NEXTDLGCTL,
                            (WPARAM)GetDlgItem(hWnd, dlg->defaultcontrol->id), (LPARAM)yes);
                return true;

        case WM_DRAWITEM:
                dlg = WndToDlg(hWnd);
                if (!dlg)
                    return true;
                for (c=dlg->head; c; c=c->next) {
                    if ((WPARAM)c->id == wParam)
                        goto FOUND;
                }
                return false;
                FOUND:
                DrawControl(c,(LPDRAWITEMSTRUCT) lParam);
                return TRUE;

        case WM_COMMAND:
                if (lParam == 0 and wParam == IDCANCEL) {
                    ModelessIsClosing(hWnd);
                    EndDialog(hWnd, -1);
                }
                else  if (lParam == 0 and wParam == IDOK) { // Enter Was pressed
                    dlg = WndToDlg(hWnd);
                    if (dlg == NULL)
                        return true;

                    // Try to execute DialogCommand
                    bool rez = DialogCommand(dlg->Owner, dlg, LOWORD(wParam), HIWORD(wParam));
                    if (dlg->ReturnVal) {
                        returnval = dlg->ReturnVal;
                        ModelessIsClosing(hWnd);
                        EndDialog(hWnd, returnval);
                    }
                    // if DialogCommand didn't perform any action - try to force callback of the current
                    // control by setting focus
                    if (!rez) {
                        HWND hwnd = SetFocus(NULL);
                        SetFocus(hwnd);
                    }
                }
                else if (HIWORD(wParam) == 0 and PopupMenuChoice == 553) {
                    PopupMenuChoice = LOWORD(wParam);
                    /* This is for the 'popup menu' dialog-box control. */
                }
                else {
                    dlg = WndToDlg(hWnd);
                    if (dlg == NULL)
                        return true;
                    if (HIWORD(wParam) != 0x0400 and HIWORD(wParam) != 0x0300)
                        DialogCommand(dlg->Owner, dlg, LOWORD(wParam), HIWORD(wParam));
                    if (CHANGE_MESSAGES and HIWORD(wParam) == 0x0300)
                        DialogCommand(dlg->Owner, dlg, LOWORD(wParam), HIWORD(wParam));
                    if (dlg->ReturnVal) {
                        returnval = dlg->ReturnVal;
                        ModelessIsClosing(hWnd);
                        EndDialog(hWnd, returnval);
                    }
                }
                return true;

        case WM_NOTIFY:
                if (((LPNMHDR)lParam)->code != TCN_SELCHANGE)
                    return false;

                dlg = WndToDlg(hWnd);
                for (c=dlg->head; c; c=c->next) {
                    if ((WPARAM)c->id == wParam)
                        goto FOUND_TAB;
                }
                return false;

                FOUND_TAB:
                hTabControl = ((LPNMHDR) lParam)->hwndFrom;
                /* Hiding old page */
                RecurseShowOrHide(c->u.tabcontrol.Tabs[c->u.tabcontrol.Selected].sub, no);
                /* Retrieve new page */
                c->u.tabcontrol.Selected = TabCtrl_GetCurSel(hTabControl);
                /* Show new page */
                RecurseShowOrHide(c->u.tabcontrol.Tabs[c->u.tabcontrol.Selected].sub, yes);
                return true;

        case WM_ACTIVATE:
                if (0 == wParam)
                    hDlgLaco = NULL;            // Laco: becoming inactive
                else hDlgLaco = hWnd;            // Laco: becoming active
                return false;

        case WM_CLOSE:
                dlg = WndToDlg(hWnd);
                TfcDropStop(dlg->drop);                    // Drag'n drop support
                if (dlg and dlg->IsModeless)
                    ModelessIsClosing(hWnd);
                else EndDialog(hWnd, -1);
                return true;

        default:return false;
    }
}



static dialog_type CreateDialogTemplate(kstr title, control rootcontrol,
            ScrollWin *sw, control default_control,int flags,
            // parameters for print_dlg:
            int x_offset= 0, int y_offset= 0,
            void** controlTempl = NULL, int templSize = 0)
{   void *lastenum=NULL;
    int dwExtendedStyle;
    control_type c;
    char buf[512];
    HGLOBAL hgbl;
    int n, size;
    RECT Rect;
    char* s;
    union {
        wchar_t *s;
        int *ip;
        DLGITEMTEMPLATE *t;
        void* p;
    } u;


    /*** Initialise 'dlg': ***/
    dialog_type dlg = new dialog_node;
    dwExtendedStyle = (*title == '*') ? WS_EX_TOPMOST : 0;
    if (*title == '*')
        title++;
    dlg->title = (str)title;
    dlg->id = 900;
    dlg->head = NULL;
    dlg->tail = NULL;
    dlg->ReturnVal = 0;
    dlg->OnExit = 0;
    dlg->IsModeless = no;
    dlg->tree_root = rootcontrol.priv;
    dlg->IsDialogBar = no;
    dlg->hWnd = NULL;
    dlg->refcount = 0;
    dlg->Owner = sw;
    dlg->next = dialog_root;
    dialog_root = dlg;


    /*** Convert all sizes into dialog units for the dialog font: ***/
    dlg->baseX = baseX;
    dlg->baseY = baseY;
    RecurseScaleControls(rootcontrol.priv);
    DlgMarginDX = DlgMarginX * 4 / baseX;
    DlgMarginDY = DlgMarginY * 8 / baseY;


    /*** Apply some pattern matching to get some controls to line up: ***/
    RecursePatternMatchAlign(rootcontrol.priv);


    /*** Allocate x,y values for the controls and put them into 'dlg': ***/
    Rect.top = 8 + y_offset;
    Rect.left = 8 + x_offset;
    Rect.right = Rect.left + rootcontrol.priv->cx;
    Rect.bottom = Rect.top + rootcontrol.priv->cy;
    DlgBeingBuilt = dlg;
    RecursePlaceControls(rootcontrol.priv, &Rect);
    RecurseLinearise(dlg, rootcontrol.priv);
    if (default_control.priv and default_control.priv->en == en_grouping)
        default_control = default_control.priv->u.g.b;
    dlg->defaultcontrol = default_control.priv;


    /* How much memory do we need for the dialog template? */
    n = 0;
    size = sizeof(DLGTEMPLATE);
    for (c=dlg->head; c; c=c->next) {
        if (c->en == en_swapper)
            continue;
        n++;
        size += sizeof(DLGITEMTEMPLATE) + 4*2;
        if (c->en == en_string)
            size += 2 * c->u.s.sizeofbuf;//2*strlen(c->u.s.buf); Sometimes buffer strlen's are 0 causing this to not be nearly enough
        else if (c->en == en_int)
            size += 2*12;            // Maximum size of an int
        else if (c->en == en_float)
            size += 2*19;            // Maximum size of a double
        else if (c->en == en_customedit) {
            c->u.c.DataToString(c->u.c.data, buf);
            size += 2*strlen(buf);
        }
        else if (c->name)
            size += 2*strlen(c->name);
        else size += 2;
    }
    size += 1024;
    size += templSize;

    /* Allocate and fill the dialog template: */
    hgbl = GlobalAlloc(GMEM_ZEROINIT, size);
    dlg->Template = (LPDLGTEMPLATE)GlobalLock(hgbl);
	dlg->Template->style = WS_POPUP | WS_SYSMENU | WS_CAPTION | WS_BORDER
		                       | DS_MODALFRAME | DS_SETFONT;

    if (flags & TFC_DLG_MINIMISE)
        dlg->Template->style |= WS_MINIMIZEBOX;
    dlg->Template->dwExtendedStyle = dwExtendedStyle;
    dlg->Template->cdit = n;
    dlg->Template->x = 50;
    dlg->Template->y = 50;
    dlg->Template->cx = dlg->tree_root->cx + 2*8;
    dlg->Template->cy = dlg->tree_root->cy + 2*8;
    u.p = dlg->Template + 1;
    *u.s++ = 0;
    *u.s++ = 0;
    for (s="DIALOG"/*Dlg->title*/; *s; )        // Convert the title to unicode.
        *u.s++ = *s++;
    *u.s++ = 0;
    *u.s++ = 8;
    for (s="MS Sans Serif"; *s; )        // Convert the font typeface to unicode.
    //for (s="Arial"; *s; )        // Convert the font typeface to unicode.
        *u.s++ = *s++;
    *u.s++ = 0;
    *u.s++ = 0;

    for (int phase=0; phase < 2; phase++) {
      for (c=dlg->head; c; c=c->next) {
        if ((phase == 1) != (c->en == en_statictext or c->en == en_staticbitmap or c->en == en_staticicon))
            continue;
        DLGITEMTEMPLATE *t = u.t++;
        t->style = WS_CHILD | WS_VISIBLE;
        if (c->disabled)
            t->style |= WS_DISABLED;
        t->x = c->x;
        t->y = c->y;
        t->cx = c->cx;
        t->cy = c->cy;
        t->id = c->id;
        *u.s++ = 0xffff;        // class
        switch (c->en) {
            case en_string:
                t->style |= ES_LEFT | WS_TABSTOP | WS_BORDER;
                if (c->u.s.flags & TFC_PASSWORD)
                    t->style |= ES_PASSWORD;
                if (c->u.s.flags & TFC_MULTILINE)
                    t->style |= ES_MULTILINE | ES_WANTRETURN | WS_VSCROLL;
                else
                    t->style |= ES_AUTOHSCROLL;
                if (c->u.s.flags & TFC_NOEDIT)
                    t->style |= ES_READONLY;
                *u.s++ = 0x0081;
                Utf8ToWide(c->u.s.buf, u.s, 512);
                u.s += wcslen(u.s);
                /*for (s=c->u.s.buf; *s; )
                    *u.s++ = *s++;*/
                *u.s++ = 0;
                *u.s++ = 0;                // Creation data
                break;

            case en_int:
                t->style |= ES_AUTOHSCROLL | WS_TABSTOP | WS_BORDER;
                if (c->u.i.minm >= 0)
                    t->style |= ES_NUMBER;
                *u.s++ = 0x0081;
				if (*c->u.i.ip == NoNum)
					*buf = '\0';
                else itoa(*c->u.i.ip, buf, 10);
                for (s=buf; *s; )
                    *u.s++ = *s++;
                *u.s++ = 0;
                *u.s++ = 0;                // Creation data
                break;

            case en_float:
                t->style |= ES_AUTOHSCROLL | WS_TABSTOP | WS_BORDER;
                *u.s++ = 0x0081;
                ftoascii(*c->u.f.fp, buf, c);
                for (s=buf; *s; )
                    *u.s++ = *s++;
                *u.s++ = 0;
                *u.s++ = 0;                // Creation data
                break;

            case en_customedit:
                t->style |= ES_AUTOHSCROLL | WS_TABSTOP | WS_BORDER;
                *u.s++ = 0x0081;
                c->u.c.DataToString(c->u.c.data, buf);
                for (s=buf; *s; )
                    *u.s++ = *s++;
                *u.s++ = 0;
                *u.s++ = 0;                // Creation data
                break;

			case en_togglebutton:
				t->style |= BS_CHECKBOX | BS_PUSHLIKE | WS_TABSTOP;
				if( c == default_control.priv or (c->u.s.flags & TFC_DEFPUSHBUTTON) )
					t->style |= BS_DEFPUSHBUTTON;
				*u.s++ = 0x0080;
				goto ENCODE_NAME;

            case en_textbutton:
            case en_menubutton:
                t->style |= BS_PUSHBUTTON | WS_TABSTOP;
                if (c == default_control.priv or (c->u.s.flags&TFC_DEFPUSHBUTTON))
                    t->style |= BS_DEFPUSHBUTTON;
                *u.s++ = 0x0080;
                goto ENCODE_NAME;

            case en_boolean:
                t->style |= BS_CHECKBOX | WS_TABSTOP;
                *u.s++ = 0x0080;
                goto ENCODE_NAME;

            case en_combo:
            case en_list:
                t->cy = 67;
                t->style |= CBS_DROPDOWN | CBS_HASSTRINGS | CBS_AUTOHSCROLL
                            | WS_VSCROLL | WS_TABSTOP | WS_BORDER;
                *u.s++ = 0x0085;
                *u.s++ = 0;
                *u.s++ = 0;
                break;//goto ENCODE_NAME;

            case en_set:
                t->style |= LBS_HASSTRINGS | LBS_MULTIPLESEL | LBS_NOTIFY
                            | WS_VSCROLL | WS_TABSTOP | WS_BORDER;
                *u.s++ = 0x0083;
                goto ENCODE_NAME;

            case en_setsingle:
                t->style |= LBS_HASSTRINGS | LBS_NOTIFY
                        | WS_VSCROLL | WS_TABSTOP | WS_BORDER;
                *u.s++ = 0x0083;
                goto ENCODE_NAME;

            case en_enumerated:
                t->style |= BS_AUTORADIOBUTTON | WS_TABSTOP;
                if (c->u.e.vp != lastenum)
                    lastenum = c->u.e.vp, t->style |= WS_GROUP;
                *u.s++ = 0x0080;
                goto ENCODE_NAME;

            case en_staticbitmap:
                t->style |= SS_BITMAP;//OWNERDRAW,
                *u.s++ = 0x0082;
                *u.s++ = 0;
                *u.s++ = 0;                // Creation data
                break;

            case en_staticicon:
                t->style |= SS_ICON;//OWNERDRAW,
                *u.s++ = 0x0082;
                *u.s++ = 0;
                *u.s++ = 0;                // Creation data
                break;

            case en_colourbutton:
                t->style |= WS_TABSTOP | BS_OWNERDRAW, *u.s++ = 0x0080;
                *u.s++ = 0;
                *u.s++ = 0;                // Creation data
                break;

			case en_bitmapbutton:
				t->style |=  WS_TABSTOP | BS_BITMAP | BS_CENTER | BS_VCENTER  | BS_FLAT;
				if(c == default_control.priv)
					t->style |= BS_DEFPUSHBUTTON;
                *u.s++ = 0x0080;
				*u.s++ = 0;
				*u.s++ = 0;                // Creation data
				break;

			case en_iconbutton:
				t->style |= BS_ICON | WS_TABSTOP;
                *u.s++ = 0x0080;
				*u.s++    = 0;
				*u.s++    = 0;             // Creation data
				break;

            case en_scrollwin:
                t->style |= WS_TABSTOP;// | WS_VSCROLL | WS_HSCROLL | WS_BORDER | WS_THICKFRAME;
                u.s--;
                for (s="TfcSwin"; *s; s++)
                    *u.s++ = *s;
                *u.s++ = 0;
                *u.s++ = 'H';
                *u.s++ = 0;
                *u.s++ = 0;                // Creation data
                break;

            case en_tabcontrol:
				t->style |= WS_CLIPSIBLINGS | TCS_OWNERDRAWFIXED;
				// To use the default tab panel background colour:   t->style |= WS_CLIPSIBLINGS;
                u.s--;
                for (s="SysTabControl32"; *s; s++)
                    *u.s++ = *s;
                *u.s++ = 0;
                *u.s++ = 'H';
                *u.s++ = 0;
                *u.s++ = 0;                // Creation data
                break;

            case en_statictext:
                t->style |= SS_LEFT;
                *u.s++ = 0x0082;
                goto ENCODE_NAME;

                ENCODE_NAME:
                Utf8ToWide(c->name, u.s, 512);
                u.s += wcslen(u.s);
                *u.s++ = 0;
                *u.s++ = 0;
                break;

			case en_enclosure:
				t->dwExtendedStyle = WS_EX_TRANSPARENT;
#ifdef STANDARD_ENCLOSURES
				t->style          |= BS_GROUPBOX;
				*u.s++             = 0x0080;
#else
				t->style          |= SS_OWNERDRAW;
				*u.s++             = 0x0082;
#endif
				goto ENCODE_NAME;

            case en_swapper:
                u.t = t;
                continue;

            case en_filler:
                u.t = t;
                continue;
        }
        if ((int)u.s & 2)
            *u.s++ = 0;
      }
    }
    if (controlTempl)
        *controlTempl = u.s;

    return dlg;
}


/* Dialog functions */
int ScrollWin::DoDialog(kstr title, control rootcontrol,
            control default_control, int flags)
{
    return ::DoDialog(title,rootcontrol,default_control,this,flags);
}


void* ScrollWin::CreateModelessDialog(kstr title, control rootcontrol,
            control default_control, TfcCallback OnExit, int flags)
{
    return ::CreateModelessDialog(title, rootcontrol,
                    default_control,OnExit,this,flags);
}


interface int DoChildDialog(kstr title, control rootcontrol, control
            default_control)
{
    return DoDialog(title, rootcontrol, default_control, NULL, TFC_DLG_CHILD);
}



interface int DoDialog(kstr title, control rootcontrol, control default_control,
            ScrollWin* Owner, int flags)
/* For modal dialogs, it returns: 1=OK, 0=CANCEL or a value from some button. */
/* For modeless dialogs, it returns the handle to the created window.         */
/* Owners windows:                                                            */
/* Note: it's generally a good idea for all dialog boxes to have an owner     */
/* unless they are the app's only window.  Otherwise you can have them hidden */
/* behind other windows for the app, to the confusion of the user.  You can   */
/* either pass it 'Owner' (recommended) or request it to FindOwner.  If the   */
/* latter does not reliably identify the right window then you'll need to     */
/* use the first method (e.g. someone was having trouble with Admin). */
{   int result, lastError;
    HWND hOwner = NULL;
    dialog_type dlg;

    DlgMarginX = 6;                // The space between controls
    DlgMarginY = 6;

	if (Owner)
		hOwner = (HWND)Owner->_hWnd();
	else if (flags & TFC_DLG_CHILD)
		hOwner = (HWND)TfcTopLevelHwnd(no);
	else hOwner = NULL;

	dlg = CreateDialogTemplate(TfcDisplayStringConverter(title), 
						rootcontrol, Owner, default_control, flags);

    if (flags & TFC_DLG_MODELESS) {
        /* Create a modeless dialog box and return the window handle: */
        HWND hWnd = CreateDialogIndirectW(
            hInstance,
            dlg->Template,
            hOwner,
            (DLGPROC)(wincallback_fn)DialogBoxProc);
        ShowWindow(hWnd, SW_SHOW);
        result = (int)hWnd;
        dlg->IsModeless = yes;
    }
    else {
        /* Create a modal dialog box and return the return value: */
        SetLastError(0);
        result = DialogBoxIndirectW(
                hInstance,
                dlg->Template,
                hOwner,
                (DLGPROC)(wincallback_fn)DialogBoxProc);

        /* check for any errors with dialog box */
		if (result == 0 and hOwner != NULL) {
			/* If the function fails because the hWndParent parameter is invalid, the return value 
			is zero. The function returns zero in this case for compatibility with previous versions 
			of Windows. If the function fails for any other reason, the return value is 1. To get 
			extended error information, call GetLastError.*/
			lastError = GetLastError();
			if (lastError == ERROR_INVALID_HANDLE)
				result = -1;
		}

        GlobalUnlock(dlg->Template);
        GlobalFree(dlg->Template);
        DialogFree(dlg);
    }

    /* Returning: */
    return result;
}


interface void TfcEndDialog(int returnval)
/* controls in modal dialog boxes may want to call this. */
{   dialog_type dlg=dialog_root;

    if (dlg == NULL) {
        assert(false);
        return;
    }
    EndDialog(dlg->hWnd, returnval);
}


interface void* CreateModelessDialog(kstr title, control rootcontrol,
            control default_control, TfcCallback OnExit,
            ScrollWin* Owner, int flags)
{   void* r;

    r = (void*)DoDialog(title, rootcontrol, default_control, Owner, flags|TFC_DLG_MODELESS);
    dialog_root->OnExit = OnExit;
    return r;
}


interface void KillModelessDialog(void* hWnd)
{
    ModelessIsClosing((HWND)hWnd);
}


interface void FocusModelessDialog(void* hWnd)
{
    SetForegroundWindow((HWND)hWnd);
}


interface void HideModelessDialog(void *hWnd)
{
    ShowWindow((HWND)hWnd, SW_HIDE);
}


interface void ShowModelessDialog(void *hWnd)
{
    ShowWindow((HWND)hWnd, SW_SHOW);
}



static void GetControlStyle(control_type c, int *stylep, char* *cclassp)
{
    *stylep = WS_CHILD | WS_VISIBLE | WS_TABSTOP;
    if (c->disabled)
        *stylep |= WS_DISABLED;

    switch (c->en) {
        case en_string:
        case en_customedit:
            *stylep |= ES_AUTOHSCROLL | ES_LEFT | WS_BORDER | WS_TABSTOP;
            *cclassp = "EDIT";
            break;

        case en_trackbar:
            *stylep |= WS_CHILD | WS_VISIBLE | TBS_ENABLESELRANGE | TBS_NOTICKS;
            *cclassp = TRACKBAR_CLASS;
            break;

        case en_int:
            *stylep |= ES_AUTOHSCROLL | WS_BORDER;
            if (c->u.i.minm >= 0)
                *stylep |= ES_NUMBER;
            *cclassp = "EDIT";
            break;

        case en_float:
            *stylep |= ES_AUTOHSCROLL | WS_BORDER;
            *cclassp = "EDIT";
            break;

        case en_textbutton:
        case en_menubutton:
            *stylep |= BS_PUSHBUTTON;
            *cclassp = "BUTTON";
            break;

		case en_togglebutton:
			*stylep |= BS_CHECKBOX | BS_PUSHLIKE;
			*cclassp = "BUTTON";
			break;

        case en_boolean:
            *stylep |= BS_CHECKBOX;
            *cclassp = "BUTTON";
            break;

        case en_combo:
        case en_list:
            *stylep |= CBS_DROPDOWN | CBS_HASSTRINGS | CBS_AUTOHSCROLL
                            | WS_VSCROLL | WS_BORDER;
            *cclassp = "COMBOBOX";
            break;

        case en_set:
            *stylep = LBS_HASSTRINGS | LBS_MULTIPLESEL | LBS_NOTIFY
                            | WS_VSCROLL | WS_TABSTOP | WS_BORDER;
            *cclassp = "LISTBOX";
            break;

        case en_setsingle:
            *stylep = LBS_HASSTRINGS  | LBS_NOTIFY
                            | WS_VSCROLL | WS_TABSTOP | WS_BORDER;
            *cclassp = "LISTBOX";
            break;

        case en_enumerated:
            *stylep |= BS_AUTORADIOBUTTON;
            *cclassp = "BUTTON";
            break;

        case en_staticbitmap:
            *cclassp = "STATIC";
            *stylep |= SS_BITMAP;
            break;

        case en_staticicon:
            *cclassp = "STATIC";
            *stylep |= SS_ICON;
            break;

        case en_colourbutton:
            *stylep |= BS_PUSHBUTTON | BS_OWNERDRAW;
            *cclassp = "BUTTON";
            break;

		case en_bitmapbutton:
			*stylep |= BS_PUSHBUTTON | BS_BITMAP;
			*cclassp = "BUTTON";
			break;

		case en_scrollwin:
			*stylep |= 0;
			*cclassp = "TfcSwin";
			break;

		case en_iconbutton:
			*stylep |= BS_PUSHBUTTON | BS_ICON;
			*cclassp = "BUTTON";
			break;

        case en_statictext:
            *stylep |= SS_LEFT;
            *cclassp = "STATIC";
            c->aligny = align_bottom;
            break;
    }
}


static long _stdcall DialogBarProc(void* _hWnd, uint uMsg, uint wParam, long lParam)
{   HWND hWnd=(HWND)_hWnd;
    LPMINMAXINFO lpmmi;
    dialog_type dlg;
    ScrollWin * sw;
    control_type c;
    char buf[512];
    str s;

    switch (uMsg) {
        case WM_GETMINMAXINFO:
                    lpmmi = (LPMINMAXINFO)lParam;
                    lpmmi->ptMaxSize.x = 100;
                    return 0;
          
        case WM_CHAR:
                    sw = ScrollWin::SwFromWnd(RebarParent(hWnd));
                    if (sw == NULL)
                        break;
                    hWnd = GetFocus();
                    c = CtlFromId(sw, (int)GetMenu(hWnd));
                    if (c == NULL)
                        break;
                    if (c->en == en_textbutton or c->en == en_iconbutton
                            or c->en == en_bitmapbutton
                            or c->en == en_menubutton)
                        response = wParam;
                    break;

        case WM_USER+1:
                    // This msg means that the dialog need to be destroyed
                    DestroyWindow(hWnd);
                    dlg = (dialog_type) lParam;
                    DialogFree(dlg);
                    delete dlg;
                    break;


        case WM_COMMAND:
                    sw = ScrollWin::SwFromWnd(RebarParent(hWnd));
                    if (sw == NULL)
                        break;
                    if (lParam) {
                        // if this message is from a control
                        dlg = sw->RebarFromWnd(hWnd);
                        if (dlg == NULL)
                            return TRUE;
                        DialogCommand(sw, dlg, lParam,HIWORD(wParam));
						if (sw and dlg->ReturnVal and not WaitingForAnyKeystroke) {
							if (WaitingForKeystroke)
								response = dlg->ReturnVal;
							else sw->Keystroke(dlg->ReturnVal);
							dlg->ReturnVal = 0;
						}
                    }
                    /*else
                        PerformMenuFunction(sw, (short)LOWORD(wParam));
                        tco> Dialog bars don't create menu command messages,
                        and this was causing bugs for me when I ran the
                        Print dialog box for the 2nd time that process.
                    */
                    break;

            case WM_SETFOCUS:
                    sw = ScrollWin::SwFromWnd(RebarParent(hWnd));
                    if (sw == NULL)
                        return 0;
                    dlg = sw->RebarFromWnd(hWnd);
                    if (dlg == NULL)
                        return 0;
                    SetFocus(GetDlgItem(hWnd,dlg->head->id));
                    return 0;

            case WM_HSCROLL:
                    sw = ScrollWin::SwFromWnd(RebarParent(hWnd));
                    if (sw == NULL)
                        break;
                    if (lParam) {
                        // if this message is from a control
                        dlg = sw->RebarFromWnd(hWnd);
                        if (dlg == NULL)
                            return TRUE;
                        DialogCommand(sw, dlg, lParam,HIWORD(wParam));
                    }

            case WM_NOTIFY_SYSCHAR:
                    sw = ScrollWin::SwFromWnd(RebarParent(hWnd));
                    dlg = sw->RebarFromWnd(hWnd);
                    if (!dlg)
                        return 0;
                    for (c=dlg->head; c; c=c->next) {
                        GetWindowText((HWND)c->id, buf, sizeof(buf));
                        s = strchr(buf, '&');
                        if (s) {
                            if (tolower(s[1]) == wParam)
                                DialogCommand(sw, sw->dialogbar, c->id,HIWORD(wParam));
                        }
                    }
                    return 0;

            case WM_SYSCHAR:
                    sw = ScrollWin::SwFromWnd(RebarParent(hWnd));
                    dlg = sw->RebarFromWnd(hWnd);
                    for (c=dlg->head; c; c=c->next) {
                        char buf[512];
                        GetWindowText((HWND)c->id, buf, sizeof(buf));
                        s = strchr(buf, '&');
                        if (s) {
                            if (tolower(s[1]) == wParam)
                                DialogCommand(sw, sw->dialogbar, c->id,HIWORD(wParam));
                        }
                    }
                    return DefWindowProc(hWnd, uMsg, wParam, lParam);

            case WM_DRAWITEM:
                    sw = ScrollWin::SwFromWnd(RebarParent(hWnd));
                    if (sw == NULL)
                        return 0;
                    for (c=sw->RebarFromWnd(hWnd)->head; c; c=c->next)
                        if (wParam == c->id)
                            break;
                    if (c == NULL)
                        return 0;
                    DrawControl(c,(DRAWITEMSTRUCT*)lParam);
                    return yes;

            default:return DefWindowProc(hWnd, uMsg, wParam, lParam);
    }
    return 1;
}


static void SendMessageToDialog(dialog_type dlg, MSG *msg)
{
    for (; dlg; dlg=dlg->next)
        SendMessage(dlg->hWnd, msg->message, msg->wParam, msg->lParam);
}


static char* DialogBarClass(void)
{   WNDCLASS wndClass;

    memset(&wndClass, 0, sizeof(wndClass));
    wndClass.style = CS_HREDRAW | CS_VREDRAW;
    wndClass.lpfnWndProc = (WNDPROC)DialogBarProc;
    wndClass.hInstance = hInstance;
    wndClass.hCursor = LoadCursor(NULL, IDC_ARROW);
    wndClass.hIcon = NULL;
    wndClass.hbrBackground = GetSysColorBrush(COLOR_BTNFACE);
    wndClass.lpszClassName = "DialogBar";
    RegisterClass(&wndClass);
    return (char*)wndClass.lpszClassName;
}


static void ReduceButtonSize(controlprivate_node* c)
{   RECT Rect={0,0,999,999};
    controlprivate_node* cc;
    int dx;

    DrawText(ScreenDC(), c->name, -1, &Rect, DT_CALCRECT);
    dx = c->cx - Rect.right -  10;
    c->cx = Rect.right +  10;
    c->cy = Rect.bottom + 6;

    for (cc = c->next; cc; cc=cc->next)
        if (cc->x > c->x and cc->y < c->y  + c->cy )
            cc->x -= dx;
}





void ScrollWin::SetDialogBar(class control &root, bool setup)
{   struct controlprivate_node *c;
    dialog_type dlg, d;
    int style, id;
    char* cclass;
    RECT Rect;
    HWND cWnd;


    if (setup) {
        /*** Set up a new dialog bar: ***/
        dlg =  new dialog_node;
        dlg->title = NULL;
        dlg->id = 1000;
        dlg->head = NULL;
        dlg->tail = NULL;
        dlg->next = NULL;
        dlg->ReturnVal = 0;
        dlg->refcount = 0;
        dlg->baseX = 4;
        dlg->baseY = 8;
        DlgMarginX = 4;                // The space between controls
        DlgMarginY = 4;
        dlg->IsDialogBar = yes;
        dlg->tree_root = root.priv;
        dlg->Owner = this;

        if (dialogbar == NULL)
            dialogbar = dlg;
        else {
            for (d=dialogbar; d->next; d=d->next)
                ;
            d->next = dlg;
        }

        /*** Place the controls: ***/
        Rect.left = 3;
        Rect.right = root.priv->cx;
        Rect.top = 3;
        Rect.bottom = 2 + root.priv->cy;
        DlgMarginDX = DlgMarginX;
        DlgMarginDY = DlgMarginY;
        DlgBeingBuilt = dlg;
        RecursePlaceControls(dlg->tree_root, &Rect);
        RecurseLinearise(dlg, dlg->tree_root);
        DialogHeight = (unsigned char)(Rect.bottom) - 2;
        dlg->Width = Rect.right;
        dlg->Height = DialogHeight;
    }
    else {
        dlg = DlgBeingBuilt;
        DialogHeight = dlg->Height;
        dlg->Width = 0; // reset to make sure MoveRebar will re-arrange controls
    }

    if (!hWnd)
        return;

    /*** Create the dialog bar window: ***/
    dlg->hWnd = CreateWindowEx(
                    WS_EX_TOOLWINDOW | WS_EX_CONTROLPARENT,
                    DialogBarClass(),
                    "DialogBar",
                    WS_CHILD | WS_VISIBLE,
                    0, 0,
                    9999, DialogHeight,
                    (HWND)hRebar,
                    NULL,
                    hInstance,
                    NULL
    );
    ShowWindow(dlg->hWnd, SW_SHOW);

    /*** Create the control windows: ***/
    id = 0;
    for (c=dlg->head; c; c=c->next) {
        GetControlStyle(c, &style, &cclass);
        c->dlgOwner = dlg;
        if (c->en == en_textbutton or c->en == en_togglebutton )
            ReduceButtonSize(c);
        wchar_t wide[32], www[512];
        Utf8ToWide(cclass, wide, sizeof(wide));
        Utf8ToWide(c->name, www, sizeof(www));

        cWnd = CreateWindowExW(
            0,
            wide,//cclass,
            www,//name,
            style,
            c->x, c->y,
            c->cx, (c->en == en_list or c->en == en_combo) ? 200 : c->cy,
            dlg->hWnd,
            (HMENU)(void*)id++,
            hInstance,
            NULL
        );

        c->id = (int)cWnd;
        SetWindowLongData(cWnd,c,cclass);
    }
    scrollY = 0;

    /*** Initialise the controls: ***/
	int saveHeight = DialogHeight;
    for (c=dlg->head; c; c=c->next) {
        InitControl(c, dlg);
    }
	DialogHeight = saveHeight;		// (tco) Dunno why we need this hack.
}


void ScrollWin::RedrawDialogBar()
{   RECT Rect;

    Rect.top = 0;
    Rect.left = 0;
    Rect.right = clientWidth;
    Rect.bottom = DialogHeight;
    if (hRebar)
        ::InvalidateRect((HWND)hRebar, &Rect, yes);
    if (dialogbar and dialogbar->hWnd)
        ::InvalidateRect((HWND)dialogbar->hWnd, &Rect, yes);
}




/*--------------------- Menu's: --------------------*/

/* I could _almost_ provide the same API without using my own objects        */
/* at all.  I could have Windows MENU handles masquerading as pointers       */
/* and possibly provide the same API.  I would have to put some more         */
/* thought into this before implementing it. */

static TfcCallback *MenuTerms;
static TfcGenericMenuItem *MenuCheckedItem;

static void PerformMenuFunction(ScrollWin *SW, int idx)
{
    if (idx <= 0 or idx >= ListSize(MenuTerms))
        return;

    // force callback call if there is suspicion that rebar control is in focus
    HWND hF = GetFocus();
    if (hF and hF != (HWND)SW->_hWnd() and GetParent(hF) != (HWND)SW->_hWnd()) {
        int id = GetWindowLong(hF,GWL_ID);
        SendMessage(GetParent(hF),WM_COMMAND,MAKELPARAM(id,EN_ENTER),id);
    }

    SetFocus((HWND)SW->_hWnd());
	response = 0;
	int tmpresponse = MenuTerms[idx](SW, nullcontrol);
	if (response == 0)
		response = tmpresponse;		// With most of Edval.exe, this is the important one.
	if (not SW->IsValid())
		return;
    SW->Keystroke(response);		// With EdvalPTN, this is the important one.
			// There's a chance that some action might get double-done, firstly via 
			// SW->Keystroke() and subsequently by "sw->GetKey()", but I'm hoping not.
    SW->FlushBuffer();
}


interface void TfcRefreshCheckMenuItem(bool* value)
{   TfcGenericMenuItem *item = NULL;
    UINT state;
    int i;

    for (each_oeli(item,MenuCheckedItem))
        if (item->value == value) {
            state = *value ? MF_CHECKED : MF_UNCHECKED;
            CheckMenuItem((HMENU)item->hmenu, item->id, MF_BYCOMMAND | state);
        }
}


interface void TfcRefreshRadioMenuItem(void** selector)
{   TfcGenericMenuItem *item = NULL;
    int value;
    int i;

    for (each_oeli(item,MenuCheckedItem))
        if (item->selector == selector) {
            /* Is it a 1-byte or 4-byte value? */
            value = (item->flags & MF_REMOVE) ? *(char*)selector :
                    *(int*)selector;
            CheckMenuItem((HMENU)item->hmenu, item->id,
                    MF_BYCOMMAND |
                    ((int)item->value==value ? MF_CHECKED : MF_UNCHECKED)
            );
        }
}


void ScrollWin::TfcCheckMenuItemPressed(void* itemId)
{   TfcGenericMenuItem *item;

    /* Find the item: */
    if ((int)itemId < 0 or (int)itemId >= ListSize(MenuCheckedItem)) {
        assert(false);
        return;
    }
    item = &MenuCheckedItem[(int)itemId];

    if (item->selector != NULL) {   // This means it's a radio group
        if (item->flags & MF_REMOVE)        // Actually means 1-byte value
            *((char*)item->selector) = (char)(int)item->value;
        else *item->selector = item->value; // 4-byte value
        TfcRefreshRadioMenuItem(item->selector);
    }
    else {   // This means it's a simple bool
        int state = GetMenuState((HMENU)item->hmenu, item->id,  MF_BYCOMMAND);
        if (state == -1)
            *(bool*)item->value = !*(bool*)item->value;
            /* If it's a check-mark in a PopupMenu() then the menu will have */
            /* already been destroyed, in which case we just assume the      */
            /* underlying bool was in-sync with the menu state.  I know it's */
            /* not nice to knowingly pass a menu handle which will sometimes */
            /* be invalid to Win32 API, but we'd be doing it anyway in       */
            /* 'RefreshCheckMenuItem()'. And Win32 API seems to cope.        */
        else if ((bool*)item->value) {  // if value provided
            *(bool*)item->value = !(state & MF_CHECKED);
            TfcRefreshCheckMenuItem((bool*)item->value);
        }
        else {
            assert(0);  //can't see how ever in here.
            CheckMenuItem((HMENU)item->hmenu, item->id, MF_BYCOMMAND | MF_CHECKED);
        }
    }

    response = item->Callback(this,nullcontrol);
    if (response)
        Keystroke(response);
}


interface TfcGenericMenuItem TfcMenuItem(kstr name, TfcCallback Callback, bool greyed, int icon)
{   TfcGenericMenuItem it;

	it.name = TfcDisplayStringConverter(name);
    it.icon = icon;
    it.flags = greyed ? MF_GRAYED : 0;
    it.Callback = Callback;
    return it;
}

#define MF_CHECKMENUITEM MF_OWNERDRAW

static void AppendMenuItem(HMENU menu, TfcGenericMenuItem *item)
{
    if (item->flags & MF_POPUP) {
        /* A submenu */
        AppendMenu(menu, MF_STRING|MF_POPUP, (int)item->winMenu, item->name);
    }
    else if (item->flags & MF_SEPARATOR)
        /* A separator */
        AppendMenu(menu, MF_SEPARATOR, 0, NULL);
    else if (not item->Callback and item->value == NULL)
        ;   /* Specifying a null callback is how you disable menu items */
        /* so they don't even appear in the menu, while still being able */
        /* to use the variable argument list method. */
    else {
        /* A command. */
        if (ListSize(MenuTerms) == 0)
            ListAdd(MenuTerms, TfcCallback(0));
        AppendMenu(menu,
                MF_STRING| (item->flags & ~MF_CHECKMENUITEM),
                ListSize(MenuTerms),
                item->name);

        /* If menu item is checked */
        if (item->flags & MF_CHECKMENUITEM) {
            item->hmenu = menu;
            item->id = ListSize(MenuTerms);
            int id = ListSize(MenuCheckedItem);
            ListAdd(MenuCheckedItem , *item);
            item->Callback = TfcCallback(&ScrollWin::TfcCheckMenuItemPressed, (void*)id);
        }

        ListAdd(MenuTerms, item->Callback);
    }
}


interface TfcGenericMenuItem TfcRadioMenuItem(kstr name, void** selector, const void* value,
                    TfcCallback Callback, bool greyed, int icon)
/* Use this for 4-byte variables. */
{   TfcGenericMenuItem it;

    it.name = TfcDisplayStringConverter(name);
    it.icon = icon;
    it.flags = greyed ? MF_GRAYED : 0;
    it.selector = selector;
    it.value    = (void*)value;
    it.Callback = Callback;
    if (!selector or !value) {
        assert(false);
        return it;
    }
    if (*selector == value)
        it.flags |= MF_CHECKED;
    else
        it.flags |= MF_UNCHECKED;
    it.flags |= MF_CHECKMENUITEM;
    return it;
}


interface TfcGenericMenuItem TfcRadioMenuItem(kstr name, char* selector, char value,
                            TfcCallback Callback, bool greyed, int icon)
/* Use this for 1-byte variables.  NB: 0 is a valid value for these variables. */
{   TfcGenericMenuItem it;

    it.name = TfcDisplayStringConverter(name);
    it.icon = icon;
    it.flags = MF_REMOVE;   // Actually means '1-byte value'.
    if (greyed)
        it.flags |= MF_GRAYED;
    it.selector = (void**)selector;
    it.value    = (void*)value;
    it.Callback = Callback;
    if (selector == NULL) {
        assert(false);
        return it;
    }
    if (*selector == value)
        it.flags |= MF_CHECKED;
    else
        it.flags |= MF_UNCHECKED;
    it.flags |= MF_CHECKMENUITEM;
    return it;
}


interface TfcGenericMenuItem TfcCheckMenuItem(kstr name, bool* checkValue, TfcCallback Callback, bool greyed, int icon)
{   TfcGenericMenuItem it;

    it.name = name;
    it.icon = icon;
    it.flags = greyed ? MF_GRAYED : 0;
    if (checkValue)
        it.flags |= *checkValue ? MF_CHECKED : MF_UNCHECKED;
    else
        it.flags |= MF_UNCHECKED;
    it.Callback = Callback;
    it.value = checkValue;
    it.flags |= MF_CHECKMENUITEM;
    return it;
}

#undef MF_CHECKMENUITEM

interface TfcGenericMenuItem TfcSubMenu(kstr name, TfcGenericMenuItem first, ...)
{   TfcGenericMenuItem it;
    va_list args;
    HMENU menu;

	it.name = TfcDisplayStringConverter(name);
    it.icon = 0;
    it.flags = MF_POPUP;
    menu = CreateMenu();
    it.winMenu = (TfcMenu*)menu;
    AppendMenuItem(menu, &first);
    va_start(args, first);
    do {
        if (*(void**)args == NULL)
            break;
        AppendMenuItem(menu, &va_arg(args, TfcGenericMenuItem));
    } forever;
    va_end(args);
    return it;
}


interface TfcGenericMenuItem TfcSubMenu(TfcMenu **destp, kstr name, TfcGenericMenuItem first, ...)
{   TfcGenericMenuItem it, item;
    va_list args;
    HMENU menu;

    it.name = name;
    it.icon = 0;
    it.flags = MF_POPUP;
    menu = CreateMenu();
    it.winMenu = (TfcMenu*)menu;
    AppendMenuItem(menu, &first);
    va_start(args, first);
    do {
        if (*(void**)args == NULL)
            break;
        AppendMenuItem(menu, &va_arg(args, TfcGenericMenuItem));
    } forever;
    va_end(args);
    *destp = (TfcMenu*)menu;
    return it;
}


interface TfcGenericMenuItem TfcSubMenu(kstr name, TfcGenericMenuItem *List)
{   TfcGenericMenuItem it, *item = NULL;
    HMENU menu;
    int i;

    it.name = name;
    it.icon = 0;
    it.flags = MF_POPUP;
    menu = CreateMenu();
    it.winMenu = (TfcMenu*)menu;
    for (each_oeli(item, List))
        AppendMenuItem(menu, item);
    return it;
}


interface TfcGenericMenuItem TfcSubMenu(TfcMenu **destp, kstr name, TfcGenericMenuItem *List)
{   TfcGenericMenuItem it, *item = NULL;
    HMENU menu;
    int i;

    it.name = name;
    it.icon = 0;
    it.flags = MF_POPUP;
    menu = CreateMenu();
    it.winMenu = (TfcMenu*)menu;
    for (each_oeli(item, List))
        AppendMenuItem(menu, item);
    *destp = (TfcMenu*)menu;
    return it;
}


interface TfcGenericMenuItem TfcSeparator()
{   TfcGenericMenuItem it;

    it.name = "---";        // It can't be NULL because this is the signal
    it.icon = 0;                // that the variable-argument-list is finished.
    it.flags = MF_SEPARATOR;
    it.winMenu = 0;
    return it;
}

void ScrollWin::SetMenu(TfcGenericMenuItem first, ...)
{   RECT ClientRectBefore, ClientRect, WindowRect;
    va_list args;
    HMENU _menu;

    if (menu) {
        for (int n=GetMenuItemCount((HMENU)menu)-1; n >= 0; n--) {
            ((class TfcMenu *)GetSubMenu((HMENU)menu, 0))->Clear();
            DeleteMenu((HMENU)menu, 0, MF_BYPOSITION);
        }
        _menu = (HMENU)menu;
    }
    else _menu = CreateMenu();
    AppendMenuItem(_menu, &first);
    va_start(args, first);
    do {
        if (*(void**)args == NULL)
            break;
        TfcGenericMenuItem *tmpMenu = &va_arg(args, TfcGenericMenuItem);
        AppendMenuItem(_menu, tmpMenu);

    } forever;
    va_end(args);

    /* Get size of client area before setting menu */
    GetClientRect((HWND)this->_hWnd(), &ClientRectBefore);
    ::SetMenu((HWND)hWnd, _menu);

    /* Get size of window and client after setting menu */
    GetClientRect((HWND)this->_hWnd(), &ClientRect);
    GetWindowRect((HWND)this->_hWnd(), &WindowRect);

    /* Resize acording to the newly created menu */
    SetWindowPos((struct HWND__ *)hWnd,
                 HWND_TOP,
                 0,
                 0,
                 WindowRect.right - WindowRect.left,
                 WindowRect.bottom - WindowRect.top +
                 ((ClientRectBefore.bottom - ClientRectBefore.top) -
                 (ClientRect.bottom - ClientRect.top)),
                 SWP_NOMOVE
                 );

    menu = (class TfcMenu*)_menu;
}


void TfcMenu::RedrawIfNecessary()
{
    for (each_scrollwin)
        if (sw->GetMenu() == this)
            sw->RedrawMenuBar();
}


void TfcMenu::Add(TfcGenericMenuItem item)
{
    AppendMenuItem((HMENU)this, &item);
    RedrawIfNecessary();
}


void TfcMenu::Del(int n)
{
    DeleteMenu((HMENU)this, n, MF_BYPOSITION);
    RedrawIfNecessary();
}


void TfcMenu::Del(str name)
{   char buf[512];
    int n;

    for (n=GetMenuItemCount((HMENU)this)-1; n >= 0; n--) {
        GetMenuString((HMENU)this, n, buf, sizeof(buf), MF_BYPOSITION);
        if (streq(name, buf)) {
            Del(n);
            break;
        }
    }
}


void TfcMenu::Del(TfcMenu *menu)
{
    DeleteMenu((HMENU)this, (int)menu, MF_BYCOMMAND);
    RedrawIfNecessary();
}


void TfcMenu::Grey(int n, bool greyed)
{
    EnableMenuItem((HMENU)this, n, greyed ? MF_BYPOSITION | MF_GRAYED : MF_BYPOSITION);
    RedrawIfNecessary();
}


void TfcMenu::GreyLeaves(bool greyed)
{
	int max = GetMenuItemCount((HMENU)this);
	for (int n=0; n < max; n++) {
		TfcMenu *subMenu = (TfcMenu*)GetSubMenu((HMENU)this, n);
		if (subMenu == NULL)
		    EnableMenuItem((HMENU)this, n, greyed ? MF_BYPOSITION | MF_GRAYED : MF_BYPOSITION);
		else subMenu->GreyLeaves(greyed);
	}
    RedrawIfNecessary();
}


void TfcMenu::Grey(str name, bool greyed)
{   char buf[512];
    int n;

    for (n=GetMenuItemCount((HMENU)this)-1; n >= 0; n--) {
        GetMenuString((HMENU)this, n, buf, sizeof(buf), MF_BYPOSITION);
        if (streq(name, buf)) {
            Grey(n, greyed);
            break;
        }
    }
}


void TfcMenu::SetCheckMark(int n, bool checked)
{   MENUITEMINFO info;

    clearS(info);
    info.cbSize = sizeof(info);
    info.fMask = MIIM_STATE;
    info.fType = MFT_STRING;
    info.fState = checked ? MFS_CHECKED : MFS_UNCHECKED;
    SetMenuItemInfo((HMENU)this, n, MF_BYPOSITION, &info);
}


void TfcMenu::Clear()
{   int n;

    for (n=GetMenuItemCount((HMENU)this)-1; n >= 0; n--)
    {
        ((class TfcMenu *)GetSubMenu((HMENU)this, 0))->Clear();
        DeleteMenu((HMENU)this, 0, MF_BYPOSITION);
    }
}


/* For menu buttons in dialog boxes*/
interface TfcMenu* TfcPopupMenu(TfcGenericMenuItem first, ...)
{   TfcGenericMenuItem item;
    va_list args;
    HMENU _menu;

    _menu = CreatePopupMenu();
    AppendMenuItem(_menu, &first);
    va_start(args, first);
    do {
        item = va_arg(args, TfcGenericMenuItem);
        if (item.name == NULL)
            break;
        AppendMenuItem(_menu, &item);
    } forever;
    va_end(args);
    return (TfcMenu*)_menu;
}


interface void ScrollWin::PopupMenu(int x, int y, TfcGenericMenuItem *items)
{   TfcGenericMenuItem item;
    HMENU menu;
    POINT p;

    /* Construct the menu: */
    menu = CreatePopupMenu();
    for (int n=0; n < ListSize(items); n++)
        AppendMenuItem(menu, &items[n]);

    /* Track it: */
	MapXYToScreenCoords(&x,&y);
    TrackPopupMenu(menu,
                        TPM_LEFTALIGN,
                        x,y,
                        0,
                        (HWND)hWnd,
                        NULL);

    /* Destroy it: */
    DestroyMenu(menu);
}


interface void ScrollWin::PopupMenu(int x, int y, TfcGenericMenuItem first, ...)
/* Display and track a popup menu. Menu entries are defined in */
/* a variable-argument list terminated by a NULL. */
{   TfcGenericMenuItem item;
    va_list args;
    HMENU menu;
    POINT p;

    /* Construct the menu: */
    menu = CreatePopupMenu();
    if (not first.IsNull())
        AppendMenuItem(menu, &first);
    va_start(args, first);
    do {
        item = va_arg(args, TfcGenericMenuItem);
        if (item.name == NULL)
            break;
        if (not item.IsNull() or *item.name == '-'/*i.e. seperator*/)
            AppendMenuItem(menu, &item);
    } forever;
    va_end(args);

    /* Track it: */
	MapXYToScreenCoords(&x,&y);
    TrackPopupMenu(menu,
                        TPM_LEFTALIGN,
                        x,y,
                        0,
                        (HWND)hWnd,
                        NULL);

    /* Destroy it: */
    DestroyMenu(menu);
}


struct statusbox {
    int   nIcon;
    void* hIcon;
    int   Width;
    str   text;
};


StatusBox::StatusBox(str text, int width, int icon)
{
    this->text = text;
    this->icon = icon;
    if (text and width == -1) {
        // determine dimensions of text
        HFONT hDCFont;
        RECT Rect;
        HDC hDC;

        hDC = PlayDC();
        Rect.left = 0;
        Rect.top = 0;
        Rect.right = 32767;
        Rect.bottom = 32767;

        hDCFont = (HFONT) SelectObject(hDC, (HFONT)TfcGetSystemFont());

        ::DrawText(hDC,text, strlen(text), &Rect, DT_CALCRECT |
                    DT_LEFT | DT_NOPREFIX | DT_TOP | DT_SINGLELINE);

        SelectObject(hDC,hDCFont);
        width = Rect.right - Rect.left + 6;
    }
    this->width = width;
}


int ScrollWin::RedrawStatusBar(bool reposition /*=false*/)
{   int* part, i, pTotal;
    RECT statusRect;
    int statusH;

    if (not hStatus)
        return 0;

    GetWindowRect((HWND) hStatus, &statusRect);
    statusH = statusRect.bottom - statusRect.top;
    //++ (jla) VFIVE-557 --
    pTotal = clientWidth - 20;//(IsMaximised() ? 0 : 20);

    if (reposition) {
        MoveWindow((HWND) hStatus, 0, clientHeight - statusH, pTotal, statusH, TRUE);
        part = NULL;
        statusbox* box = NULL;
        for (each_oeli_backwards(box, sbox)) {
            ListInsN(part, 0, pTotal);
            pTotal -= box->Width;
        }
        SendMessage((HWND)hStatus, SB_SETPARTS, ListSize(part), (LPARAM)part);
        ListFree(part);
    } else {
        statusRect.top = 0;
        statusRect.left = 0;
        statusRect.right = clientWidth;
        statusRect.bottom = statusH;
        ::InvalidateRect((HWND)hStatus, &statusRect, true);
    }

    return statusH;
}


int ScrollWin::GetStatusBarHeight()
{
    if (!hStatus) {
        return 0;
    } else {
        RECT statusRect;
        GetWindowRect((HWND) hStatus, &statusRect);
        return statusRect.bottom - statusRect.top;
    }
}


// Functions For Status Bar

static statusbox status(StatusBox box)
{   statusbox status;

	status.nIcon = box.icon;
	status.Width = box.width;
	if (status.nIcon > 0)
		status.hIcon = LoadImage(hInstance,MAKEINTRESOURCE(status.nIcon),IMAGE_ICON,16,16,0);
	else
		status.hIcon = NULL;

	return status;
}


// Initializes application's status bar.
// Parameters :
//      StatusText  - text that will appear at left side of status bar
//      box1, ... (optional) - additional status boxes that will appear on right side of status bar
void ScrollWin::SetStatusBar(str StatusText, StatusBox box1, ... )
{   int i;
    StatusBox box;
    statusbox st;
    str* text;
    va_list args;

    clearS(st);

    TfcInitCommonControls(ICC_BAR_CLASSES );

    // Create status bar
    if (!hStatus)
        hStatus = TfcCreateStatusWindow(WS_CHILD | WS_VISIBLE | SBT_OWNERDRAW, "",  (HWND) hWnd, 555);

    sbox = NULL;text = NULL;

    // add left pane to array
    ListAdd(sbox, status(StatusBox(StatusText)));
    ListAdd(text, StatusText ? StatusText : "");

    // fill box array
    va_start(args, box1);
    box = box1;
    do {
        if (!box.text)
            break;
        ListAdd(sbox, status(box));
        ListAdd(text, box.text);
        box = va_arg(args, StatusBox);

    } forever;
    va_end(args);

    // fill status bar panes with text and icons
    Resized();
    for (each_aeli(st, sbox))
        UpdateStatusBar(i, text[i], st.nIcon);

    ListFree(text);
}

// Update left pane of status bar with text
void ScrollWin::UpdateStatusBar(str text)
{
SendMessage((HWND) hStatus, SB_SETTEXT, SBT_NOBORDERS, (LPARAM) text);
}

// Update specified status bar box with text and/or icon
// 0 index is for left pane
// indexes from 1 are for right boxes
void ScrollWin::UpdateStatusBar(int boxN, str text, int icon, int nWidth)
{   statusbox* status;
    int flag0;

    if (boxN < 0 or boxN > ListSize(sbox))
        return;

    status = sbox + boxN ;
    // update flag - left pane has no borders, others have
    flag0 = boxN == 0 ? SBT_NOBORDERS : 0;
    // if text is specified - sed it to pane
    if (text)
        SendMessage((HWND) hStatus, SB_SETTEXT, boxN | flag0, (LPARAM) text);

    if (nWidth != -1)
    {
        status->Width = nWidth;
        RedrawStatusBar(true);
    }

    if (icon == -1)
        return;
    // update icon if nessesary
    if (icon != status->nIcon and icon > 0) {
        status->nIcon = icon;
        DestroyIcon((HICON)sbox[boxN].nIcon);
        status->hIcon = LoadImage(hInstance,MAKEINTRESOURCE(status->nIcon),IMAGE_ICON,16,16,0);
    }
    if (status->hIcon)
        SendMessage((HWND) hStatus, SB_SETICON, boxN , (LPARAM) status->hIcon);
}



/*--------------------- Accelerator keys: --------------------*/

void ScrollWin::AddAccelerator(int key, TfcCallback Callback)
{   struct accel_node *ac, **acp;
    unsigned int h;

    h = (unsigned int)key % 57;
    if (Callback.IsNull()) {
        /* Delete the callback. */
        if (Accelerator == NULL)
            return;
        for (acp=&Accelerator[h]; (ac=*acp) != NULL; acp=&ac->next) {
            if (ac->key == key) {
                *acp = ac->next;
                delete ac;
                break;
            }
        }
    }
    else {
        /* Create the callback. */
        if (Accelerator == NULL)
            Accelerator = (struct accel_node**)calloc(57, sizeof(struct accel_node*));
        for (ac=Accelerator[h]; ac; ac=ac->next) {
            if (ac->key == key)
                goto FOUND;
        }
        ac = new accel_node;
        ac->key = key;
        ac->next = Accelerator[h];
        Accelerator[h] = ac;
        FOUND:
        ac->Callback = Callback;
    }
}


bool ScrollWin::ProcessAccelerator(int key)
{   struct accel_node *ac;
    unsigned int h;

    if (Accelerator == NULL)
        return no;
    h = (unsigned int)key % 57;
    for (ac=Accelerator[h]; ac; ac=ac->next) {
        if (ac->key == key) {
            response = ac->Callback(this, nullcontrol);
            if (response)
                QuitEventLoop = yes;
            return yes;
        }
    }
    return no;
}





void _TfcDropStop(void* droptarget)        {   }


void* _TfcSWDropStart(ScrollWin* sw, TfcCallback dropCallback)
{
    return NULL;
}

void* _TfcDropStart(void* hWnd, TfcCallback dropCallback)
{
    return NULL;
}



/*-------------- WinMain(): ----------------*/

interface TfcCallback F1Callback=0;
static HHOOK hHook;
extern DWORD DumpStackTrace( EXCEPTION_POINTERS *ep );


DWORD CALLBACK F1FilterFunc(int nCode, WORD wParam, DWORD lParam)
{
    if (MSGF_DIALOGBOX == nCode) {
        MSG FAR * ptrMsg;
        ptrMsg = (MSG FAR *)lParam;

        if (WM_KEYDOWN == ptrMsg->message and VK_F1 == ptrMsg->wParam) {
            F1Callback(NULL, nullcontrol);
            return 1L;                       // Handled it, ie. swallow the F1 keystroke
        }
    }
    return CallNextHookEx(hHook, nCode, wParam, lParam);
}


static bool winMainCalled = false;
static AutoInitAndCleanUp **initers = NULL;
static enum unicodeMode_enum { unicode_UTF8, unicode_WesternEuropean } unicodeMode = unicode_WesternEuropean;



#if defined(__BORLANDC__) || defined(SMARTS_DOTNET)
#undef WinMain
#define WinMain            TfcWinMain
#endif
interface int WINAPI WinMain(HINSTANCE _hInstance, HINSTANCE hPrevInstance,
        LPSTR args, int nCmdShow)
{   str s, argv[130];
    int argc;

    /* Initialise: */
    hInstance = _hInstance;

    __try { 

		/* Create the output window: */
		/* An explanation about the CS_OWNDC option:  without this flag,
		the app will use a 'common DC' (shared between lots of app's).
		This leads to a problem on Win98 machines: the 'disco effect' where
		paints to our scrollWin's go to all sorts of other Windows windows,
		Borland windows, explorer rebars etc., especially noticeable soon
		after a reboot.
				Note that with this flag, we got even worse problems until
		we discovered that the WM_PAINT messages were being affected by
		leftover clip regions.  So now we clear the clip regions AFTER doing
		application Paint/CursorPaint functions. */

		TfcDropStart = _TfcDropStart;
		TfcSWDropStart = _TfcSWDropStart;
		TfcDropStop = _TfcDropStop;

	#ifdef TFC_UNICODE
		wchar_t className[8];
		WNDCLASSW wndClassw;

		memset(&wndClassw, 0 , sizeof(wndClassw));
		Utf8ToWide("TfcSwin", className, sizeof(className));
		wndClassw.lpfnWndProc = (WNDPROC)ScrollWinProc;
		wndClassw.hInstance = hInstance;
		wndClassw.hCursor = LoadCursor(NULL, IDC_ARROW);
		wndClassw.hIcon = LoadIcon(hInstance, "IDI_APPLICATION");
		wndClassw.hbrBackground = NULL;
		wndClassw.lpszClassName = className;
		wndClassw.lpszMenuName = NULL;
		wndClassw.style = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS | CS_OWNDC;
		ATOM c = RegisterClassW(&wndClassw);
	#endif
	//#else // NL> On my computer text in title displays properly only if both of these registrations exists...
		WNDCLASS wndClass;

		memset(&wndClass, 0, sizeof(wndClass));
		wndClass.style = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS | CS_OWNDC;
		wndClass.lpfnWndProc = (WNDPROC)ScrollWinProc;
		wndClass.hInstance = hInstance;
		wndClass.hCursor = LoadCursor(NULL, IDC_ARROW);
		wndClass.hIcon = LoadIcon(hInstance, "IDI_APPLICATION");
		wndClass.hbrBackground = NULL;
		wndClass.lpszClassName = "TfcSwin";
		wndClass.lpszMenuName = NULL;
		RegisterClass(&wndClass);
	//#endif

		// Dialog box metrics:
		TEXTMETRIC Metrics;
		GetTextMetrics(ScreenDC(), &Metrics);
		baseX = Metrics.tmAveCharWidth+1;
		baseY = Metrics.tmHeight;

		/* Translate 'args' into 'argc' and 'argv'. */
		argc = 0;
		s = strdup(GetCommandLine());
		while (*s) {
			while (isspace(*s))
				s++;
			assert(argc < 130);
			argv[argc++] = s;
			while (not isspace(*s)) {
				if (*s == '\0')
					break;
				else if (*s == '"') {
					strcpy(s, s+1);
					while (*s != '"' and *s != '\0')
						s++;
					strcpy(s, s+1);
				}
				else {
					s++;
				}
			}
			if (*s == '\0')
				break;
			else *s++ = '\0';
		}


		/* Set up a 'hook' to trap the F1 key in dialog boxes: */
		FARPROC lpfnFilterProc = (FARPROC)MakeProcInstance(F1FilterFunc, hInstance);
		hHook    = SetWindowsHookEx(WH_MSGFILTER,
								   (HOOKPROC)lpfnFilterProc,
								   hInstance,
								   GetCurrentThreadId());
		exeFilePath = argv[0];

		/* call apps initialization function */
		winMainCalled = true;
		for (int i = 0; i < ListSize(initers); ++i)
			initers[i]->CallInitFunc();
		ListFree(initers);

		/* Run the user's 'main()': */
		return main(argc, argv);
	} __except (DumpStackTrace(GetExceptionInformation())) {  
		return 1;
	}
}






/*-------------- Standard Dialog Boxes: --------------*/

interface void TfcDebug(const char* fmt, ...)
{   char text[8192];
    va_list args;

    /* Construct the text: */
    va_start(args, fmt);
    vsnprintf(text, sizeof(text), fmt, args);
    va_end(args);
	OutputDebugString(text);
}


interface void TfcMessage(kstr title, char icon, const char* fmt, ...)
{   wchar_t wtext[8192], wtitle[128];
    char text[8192];
    va_list args;
    int type;

    /* Construct the text: */
    va_start(args, fmt);
    vsnprintf(text, sizeof(text), TfcDisplayStringConverter(fmt), args);
    va_end(args);
	title = TfcDisplayStringConverter(title);

	/* Modeless message boxes are done a different way: */
	if (icon == 'm') {
		control def_c = OkButton();
		void* hWnd = CreateModelessDialog(title, 
						StaticIcon(TFC_EXCLAMATION) / FillerControl(20,0) / StaticText(text)
							-
						FillerControl(0,10)
							-
						def_c,
					def_c, 0, TfcTopLevelSW());
		SetFocus((HWND)hWnd);
		return;
	}

    /* Construct the message box: */
    if (icon == '!')
        type = MB_ICONEXCLAMATION;
    else if (icon == '?')
        type = MB_ICONQUESTION;
    else if (icon == '.')
        type = MB_ICONSTOP;
    else if (icon == 'i')
        type = MB_ICONINFORMATION;
    else if (icon == 'x' or icon == 'X')
        type = MB_ICONHAND;
    else type = 0;

    /* Display as unicode: */
	Utf8ToWide(title, wtitle, sizeof(wtitle));
    Utf8ToWide(text, wtext, sizeof(wtext));

	MessageBoxW((HWND)TfcTopLevelHwnd(yes), wtext, wtitle, MB_APPLMODAL | type);
}


interface void TfcMessageWithHelp(kstr title, char icon, kstr helpText, char* fmt, ...)
{   wchar_t wtext[8192], wtitle[128];
    char text[8192];
    va_list args;
    int type;

    /* Construct the text: */
    va_start(args, fmt);
    vsnprintf(text, sizeof(text), TfcDisplayStringConverter(fmt), args);
    va_end(args);
	title = TfcDisplayStringConverter(title);

    /* Construct the message box: */
    if (icon == '!')
        type = MB_ICONEXCLAMATION;
    else if (icon == '?')
        type = MB_ICONQUESTION;
    else if (icon == '.')
        type = MB_ICONSTOP;
    else if (icon == 'i')
        type = MB_ICONINFORMATION;
    else if (icon == 'x' or icon == 'X')
        type = MB_ICONHAND;
    else type = 0;
	if (helpText)
		type |= MB_HELP;
	MessageBoxHelp = helpText;

    /* Display as unicode: */
	Utf8ToWide(title, wtitle, sizeof(wtitle));
    Utf8ToWide(text, wtext, sizeof(wtext));
    MessageBoxW((HWND)TfcTopLevelHwnd(yes), wtext, wtitle, MB_APPLMODAL | type);
}


void TfcQuickMessage(int milliseconds, kstr fmt, ...)
/* Display a message that disappears by itself. */
{	char text[4096];
    va_list args;

	va_start(args, fmt);
	vsnprintf(text, sizeof(text), TfcDisplayStringConverter(fmt), args);
    va_end(args);
	TfcWaitBox("%s", text);
	TfcSleep(milliseconds);
	TfcWaitBox(NULL);
}


interface str TfcSelectFilename(bool for_new_file, char* dest, int sizeofdest,
					kstr filter, kstr extension, kstr title/*=NULL*/)
/* Choose a filename. */
{   char dir[512], buf[512], *s;
    OPENFILENAME OFN;

    /* Set up the majority of options: */
	memset(&OFN, 0, sizeof(OFN));
    OFN.lStructSize = sizeof(OFN);
    OFN.hwndOwner = (HWND)TfcTopLevelHwnd(yes);
    OFN.hInstance = NULL;
    OFN.lpstrFilter = filter;
    OFN.lpstrCustomFilter = NULL;
    OFN.nMaxCustFilter = 0;
    OFN.nFilterIndex = 1;
    OFN.nMaxFile = sizeof(buf);
    OFN.lpstrFileTitle = NULL;
    OFN.nMaxFileTitle = 0;
    OFN.lpstrTitle = title;
    OFN.nFileOffset = 0;
    OFN.nFileExtension = 0;
    OFN.lpstrDefExt = extension;
    OFN.lCustData = 0;
    OFN.lpfnHook = 0;
    OFN.lpTemplateName = NULL;
    strcpy(dir, dest);
    s = strrchr(dir, '\\');
    if (s) {
        OFN.lpstrInitialDir = dir;
        *++s = '\0';
        strcpy(buf, dest+(s-dir));
        OFN.lpstrFile = buf;
    }
    else {
        OFN.lpstrInitialDir = NULL;
        OFN.lpstrFile = buf;
        strcpy(buf, dest);
    }

    /* Are we saving or loading? */
    if (for_new_file) {
        OFN.Flags = OFN_LONGNAMES | OFN_HIDEREADONLY;
        if (not GetSaveFileName(&OFN))
            return NULL;
    }
    else {
        OFN.Flags = OFN_FILEMUSTEXIST | OFN_LONGNAMES;
        if (not GetOpenFileName(&OFN))
            return NULL;
    }
    if (sizeofdest < sizeof(buf))
        buf[sizeofdest] = '\0';
    return strcpy(dest,buf);
}


interface char** TfcSelectMultiFilenames(
        char* defvalue,
        char* filter, char* extension, str title/*=NULL*/)
/* Choose a set of filenames. */
{   char buf[32768], path[512], *s,**A, *d;
    OPENFILENAME OFN;

    /* Set up the majority of options: */
	memset(&OFN, 0, sizeof(OFN));
    OFN.lStructSize = sizeof(OFN);
    OFN.hwndOwner = (HWND)TfcTopLevelHwnd(yes);
    OFN.hInstance = NULL;
    OFN.lpstrFilter = filter;
    OFN.lpstrCustomFilter = NULL;
    OFN.nMaxCustFilter = 0;
    OFN.nFilterIndex = 1;
    OFN.nMaxFile = sizeof(buf);
    OFN.lpstrFileTitle = NULL;
    OFN.nMaxFileTitle = 0;
    OFN.lpstrTitle = title;
    OFN.nFileOffset = 0;
    OFN.nFileExtension = 0;
    OFN.lpstrDefExt = extension;
    OFN.lCustData = 0;
    OFN.lpfnHook = 0;
    OFN.lpTemplateName = NULL;

	// Set up the initial directory and initial filename:
	char dir[512];
	strcpy(dir, defvalue);
    s = strrchr(dir, '\\');
    if (s) {
        OFN.lpstrInitialDir = dir;
        *++s = '\0';
        strcpy(buf, defvalue+(s-dir));
        OFN.lpstrFile = buf;
    }
    else {
        OFN.lpstrInitialDir = NULL;
        OFN.lpstrFile = buf;
        strcpy(buf, defvalue);
    }

    /* Call the open-file dialog box: */
    OFN.Flags = OFN_FILEMUSTEXIST | OFN_LONGNAMES | OFN_ALLOWMULTISELECT | OFN_EXPLORER;
    if (not GetOpenFileName(&OFN))
        return NULL;

    /* Parse the return value to an array: */
    A = NULL;
    if (buf[strlen(buf)+1]) {

        strcpy(path, buf);
        d = path + strlen(path);        // 'd' points to the char after the directory name.
        *d++ = '\\';
        s = buf + strlen(buf) + 1;
    }
    else {
        d = path;
        s = buf;
    }
    while (*s) {
        strcpy(d, s);
        ListAdd(A, strdup(path));
        s += strlen(s) + 1;
    }
    return A;
}


interface str TfcSelectDir(char dest[], str title)
/* If you use this function, then you must be able to link with */
/* 'shell32.lib'. But this is one of the default libraries on   */
/* VC++ and Borland. */
{   BROWSEINFO info;

    memset(&info,0,sizeof(info));
    info.hwndOwner = (HWND)TfcTopLevelHwnd(yes);
    info.pidlRoot = NULL;
    info.pszDisplayName = dest;
    info.lpszTitle = title;
	info.ulFlags = BIF_USENEWUI;

 //   // Set the initial root directory to the address passed
 //   // in dest[]
 //   LPITEMIDLIST  pIdl = NULL;
    //IShellFolder* pDesktopFolder;
    //char          szPath[MAX_PATH];
    //OLECHAR       olePath[MAX_PATH];
    //ULONG         chEaten;
    //ULONG         dwAttributes;

 //   char* szPath;
    //strdup(szPath, dest);
    //if (SUCCEEDED(SHGetDesktopFolder(&pDesktopFolder))) {
       // MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, szPath, -1, olePath, MAX_PATH);
       // pDesktopFolder->ParseDisplayName(NULL, NULL, olePath, &chEaten, &pIdl, &dwAttributes);
       // pDesktopFolder->Release();
    //}
    //bi.pidlRoot = pIdl;
 //   //End of changes

    LPITEMIDLIST ilist = SHBrowseForFolder(&info);

    if (not ilist)
        return NULL; // user pressed CANCEL
    SHGetPathFromIDList(ilist,dest);
    return dest;
}


interface int TfcChooseColour(str title, int colour)
/* The Win32 API apparently doesn't support setting a title on the */
/* dialog-box, it always uses "Color".  Therefore, the 'title'     */
/* param is ignored, but it's there in case one day the situation  */
/* changes or we implement our own colour chooser. */
{   static COLORREF Custom[16];
    CHOOSECOLOR Dlg;
    int result;

    Dlg.lStructSize = sizeof(CHOOSECOLOR);
    Dlg.hwndOwner = (HWND)TfcTopLevelHwnd(yes);
    Dlg.hInstance = (HWND)hInstance;
    Dlg.rgbResult = colour;
    Dlg.lpCustColors = Custom;
    Dlg.Flags = CC_FULLOPEN | CC_RGBINIT;
    Dlg.lCustData = 0;
    Dlg.lpfnHook = NULL;
    Dlg.lpTemplateName = NULL;
    result = ChooseColor(&Dlg);
    if (not result)
        return colour;
    return Dlg.rgbResult;
}


interface TfcFont TfcChooseFont(TfcFont font, bool bTTOnly /* = false */)
{   LOGFONT Logfnt;
    CHOOSEFONT Dlg;
    int result = 0;

    clearS(Dlg);
    if (font == NULL)
        font = (HFONT)TfcGetSystemFont();
    GetObject(font, sizeof(Logfnt), &Logfnt);

    /* if GetObject didn't recognize the font - retrieve font name and size*/
    if (*Logfnt.lfFaceName == '\0')
        TfcFontName(font, Logfnt.lfFaceName , LF_FACESIZE);
    if (Logfnt.lfHeight == 0)
        Logfnt.lfHeight = TfcFontHeight(font);

    Dlg.lStructSize = sizeof(Dlg);
    Dlg.hwndOwner = (HWND)TfcTopLevelHwnd(yes);
    Dlg.hInstance = (HINSTANCE)hInstance;
    Dlg.lpLogFont = &Logfnt;
    Dlg.nSizeMin = 5;
    Dlg.nSizeMax = 55;
    Dlg.Flags = CF_INITTOLOGFONTSTRUCT|CF_FORCEFONTEXIST|CF_SCREENFONTS;

    result = ChooseFont(&Dlg);
    if (not result) {
        return font;
    } else if ( (Logfnt.lfHeight * (-0.75)) > 100 ) {
        // There is a direct correlation between the font size
        // chosen, and the lfHeight value in Logfnt where the
        // Logfnt value is always -3/4 times the font size chosen.
        // Hence, to restrict the height to 100 at maximum, we
        // check for above condition, and now set the value to 100
        Logfnt.lfHeight = -133; // Font size 100 converted for Logfnt
    }
    Logfnt.lfOutPrecision = bTTOnly ? OUT_TT_ONLY_PRECIS : OUT_DEFAULT_PRECIS;
    return CreateFontIndirect(&Logfnt);
}


interface int TfcChoose(kstr title, kstr choices, kstr fmt, ...)
/* This provides a dialog box with a small set of alternatives. */
/* The alternatives are specified as a sequence of null-terminated  */
/* strings, e.g.:  "One\0Two\0Three\0Four\0".  It returns a number  */
/* in this case from 1 to 4, being the index into this sequence, or */
/* 0=none of the above (i.e. cancelled). */
{   control a, b, c, StartHere=nullcontrol;
    char text[16384];
    va_list args;
    int n=0;

    /* Construct the text: */
    va_start(args, fmt);
    vsnprintf(text, sizeof(text), fmt, args);
    va_end(args);

    /* Construct the dialog box: */
    a = FillerControl(10,4) - StaticText(text) - FillerControl(10,8);
    b = nullcontrol;
    while (*choices) {
        if (*choices == '~') {
            c = Button(++choices, ++n);
            StartHere = c;
        }
        else c = Button(choices, ++n);
        b = b | c;
        choices += strlen(choices) + 1;
    }
    b = AlignXCentre(b);

    /* Do the dialog box: */
    return DoDialog(title, a - b, StartHere, NULL, TFC_DLG_CHILD);
}


interface str TfcDesktopFolder(char dest[])
{
    if (SHGetSpecialFolderPathA(HWND_DESKTOP, dest, CSIDL_DESKTOPDIRECTORY, FALSE))
        return dest;
    else
        return NULL;
}


struct WaitBox_node {
	bool WantsCancel;
	bool onTheTop;
	void* dlg;
	str ButtonText;
	control button_c;
	control text_c;
};

static WaitBox_node WaitBox;

interface void TfcWaitBoxOnTheTop(bool on) 
{
	WaitBox.onTheTop = on;
}


interface void YesTheyWantToCancel()
{
    WaitBox.WantsCancel = yes;
}


interface void TfcClearWantToCancel()
{
    WaitBox.WantsCancel = no;
}


interface bool TfcWantsCancel()
{
    TfcYield(no);
    return WaitBox.WantsCancel;
}


static void WaitBoxDied()
{
    WaitBox.dlg = NULL;
	WaitBox.button_c = WaitBox.text_c = nullcontrol;
}


interface void TfcSetWaitBoxButtonText(str text)
{
	if (text == NULL)
		text = "          Cancel          ";
	if (text != WaitBox.ButtonText) {
		WaitBox.ButtonText = text;
		if (WaitBox.button_c)
			WaitBox.button_c.SetText(WaitBox.ButtonText);
	}
}


interface bool TfcWaitBox(str fmt, ...)
/* Set up a modeless 'wait while I'm processing' box. */
/* Pass it message=NULL to close the box.  */
/* Pass it e.g.:  "~Take best yet\0Still searching %s ...\n" to replace the word "Cancel" */
/* on the button with "Take best yet". */
/* Returns 'no' if the user wants to cancel. */
{   void* hForeWnd;
    ScrollWin *SW;
    bool retval;

    /* Do they want to kill the dialog box? */
    if (fmt == NULL) {
        /* Killing the wait box: */
        if (WaitBox.dlg)
            KillModelessDialog(WaitBox.dlg), WaitBox.dlg = NULL;
        WaitBox.WantsCancel = no;
        WaitBox.onTheTop = no;
        return yes;
    }

    /* Construct the text: */
    char buf[2048];
    va_list args;
    va_start(args, fmt);
    vsnprintf(buf, sizeof(buf), fmt, args);
    va_end(args);


    /* Create or update the wait box. */
    if (WaitBox.dlg) {
        /* Updating the wait box */
        WaitBox.text_c.SetText(buf);
    }
    else {
		/* Creating the wait box */
        WaitBox.WantsCancel = no;
		if (WaitBox.ButtonText == NULL)
			TfcSetWaitBoxButtonText(NULL);
        control c;
        c = (WaitBox.text_c=StaticText(buf))
                -
            FillerControl(20,20)
                -
            (WaitBox.button_c=Button(WaitBox.ButtonText, YesTheyWantToCancel));
            // The Cancel button must NOT be the default control,
            // we don't want people hitting it by accident.
        WaitBox.dlg = CreateModelessDialog("Wait", c, nullcontrol, WaitBoxDied, TfcTopLevelSW());
        if (WaitBox.onTheTop) {
            RECT *rect = new RECT();
            GetWindowRect((HWND)WaitBox.dlg, rect);
            SetWindowPos((HWND)WaitBox.dlg, HWND_TOPMOST, 100, 100, 
                rect->right - rect->left ,
                rect->bottom - rect->top, 
                0);
        }
    }
    TfcYield(no);
    retval = not WaitBox.WantsCancel;
    WaitBox.WantsCancel = no;
    return retval;
}







/*--------------- The Busy Cursor: ----------------*/

static int Busyness;

interface void TfcBusyOn()
/* Set the mouse cursor to an hourglass cursor. */
{
    Busyness = 1;
    HCURSOR WaitCursor = LoadCursor(NULL, IDC_WAIT);
    for (each_scrollwin) {
        SetClassLong((HWND)sw->_hWnd(),
            GCL_HCURSOR,
            (LONG)WaitCursor);
    }
    SetCursor(WaitCursor);
}


interface void TfcBusyOff()
/* Set the mouse cursor back to the normal arrow. */
{
    Busyness = 0;
    HCURSOR WaitCursor = LoadCursor(NULL, IDC_ARROW);
    for (each_scrollwin) {
        SetClassLong((HWND)sw->_hWnd(),
            GCL_HCURSOR,
            (LONG)WaitCursor);
    }
    SetCursor(WaitCursor);
}


interface void TfcBusyPush()
{
    if (Busyness++)
        return; // It was already on.
    TfcBusyOn();
}


interface void TfcBusyPop()
{
    if (--Busyness)
        return; // It is still on.
    TfcBusyOff();
}


interface void TfcCursorNormal()
{
    HCURSOR Cursor = LoadCursor(NULL, IDC_ARROW);
    SetCursor(Cursor);
}


interface void TfcSplitCurOn()
{
    HCURSOR splitCursor  = LoadCursor(NULL, IDC_SIZEWE);
    SetCursor(splitCursor);
}


interface void TfcSplitCurOff()
{
    TfcCursorNormal();
}


interface void TfcDragCurOn()
{
    HCURSOR dragCursor = LoadCursor(NULL, IDC_SIZEALL);
    SetCursor(dragCursor);
}


interface void TfcDragCurOff()
{
    TfcCursorNormal();
}


interface void TfcSetCursor(int cursor_id)
{
    if (cursor_id == -1)
        TfcCursorNormal();
    else {
        HCURSOR mycursor = (HCURSOR)GetBitmapOrIcon(cursor_id, IMAGE_CURSOR, 32, 32, NULL);
        if (mycursor)
            SetCursor(mycursor);
    }
}




/*--------------- The Windows Clipboard: ----------------*/

interface void ClipboardSetText(kstr text)
/* Copy this text into the clipboard.  The caller      */
/* still owns 'text', i.e. should eventually free it.  */
/* We convert normal format to DOS format by inserting */
/* '\r' characters. */
{   int barelinefeeds;
    HGLOBAL h;
    kstr s;
	str d;

    OpenClipboard(NULL);
    EmptyClipboard();
    barelinefeeds = 0;       // We convert normal format to DOS format.
    for (s=strchr(text, '\n'); s; s=strchr(s+1, '\n')) {
        if (s == text or s[-1] != '\r')
            barelinefeeds++;
    }
    h = GlobalAlloc(GMEM_MOVEABLE|GMEM_DDESHARE, strlen(text)+1+barelinefeeds);
    d = (char*)GlobalLock(h);
    if (barelinefeeds) {
        for (s=text; *s; s++) {
            if (*s == '\n' and (s==text or s[-1] != '\r'))
                *d++ = '\r';
            *d++ = *s;
        }
    }
    else strcpy(d, text);
    GlobalUnlock(h);
    SetClipboardData(CF_TEXT, h);
    CloseClipboard();
}


interface void ClipboardSetText(wchar_t* text)
{   int barelinefeeds;
    wchar_t* d;
    HGLOBAL h;

    OpenClipboard(NULL);
    EmptyClipboard();
    h = GlobalAlloc(GMEM_MOVEABLE|GMEM_DDESHARE, sizeof(wchar_t)*wcslen(text)+2);
    d = (wchar_t*)GlobalLock(h);
    wcscpy(d, text);
    GlobalUnlock(h);
    SetClipboardData(CF_UNICODETEXT, h);
    CloseClipboard();
}


/* The single-thread libraries that Edval uses don't have 'wcsdup'! */
static wstr wcsdup(wstr ws)
{   int len=(wcslen(ws)+1)*2;

    return (wstr)memcpy(malloc(len), ws, len);
}


interface wstr ClipboardGetTextW()
{   wchar_t *text;
    HGLOBAL h;

    OpenClipboard(NULL);
    h = GetClipboardData(CF_UNICODETEXT);
    if (h == NULL)
        text = NULL;
    else {
        text = wcsdup((wstr)GlobalLock(h));
        GlobalUnlock(h);
    }
    CloseClipboard();
    return text;

}


interface str ClipboardGetText()
/* Return the text in the clipboard.  NULL=no clipboard. */
/* The caller must free the string that is returned. */
{   char *text, *utf8text;
    HGLOBAL h;

    OpenClipboard(NULL);
    h = GetClipboardData(CF_UNICODETEXT);
    if (h == NULL)
        text = NULL;
    else {
        wchar_t* wtext = (wchar_t*) GlobalLock(h);
        int size = wcslen(wtext)*8+1;
        str utftext = (str) malloc(size);
        WideToUtf8(wtext, utftext, size);
        text = strdup(utftext);
        free(utftext);
        GlobalUnlock(h);
    }
    CloseClipboard();
    return text;
}



/*--------------------- File mapping and locking: ------------------*/

#include <errno.h>
#include <fcntl.h>
#include <io.h>


static struct fmap_node {
	HANDLE file;
	HANDLE mapping;
	void *mem;
	int size;
} FMapSet[10];


interface void* TfcMapFile(const char* filename, unsigned int *lengthp, char *errormsg, bool for_write)
{
    struct fmap_node *FMap;
    for (int i=0; i < arraymax(FMapSet); i++) {
        FMap = &FMapSet[i];
        if (FMap->mem == NULL)
            goto FOUND;
    }
    sprintf(errormsg, "Too many mapped files (TFC max=%d)", arraymax(FMapSet));
    return NULL;
    FOUND:
    FMap->file = CreateFile(filename,
                    for_write ? GENERIC_WRITE|GENERIC_READ : GENERIC_READ,
                    FILE_SHARE_READ | FILE_SHARE_WRITE,
                    NULL,
                    OPEN_EXISTING,
                    FILE_ATTRIBUTE_NORMAL,
                    NULL);
    if (FMap->file == NULL or FMap->file == INVALID_HANDLE_VALUE) {
        FAILURE:
        if (errormsg)
            strcpy(errormsg, TfcStrerror());
        return NULL;
    }
    *lengthp = FMap->size = GetFileSize(FMap->file, NULL);
    if (*lengthp == 0) {
        sprintf(errormsg, "Can't map %s: zero-length file", filename);
        CloseHandle(FMap->file), FMap->file = NULL;
        return NULL;
    }
    FMap->mapping = CreateFileMapping(FMap->file, NULL,
                for_write ? PAGE_READWRITE : PAGE_READONLY, 0, 0, NULL);
                // Previously the last param was "IDPATH", but this didn't
                // work on my WinME machine with many mappings. In fact,
                // I don't think we need to name the mapping at all.
    if (FMap->mapping == NULL) {
        CloseHandle(FMap->file), FMap->file = NULL;
        goto FAILURE;
    }
    FMap->mem = MapViewOfFile(FMap->mapping,
                for_write ? FILE_MAP_READ|FILE_MAP_WRITE : FILE_MAP_READ,
                0, 0,       // From the beginning of the file
                FMap->size);        // Some Windows's can't handle the '0' here.
    if (FMap->mem == NULL) {
        CloseHandle(FMap->mapping), FMap->mapping = NULL;
        CloseHandle(FMap->file), FMap->file = NULL;
        goto FAILURE;
    }
    return FMap->mem;
}


interface void TfcUnmapFile(void *mem)
{
    struct fmap_node *FMap;
    for (int i=0; i < arraymax(FMapSet); i++) {
        FMap = &FMapSet[i];
        if (FMap->mem == mem)
            goto FOUND;
    }
    return;
    FOUND:
    if (FMap->mem)
        UnmapViewOfFile(FMap->mem), FMap->mem = NULL;
    if (FMap->mapping)
        CloseHandle(FMap->mapping), FMap->mapping = NULL;
    if (FMap->file)
        CloseHandle(FMap->file), FMap->file = NULL;
}



interface bool TfcLockFilename(str filename, int seconds_to_wait, char *errormsg)
/* Try to get a lock on this file.  If you can't get it immediately, */
/* try for up to 'seconds_to_wait' seconds.   If stw=0, then you     */
/* have the non-blocking version;  if stw=99999, then you have the   */
/* blocking version, otherwise you have the timeout version.  In the */
/* event of any error or failure to get the lock, return 'no'.       */
{   char buf[512];
    HANDLE file;
    int error;

    strcpy(buf, filename);
    strcat(buf, ".lock");
    do {
        file = CreateFile(buf, GENERIC_READ | GENERIC_WRITE,
                                    FILE_SHARE_READ | FILE_SHARE_WRITE,
                                    NULL,
                                    CREATE_NEW,
                                    FILE_ATTRIBUTE_NORMAL,
                                    NULL);
        if (file != INVALID_HANDLE_VALUE) {
            CloseHandle(file);
            return yes;
        }
        if ((error=GetLastError()) != ERROR_FILE_EXISTS) {
            if (errormsg)
                sprintf(errormsg, "%s : %s", buf, TfcStrerror(errno));
            return no;
        }
        if (seconds_to_wait-- <= 0) {
            if (errormsg)
                sprintf(errormsg, "%s already locked.", filename);
            return no;
        }
        Sleep(1000);
        TfcYield(no);
    } while(1);
//        return no;
}


interface bool TfcUnlockFilename(str filename)
/* Release the lock on this file. */
{   char buf[512];

    strcpy(buf, filename);
    strcat(buf, ".lock");
    if (DeleteFile(buf) == 0) {
        int err = GetLastError();
        if (err == ERROR_FILE_NOT_FOUND)
            ;       // That's okay.
        else {
            TfcMessage("Unlock", '!', "Can't delete file\n\n%s"
                    "\n\nReason: %d\n", buf, err);
            return no;
        }
    }
    return yes;
}






/*----------------- Timers: ----------------*/

static struct tfctimer_node {
    int TimerId;
    TfcCallback callback;
    bool called;
} *TfcTimers;


static void _stdcall TfcTimerCallback(void* hWnd, uint message, uint Timer, long SysTime)
{   struct tfctimer_node *T = NULL, *T2 = NULL;
    int i;

    for (each_oeli(T, TfcTimers)) {
        if (T->TimerId == Timer) {
            if (!T->called) {
                T->called = true;
                T->callback(NULL,nullcontrol);
                for (each_oeli(T2, TfcTimers)) {
                    if (T2->TimerId == Timer) {
                        T2->called = false;
                        break;
                    }
                }
            }
            break;
        }
    }
}


interface int TfcStartTimer(int MilliSec, TfcCallback callback)
{   struct tfctimer_node *T;

    if (MilliSec <= 0)
        return 0;
    T = (tfctimer_node*)ListNext(TfcTimers);
    T->TimerId = SetTimer(NULL, 0, MilliSec, (TIMERPROC)(wincallback_fn)TfcTimerCallback);
    T->callback = callback;
    T->called = false;
    return T->TimerId;
}


interface void TfcKillTimer(int timer)
{   struct tfctimer_node *T = NULL;
    int i;

    for (each_oeli(T, TfcTimers)) {
        if (T->TimerId == timer) {
            ListDelN(TfcTimers, i);
            break;
        }
    }
    KillTimer(NULL,timer);
}



/*-------------------- The registry: --------------------*/

TfcRegistryKey::TfcRegistryKey(bool allow_create, kstr root, ...)
{   va_list args;
    int result;
    HKEY key;
    str s;

    /* Which root? */
    if (*root == *TFC_CURRENT_USER)
        key = HKEY_CURRENT_USER;
    else if (*root == *TFC_LOCAL_MACHINE)
        key = HKEY_LOCAL_MACHINE;
    else if (*root == *TFC_USERS)
        key = HKEY_USERS;
    else if (*root == *TFC_CLASSES_ROOT)
        key = HKEY_CLASSES_ROOT;
    else {
        assert(false);
        return;
    }

    /* Go down: */
    va_start(args, root);
    do {
        s = va_arg(args, str);
        if (s == NULL)
            break;
        if (allow_create) {
            RegCreateKey(key, s, &key);
            if (key == NULL) {
                hKey = NULL;
                return;
            }
        }
        else {
            result = RegOpenKeyEx(key, s, 0, KEY_READ, &key);
            if (key == NULL or result != ERROR_SUCCESS) {
                hKey = NULL;
                return;
            }
        }
    } forever;
    hKey = (void*)key;
}


str TfcRegistryKey::Get(char dest[], int sizeofdest)
{   long result;

	*dest = '\0';
	if (hKey == NULL)
        return NULL;
    result = sizeofdest;
    RegQueryValue((HKEY)hKey, NULL, dest, &result);
    return dest;
}


void TfcRegistryKey::Set(kstr value)
{
    RegSetValue((HKEY)hKey, NULL, REG_SZ, value, strlen(value));
}


void TfcRegistryKey::SetBinary(void* data, int len)
{
    RegSetValueEx((HKEY)hKey, NULL, 0, REG_BINARY, (const BYTE*)data, len);
}


str TfcRegistryKey::Get(kstr subkey, char dest[], int sizeofdest)
{
    return Subkey(no, subkey).Get(dest, sizeofdest);
}


void TfcRegistryKey::Set(kstr subkey, kstr value)
{
    Subkey(yes, subkey).Set(value);
}


TfcRegistryKey TfcRegistryKey::Subkey(bool allow_create, kstr s)
{   TfcRegistryKey r;
    long result;

    if (allow_create) {
        RegCreateKey((HKEY)hKey, s, (HKEY*)&r.hKey);
    }
    else {
        result = RegOpenKeyEx((HKEY)hKey, s, 0, KEY_READ, (HKEY*)&r.hKey);
        if (result != ERROR_SUCCESS)
            r.hKey = NULL;
    }
    return r;
}


TfcRegistryKey TfcRegistryKey::ChildKey(int idx, char name[], int sizeofname)
{	unsigned long len=sizeofname;

	int result = RegEnumKeyEx((HKEY)hKey,
					idx,
					name,
					&len,
					0,
					NULL,NULL,NULL);
	if (result == ERROR_SUCCESS)
		return Subkey(no, name);
	else {
		*name = '\0';
		return TfcRegistryKey();
	}
}




/*------------------------ Cooperative multitasking: ------------------------*/

interface bool TfcYield(bool DoCommands)
/* Process all pending messages, with the possible exception    */
/* of menu selections and button messages where the user has    */
/* specified DoCommands=no.   This allows users to do a form of */
/* cooperative multitasking, and get the advantages of multi-   */
/* threaded programs without the effort of using semaphores etc.*/
/*        DoCommands=no will process all messages except: menu  */
/* selections, dialog box buttons, mousestrokes and keystrokes. */
{
    response = 0;
    if (DoCommands) {
        while (PeekMessage(&EventLoopMsg, NULL, 0, WM_USER-1, PM_REMOVE)) {
            if (EventLoopMsg.message != WM_TIMER and
                                (hDlgLaco == 0 or not IsDialogMessage(hDlgLaco,&EventLoopMsg)))
                DispatchMessage(&EventLoopMsg);
            if (response)
                return yes;
        }
    }
    else {
        WaitingForAnyKeystroke = yes;
        while (PeekMessage(&EventLoopMsg, NULL, 0, WM_USER-1, PM_NOREMOVE)) {
            if (EventLoopMsg.message == WM_COMMAND or EventLoopMsg.message == WM_CLOSE) {
                WaitingForAnyKeystroke = no;
                return yes;
            }
            PeekMessage(&EventLoopMsg, NULL, 0, WM_USER-1, PM_REMOVE);
            if (hDlgLaco == 0 or not IsDialogMessage(hDlgLaco,&EventLoopMsg))
                DispatchMessage(&EventLoopMsg);
            if (response) {
                WaitingForAnyKeystroke = no;
                return yes;
            }
        }
        WaitingForAnyKeystroke = no;
    }
    return no;
}


interface void TfcSleep(int milliseconds)
{
    Sleep(milliseconds);
}


interface void TfcPostCallback(void (*Callback)())
/* Post a callback call to the message loop, to be done after all */
/* other pending messages. */
{
    // (ksh) Since thread messages are lost if there is a dialog box
    // active (or if the user is manipulating a window owned by the
    // thread), we now post the TFC_CALLCALLBACK message to the top
    // level scrollwin if possible.
    PostMessage((HWND)TfcTopLevelHwnd(no), TFC_CALLCALLBACK,
                       (WPARAM)Callback, 0);
}


/*----------------- Invoke the browser -------------------*/

interface void InvokeURL(kstr URL)
{
	ShellExecute(NULL,NULL,URL,NULL,NULL,SW_SHOWNORMAL);
}




/*----------------- Rebar -------------------*/

#ifndef RBBS_GRIPPERALWAYS
#define RBBS_GRIPPERALWAYS  0x0080
#endif
#ifdef __BORLANDC__
    typedef int (__stdcall* param1_fn)(void);
#elif defined(VC5)
    typedef int (__stdcall* param1_fn)(void);
#else
    typedef WNDPROC param1_fn;
#endif

long _stdcall RebarWndProc(HWND, UINT, WPARAM, LPARAM);

void ScrollWin::RemoveRebarBand(int bandN)
{   dialog_node *dlg, *prev;
    int idx;

    /* know index of band */
    idx = SendMessage((HWND)hRebar,RB_IDTOINDEX,bandN,0);

    /* delete band from window*/
    SendMessage((HWND)hRebar,RB_DELETEBAND,idx,0);

    /* delete band from dialogbar list*/
    dlg = dialogbar;
    prev = NULL;
    while (dlg) {
        if (dlg->id ==  bandN)
            break;
        prev = dlg;
        dlg = dlg->next;
    }
    if (not dlg)
        return;

    /* unset the focus to make sure that all callback was called for current control*/
    SetFocus(NULL);

    /* hide the dialog */
    ShowWindow(dlg->hWnd, SW_HIDE);

    /* post message to destroy dialog later */
    PostMessage(dlg->hWnd, WM_USER + 1,0,(LPARAM) dlg);

    if (not prev)
        dialogbar = dlg->next;
    else
        prev->next = dlg->next;
}


void ScrollWin::RestoreRebar()
/* Restore rebar in case window was detached from ScrollWin */
{   REBARBANDINFO rbbi;
    RECT Rect, ClRect;
    dialog_type dlg;
    REBARINFO rbi;
    int id=0;

    if (!dialogbar)
        return;

    /* Create the rebar window (the 'container' for the various */
    /* 'bands') if we haven't already done so. */
    GetWindowRect((HWND)hWnd, &Rect);
    TfcInitCommonControls(ICC_COOL_CLASSES | ICC_BAR_CLASSES);
    hRebar = CreateWindowEx(WS_EX_TOOLWINDOW,
                                  REBARCLASSNAME,
                                  NULL,
                                  WS_VISIBLE | WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS |
                                  RBS_VARHEIGHT | CCS_NODIVIDER,
                                  0,0,0,0,
                                  (HWND)hWnd,
                                  (HMENU)ID_REBAR,
                                  hInstance,
                                  NULL);
    if (!hRebar) {
        assert(false);
        return ;
    }
    clearS(rbi);
    rbi.cbSize  = sizeof(rbi);
    rbi.fMask   = 0;
    SendMessage((HWND)hRebar, RB_SETBARINFO, 0, (LPARAM)&rbi);

    /* Specify window procedure to Rebar window */
    SetWindowLong((HWND)hRebar,GWL_USERDATA,
                    GetWindowLong((HWND)hRebar,GWL_WNDPROC));
    SetWindowLong((HWND)hRebar,GWL_WNDPROC,(LPARAM) RebarWndProc);

    for (dlg=dialogbar; dlg; dlg=dlg->next) {
        DlgBeingBuilt = dlg;
        SetDialogBar(nullcontrol, no);
        DlgBeingBuilt->id = id;
        HWND hwndChild = DlgBeingBuilt->hWnd;
        clearS(rbbi);
        rbbi.cbSize       = sizeof(REBARBANDINFO);
        rbbi.fMask        = RBBIM_SIZE |
                            RBBIM_CHILD |
                            RBBIM_CHILDSIZE |
                            RBBIM_ID |
                            RBBIM_STYLE ;
        rbbi.cxMinChild   = DlgBeingBuilt->Width;
        rbbi.cyMinChild   = DialogHeight+2;
        rbbi.clrBack      = RGB(0,0,0);
        rbbi.clrFore      = RGB(198,198,198);
        rbbi.cx           = 100;
        rbbi.fStyle       = RBBS_CHILDEDGE | RBBS_GRIPPERALWAYS;
        rbbi.wID          = id++;
        rbbi.hwndChild    = hwndChild;
        rbbi.lpText       = "Button";

        SendMessage((HWND)hRebar, RB_INSERTBAND, (WPARAM)-1, (LPARAM)(LPREBARBANDINFO)&rbbi);
        DialogHeight = SendMessage((HWND)hRebar,RB_GETBARHEIGHT,0,0);
        // This is done in the WM_NOTIFY for the very first call to SetRebar(),
        // but on subsequent calls if the rebar is not resized then it isn't
        // called. But we need it to map dialog units to pixels, so call it.
    }

    ShowWindow((HWND)hRebar,SW_SHOW);

    /* Resize rebar: */
    GetClientRect((HWND)hWnd, &ClRect);
    MoveRebar(&ClRect);
    ::InvalidateRect((HWND)hWnd,&ClRect,yes);

}


void ScrollWin::SetRebar(class control toolbar1, ...)
/*  Assigns rebar for window  */
{   int id=0, DlgHeight;
    REBARBANDINFO rbbi;
    RECT Rect, ClRect;
    REBARINFO rbi;
    va_list args;

    /* Do this first.  Otherwise we might have trouble with Windows2K with Report. */
    TfcInitCommonControls(ICC_COOL_CLASSES | ICC_BAR_CLASSES);

    // If we still don't have 'real' window -> just set up dialog bars...
    if (!hWnd) {
        va_start(args, toolbar1);
        control current = toolbar1;
        do {
            SetDialogBar(current);
            current = va_arg(args,control);
        } while (current.priv != NULL);
        va_end(args);
        return;
    }

    DlgHeight = DialogHeight;
    if (hRebar) {
        ShowWindow((HWND)hRebar,SW_HIDE);
        /* remove all previous rebar bands */
        while (dialogbar)
            RemoveRebarBand(dialogbar->id);
    }
    else {
        /* Create the rebar window (the 'container' for the various */
        /* 'bands') if we haven't already done so. */
        GetWindowRect((HWND)hWnd, &Rect);
        hRebar = CreateWindowEx(WS_EX_TOOLWINDOW,
                              REBARCLASSNAME,
                              NULL,
                              WS_VISIBLE | WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS |
                              RBS_VARHEIGHT | CCS_NODIVIDER,
                              0,0,0,0,
                              (HWND)hWnd,
                              (HMENU)ID_REBAR,
                              hInstance,
                              NULL);

        if (!hRebar) {
            assert(false);
            return ;
        }
        clearS(rbi);
        rbi.cbSize  = sizeof(rbi);
        rbi.fMask   = 0;
        SendMessage((HWND)hRebar, RB_SETBARINFO, 0, (LPARAM)&rbi);

        /* Specify window procedure to Rebar window */
        SetWindowLong((HWND)hRebar,GWL_USERDATA,
                      GetWindowLong((HWND)hRebar,GWL_WNDPROC));
        SetWindowLong((HWND)hRebar,GWL_WNDPROC,(LPARAM) RebarWndProc);
    }


    /* create dialog bars */
    va_start(args, toolbar1);
    control current = toolbar1;

    do {
        SetDialogBar(current);

        DlgBeingBuilt->id = id;

        HWND hwndChild = DlgBeingBuilt->hWnd ;
        clearS(rbbi);
        rbbi.cbSize       = sizeof(REBARBANDINFO);
        rbbi.fMask        = RBBIM_SIZE |
                            RBBIM_CHILD |
                            RBBIM_CHILDSIZE |
                            RBBIM_ID |
                            RBBIM_STYLE ;
        rbbi.cxMinChild   = DlgBeingBuilt->Width;
        rbbi.cyMinChild   = DialogHeight+2;
        rbbi.clrBack      = RGB(0,0,0);
        rbbi.clrFore      = RGB(198,198,198);
        rbbi.cx           = 100;
        rbbi.fStyle       = RBBS_CHILDEDGE | RBBS_GRIPPERALWAYS;
        rbbi.wID          = id++;
        rbbi.hwndChild    = hwndChild;
        rbbi.lpText       = "Button";

        SendMessage((HWND)hRebar, RB_INSERTBAND, (WPARAM)-1, (LPARAM)(LPREBARBANDINFO)&rbbi);
        DialogHeight = SendMessage((HWND)hRebar,RB_GETBARHEIGHT,0,0);
        // This is done in the WM_NOTIFY for the very first call to SetRebar(),
        // but on subsequent calls if the rebar is not resized then it isn't
        // called. But we need it to map dialog units to pixels, so call it.

        current = va_arg(args,control);

    } while (current.priv != NULL);
    va_end(args);

    ShowWindow((HWND)hRebar,SW_SHOW);

    /* Resize rebar: */
    GetClientRect((HWND)hWnd, &ClRect);
    MoveRebar(&ClRect);

    // if this is top-level window - force clientHeight remain the same
    GetWindowRect((HWND)hWnd, &Rect);
    if (not GetParent((HWND) hWnd)) {
        if (not IsMaximised()) {
            MoveWindow((HWND)hWnd,
                  Rect.left, Rect.top,
                  Rect.right - Rect.left,
                  Rect.bottom - Rect.top + DialogHeight - DlgHeight,
                  yes);
        }
        else // if window is Not Maximized
        {
            clientHeight = ClRect.bottom - ClRect.top - DialogHeight - GetStatusBarHeight();
            Resized();
        }
    }

    ::InvalidateRect((HWND)hWnd,&ClRect,yes);
	//::RedrawWindow((HWND)hWnd,&ClRect,NULL,RDW_UPDATENOW);//added by Laco
}


static long _stdcall RebarWndProc(HWND hwnd, UINT uMsg,WPARAM wParam,LPARAM lParam)
/* Rebar window procedure. Used to make microsoft-specific look */
{   static int x0 = 9999;
    PAINTSTRUCT paintStruct;
    HPEN penW, penG, penG2;
    int x, count;
    RECT rect;
    HDC hDC;
    int i;

    switch (uMsg) {
                
       case WM_MOUSEMOVE: // Redraw immediately when dragging gripper
                if (wParam & MK_LBUTTON) {
                    rect.left = x0; rect.right = LOWORD(lParam);
                    rect.top  = 0;  rect.bottom = 9999;
                    InvalidateRect(hwnd, &rect, false);
                    x0 = rect.right-5;
                }
                break;
                
        case WM_PAINT:
                /* Draw edge around the rebar */
                hDC = BeginPaint(hwnd, &paintStruct);

                penW = (HPEN) GetStockObject(WHITE_PEN);
                penG = GetPen(tfc_colour, RGB(128,128,128), 1);
                penG2 = GetPen(tfc_colour, RGB(198,198,198), 1);

                count = SendMessage(hwnd,RB_GETBANDCOUNT,0,0);
                for (i=count; i>=0; i--) {
                    memset(&rect, 0, sizeof(RECT));
                    SendMessage(hwnd,RB_GETRECT,i,(LPARAM)&rect);

                    /* Draw lines around the current band*/
                    SelectObject(hDC, penW);
                    MoveToEx(hDC, rect.left, rect.bottom-2, NULL);
                    LineTo(hDC, rect.left, rect.top+1);
                    LineTo(hDC, rect.right-1, rect.top+1);
                    SelectObject(hDC, penG);
                    LineTo(hDC,  rect.right-1,rect.bottom-1);
                    LineTo(hDC, rect.left, rect.bottom-1);

                    x = rect.left+1;

#define TOP_MARGIN 3
#define BOTTOM_MARGIN 4
                    /* Draw the gripper */
                    SelectObject(hDC, penW);
                    MoveToEx(hDC, x+2, rect.top+TOP_MARGIN, NULL);
                    LineTo(hDC, x+1, rect.top+TOP_MARGIN);
                    LineTo(hDC, x+1, rect.bottom-BOTTOM_MARGIN);
                    SelectObject(hDC, penG2);
                    MoveToEx(hDC, x+2, rect.top+TOP_MARGIN+1, NULL);
                    LineTo(hDC, x+2, rect.bottom-BOTTOM_MARGIN);
                    SelectObject(hDC, penG);
                    MoveToEx(hDC, x+3, rect.top+TOP_MARGIN, NULL);
                    LineTo(hDC, x+3, rect.bottom-BOTTOM_MARGIN);
                    LineTo(hDC, x, rect.bottom-BOTTOM_MARGIN);

                    x += 4;

                    SelectObject(hDC, penW);
                    MoveToEx(hDC, x+2, rect.top+TOP_MARGIN, NULL);
                    LineTo(hDC, x+1, rect.top+TOP_MARGIN);
                    LineTo(hDC, x+1, rect.bottom-BOTTOM_MARGIN);
                    SelectObject(hDC, penG2);
                    MoveToEx(hDC, x+2, rect.top+TOP_MARGIN+1, NULL);
                    LineTo(hDC, x+2, rect.bottom-BOTTOM_MARGIN);
                    SelectObject(hDC, penG);
                    MoveToEx(hDC, x+3, rect.top+TOP_MARGIN, NULL);
                    LineTo(hDC, x+3, rect.bottom-BOTTOM_MARGIN);
                    LineTo(hDC, x, rect.bottom-BOTTOM_MARGIN);
                }

                EndPaint(hwnd, &paintStruct);
                return yes;
    }

    return CallWindowProc((param1_fn)GetWindowLong(
                            hwnd, GWL_USERDATA),hwnd, uMsg,wParam,lParam);
}


void ScrollWin::MoveRebar(void* rect)
{   int w,h=0,idx,x0,y0=0,wMax,x,y;
    RECT* winRect = (RECT*)rect;
    control_type c;
    dialog_type db;

    if (hRebar == NULL)
        return;

    ShowWindow((HWND)hRebar,SW_HIDE);
    if (dialogbar == NULL)
        return;

    // move controls to next line
    for (db=dialogbar, idx=0; db; db=db->next,idx++) {
        idx = SendMessage((HWND)hRebar,RB_IDTOINDEX,db->id,0);
        wMax = w = h = x0 = y0 = 0;

        for (c=db->head;c; c=c->next) {

            // create next line
            if (c->x + c->cx - x0 > winRect->right - winRect->left) {
                wMax = w > wMax ? w : wMax; // width of rebar band
                x0 = x0 + w; w = 0;
                y0 = y0 + h; h = 0;
            }

            // calculate new position
            x = c->x - x0;
            y = y0 + c->y;

            // stop things magically disappearing
            // while resizing an overcluttered multi-lined
            // rebar.
            if (x0 > c->x) {
               x0 = 0;
               x = 0;
            }

            w = c->x + c->cx - x0;
            wMax = w > wMax ? w : wMax; // width of rebar band

            if (h < c->y + c->cy)
                h = c->y + c->cy;

            MoveWindow( GetDlgItem(db->hWnd,c->id),
                        x,
                        y,
                        c->cx,
                        c->cy,
                        TRUE
                        );
        }
        wMax = w > wMax ? w : wMax;

        // if dialogbar's width didn't change - do nothing
        if (db->Width == wMax)
            continue;
        db->Width = wMax;

        MoveWindow(db->hWnd,2,2,winRect->right - winRect->left/*wMax*/, y0 + h, TRUE);

        SendMessage((HWND)hRebar, RB_DELETEBAND, idx, 0);
            REBARBANDINFO rbbi;
            clearS(rbbi);
            rbbi.cbSize       = sizeof(REBARBANDINFO);
            rbbi.fMask        = RBBIM_SIZE |RBBIM_CHILD |RBBIM_CHILDSIZE |RBBIM_ID |RBBIM_STYLE ;
            rbbi.cxMinChild   = wMax;
            rbbi.cyMinChild   = y0 + h + 2;
            rbbi.clrBack      = RGB(0,0,0);
            rbbi.clrFore      = RGB(198,198,198);
            rbbi.cx           = winRect->right - winRect->left;
            rbbi.fStyle       = RBBS_CHILDEDGE | RBBS_GRIPPERALWAYS;
            rbbi.wID          = db->id;
            rbbi.hwndChild    = db->hWnd;

        SendMessage((HWND)hRebar, RB_INSERTBAND, idx,(LPARAM)&rbbi);
    }

    MoveWindow((HWND)hRebar,
                    0,0,
                    winRect->right - winRect->left,
                    y0 + h + 4,
                    TRUE);
    ShowWindow((HWND)hRebar, SW_SHOW);
    DialogHeight = SendMessage((HWND)hRebar,RB_GETBARHEIGHT,0,0);
}


void ScrollWin::DetachRebar()
{   controlprivate_node* c;
    dialog_type dlg;

    for (dlg=dialogbar; dlg; dlg=dlg->next) {
        for (c=dlg->head; c; c=c->next)
            if (c->en == en_scrollwin)
                c->u.sw->DetachFromWindow();
        dlg->hWnd = NULL;
    }
    DestroyWindow((HWND)hRebar);
    hRebar = NULL;
}


dialog_node* ScrollWin::RebarFromWnd(void* hwnd)
{   HWND hDialogBar = (HWND) hwnd;
    dialog_type dlg;

    if (not dialogbar)
        return NULL;
    for (dlg = dialogbar;
             dlg != NULL and dlg->hWnd != hDialogBar;
             dlg = dlg->next);
    return dlg;
}


static void* GetNextDialogBar(void* hwnd)
{   dialog_type dlg;
    ScrollWin* sw;

    sw = ScrollWin::SwFromWnd(RebarParent((HWND)hwnd));

    if (sw == NULL)
        return NULL;
    dlg = sw->RebarFromWnd(hwnd);
    if (not dlg)
        return NULL;
    if (not dlg->next)
        return sw->dialogbar->hWnd;
    return dlg->next->hWnd;
}


static dialog_node* GetLastDialogBar(void* hwnd)
{   dialog_type dlg;
    ScrollWin* sw;

    sw = ScrollWin::SwFromWnd(RebarParent((HWND)hwnd));

    if (sw == NULL)
        return NULL;

    dlg = (dialog_node*)sw->GetRebar();
    if (dlg->hWnd == hwnd) { // it's on the first rebar
        while(dlg and dlg->next)
            dlg = dlg->next;
        if (dlg)
            return dlg;
    }
    else { // find the rebar before this one
        while (dlg and dlg->next->hWnd != hwnd)
            dlg = dlg->next;
        if (dlg)
            return dlg;
    }
    return NULL;
}


/*--- function initialization of controls in rebar bands ---*/

struct CtrlData {
    controlprivate_node * c;
    LRESULT (CALLBACK* wnd_proc) (HWND, UINT, WPARAM, LPARAM);
};


static long _stdcall CtrlWinProc(  HWND hwnd, UINT uMsg,WPARAM wParam,LPARAM lParam)
#define NextFocusableControl(N, I)  N = I;\
                                while (N and N->next and (N->en == en_statictext or N->disabled))\
                                    N = N->next;

{   controlprivate_node *c;
    CtrlData *data;
    int Result;

    data = (CtrlData*)GetWindowLongW(hwnd,GWL_USERDATA);
    if (data == NULL)
        return DefWindowProcW(hwnd,uMsg,wParam,lParam);
    c = data->c;

    switch (uMsg) {
        case WM_SYSKEYUP:
        case WM_SYSKEYDOWN:
        case WM_SYSCHAR:
            TranslateMessage(&EventLoopMsg);
            break;

        case WM_SETFOCUS: // Static text is non-focusable
            if (c->en == en_statictext) {
                if (c->next) {
                    SetFocus((HWND)c->next->id);
                    if (c->next->en == en_string or c->next->en == en_int)
                        SendMessage((HWND)c->next->id, EM_SETSEL, 0, -1);
                }
                else
                    SetFocus((HWND)GetNextDialogBar(c->dlgOwner->hWnd));
            }
            else if (c->en == en_string or c->en == en_int) {
                PostMessage((HWND)c->id, EM_SETSEL, 0, -1);
            }
            break;

        case WM_KEYDOWN: // if user pressed TAB key, we need to transfer
            if (wParam == VK_TAB) {   // focus to next or last control
                if (not TfcShiftStatus()) {
                    if (c->next) {
                        controlprivate_node *n;

                        NextFocusableControl(n, c->next);
                        if (n)
                            SetFocus((HWND)n->id);
                        else
                            SetFocus((HWND)GetNextDialogBar(c->dlgOwner->hWnd));
                    }
                    else SetFocus((HWND)GetNextDialogBar(c->dlgOwner->hWnd));
                    return 0;
                }
                else {   // BACKTAB focus to last control
                    controlprivate_node *l, *n;

                    NextFocusableControl(n, c->dlgOwner->head);

                    if (c == n) { // on the first control of this rebar
                        dialog_node *dlg = GetLastDialogBar(c->dlgOwner->hWnd);
                        if (dlg) {
                            l = dlg->tail;
                            SetFocus((HWND)l->id);
                            if (l->en == en_string or l->en == en_int)
                                SendMessage((HWND)l->id, EM_SETSEL, 0, -1);
                        }
                    }
                    else {
                        l = c->dlgOwner->head;
                        NextFocusableControl(n, l->next);
                        while (l and n != c) {
                            NextFocusableControl(l, l->next);
                            NextFocusableControl(n, l->next);
                        }
                        if (l)
                            SetFocus((HWND)l->id);
                    }
                }
            }
            else if (wParam == VK_RETURN) {
                if (c->en == en_string or c->en == en_int or
                        c->en == en_float or c->en == en_list or c->en == en_combo)
                    // Send notification message for control's parent
                    SendMessage(c->dlgOwner->hWnd,
                                WM_COMMAND,
                                MAKELPARAM(c->id,EN_ENTER),
                                c->id);
                return 0;
            }
            else {
                // Process accelerator fo virtual keys
                if (c->dlgOwner->Owner) {
                    int key = GetExtended(wParam);
                    if (c->dlgOwner->Owner->ProcessAccelerator(key))
                        ;
                    else if ((key >= F1 and key <= F12) or (key >= CTRL('A')
                                    and key <= CTRL('Z') and key != TAB and key != ENTER
                                    and key != ESC))
                        c->dlgOwner->Owner->Keystroke(key);
                        //SetFocus(GetDlgItem(c->dlgOwner->hWnd, c->id));
                        // tco> Don't force focus to the app's main window,
                        // because often the keystroke is used to pop up
                        // a help box.
                }

                // translate messages only for rebars
                if (c->dlgOwner->IsDialogBar and c->en != en_scrollwin)
                    TranslateMessage(&EventLoopMsg);
                char x = (char)wParam;
                if (c->en == en_list and ((x >= 'a' and x <= 'z') or
                            (x >= 'A' and x <= 'Z')))
                    PostMessage(c->dlgOwner->hWnd,WM_COMMAND,MAKELPARAM(c->id,EN_KEYPRESS),c->id);
            }
            break;
            
        case WM_CHAR:
            // Check either it's a accelerator
            if (c->dlgOwner->Owner and c->dlgOwner->Owner->ProcessAccelerator(wParam))
                  SetFocus(GetDlgItem(c->dlgOwner->hWnd, c->id));
            break;

        case WM_LBUTTONUP:
            if (c->en == en_list or c->en == en_combo) {
                if (not SendMessage( hwnd, CB_GETDROPPEDSTATE,0,0))
                      break;
                // Ensure that when list box is dropped down, the selection remains the same
                // (by default, it selects first item that begins from string that is in editor box)

                Result = SendMessage(hwnd, CB_GETCURSEL, 0, 0);
                PostMessage(hwnd,CB_SETCURSEL,Result,0L);
                PostMessage(GetParent(hwnd),WM_COMMAND,MAKEWPARAM(c->id,CBN_STUPIDBUG),(LPARAM) hwnd);
            }
            break;

        case WM_KEYUP:
            if (wParam == VK_LEFT)
                return CallWindowProc((param1_fn)data->wnd_proc,hwnd,uMsg,wParam,lParam);
            TranslateMessage(&EventLoopMsg);
            break;

        case WM_DESTROY:
            if (c->en == en_scrollwin and c->u.sw->IsValid())
                c->u.sw->DetachFromWindow();
            SetWindowLong(hwnd,GWL_WNDPROC,(LONG) data->wnd_proc );
            SetWindowLong(hwnd,GWL_USERDATA,(LONG) 0);
            delete data;
            //c->id = 0;
            return DefWindowProcW(hwnd,uMsg,wParam,lParam);
    }
    return CallWindowProc((param1_fn)data->wnd_proc,hwnd,uMsg,wParam,lParam);
#undef NextFocusableControl
}


static BOOL CALLBACK EnumCBChild(HWND hwnd, LPARAM lParam)
/* Function for enumeration childs of ComboBox            */
/* Servrs for assigning new behaviour for Edit in ComboBox*/
{   CtrlData *dataCB, *dataED;

    dataCB = (CtrlData*) lParam;
    dataED = new CtrlData;
    dataED->c = dataCB->c;
    dataED->wnd_proc = (WNDPROC)SetWindowLongW(hwnd,GWL_WNDPROC,(LONG)CtrlWinProc);
    SetWindowLong(hwnd,GWL_USERDATA,(LONG)dataED);
    SetWindowLong(hwnd,GWL_ID,(LONG)dataED->c->id);
    return 0;
}


static void SetWindowLongData(HWND hControl, controlprivate_node *c, char* className)
{   CtrlData * data;

    data = new CtrlData;
    data->c = c;
    if (c->en == en_list or c->en == en_combo ) {
        EnumChildWindows(hControl, (WNDENUMPROC)EnumCBChild, (LPARAM)data);
        SetWindowLongW(hControl,GWL_ID,(LONG)c->id);
    }
    data->wnd_proc = (WNDPROC)SetWindowLongW(hControl, GWL_WNDPROC, (LONG)CtrlWinProc);
    SetWindowLongW(hControl,GWL_USERDATA,(LONG) data);
    SetWindowLongW(hControl,GWL_ID,(LONG)c->id);
}




/*--------------------- Splitter windows: ------------------*/

#define splitWidth 5


// class for the splitter representation
class Splitter  {
public :
    Splitter(HWND parent, SplitWindow* win, bool isH, char around);
    ~Splitter();

    void Paint(HDC hdc);

    void ForceRepaint();
    void Move(int x,int y,int cx, int cy);

    void Size();

    void Show();
    void Show(bool show);

    void LButtonDown (POINTS pt) ;
    void LButtonUp (POINTS pt) ;
    void LButtonDrag (POINTS pt);

    void RButtonDown () ;
    void RButtonUp () ;
    void RButtonDrag (POINTS pt);

    void LRButtonUp () ;
    void ButtonUp () ;

    void LRButtonDown () ;
    void ButtonDown () ;

    void CaptureChanged () ;

    HWND _hWnd() {return hWnd; }
protected:
    str GetClassName();
    void RegisterClass();
    void DrawLine(HDC hdc, int x1, int y1, int x2, int y2, COLORREF color=RGB(255,255,255));
    bool IsTopLevel(SplitWindow* win);


    HWND hWnd;
    HWND parent;
    static int initV;
    static int initH;
    static int initA[4];

    SplitWindow* split_win;

    int _x;
    int _y;
    int _cy;
    int _cx;
    int _dragStart;
    int _drag;
    int oldMode;
    bool right_drag;  // user drags for new window using right button
    bool left_drag;   // user drags for new window using left button
    HDC hTempDC;

    bool isH;
    char around;
    char aroundN;

};


int Splitter::initV = 0;
int Splitter::initH = 0;
int Splitter::initA[] = {0,0,0,0};



Splitter::~Splitter()
{
//        DestroyWindow(hWnd);
}


void Splitter::Size()
{   RECT Rect;
    // Parent window was resized.
    // Store splitter's coordinates in parent windows coordinates

    split_win->GetClientRect(&Rect);
    _x = Rect.left;
    _y = Rect.top;
    _cx = Rect.right;
    _cy = Rect.bottom;
}


void Splitter::DrawLine(HDC hdc, int x1, int y1, int x2, int y2, COLORREF color)
{
    HPEN pen = CreatePen(PS_SOLID,1,color);
    HPEN old = (HPEN) SelectObject(hdc,pen);
    MoveToEx(hdc,x1,y1,NULL);
    LineTo(hdc,x2,y2);
    SelectObject(hdc,old);
    DeleteObject(pen);
}


void Splitter::Show(bool show)
{
    ShowWindow(hWnd, show ? SW_SHOW : SW_HIDE);
}


LRESULT CALLBACK WndProcSplitter (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);

void Splitter::Move(int x,int y,int cx, int cy)
{
    MoveWindow(hWnd,x,y,cx,cy,TRUE);
}


Splitter::Splitter(HWND _parent, SplitWindow* win, bool isHSplitter, char isAroundSplitter)
{
    parent = _parent;
    split_win = win;
    isH = isHSplitter;
    around = isAroundSplitter;
    left_drag = right_drag = 0;
    switch (around)
    {
        case 'L' : aroundN = 0; break;
        case 'T' : aroundN = 1; break;
        case 'R' : aroundN = 2; break;
        case 'B' : aroundN = 3; break;
        default :
            aroundN = -1; break;
    }

    RegisterClass();
    hWnd = CreateWindowEx (0,
            GetClassName(),
            "",
            WS_CHILD | WS_VISIBLE,
            0,0,
            100,100,
            parent,
            0,
            TfcGetInstance(),
            this);

}

void Splitter::ForceRepaint()
{
    InvalidateRect(hWnd,NULL,TRUE);
    UpdateWindow(hWnd);
}


LRESULT CALLBACK WndProcSplitter (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    Splitter * pCtrl = (Splitter*) GetWindowLong(hwnd, GWL_USERDATA);
    switch (message) {
        case WM_CREATE:
            SetWindowLong(hwnd,GWL_USERDATA,(LPARAM)((LPCREATESTRUCT)lParam)->lpCreateParams);
            return 0;

        case WM_PAINT:    {
            PAINTSTRUCT paintStruct;
            HDC hDC = BeginPaint(hwnd, &paintStruct);
            pCtrl->Paint(hDC);
            EndPaint(hwnd, &paintStruct);
            break;
        }

        case WM_SIZE:
            pCtrl->Size();
            return 0;

        case WM_RBUTTONDOWN:
            pCtrl->RButtonDown();
            return 0;

        case WM_RBUTTONUP:
            pCtrl->RButtonUp();
            return 0;

        case WM_LBUTTONDOWN:
            pCtrl->LButtonDown (MAKEPOINTS (lParam));
            return 0;

        case WM_LBUTTONUP:
            pCtrl->LButtonUp (MAKEPOINTS (lParam));
            return 0;

        case WM_MOUSEMOVE:
            if (wParam & MK_LBUTTON)
                pCtrl->LButtonDrag (MAKEPOINTS (lParam));
            if (wParam & MK_RBUTTON)
                pCtrl->RButtonDrag (MAKEPOINTS (lParam));

            return 0;

        case WM_CAPTURECHANGED:
            pCtrl->CaptureChanged();
            return 0;
        case WM_USER + 1:
            delete pCtrl;
            SetWindowLong(hwnd,GWL_USERDATA,NULL);
            DestroyWindow(hwnd);
            return 0;

    }

    return DefWindowProc (hwnd, message, wParam, lParam);
}





#define LEFT  0x01
#define RIGHT 0x02
#define BOTH  0x03

void Splitter::ButtonDown()
{
    SetCapture(hWnd);
    if (around)
        split_win->SplitStart(around);
}


void Splitter::LRButtonDown()
{
if (right_drag or left_drag) // if we're already in dragging mode -> do nothing
    return;
left_drag = yes; // set dragging with LEFT button ON
ButtonDown();
}


void Splitter::RButtonDown()
{
    if (right_drag or left_drag) // if we're already in dragging mode -> do nothing
        return;
    right_drag = yes; // set dragging with RIGHT button ON
    ButtonDown();
}


void Splitter::ButtonUp()
{
    ReleaseCapture();
    if (around)
        split_win->SplitEnd();
    // switch off all dragging
}


void Splitter::LRButtonUp()
{
    if (!left_drag)
        return;
    ButtonUp();
    left_drag = NULL;
}


void Splitter::RButtonUp()
{
    if (!right_drag)
        return;
    ButtonUp();
    right_drag = NULL;
}


void Splitter::RButtonDrag(POINTS pt)
{   POINT p;
    RECT re;

    if (!around)
        return;
    p.x = pt.x, p.y = pt.y;
    ClientToScreen((HWND) hWnd, &p);
    GetWindowRect(hWnd,&re);
    if (p.x >= re.left and p.x <= re.right and p.y <= re.top and p.y >= re.bottom)
        return;
    split_win->SplitDrag(p.x, p.y);
}


bool Splitter::IsTopLevel(SplitWindow* win)
{
    if (not win->parent)
        return yes;
    if (win->parent->splitMode == '|') {
        if (win->parent->isLeft(win))
            if (around == 'R')
                return no;
            else
                return IsTopLevel(win->parent);
        else
            if (around == 'L')
                return no;
            else
                return IsTopLevel(win->parent);
    }
    else {
        if (win->parent->isLeft(win))
            if (around == 'B')
                return no;
            else
                return IsTopLevel(win->parent);
        else
            if (around == 'T')
                return no;
            else
                return IsTopLevel(win->parent);
    }
}


void Splitter::LButtonDown(POINTS pt)
{
    if (around) {   // user wants to create new window
        LRButtonDown();
        return;
    }

    // Capture mouse
    SetCapture(hWnd);

    // Find x offset of splitter
    // with respect to parent client area
    POINT ptOrg = {0, 0 };
    ClientToScreen (parent,&ptOrg);
    int xParent = ptOrg.x;
    int yParent = ptOrg.y;


    //isH ? ptOrg.x = 0 : ptOrg.y = 0;
    ptOrg.x = 0 , ptOrg.y = 0;
    ClientToScreen (hWnd,&ptOrg);
    int yChild = ptOrg.y;
    int xChild = ptOrg.x;

    _dragStart =
      isH ?
      yChild - yParent - pt.y :
      xChild - xParent + pt.x ;

    _drag =
       isH ?
        _dragStart + pt.y :
        _dragStart + pt.x ;

    // Draw a divider using XOR mode
    hTempDC = GetDC(parent);
    oldMode = SetROP2(hTempDC,R2_XORPEN);
    if (isH)
        DrawLine(hTempDC,_x,_drag, _cx-1,_drag);
    else
        DrawLine(hTempDC,_drag, _y,_drag, _cy - 1);
}


void Splitter::LButtonUp(POINTS pt)
{
    if (around) {
        LRButtonUp();
        return;
    }

    ReleaseCapture();
    SetROP2(hTempDC,oldMode);
    ReleaseDC(parent,hTempDC);
    if (isH)
        split_win->MoveSplitter(_dragStart + pt.y,true);
    else
        split_win->MoveSplitter(_dragStart + pt.x);
}


void Splitter::LButtonDrag(POINTS pt)
{
    if (around) {
        if (left_drag)
            RButtonDrag(pt);
        return;
    }

    // Erase previous divider and draw new one
    if (isH)
        DrawLine (hTempDC,_x,_drag, _cx-1, _drag);
    else
        DrawLine (hTempDC,_drag, _y, _drag, _cy - 1);

    _drag = isH ? _dragStart + pt.y : _dragStart + pt.x;

    if (isH and _drag < _y)
        _drag = _y+1;
    if (isH)
        DrawLine (hTempDC,_x,_drag, _cx-1, _drag);
    else
        DrawLine (hTempDC,_drag, _y, _drag, _cy - 1);
}


void Splitter::CaptureChanged()
{
    if (isH)
        DrawLine(hTempDC,_x,_drag, _cx-1, _drag);
    else
        DrawLine (hTempDC,_drag, _y, _drag, _cy - 1);
}


BYTE curAnd[4][32] = {
{0xff, 0xff,0xff, 0xff,0xff, 0xff,0xc7, 0xff,0xc7, 0x9f,0xc7, 0x8f,0xc7, 0x87,0xc0, 0x03,
 0xc0, 0x01,0xc0, 0x03,0xc7, 0x87,0xc7, 0x8f,0xc7, 0x9f,0xc7, 0xff,0xff, 0xff,0xff, 0xff},

{0xff, 0xff,0xc0, 0x01,0xc0, 0x01,0xc0, 0x01,0xfe, 0x3f,0xfe, 0x3f,0xfe, 0x3f,0xfe, 0x3f,
 0xfe, 0x3f,0xf0, 0x07,0xf0, 0x07,0xf8, 0x0f,0xfc, 0x1f,0xfe, 0x3f,0xff, 0x7f,0xff, 0xff},

{0xff, 0xff,0xff, 0xff,0xff, 0xff,0xff, 0xe3,0xf9, 0xe3,0xf1, 0xe3,0xe1, 0xe3,0xc0, 0x03,
 0x80, 0x03,0xc0, 0x03,0xe1, 0xe3,0xf1, 0xe3,0xf9, 0xe3,0xff, 0xe3,0xff, 0xff,0xff, 0xff},

{0xff, 0xff,0xff, 0x7f,0xfe, 0x3f,0xfc, 0x1f,0xf8, 0x0f,0xf0, 0x07,0xf0, 0x07,0xfe, 0x3f,
 0xfe, 0x3f,0xfe, 0x3f,0xfe, 0x3f,0xfe, 0x3f,0xc0, 0x01,0xc0, 0x01,0xc0, 0x01,0xff, 0xff}
};


BYTE curXOr[4][32] = {
{0x00, 0x00,0x00, 0x00,0x00, 0x00,0x38, 0x00,0x28, 0x60,0x28, 0x50,0x28, 0x48,0x2f, 0xc4,
 0x20, 0x02,0x2f, 0xc4,0x28, 0x48,0x28, 0x50,0x28, 0x60,0x38, 0x00,0x00, 0x00,0x00, 0x00},

{0x00, 0x00,0x3f, 0xfe,0x20, 0x02,0x3f, 0x7e,0x01, 0x40,0x01, 0x40,0x01, 0x40,0x01, 0x40,
 0x01, 0x40,0x0f, 0x78,0x08, 0x08,0x04, 0x10,0x02, 0x20,0x01, 0x40,0x00, 0x80,0x00, 0x00},

{0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x1c,0x06, 0x14,0x0a, 0x14,0x12, 0x14,0x23, 0xf4,
 0x40, 0x04,0x23, 0xf4,0x12, 0x14,0x0a, 0x14,0x06, 0x14,0x00, 0x1c,0x00, 0x00,0x00, 0x00},

{0x00, 0x00,0x00, 0x80,0x01, 0x40,0x02, 0x20,0x04, 0x10,0x08, 0x08,0x0f, 0x78,0x01, 0x40,
 0x01, 0x40,0x01, 0x40,0x01, 0x40,0x01, 0x40,0x3f, 0x7e,0x20, 0x02,0x3f, 0xfe,0x00, 0x00}
};


str Splitter::GetClassName()
{   static char className[50];

    if (around) {
        sprintf(className,"TfcA%cSplitterWnd",around);
        return className;
    }
    return isH ? "TfcVSplitterWnd" : "TfcHSplitterWnd";
}


void Splitter::RegisterClass()
{   WNDCLASS wndClass;
    LPCTSTR curID;
    HCURSOR hCur;
    int x,y;

    if (around and initA[aroundN])
        return;
    else
    if (isH and initV)
        return;
    else
    if (not isH and initH)
       return;

    curID = around ? IDC_UPARROW : isH ? IDC_SIZENS : IDC_SIZEWE;
    if (around) {
        switch (around) {
            case 'L' : x = 0, y = 8; break;
            case 'T' : x = 8, y = 0; break;
            case 'R' : x = 15, y = 8; break;
            case 'B' : x = 8, y = 15; break;
            default  : x = 0, y = 0; break;
        }
        hCur = CreateCursor(hInstance, x,y,16,16,curAnd[aroundN],curXOr[aroundN]);
    }
    else
        hCur = LoadCursor(NULL, curID);


    memset(&wndClass, 0, sizeof(wndClass));
    wndClass.style = CS_HREDRAW | CS_VREDRAW;
    wndClass.lpfnWndProc = (WNDPROC)WndProcSplitter;
    wndClass.hInstance = TfcGetInstance();
    wndClass.hCursor = hCur;
    wndClass.hIcon = NULL;
    wndClass.hbrBackground = GetSysColorBrush(COLOR_BTNFACE);
    wndClass.lpszClassName = GetClassName();
    ::RegisterClass(&wndClass);
    if (around)
        initA[aroundN] = yes;
    else
    if (isH)
        initV = yes;
    else
        initH = yes;
}


void Splitter::Paint(HDC hDC)
{   int x1,x2,y1,y2;

    if (isH)
        x1=0,x2=_cx,y1=0,y2=splitWidth;
    else
        x1=0,x2=splitWidth,y1=0,y2=_cy;

    if (isH) {
        DrawLine(hDC,x1, y1, x2, y1, GetSysColor (COLOR_3DLIGHT));
        DrawLine(hDC,x1, y1+1, x2-1, y1+1, GetSysColor (COLOR_3DHILIGHT));
        DrawLine(hDC,x1, y2-2, x2-1, y2-2, GetSysColor (COLOR_3DSHADOW));
        DrawLine(hDC,x2, y1-1, x2-1, y2-1, GetSysColor (COLOR_3DDKSHADOW));
    }
    else {
        DrawLine(hDC,x1, y1, x1, y2, GetSysColor (COLOR_3DLIGHT));
        DrawLine(hDC,x1+1, y1, x1+1, y2-1, GetSysColor (COLOR_3DHILIGHT));
        DrawLine(hDC,x2-2, y1, x2-2, y2-1, GetSysColor (COLOR_3DSHADOW));
        DrawLine(hDC,x2-1, y1, x2-1, y2-1, GetSysColor (COLOR_3DDKSHADOW));
    }
}


class WindowGrey : public ScrollWin  {
public :
    WindowGrey() : ScrollWin(NULL, 10,10) {}

    bool Keystroke (int key) {return no;}
    void Paint(int x1, int y1, int x2, int y2);
    void Measure(int *widthp, int *heightp) {}
};


void WindowGrey::Paint(int x1, int y1, int x2, int y2)
{
    DrawRectangle(x1,y1,x2,y2,GREY,NOCOLOUR);
}


// protected constructor
SplitWindow::SplitWindow(SplitWindow* _parent, ScrollWin* _scrollW)
    : ScrollWin("",1,1)
{
    childLT = NULL;
    childRB = NULL;
    splitter = NULL;

    splitterL = NULL;
    splitterR = NULL;
    splitterT = NULL;
    splitterB = NULL;

    wndGrey = NULL;

    splitMode = '-';
    showMode = 0;
    parent = _parent;
    leaf = _scrollW;
    maxWindow = NULL;
    SetSWParent(parent);
    SetSplittersAround();
    if (leaf) {
        leaf->SetSWParent(this);
        leaf->Show();
    }

    disableChildDelete = false;
}


// public constructor for top-level split window
SplitWindow::SplitWindow(char* title, int x, int y, ScrollWin* top_win) : ScrollWin(title,x,y)
{
    childLT = NULL;
    childRB = NULL;
    splitter = NULL;
    splitterL = NULL;
    splitterR = NULL;
    splitterT = NULL;
    splitterB = NULL;
    wndGrey = NULL;
    splitMode = '-';
    showMode = 0;
    _splitting = 0;
    parent = NULL;
    maxWindow = NULL;
    leaf = top_win;
    if (leaf) {
        SetSplittersAround();
        leaf->SetSWParent(this);
        leaf->Show();
    }
}


SplitWindow::~SplitWindow()
{   HWND hWnd;


    if (leaf and leaf->IsValid()) {
        hWnd = (HWND) leaf->hWnd;
        leaf->DetachFromWindow();
        DestroyWindow(hWnd);
    }
    DeleteSplitters();
    //leaf->RestoreSWParent();
    /* Often, the leaf has already been destructed.  Some people */
    /* might consider the call to leaf->IsValid() to be a hack, */
    /* but it seems to do exactly what we need done here. */
}


void SplitWindow::SplitStart(char split_mode)
{
    _splitting = split_mode;
    wndGrey = new WindowGrey();
    ((WindowGrey*)wndGrey)->SetSWParent(this);
}


SplitWindow* SplitWindow::GetTopSplit()
{
    if (parent)
        return parent->GetTopSplit();
    return this;
}


void SplitWindow::SetWinToAdd(str win_code)
{
    _new_window = GetTopSplit()->CreateWin(win_code);
}


void SplitWindow::DoSplitEnd(char mode, void* _wndGrey)
{   POINT p;

    if (leaf) {
        _splitting = mode;
        wndGrey = _wndGrey;
        SplitEnd();
    }
    else {
        GetCursorPos(&p);
        ScreenToClient((HWND) hWnd, &p);
        if (p.x < 0)
            p.x = 0;
        if (p.y < 0)
            p.y = 0;
        if (p.x > clientWidth)
            p.x = clientWidth;
        if (p.y < clientHeight)
            p.x = clientHeight;
        ratio = splitMode == '-' ? (double) p.y/cy : (double) p.x/cx;
        if (splitMode == '|') {
            if (ratio < splitRatio)
                childLT->DoSplitEnd('R', wndGrey);
            else
                childRB->DoSplitEnd('L', wndGrey);
        }
        else {
            if (ratio < splitRatio)
                childLT->DoSplitEnd('B', wndGrey);
            else
                childRB->DoSplitEnd('T', wndGrey);
        }
    }
}


void SplitWindow::SplitEnd()
{   TfcGenericMenuItem* items=NULL;
    SplitWindow* Top;
    str win = NULL, *list;
    int i,whole;
    POINT p;

    //ClipCursor(NULL);

    if (not leaf) {
        if (childRB and childLT)
            DoSplitEnd(0,wndGrey);
        return;
    }

    Top = GetTopSplit();
    whole = (_splitting == 'B' or _splitting == 'T') ? cy : cx;
    if ((_splitting == 'B' or _splitting == 'R') and ratio*whole > whole - 16)
        goto FINAL;
    if ((_splitting == 'T' or _splitting == 'L') and ratio*whole < 16)
        goto FINAL;
    _new_window = NULL;
    list = Top->GetWindowList();

#if 0
    for (each_aeli(win, list))      // The original:
        ListAdd(items, TfcMenuItem(win, TfcCallback(&SplitWindow::SetWinToAdd, win)));
#else
    /* Tim has to do this horrible kludge to avoid a C2440 error in Valk2.exe.
    God knows why the above compiles in SMARTS app's. */
    union {
        SwVoidData_fn goo;
        void (SplitWindow::*hoo)(str);
    } u;
    u.hoo = &SplitWindow::SetWinToAdd;
    for (each_aeli(win, list))
        ListAdd(items, TfcMenuItem(win, TfcCallback(u.goo, (void*)win)));
#endif
    GetCursorPos(&p);
    ScreenToClient((HWND) hWnd, &p);
    PopupMenu(p.x, p.y-DialogHeight,items);
    TfcYield(yes);
    if (_new_window and _new_window != leaf)
        Top->Split(leaf, (ScrollWin*)_new_window, ratio, _splitting);
    _new_window = NULL;

    FINAL :
    delete ((WindowGrey*)wndGrey);
    wndGrey = NULL;
    _splitting = 0;
    Resized();
}


void SplitWindow::DoSplitDrag(int x, int y, char mode, void* _wndGrey)
{   POINT p;

    if (not _wndGrey)
        return;
    if (not leaf) {
        p.x = x; p.y = y;
        ScreenToClient((HWND) hWnd, &p);
        ratio = splitMode == '-' ? (double) p.y/cy : (double) p.x/cx;
        if (splitMode == '-') {
            if (ratio < splitRatio)
                childLT->DoSplitDrag(x,y,mode ? mode : 'B', _wndGrey);
            else
                childRB->DoSplitDrag(x,y,mode ? mode : 'T', _wndGrey);
        }
        else {
            if (ratio < splitRatio)
                childLT->DoSplitDrag(x,y,mode ? mode : 'R', _wndGrey);
            else
                childRB->DoSplitDrag(x,y,mode ? mode : 'L', _wndGrey);
        }
    }
    else {
        _splitting = mode;
        wndGrey = _wndGrey;
        ((WindowGrey*)wndGrey)->SetSWParent(this);
        SplitDrag(x,y);
        UpdateWindow((HWND)parent->_hWnd());
    }
}


void SplitWindow::SplitDrag(int x, int y)
{   RECT clipRect;
    double whole;
    POINT p;

    //if (not _splitting)
    //    return;
    p.x = x; p.y = y;
    if (not leaf) {
        DoSplitDrag(x,y,0,wndGrey);
        return;
    }

    GetClientRect(&clipRect);
    ClientToScreen((HWND) hWnd, (POINT*) &clipRect);
    ClientToScreen((HWND) hWnd, (POINT*) &clipRect.right);
    //ClipCursor(&clipRect);

    ScreenToClient((HWND) hWnd, &p);
    p.x = p.x < 0 ? 0 : p.x > clientWidth ? clientWidth : p.x;
    p.y = p.y < 0 ? 0 : p.y > clientHeight ? clientHeight : p.y;
    x = p.x; y = p.y;

    ClientToScreen((HWND) hWnd, &p);
    SetCursorPos(p.x, p.y);

    if (wndGrey == NULL)
        return;

    ScrollWin* grey;
    grey = (ScrollWin*) wndGrey;
    if (not grey)
        return;
    if (_splitting == 'L' or _splitting == 'R')
        ratio = (double) x/cx, whole = cx;
    else
        ratio = (double) y/cy, whole = cy;

    bool direction = _splitting == 'R' or _splitting == 'B';// yes if up (left)
                                                            // no  if down (right)
    int W=3;
    int W1=W+DialogHeight;

    whole = 0;
    switch (_splitting) {
    case 'B' :
        leaf->Move(W, W1, cx-2*W,  y-W1);
        grey->Move(W, y,  cx-2*W,  cy-y+DialogHeight-W);
        break;
    case 'T':
        leaf->Move(W,  y, cx-2*W, cy-y+DialogHeight-W);
        grey->Move(W , W1,cx-2*W, y-W1);
        break;
    case 'R' :
        leaf->Move(W,  W1, x-W,     cy-2*W);
        grey->Move(x,  W1, cx-x-W,  cy-2*W);
        break;
    case 'L' :
        leaf->Move(x, W1, cx-x-W,   cy-2*W);
        grey->Move(W, W1, x-W,      cy-2*W);
    }
    grey->Show();

    if (wndGrey == NULL)
        return;

    UpdateWindow((HWND) leaf->_hWnd());
    UpdateWindow((HWND) grey->_hWnd());
    UpdateWindow((HWND) hWnd);
}


bool SplitWindow::Mousestroke(int op, int x, int y)
{
    if (op == MOUSE_MOVE or op == MOUSE2_DRAG) {
        if (_splitting)
            SplitDrag(x,y);
    }
    return no;
}


void SplitWindow::AttachToWindow(void* _hWnd)
{   HWND hwnd;

    if (childLT and not childLT->hWnd) {
        hwnd = CreateWindow(("TfcSwin"), windowTitle,
                    WS_CHILDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    100, 100,
                    (HWND) _hWnd,
                    NULL, hInstance, NULL);

        childLT->AttachToWindow(hwnd);
    }

    if (childRB and not childRB->hWnd) {
        hwnd = CreateWindow(("TfcSwin"), windowTitle,
                    WS_CHILDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    100, 100,
                    (HWND) _hWnd,
                    NULL, hInstance, NULL);
        childRB->AttachToWindow(hwnd);
    }

    ScrollWin::AttachToWindow(_hWnd);

    if (leaf and not leaf->hWnd) {
        hwnd = CreateWindow("TfcSwin", windowTitle,
                    WS_CHILDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    100, 100,
                    (HWND) _hWnd,
                    NULL, hInstance, NULL);

        leaf->AttachToWindow(hwnd);
        leaf->Show();
        SetSplittersAround();
    }


    if (childLT and childRB)
        SetSplitMode(splitMode);
}


void SplitWindow::DetachFromWindow()
{   HWND hWnd;

    if (childLT and childLT->hWnd) {
        hWnd = (HWND) childLT->hWnd;
        childLT->DetachFromWindow();
        DestroyWindow(hWnd);
    }

    if (childRB and childRB->hWnd) {
        hWnd = (HWND) childRB->hWnd;
        childRB->DetachFromWindow();
        DestroyWindow(hWnd);
    }

    if (leaf and leaf->hWnd) {
        hWnd = (HWND) leaf->hWnd;
        leaf->DetachFromWindow();
        DestroyWindow(hWnd);
    }

    DeleteSplitters();
    ScrollWin::DetachFromWindow();
}


SplitWindow* SplitWindow::Find(ScrollWin* win)
{   SplitWindow* res;

    if (leaf == win)
        return this;

    if (childLT) {
        res = childLT->Find(win);
        if (res)
            return res;
    }

    if (childRB) {
        res = childRB->Find(win);
        if (res) return res;
    }

    return NULL;
}


void SplitWindow::Split(ScrollWin* win, ScrollWin* new_win, double ratio, char direction)
{   SplitWindow* sWin, *child1, *child2, *LT, *RB ;
    char mode;

    if (win == new_win)
        return;
    if (not win) {
        // if top-level window - just set ScrollWin
        new_win->SetSWParent(this);
        new_win->Show();
        leaf = new_win;
        SetSplittersAround();
        Resized(); // Must resize the leaf too
        return;
    }


    sWin = Find(win);
    child1 = Find(new_win);

    if (direction == 'L')
        mode = '|', LT = child1, RB = sWin ;
    else if (direction == 'R')
        mode = '|', LT = sWin, RB = child1 ;
    else if (direction == 'T')
        mode = '-', LT = child1, RB = sWin;
    else // if (direction == 'B')
        mode = '-', LT = sWin, RB = child1 ;


    if (child1) {
        SplitWindow* spw = child1->parent;

        if (spw)            // sometimes happens that we must just swap/rotate etc the same windows.
        {
            if ((spw->isLeft(sWin) and spw->isRight(child1)) or
                (spw->isLeft(child1) and spw->isRight(sWin)))
            {
                spw->SetSplitMode(mode);
                spw->splitRatio = ratio;
                spw->childLT = LT;
                spw->childRB = RB;
                return;
            }
            spw->Remove(child1);
        }
    }

    if (!sWin)
        sWin = this;

    sWin->leaf = NULL;
    child1 = new SplitWindow(sWin,new_win);
    child2 = new SplitWindow(sWin,win);

    if (direction == 'L')
        mode = '|', LT = child1, RB = child2 ;
    else if (direction == 'R')
        mode = '|', LT = child2, RB = child1 ;
    else if (direction == 'T')
        mode = '-', LT = child1, RB = child2 ;
    else // if (direction == 'B')
        mode = '-', LT = child2, RB = child1 ;

    sWin->SplitInternal(LT,RB,ratio,mode);
}


str SplitWindow::SavePositions(char dest[])
{
    return RecurseSavePositions(dest, this);
}


str SplitWindow::RecurseSavePositions(char dest[], SplitWindow* top )
/* Return a pointer to the '\0' at the end of the string. */
{   str s=dest;
    int ratio;

    if (not leaf) { // not leaf
        if (not childLT or not childRB) {
            strcpy(dest, "???");
            return dest; // some error occured
        }
        *s++ = '(';
        s = childLT->RecurseSavePositions(s, top);
        *s++ = splitMode;
        ratio = splitRatio * 100;
        *s++ = (ratio / 10) % 10 + '0';
        *s++ = ratio % 10 + '0';
        *s++ = '%';
        s = childRB->RecurseSavePositions(s, top);
        *s++ = ')';
        *s = '\0';
        return s;
    }
    else {
        s += sprintf(s, "%s", leaf->windowTitle);
        return s;
    }
}

// Use this to get the number of window splits in the application
int SplitWindow::GetNumWindowSplits()
{
int num_elements = 0;
if (not leaf) 
{ 
    if (not childLT or not childRB) 
    {   
        return 0; // some error occured
    }
   
    num_elements += childLT->GetNumWindowSplits();        
    num_elements++;            
    num_elements += childRB->GetNumWindowSplits();
    return num_elements;

}
else 
{
    return 0;
}
}

// pass an array of size GetNumWindowSplits() into this function
// Note, negative denotes horizontal splits
int SplitWindow::SavePositionsArray(double* arrays)
{
int num_elements = 0;
if (not leaf) 
{ 
    if (not childLT or not childRB) 
    {   
        return 0; // some error occured
    }
   
    num_elements += childLT->SavePositionsArray(&(arrays[num_elements]) );
    arrays[num_elements] = splitRatio;
    if (splitMode == '|')
        arrays[num_elements] = -arrays[num_elements];
    num_elements++;            
    num_elements += childRB->SavePositionsArray(&(arrays[num_elements]));
    return num_elements;    
}
else 
{
    return 0;
}
}

void SplitWindow::SetSplittersAround()
{
    assert(hWnd); // please, report to Natalija if this assert will arrise

    if (not splitterL)
        splitterL = new Splitter((HWND)hWnd,this, no, 'L');
    if (not splitterR)
        splitterR = new Splitter((HWND)hWnd,this, no, 'R');
    if (not splitterT)
        splitterT = new Splitter((HWND)hWnd,this, yes, 'T');
    if (not splitterB)
        splitterB = new Splitter((HWND)hWnd,this, yes, 'B');
}


void SplitWindow::DeleteSplitters()
{
    /* post messages to destroy splitters later, since now there's a chance
    that this function is called from splitter. */
    if (splitter)
        PostMessage(splitter->_hWnd(), WM_USER + 1,0,0);

    if (splitterL)
        PostMessage(splitterL->_hWnd(), WM_USER + 1,0,0);

    if (splitterR)
        PostMessage(splitterR->_hWnd(), WM_USER + 1,0,0);

    if (splitterT)
        PostMessage(splitterT->_hWnd(), WM_USER + 1,0,0);

    if (splitterB)
        PostMessage(splitterB->_hWnd(), WM_USER + 1,0,0);

    splitterL = NULL;
    splitterR = NULL;
    splitterT = NULL;
    splitterB = NULL;

    splitter = NULL;
}


void SplitWindow::RemoveAll()
{   HWND hWnd;

    if (childLT) {
        hWnd = (HWND) childLT->hWnd;
        childLT->RemoveAll();
        childLT->DetachFromWindow();
        DestroyWindow(hWnd);
        delete childLT;
        childLT = NULL;
    }

    if (childRB) {
        hWnd = (HWND) childRB->hWnd;
        childRB->RemoveAll();
        childRB->DetachFromWindow();
        DestroyWindow(hWnd);
        delete childRB;
        childRB = NULL;
    }

    DeleteSplitters();

    if (leaf) {
        hWnd = (HWND) leaf->hWnd;
        leaf->DetachFromWindow();
        DestroyWindow(hWnd);
    }
}


void SplitWindow::LoadWindows(str s)
{
    /* remove all existing windows first */
    RemoveAll();    // includes a DetachFromWindow().
    leaf = NULL;
    RecurseLoadWindows(s,this);
}

void SplitWindow::RecurseAdjustPositions(str& s, SplitWindow* top)
{
if (*s != '(') 
{   
    Split(NULL, top);
    return;
}
else
{
    if (not leaf)
    {
        double ratio;
        char op;
        assert (childLT && childRB);
        s++;
        childLT->RecurseAdjustPositions(s, top);
       
        op = *s;
        if (*s)
            s++;
        ratio = 0;
        while (IsUTF8Digit(*s))
            ratio = ratio*10 + (*s++ - '0');
        if (*s == '%')
            s++;
        ratio *= 0.01;
        if (ratio > 1.0 or ratio <= 0)
            ratio = 0.5;
        childRB->RecurseAdjustPositions(s, top);
        if (*s == ')')
            s++;
        SplitInternal(childLT,childRB,ratio, op);
    }
    else
    {
        assert(*s == '(');
        s++;
        assert(strncmp(s, "null", 4)==0);
        s+= 4;
        assert(*s == ')');
        s++;
    }
}
}

void SplitWindow::RecurseLoadWindows(str &s, SplitWindow* top)
/*this function can be called directly only in the begining of program*/
/*To restore windows positions when windows were already created */
/*and places  call LoadWindows                                  */
{   SplitWindow *left, *right;
    static int nEntryLvl;
    double ratio;
    char op;

    /*remove all existing window*/
    nEntryLvl++;

    /* Is it an atomic expression? */
    if (*s != '(') {
        char tmp[256], *d;
        for (d=tmp; not strchr("-|)", *s ) && (d-tmp) < 254; )
            *d++ = *s++;
        *d = '\0';
        ScrollWin* sw=top->CreateWin(tmp);
        assert(sw);
        Split(NULL, sw);
        return;
    }

    /* Is it a binary expression? */
    s++;
    left = new SplitWindow(this,NULL);
    left->RecurseLoadWindows(s, top);
    op = *s;
    if (*s)
        s++;
    ratio = 0;
    while (IsUTF8Digit(*s))
        ratio = ratio*10 + (*s++ - '0');
    if (*s == '%')
        s++;
    ratio *= 0.01;
    if (ratio > 1.0 or ratio <= 0)
        ratio = 0.5;
    right = new SplitWindow(this,NULL);
    right->RecurseLoadWindows(s, top);
    if (*s == ')')
        s++;
    SplitInternal(left,right,ratio, op);
}


void ScrollWin::RestoreSWParent()
{
    Hide();
    SetParent((HWND)hWnd,(HWND)NULL);
}


void ScrollWin::SetSWParent(ScrollWin* _parent)
{   HWND hOldParent, hWin, hNewParent;
    long Style;

    if (!_parent)
        return;

    hNewParent = (HWND) _parent->_hWnd();

    /*Create window*/
    if (!hWnd) {
        hWin = CreateWindow("TfcSwin", windowTitle,
                    WS_CHILDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    clientWidth+8, clientHeight+36,
                    hNewParent,
                    NULL, hInstance, NULL);
                /* Don't show it until the application is ready to show it. */

        AttachToWindow(hWin);

        Show();

    } else {
        Style = GetWindowLong((HWND)hWnd,GWL_STYLE);

        if (! (Style & WS_CHILD))
            SetWindowLong((HWND)hWnd,GWL_STYLE,WS_CHILD );

        hOldParent = GetParent((HWND)hWnd);

        // if this window is already child window  ->do nothing
        if (hOldParent != hNewParent)
            SetParent((HWND)hWnd,(HWND) hNewParent);
    }
}


void SplitWindow::MaximizeChild(ScrollWin* sWin)
{
    SplitWindow* win = Find(sWin);
    if (not win)
        return;
    maxWindow = win;
    if (win->parent)
        win->parent->MaximizeChild(win);
}


void SplitWindow::MaximizeChild(SplitWindow* win)
{
    if (win == childLT)
        ShowRight(false);
    else if (win == childRB)
        ShowLeft(false);
    else return;

    if (parent)
        parent->MaximizeChild(this);

    Resized();
}


void SplitWindow::RestoreChild()
{
    maxWindow = NULL;
    if (childRB)
        ShowRight(), childRB->RestoreChild();
    if (childLT)
        ShowLeft(),  childLT->RestoreChild();
    Resized();
}


void SplitWindow::SetSplitMode(char mode)
{

    splitMode = mode;

    DeleteSplitters();

    splitter = new Splitter((HWND)hWnd,this, splitMode == '-',0);
    Resized();
}


bool SplitWindow::isLeft(SplitWindow* win)
{
    return win == childLT;
}


bool SplitWindow::isRight(SplitWindow* win)
{
    return win == childRB;
}


void SplitWindow::Remove(ScrollWin* sWin)
{   SplitWindow* win, *spw;

    win = Find(sWin);
    if (not win)
        return;

    spw = win->parent;
    if (spw)
        spw->Remove(win);
}


int SplitWindow::Remove(SplitWindow* win)
{
    if (!win)
        return 0;
    if (isLeft(win))
        return removeLeft();
    if (isRight(win))
        return removeRight();

    return 0;
}


int SplitWindow::removeLeft()
{   SplitWindow* child;

    if (!childLT) return 0;
    if (!childRB and !parent) return 0; // can not remove last

    if (!childLT->leaf)
    {
        childLT->removeLeft();
        childLT->removeRight();
    }

    delete childLT;

    child = childRB;
    childLT = NULL;
    childRB = NULL;

    if (parent) {
        parent->Substitute(this,child);
        delete this;
        return 1;
    }
    else {
        if (child->leaf) {
            leaf = child->leaf;
            leaf->SetSWParent(this);
            child->leaf = NULL;
            PostMessage(splitter->_hWnd(), WM_USER + 1,0,0);
            SetSplittersAround();
            splitter = NULL;
        }
        else {
            SplitInternal(child->childLT,child->childRB,child->splitRatio, child->splitMode);
        }

        delete child;
        Resized();
        return 0;
    }
}


int SplitWindow::removeRight()
{   SplitWindow* child;

    if (!childRB)
        return 0;
    if (!childLT and !parent)
        return 0; // can not remove last (

    if (!childRB->leaf)
    {
        childRB->removeLeft();
        childRB->removeRight();
    }

    delete childRB;
    child = childLT;
    childRB = NULL;
    childLT = NULL;

    if (parent) {   /* simple node => replace it with left branch*/
        parent->Substitute(this,child);
        delete this;
        return 1;
    }
    else {
        if (child->leaf) {  /* left is leaf */
            leaf = child->leaf;
            leaf->SetSWParent(this);
            child->leaf = NULL;
            PostMessage(splitter->_hWnd(), WM_USER + 1,0,0);
            SetSplittersAround();
            splitter = NULL;
        }
        else {    /* left is node */
            SplitInternal(child->childLT,child->childRB,child->splitRatio, child->splitMode);
        }
        Resized();
        delete child;
    }

    return 0;
}


void SplitWindow::Substitute(SplitWindow* oldWin, SplitWindow* newWin)
{
    if (isLeft(oldWin))
        childLT = newWin;
    else
    if (isRight(oldWin))
        childRB = newWin;
    newWin->SetSWParent(this);
    newWin->parent = this;
    Resized();
}


void SplitWindow::ShowLeft(bool show)
{
    if (not childLT)
        return;
    showMode = show ? showMode | LEFT : showMode & ~LEFT;
}


void SplitWindow::ShowRight(bool show)
{
    if (not childRB)
        return;
    showMode = show ? showMode | RIGHT : showMode & ~RIGHT;
}


void SplitWindow::SplitInternal(SplitWindow* leftWin, SplitWindow* rightWin,
            double dividerLocation, char _splitMode)
{
    childLT = leftWin;
    childRB = rightWin;
    childLT->SetSWParent(this);
    childRB->SetSWParent(this);
    childLT->parent = this;
    childRB->parent = this;
    showMode = BOTH;

    splitRatio =  dividerLocation;

    SetSplitMode(_splitMode);
    if (childLT->leaf)
    {
        childLT->leaf->Show();
        childLT->leaf->Focus();
        childLT->SetSplittersAround();
    }
    if (childRB->leaf)
    {
        childRB->leaf->Show();
        childRB->leaf->Focus();
        childRB->SetSplittersAround();
    }
}


void SplitWindow::Resized()
{   int xSplit, ySplit;
    int W = 3;
    int r1,r2,rw,rh;
    int lw,lh;

    cx = clientWidth;
    cy = clientHeight;

    if (leaf) {
        MoveWindow((HWND)leaf->_hWnd(), W, DialogHeight+W, cx-2*W, cy-2*W, TRUE);

        MoveWindow(splitterL->_hWnd(), 0,     DialogHeight, W, cy, TRUE);
        MoveWindow(splitterR->_hWnd(), cx-W,  DialogHeight, W, cy, TRUE);
        MoveWindow(splitterT->_hWnd(), 0,     DialogHeight, cx, W, TRUE);
        MoveWindow(splitterB->_hWnd(), 0,     DialogHeight+ cy - W,       cx, W, TRUE);

        return;                                              // ^ not cy-DialogHeight. cy has already been adjusted
    }
    if (showMode == BOTH) { /* show left and right windows */
        if (splitMode == '|') {
            xSplit = cx * splitRatio;
            ySplit = cy;
            lw = xSplit;
            lh = cy;
            r1 = xSplit + splitWidth;
            r2 = DialogHeight;
            rw = cx - xSplit - splitWidth/* * splitRatio*/;
            rh = cy;
        }
        else {    // '-'
            xSplit = cx;
            ySplit = cy * splitRatio;
            lw = cx;
            lh = ySplit;
            r1 = 0;
            r2 = DialogHeight + ySplit + splitWidth;
            rw = cx;
            rh = cy - ySplit - splitWidth;
        }

        if (xSplit < 0) xSplit = 0;
        if (ySplit < 0) ySplit = 0;

        if (childLT)
            MoveWindow((HWND)childLT->_hWnd(), 0, DialogHeight, lw, lh, TRUE);
        if (childRB)
            MoveWindow((HWND)childRB->_hWnd(), r1, r2, rw, rh, TRUE);

        if (splitter)
            splitMode == '|' ?
                    splitter->Move(xSplit, DialogHeight, splitWidth, cy) :
                    splitter->Move(0, DialogHeight+ ySplit, cx,splitWidth);
    }
    else {
        if (showMode & LEFT) {      /* maximize left window */
            if (childLT)
                MoveWindow((HWND)childLT->_hWnd(), 0, DialogHeight, cx, cy, TRUE);
        }
        else if (showMode & RIGHT) {   /* maximize right window */
            if (childRB)
                MoveWindow((HWND)childRB->_hWnd(), 0, DialogHeight, cx, cy, TRUE);
        }
    }

    if (childRB)
        showMode & RIGHT ? childRB->Show() : childRB->Hide();
    if (childLT)
        showMode & LEFT  ? childLT ->Show() : childLT ->Hide();



    // if splitter doesn't need to be shown then hide it
    if (splitter)
        splitter->Show(showMode == BOTH);
}


bool SplitWindow::DeleteChild()
{   SplitWindow *currentParent = this;

    while (currentParent and currentParent->parent)
        currentParent = currentParent->parent;
    return not currentParent->disableChildDelete;
}


void SplitWindow::MoveSplitter(double x)
{   int whole;

    // (awa) Added some code to disable the auto deletion of windows
    // because a lot of apps use splitwin, but they don't want the
    // Children mysteriously disappearing on them.

    double previousSplitRatio = splitRatio;
    splitRatio = x;
    whole = splitMode == '|' ? cx : cy;

    if (splitRatio*whole < 16)
    {
        if (DeleteChild())
        {
            removeLeft();
            return;
        }
        else
            splitRatio = previousSplitRatio;
    }
    else if (splitRatio*whole > whole  - 16) {
        if (DeleteChild()) {
            removeRight();
            return;
        }
        else
            splitRatio = previousSplitRatio;
    }

    Resized();
}


void SplitWindow::MoveSplitter(int x, bool include_rebar)
{
    int d = (splitMode == '|') ? cx : cy;
    if (include_rebar)
        x -= DialogHeight;
    MoveSplitter((double) x  / d) ;
}


void SplitWindow::GetClientRect(void * _rect)
{   RECT* rect = (RECT*) _rect;

    rect->top = DialogHeight;
    rect->bottom = clientHeight + DialogHeight;
    rect->left = 0;
    rect->right = clientWidth;
}


bool SplitWindow::Keystroke(int key)
{
    if (key == WINDOW_QUIT) {
        delete this;
// This should be left to the derived class of the main window.
// You might want to delete a SplitWindow but not quit.

        //this causes too many applications to break:
        //Kieran, can't you just derive this yourself
        //and get rid of the PostQuitMessage?

       PostQuitMessage(0);
    }
    return no;
}


void SplitWindow::Split(ScrollWin *origWin, ScrollWin* newWin, int x, int y)
/* You don't have to use this function, but if you like our 'diagonal */
/* cross method of specifying window placement, then you can use this */
/* to interpret the mouse positions. */
{   double ratio;
    char quarter;

    int cx = origWin->clientWidth;
    int cy = origWin->clientHeight;

	origWin->MapXYToWindowCoords(&x,&y);
    // Check in which quarter the mouse was pressed
    // ---------
    //| \  T / |
    //|  \  /  |
    //| L \/ R |
    //   /  \  |
    //| /  B \ |
    // ---------

    quarter = (float)y/cy - (float)x/cx < 0 ? 14 : 32;
    if ((float)y/cy + (float)x/cx - 1 < 0 )
        quarter = (quarter == 14) ? 'T' : 'L';
    else
        quarter = (quarter == 14) ? 'R'  : 'B';

    /* Depending on quarter - set split mode,  */
    /* left & right windows and calculate ratio */
    switch (quarter) {
            case 'T':
                    ratio = 2.*y/cy;
                    if (ratio > 0.5) ratio = 0.5;
                    break;
            case 'B':
                    ratio = 2.*y/cy - 1;
                    if (ratio < 0.5) ratio = 0.5;
                    break;
            case 'L':
                    ratio = (double)2.*x/cx;
                    if (ratio > 0.5) ratio = 0.5;
                    break;
            case 'R':
                    ratio =  2.*x/cx - 1;
                    if (ratio < 0.5) ratio = 0.5;
                    break;
            // Should never happen - just fixes compiler warning for uninitialised var
            default:
                    ratio = 0.0;
                    break;
    }

    /* Actually do the split: */
    Split(origWin,newWin,ratio,quarter);
}


/*----------------- Popup message Boxes -----------------*/

struct PopWVars {
	wchar_t       *pText;
	wchar_t       *pTitle;
	HFONT         hBoldFont;
	TfcCallback   OnExit;
	unsigned char MRule;
	unsigned char Flags;
	RECT		  Rect;
};

#define POPWSTYLES        (WS_VISIBLE | WS_POPUP)
#define POPWTXTSTYLE      (DT_LEFT | DT_NOCLIP | DT_EXPANDTABS | DT_NOPREFIX)
#define POPW_MOVED        1
#define POPW_HARDY        2
#define POPW_TRANSPARENT  4

static LRESULT CALLBACK PopWProc(
     HWND HWnd,              // handle of window
     UINT uMsg,              // message identifier
     WPARAM wParam,          // first message parameter
     LPARAM lParam           // second message parameter
  )
{
	PopWVars            *pPWVars;
	LRESULT             Result = 0;
	static LPARAM MousePos = -1;

	pPWVars = (PopWVars*)GetWindowLong(HWnd, GWL_USERDATA);
	if (pPWVars == NULL)
		return DefWindowProc(HWnd, uMsg, wParam, lParam);
	switch (uMsg) {
	 case WM_LBUTTONDOWN:
	 case WM_MBUTTONDOWN:
	 case WM_RBUTTONDOWN:
	 {
		 MousePos = lParam;
		 response = 0;
		 SetCapture(HWnd);
		 break;
	 }
	 case WM_LBUTTONUP:
	 case WM_MBUTTONUP:
	 case WM_RBUTTONUP:
	 {
		 bool  DismissClick;

		 ReleaseCapture();
		 if (pPWVars->Flags & POPW_HARDY)
			 SetFocus(GetParent(HWnd));
		 MousePos = -1;
		 DismissClick = (pPWVars->Flags & POPW_MOVED) == 0;
		 pPWVars->Flags &= ~POPW_MOVED;
		 if (DismissClick)
		 {
			 DestroyWindow(HWnd);
		 }
		 break;
	 }
	 case WM_MOUSEMOVE:
	 {
		 if (GetCapture() == HWnd) {
			 if (MousePos < 0)
				 MousePos = lParam;
			 GetWindowRect(HWnd, &pPWVars->Rect);
			 OffsetRect(&pPWVars->Rect,
						 (short)LOWORD(lParam) - (short)LOWORD(MousePos),
						 (short)HIWORD(lParam) - (short)HIWORD(MousePos));
			 MoveWindow(HWnd, pPWVars->Rect.left, pPWVars->Rect.top, pPWVars->Rect.right - pPWVars->Rect.left, 
							pPWVars->Rect.bottom - pPWVars->Rect.top, true);
			 pPWVars->Flags |= POPW_MOVED;
		 }
		 break;
	 }
	 case WM_PAINT:
	 {
		 HDC          hDC;
		 PAINTSTRUCT  PaintStruct;
		 RECT         ClientRect;
		 HFONT        hSaveFont;

		 hDC = BeginPaint(HWnd, &PaintStruct);
		 if (hDC)
		 {
			 GetClientRect(HWnd, &ClientRect);
			 DrawEdge(hDC, &ClientRect, BDR_RAISEDINNER, BF_RECT);

			 if (pPWVars->Flags & POPW_TRANSPARENT)
			 {
				SetBkMode(hDC, TRANSPARENT);
				SetROP2(hDC,R2_MERGEPEN);
			 }

			 HBRUSH hBrush = GetBrush(tfc_colour, GetSysColor(COLOR_3DFACE));
			 SelectObject(hDC, hBrush);
			 SelectObject(hDC, (HPEN)GetStockObject(NULL_PEN));

			 Rectangle(hDC, 0,0,ClientRect.right, ClientRect.bottom);

			 SetBkColor(hDC, GetSysColor(COLOR_3DFACE));

			 InflateRect(&ClientRect, -pPWVars->MRule / 2, -pPWVars->MRule / 2);

			 hSaveFont = (HFONT) SelectObject(hDC, GetStockObject(DEFAULT_GUI_FONT));

			 SetBkMode(hDC, TRANSPARENT);
			 if (pPWVars->pTitle)
			 {
				 SelectObject(hDC, pPWVars->hBoldFont);
				 ClientRect.top +=
					DrawTextW(hDC, pPWVars->pTitle, wcslen(pPWVars->pTitle), &ClientRect, POPWTXTSTYLE);
				 SelectObject(hDC, GetStockObject(DEFAULT_GUI_FONT));
			 }

			 if (pPWVars->pText)
			 {
				 DrawTextW(hDC, pPWVars->pText, wcslen(pPWVars->pText), &ClientRect, POPWTXTSTYLE);
			 }
			 SelectObject(hDC, hSaveFont);
			 EndPaint(HWnd, &PaintStruct);
		 }
		 break;
	 }
	 case WM_KILLFOCUS:
	 case WM_SYSKEYDOWN:
	 {
		 if (!(pPWVars->Flags & POPW_HARDY))
			 DestroyWindow(HWnd);
		 break;
	 }
	 case WM_KEYDOWN:
		 response = TranslateExtended(wParam);
		 break;

	 case WM_CHAR:
		 response = wParam;
		 if (response == CTRL('C') or response == CTRL_(INS))
			ClipboardSetText(pPWVars->pText);
		 if (!(pPWVars->Flags & POPW_HARDY))
			 DestroyWindow(HWnd);
		 break;

	 case WM_LBUTTONDBLCLK:
	 case WM_MBUTTONDBLCLK:
	 case WM_RBUTTONDBLCLK:
	 {
		 DestroyWindow(HWnd);
		 break;
	 }
	 case WM_DESTROY:
	 {
		 if (pPWVars->pText)
			 free(pPWVars->pText);

		 if (pPWVars->pTitle)
			 free(pPWVars->pTitle);

		 if (pPWVars->hBoldFont)
			 DeleteObject(pPWVars->hBoldFont);

		 if (GetCapture() == HWnd)
			 ReleaseCapture();

		 pPWVars->OnExit(ScrollWin::SwFromWnd(GetParent(HWnd)), NULL);
		 delete pPWVars;

		 break;
	 }
	 default:
		 Result = DefWindowProc(HWnd, uMsg, wParam, lParam);
		 break;
	}
	return Result;
}


interface void TfcPopUpRect(int PopInt, TfcRect *pRect)
// Returns the coordinates of this popup in screen coords
{
	HWND hWnd = (HWND)PopInt;
    if (pRect && IsWindow(hWnd)) {
        RECT WinRect;
        GetWindowRect(hWnd, &WinRect);
        pRect->top = WinRect.top;
        pRect->left = WinRect.left;
        pRect->right = WinRect.right;
        pRect->bottom = WinRect.bottom;
    }
}


interface void TfcPopDown(int PopInt)
{
     if (PopInt && IsWindow(((HWND)PopInt)))
         DestroyWindow(((HWND)PopInt));
}


interface int TfcPopUpBox(int XPos, int YPos, bool bHardy, TfcCallback OnExit, const char *Title, const char *Text, ...)
/* Create and display a Popup window. Copy Text to a strduped buffer,   */
/* and put the buffer pointer in window extra membory.                  */
{
     HWND         hFocus;
     HWND         HWnd;
     HDC          hDC;
     RECT         Pos, TempRect = {0};
     HINSTANCE    hAppInst;
     PopWVars     *pPWVars;            // Member vars for the PopW
     char         TextBuf[4096];
     va_list      ap;
     LOGFONT      LogBoldFont;
     HFONT        hSaveFont;
     static ATOM  PopWAtom = 0;

     hFocus = GetFocus();
     if (!hFocus)
         return 0;

     HWnd = NULL;
     hAppInst = (HINSTANCE)GetWindowLong(hFocus, GWL_HINSTANCE);

     // Register the window class if you need to
     if (!PopWAtom) {
         WNDCLASSEX WndClass;

         WndClass.cbSize = sizeof(WndClass);
         WndClass.style = CS_DBLCLKS;
         WndClass.lpfnWndProc = PopWProc;
         WndClass.cbClsExtra = 0;
         WndClass.cbWndExtra = 0;
         WndClass.hInstance = hAppInst;
         WndClass.hIcon = NULL;
         WndClass.hCursor = NULL;
         WndClass.hbrBackground = (HBRUSH)(COLOR_WINDOW);
         WndClass.lpszMenuName = NULL;
         WndClass.lpszClassName = "PopW";
         WndClass.hIconSm = NULL;

         PopWAtom = RegisterClassEx(&WndClass);
         if (!PopWAtom)
             return 0;
     }

     // Make the window
     HWnd = CreateWindowEx(
             0,                   // no extended styles
             (char *)PopWAtom,    // class "name"
             NULL,                // window name
             POPWSTYLES,          // WS_CONSTANTS, #defined above
             0,                   // horizontal position
             0,                   // vertical position
             0,                   // width
             0,                   // height
             hFocus,              // parent/owner
             (HMENU) NULL,        // class menu used
             hAppInst,            // instance handle
             NULL);               // no window creation data
     if (HWnd == NULL)
         return 0;

     pPWVars = new PopWVars;
     memset(pPWVars, 0, sizeof(PopWVars));
     if (bHardy)
         pPWVars->Flags |= POPW_HARDY;
     pPWVars->OnExit = OnExit;
     SetWindowLong(HWnd, GWL_USERDATA, (LONG)pPWVars);

     // Format the text string with any param list given
     if (Text) {
         va_start(ap, Text);
         vsnprintf(TextBuf, sizeof(TextBuf), Text, ap);
         va_end(ap);
         pPWVars->pText = ToWideStrdup(TextBuf);
     }

     if (Title) {
         GetObject((HFONT)GetStockObject(DEFAULT_GUI_FONT),
                            sizeof(LOGFONT), &LogBoldFont);
         LogBoldFont.lfWeight = FW_BOLD;

         pPWVars->hBoldFont = CreateFontIndirect(&LogBoldFont);
         pPWVars->pTitle    = ToWideStrdup(Title);
     }

     Pos.left      = XPos;
     Pos.top       = YPos;
     Pos.right     = XPos;
     Pos.bottom    = YPos;

     // Calculate the size of the thing according to the strings provided
     hDC = GetDC(HWnd);
     if (hDC) {
         hSaveFont = (HFONT) SelectObject(hDC, GetStockObject(DEFAULT_GUI_FONT));
         // Size of the popup's title
         if (Title) {
             SelectObject(hDC, pPWVars->hBoldFont);
             DrawTextW(hDC, pPWVars->pTitle, wcslen(pPWVars->pTitle),
                            &TempRect,
                            DT_CALCRECT | POPWTXTSTYLE);
             SelectObject(hDC, GetStockObject(DEFAULT_GUI_FONT));
         }

         // Size of the popup's text
         if (Text) {
             DrawTextW(hDC, pPWVars->pText, wcslen(pPWVars->pText), &Pos,
                              DT_CALCRECT | POPWTXTSTYLE);
         }

         Pos.bottom += TempRect.bottom;
         if (TempRect.right > Pos.right - Pos.left)
             Pos.right = Pos.left + TempRect.right;

         // Half an m rule around the edges
         DrawText(hDC, "m", 1, &TempRect, DT_CALCRECT);
         TempRect.right++;
         pPWVars->MRule = TempRect.right;
         Pos.right     += TempRect.right;
         Pos.bottom    += TempRect.right;
         AdjustWindowRect(&Pos, POPWSTYLES, false);
         SelectObject(hDC, hSaveFont);
         ReleaseDC(HWnd, hDC);
     }

     // Make sure the popup is fully on the desktop
     memset(&TempRect, 0, sizeof(RECT));

     SystemParametersInfo(SPI_GETWORKAREA, 0, (void *)&TempRect, 0);

     // This section is commented out to cope with multiple display monitor
     // It has the unfortunate effect of always putting the popup box in the main
     // screen, even though if the application is running on another screen

/*
     if (Pos.right > TempRect.right) {
         Pos.left     -= Pos.right - TempRect.right;
         Pos.right    -= Pos.right - TempRect.right;
     }
     if (Pos.bottom > TempRect.bottom) {
         Pos.top    -= Pos.bottom - TempRect.bottom;
         Pos.bottom -= Pos.bottom - TempRect.bottom;
     }
*/
     // And finally apply the calculated position
     MoveWindow(HWnd, Pos.left, Pos.top, Pos.right - Pos.left,
                            Pos.bottom - Pos.top, true);
     ShowWindow(HWnd, SW_SHOWNORMAL);
     UpdateWindow(HWnd);

     if (bHardy)
         SetFocus(hFocus);

     // Don't set capture unless there's a mouse button down
     if (GetKeyState(VK_LBUTTON) < 0 || GetKeyState(VK_MBUTTON) < 0 || GetKeyState(VK_RBUTTON) < 0)
         SetCapture(HWnd);

     return (int)HWnd;
}


int Litewin::PopUpBox(int XPos, int YPos, bool bHardy, TfcCallback OnExit, const char *Title, const char *Text, ...)
{   char buf[4096];
    va_list ap;

    va_start(ap, Text);
    vsnprintf(buf, sizeof(buf), Text, ap);
    va_end(ap);
    MapXYToScreenCoords(&XPos,&YPos);
    return ::TfcPopUpBox(XPos,YPos,bHardy,OnExit, Title, "%s", buf);
}


int Litewin::PopUpBox(int XPos, int YPos, const char *Title, const char *Text, ...)
{   char buf[4096];
    va_list ap;

    va_start(ap, Text);
    vsnprintf(buf, sizeof(buf), Text, ap);
    va_end(ap);
    MapXYToScreenCoords(&XPos,&YPos);
    return ::TfcPopUpBox(XPos,YPos,no,0, Title, "%s", buf);
}


void Litewin::PopUpRect(int PopInt, TfcRect *rect)
{
	int XPos=10000,YPos=10000;			// The point of the '10000' is to get past any "dontScroll" region.
	TfcPopUpRect(PopInt, rect);
    MapXYToScreenCoords(&XPos,&YPos);
	XPos -= 10000;
	YPos -= 10000;
	rect->top -= YPos;
	rect->left -= XPos;
	rect->right -= XPos;
	rect->bottom -= YPos;
}





/*---------- CanvasSprite function -------------------*/

void* CreateMaskBitmap(void* bmp, int width, int height, int mask_colour)
{   HBITMAP hbmMask, hbmImage, oldSrcBmp, oldDstBmp;
    int oldBkColor, oldTextColor;
    HDC hdcSrc ,hdcDst;

    hbmImage = (HBITMAP) bmp;

    //  create mono bitmap
    hbmMask = CreateBitmap(width,height,1,1,NULL);

    // create 2 memory DC
    hdcSrc = CreateCompatibleDC(NULL);
    hdcDst = CreateCompatibleDC(NULL);

    oldSrcBmp = (HBITMAP) SelectObject(hdcSrc,hbmImage);
    oldDstBmp = (HBITMAP) SelectObject(hdcDst,hbmMask);

    // if mask colour is not specified - take top-left point colour
    if (mask_colour == NOCOLOUR)
        mask_colour = GetPixel(hdcSrc,0,0);

    // draw on mask bitmap
    // (pixels that corresponds to transparent colour marked as background,
    // pixels of all other colours - as foreground)
    oldBkColor = SetBkColor(hdcSrc,mask_colour);

    BitBlt(hdcDst,0,0,width,height,hdcSrc,0,0,SRCCOPY);

    // remove transparence colour on image bitmap
    // (pixels that had transparent colour become black
    //            [BLACK AND trans_colour = BLACK]
    //  other pixels remain unchanged)
    //            [WHITE AND colour = colour]

    oldTextColor = SetTextColor(hdcSrc,WHITE);
    SetBkColor(hdcSrc,BLACK);

    BitBlt(hdcSrc,0,0,width,height,hdcDst,0,0,SRCAND);

    // delete unnessesary DCs
    SetTextColor(hdcDst,oldTextColor);
    SetBkColor(hdcSrc,oldBkColor);
    SelectObject(hdcSrc,oldSrcBmp);
    SelectObject(hdcDst,oldDstBmp);

    DeleteDC(hdcSrc);
    DeleteDC(hdcDst);
    return hbmMask;
}


void DeleteBitmap(void* bmp)
{
    DeleteObject((HBITMAP) bmp);
}


void Litewin::DrawTransparentBitmap(int x1, int y1, int x2, int y2,
                             void* bmpImg, void* bmpMsk)
{   TfcPaintDetails paintDetails;
	int oldBkClr, oldTxtClr;
	
	GetPaintDetails(&paintDetails, x1,y1);
    HDC hdcMem = CreateCompatibleDC(NULL);
    HBITMAP hbmMask = (HBITMAP)bmpMsk, hbmImage = (HBITMAP)bmpImg;
    HBITMAP hbmT = (HBITMAP) SelectObject(hdcMem,hbmMask);

    oldBkClr = SetBkColor((HDC)paintDetails.hDC,WHITE);
    oldTxtClr = SetTextColor((HDC)paintDetails.hDC,BLACK);

    // Draw mask  - image pixels become black
    // others remain unchanged
    BitBlt((HDC)paintDetails.hDC, paintDetails.winX + x1, paintDetails.winY + y1,
						x2 - x1, y2 - y1,hdcMem,0,0,SRCAND);

    // Draw image
    SelectObject(hdcMem,hbmImage);
    BitBlt((HDC)paintDetails.hDC, paintDetails.winX + x1, paintDetails.winY + y1,
						x2 - x1, y2 - y1, hdcMem,0,0,SRCPAINT);

    // Now, clean up.
    SetBkColor((HDC)paintDetails.hDC, oldBkClr);
    SetTextColor((HDC)paintDetails.hDC, oldTxtClr);
    SelectObject(hdcMem,hbmT);
    DeleteDC(hdcMem);
}



static int CreateBMPFile(LPTSTR pszFile, HBITMAP hBmp, HDC hDC)
{   HANDLE hf;                 // file handle
    BITMAPFILEHEADER hdr;       // bitmap file-header
    PBITMAPINFOHEADER pbih;     // bitmap info-header
    LPBYTE lpBits;              // memory pointer
    DWORD dwTotal;              // total count of bytes
    DWORD cb;                   // incremental count of bytes
    BYTE *hp;                   // byte pointer
    DWORD dwTmp;
    int error;

    PBITMAPINFO pbi = CreateBitmapInfoStruct(hBmp,8);
    if (pbi == NULL)
        return ERROR_OUTOFMEMORY;
    pbih = (PBITMAPINFOHEADER)pbi;
    if (!pbih)
        return ERROR_OUTOFMEMORY;
    lpBits = (LPBYTE)GlobalAlloc(GMEM_FIXED, pbih->biSizeImage);
    if (lpBits == NULL)
         return ERROR_OUTOFMEMORY;

    // Retrieve the color table (RGBQUAD array) and the bits
    // (array of palette indices) from the DIB.
   if (!GetDIBits(hDC, hBmp, 0, (WORD) pbih->biHeight, lpBits, pbi,
                    DIB_RGB_COLORS)) {
        GlobalFree(lpBits);
        free(pbi);
        error = GetLastError();
        if (error == 0)
            error = -1;
        return error;
    }

        // for some reason it's reseted in Windows NT
        // so - assign again
    if (pbih->biClrUsed == 0 && pbih->biBitCount != 24)
        pbih->biClrUsed = (1<<pbih->biBitCount);


    // Create the .BMP file.
    hf = CreateFile(pszFile,
               GENERIC_READ | GENERIC_WRITE,
               (DWORD) 0,
                NULL,
               CREATE_ALWAYS,
               FILE_ATTRIBUTE_NORMAL,
               (HANDLE) NULL);
    if (hf == INVALID_HANDLE_VALUE) {
        GlobalFree(lpBits);
        free(pbi);
        error = GetLastError();
        if (error == 0)
            error = -1;
        return error;
    }

    hdr.bfType = 0x4d42;        // 0x42 = "B" 0x4d = "M"
    // Compute the size of the entire file.
    hdr.bfSize = (DWORD) (sizeof(BITMAPFILEHEADER) +
             pbih->biSize + pbih->biClrUsed
             * sizeof(RGBQUAD) + pbih->biSizeImage);
    hdr.bfReserved1 = 0;
    hdr.bfReserved2 = 0;

    // Compute the offset to the array of color indices.
    hdr.bfOffBits = (DWORD) sizeof(BITMAPFILEHEADER) +
                pbih->biSize + pbih->biClrUsed
                * sizeof (RGBQUAD);

    // Copy the BITMAPFILEHEADER into the .BMP file.
    WriteFile(hf, (LPVOID) &hdr, sizeof(BITMAPFILEHEADER),
                    (LPDWORD) &dwTmp,  NULL);

    // Copy the BITMAPINFOHEADER into the file.
    WriteFile(hf, (void*) pbih, sizeof(BITMAPINFOHEADER),
                        &dwTmp, ( NULL));

    // Copy RGBQUAD array  into the file
    WriteFile(hf, (char*) pbih + pbih->biSize,
              pbih->biClrUsed * sizeof (RGBQUAD),
               &dwTmp, ( NULL));

    // Copy the array of color indices into the .BMP file.
    dwTotal = cb = pbih->biSizeImage;
    hp = lpBits;
    WriteFile(hf, (LPSTR) hp, (int) cb, (LPDWORD) &dwTmp,NULL);

    // Clean up:
    CloseHandle(hf);
    free(pbi);
    GlobalFree(lpBits);

    return no;
}



/*---------- A bitmap ScrollWin, for printing a bitmap (of a window capture) -------------------*/

class BmpScrollWin : public ScrollWin {
public:
    BmpScrollWin(HBITMAP hBmp);
    ~BmpScrollWin();
    void Paint(int x1, int y1, int x2, int y2);
    void Resized();

    HBITMAP hBmp;
    PBITMAPINFO pbi;
    BYTE* pBits;
    HANDLE pBitsHnd;
};


BmpScrollWin::BmpScrollWin(HBITMAP _hBmp) : ScrollWin(NULL, 10, 10)
{
    hBmp = _hBmp;
    pbi = CreateBitmapInfoStruct(hBmp);
    pBits = 0;
}


BmpScrollWin::~BmpScrollWin()
{
    free(pbi);
    if (pBits)
        GlobalFree(pBits);
        //delete[] pBits;
}


void BmpScrollWin::Paint(int x1, int y1, int x2, int y2)
{   float   fScaleX, fScaleY;
    int     iWidth, iHeight;
    BITMAP  sBmp;
    HDC     hDC;

    if (not pBits) {
        // SnazzyHeap is incompatible with the Win32 bitmap functions,
        // something we discovered empirically.  It all works if
        // we use GlobalAlloc() instead in certain places.
        pBits = (BYTE*)GlobalAlloc(GMEM_FIXED, pbi->bmiHeader.biSizeImage + 100);
        /* "Memory objects allocated with GMEM_FIXED always have a lock count
        of zero. For these objects, the value of the returned pointer is equal
        to the value of the specified handle. */
        //new BYTE[pbi->bmiHeader.biSizeImage + 100];
        HDC hDc = (HDC) FindDC();
        GetDIBits(hDc,hBmp,0,pbi->bmiHeader.biHeight,pBits,pbi,DIB_RGB_COLORS);
    }
    if (GetObject(hBmp, sizeof(BITMAP), (LPVOID)&sBmp)) {
        DrawRectangle(0, 0, clientWidth, clientHeight, WHITE, NOCOLOUR);

        fScaleX = (float)clientWidth / sBmp.bmWidth;
        fScaleY = (float)clientHeight / sBmp.bmHeight;

        if (fScaleX > fScaleY)
            fScaleX = fScaleY;
        else fScaleY = fScaleX;

        iWidth = sBmp.bmWidth * fScaleX;
        iHeight = sBmp.bmHeight * fScaleY;

        hDC = (HDC)FindDC();

        StretchDIBits(hDC,(clientWidth - iWidth) / 2, (clientHeight - iHeight) / 2,
            iWidth, iHeight,
            0,0,pbi->bmiHeader.biWidth, pbi->bmiHeader.biHeight,
            pBits,pbi,DIB_RGB_COLORS,SRCCOPY);
    }
}


void BmpScrollWin::Resized() // Process the message that the clientRect has changed.
{     // Will be called before printing
    realWidth = clientWidth;
    realHeight = clientHeight;
}


#ifdef JPEG
extern "C" int jsave_file(const char* fileName,
            unsigned char *dataBuf,
            unsigned int widthPix,
            unsigned int height,
            int color,
            int quality);


static int CreateJPEGFile(LPCTSTR pszFile, HBITMAP hBmp, HDC hDC)
{   BYTE *pBits, *pBitsJPG, tmp;
    LPBYTE pRed, pGrn, pBlu;
    PBITMAPINFOHEADER pbh;
    PBITMAPINFO pbi;
    int j, rowSize;
    bool result;
    int error;

    pbi = CreateBitmapInfoStruct(hBmp,24);
    pbh = (PBITMAPINFOHEADER) pbi;
    pBits = (unsigned char*)GlobalAlloc(GMEM_FIXED, pbh->biSizeImage);
    if (pBits == NULL)
        return ERROR_OUTOFMEMORY;
    pBitsJPG = (unsigned char*)calloc(2,pbh->biSizeImage);

    if (not GetDIBits(hDC,hBmp,0,pbh->biHeight,pBits,pbi,DIB_RGB_COLORS)) {
        GlobalFree(pBits);
        free(pBitsJPG);
        free(pbi);
        error = GetLastError();
        if (error == 0)
            error = -1;
        return error;
    }

    // Bitmap Width must be 4-byte aligned
    rowSize = 4* (int) ((3*pbh->biWidth+4-1)/4);

    // Flip Bitmap Vertical
    for (j=0; j< pbh->biHeight; j++)
        memcpy(pBitsJPG + 3*pbh->biWidth*j, pBits + rowSize*
                            (pbh->biHeight-j-1), rowSize);

    // convert to BGR
    for (int row=0;row<pbh->biHeight;row++) {
        for (int col=0;col<pbh->biWidth;col++) {
            pRed = pBitsJPG + row * pbh->biWidth * 3 + col * 3;
            pGrn = pBitsJPG + row * pbh->biWidth * 3 + col * 3 + 1;
            pBlu = pBitsJPG + row * pbh->biWidth * 3 + col * 3 + 2;
            tmp = *pRed;
            *pRed = *pBlu;
            *pBlu = tmp;
        }
    }

    // Call the JPEG library:
    result = jsave_file(pszFile,
                        pBitsJPG,
                        pbh->biWidth,
                        pbh->biHeight,
                        1,
                        75) != 0;

    // Finish up:
    GlobalFree(pBits);
    free(pBitsJPG);
    return not result;
}


#else

static int CreateJPEGFile(LPCTSTR pszFile, HBITMAP hBmp, HDC hDC)
{
    TfcMessage("Jpeg not available", 'x',
            "The Jpeg library has not been linked into this program.");
    return no;
}

#endif

HBITMAP TfcCreateBitmap(HDC hDC, int width, int height)
{
	BITMAPINFO info;
	clearS(info);
	info.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	info.bmiHeader.biHeight = height;
	info.bmiHeader.biWidth = width;
	info.bmiHeader.biPlanes = 1;
	info.bmiHeader.biBitCount = 24;
	info.bmiHeader.biCompression = BI_RGB;
	info.bmiHeader.biSizeImage = 0;
	void* lpBits = NULL;
	return CreateDIBSection(hDC, &info, DIB_RGB_COLORS, &lpBits, NULL, 0);
}


bool ScrollWin::SaveSnapshot(str filename, bool UseDialogBox/*=yes*/, bool IncludeFrame/*=yes*/, bool ForPrinting/*=no*/,
                         str header, str footer, void (*pFunc)(str s, char dest[])/*=NULL*/,
                         void (*pFunc2)(void* ptr, int SheetLeft, int SheetRight, int SheetTop, int SheetBottom, bool leftLogo, bool topLogo)/*=NULL*/)
{   HBITMAP hBmpNew,hBmpOld;
    int x0=0, y0=0, error=0;
    char szFilename[256];
    HDC hDc, hMemDc;
    RECT screenRe;
    RECT rect;

    if (filename)
        strcpy(szFilename, filename);
    else szFilename[0] = '\0';

    if (UseDialogBox and not ForPrinting) {
        filename = TfcSelectFilename(yes/*save*/,
                      szFilename,sizeof(szFilename),
#ifdef JPEG
                      "JPEG file\0*.jpg\0Bitmap file\0*.bmp\0","jpg");
#else
                      "Bitmap file\0*.bmp\0","bmp");
#endif
        if (filename == NULL)
            return no;
    }

    // retrieve window's dimentions
    GetWindowRect((HWND)hWnd,&rect);

    // redraw the window (after Save dialog)
    ::InvalidateRect((HWND)hWnd,NULL,no);
    UpdateWindow((HWND)hWnd);

    // If a part of the window is out of screen - cut the rectangle
    SystemParametersInfo(SPI_GETWORKAREA,0,&screenRe,0);

    if (IncludeFrame)               // we need just client area
        hDc = GetWindowDC((HWND)hWnd);
    else {
        hDc = GetDC((HWND)hWnd);
        GetClientRect((HWND) hWnd, &rect);
        ClientToScreen((HWND) hWnd, (POINT*) &rect);
        ClientToScreen((HWND) hWnd, (POINT*) &rect.right);
        if (rect.top < 0)
            y0 = -rect.top;
        y0 += DialogHeight;
        if (rect.left < 0)
            x0 = -rect.left;
    }
    // This test is not good, it will create funny coordinates (right), when people use
    // second monitor.  Do not remove the commenting out below
    /*
    if (rect.left < screenRe.left)
        rect.left = screenRe.left;
    if (rect.top < screenRe.top)
        rect.top = screenRe.top;
    if (rect.right > screenRe.right)
        rect.right = screenRe.right;
    if (rect.bottom > screenRe.bottom)
        rect.bottom = screenRe.bottom;
     */
    hMemDc = CreateCompatibleDC(hDc);

    // Create new bitmap
    hBmpNew = TfcCreateBitmap(hDc, rect.right-rect.left, rect.bottom-rect.top);
    if (hBmpNew == NULL) {
		TfcMessage("Save as JPG/BMP", '.',
				   "An error (\"Incompatible monitor\") occured while saving to\n\n%s\n"
				   "\nUse the Alt-Printscreen method instead: hit "
				   "Alt-Printscreen\nand then paste into Paint (or Word "
				   "or Powerpoint).", "temporary file");
        return false;
    }
     // Copy DC to bitmap
    hBmpOld = (HBITMAP)SelectObject(hMemDc, hBmpNew);
    BitBlt(hMemDc, 0, 0, rect.right-rect.left,
                rect.bottom-rect.top, hDc, x0, y0, SRCCOPY);
    SelectObject(hMemDc,hBmpOld);

    /*if (ForPrinting) {
        // Print bitmap out
        BmpScrollWin  BmpWin(hBmpNew);
        ScrollWin     **list=NULL;

        ListAdd(list, &BmpWin);
        PrintScrollWins(list, filename, nullcontrol, '\0', NULL, (str)0x1, pFunc, pFunc2);
    }
    else*/ {
        int CreateJPEGFile(const char* pszFile, HBITMAP hBmp, HDC hDC);

        // Determine which format is selected
        char* ext = filename + strlen(filename)-3;
        if (stricmp(ext,"bmp") == 0)      // Save as 256- color bitmap
            error = CreateBMPFile(filename,hBmpNew,hDc);
        else       // otherwise save as jpeg
            error = CreateJPEGFile(filename,hBmpNew,hDc);
    }

    // clean-up
    ReleaseDC((HWND)hWnd,hDc);
    DeleteDC(hMemDc);
    DeleteObject(hBmpNew);

    if (error)
        TfcMessage("Save as JPG/BMP", '.',
                   "An error (\"%s\") occured while saving to\n\n%s\n"
                   "\nUse the Alt-Printscreen method instead: hit "
                   "Alt-Printscreen\nand then paste into Paint (or Word "
                   "or Powerpoint).", TfcStrerror(error), filename);
    else if (not ForPrinting)
        TfcMessage("Save as JPG/BMP", 'i',
                   "Successfully saved to:\n\n%s", filename);

    return not error;
}


interface void Quit()
{
    PostQuitMessage(0);
}



/*---------------- Customised Print Dialog Boxes: ------------*/

interface HGLOBAL TfcPrintTemplate(control rootcontrol, bool RightAlign,
                               int standartSize,
                               void** ctrls)
{   int cx = 0, cy = 0, x, y;

    if (RightAlign) /* place controls on right */
        x = 288, y = 0;
    else            /* place on bottom */
        x = 0, y = 178;

    dialog_type dlg = CreateDialogTemplate("Print Dialog", rootcontrol, NULL, nullcontrol,0,
                                x , y, ctrls, standartSize);

    if (RightAlign)
        cx = dlg->tree_root->cx + 2*8 + 4,cy = 0;
    else
        cx = 0,cy = dlg->tree_root->cy + 2*4 + 4;

    dlg->Template->cx = 288 + cx;
    dlg->Template->cy = 178 + cy;

    return dlg->Template;
}


void DeletePrintDlg(HWND hWnd)
{   dialog_type dlg;

    dlg = WndToDlg(hWnd);
    if (not dlg)
        return;
    GlobalUnlock(dlg->Template);
    DialogFree(dlg);
    GlobalFree(dlg->Template);
    delete dlg;
}


UINT CALLBACK PrintSetupHookProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
// this function can be moved into print.cpp, but then the DialogBoxProc must be non-static
{
    switch (uMsg) {
        case WM_COMMAND :
            if  (wParam == IDOK or wParam == IDCANCEL)
                DeletePrintDlg(hWnd);
            else if (LOWORD(wParam) < 0x400) // this is user controls
                DialogBoxProc(hWnd,uMsg, wParam, lParam);
            break;
        case WM_CLOSE :
            DeletePrintDlg(hWnd);
            break;
        default :
			if (uMsg == 131)
				return 0;
            DialogBoxProc(hWnd,uMsg, wParam, lParam);
    }

    return 0;
}


void ScrollWin::DecideOnPageBreakPosX(int x, int *endX, int *startOfNextX)
{
	*endX = x;
	*startOfNextX = x - clientWidth*0.05;			// 5% overlap
}


void ScrollWin::DecideOnPageBreakPosY(int y, int *endY, int *startOfNextY)
{
	*endY = y;
	*startOfNextY = y - clientHeight*0.05;			// 1% overlap
}




/*----------------- AATimers: ----------------*/

typedef struct AATimer_node {
    int Id;
    TfcCallback callback;
    void * data;
    bool called;
} *AATimer_type;


static AATimer_type AATimers;


static void _stdcall AATimerCallback(void* hWnd, uint message, uint Timer, long SysTime)
{   struct AATimer_node *T = NULL, *T2 = NULL;
    int i;

    for (each_oeli(T, AATimers)) {
        if (T->Id == Timer) {
            if (!T->called) {
                T->called = true;
                T->callback(NULL, NULL);
                for (each_oeli(T2, AATimers)) {
                    if (T2->Id == Timer) {
                        T2->called = false;
                        break;
                    }
                }
            }
            break;
        }
    }
}


interface int AAStartTimer(int MilliSec, VoidData_fn callback, void * data)
{   struct AATimer_node *T;

    if (MilliSec <= 0)
        return 0;
    T = (AATimer_type)ListNext(AATimers);
    T->Id = SetTimer(NULL, 0, MilliSec, (TIMERPROC)(wincallback_fn)AATimerCallback);
    T->callback = TfcCallback((VoidData_fn)callback, (void*)data);
    T->data = data;
    T->called = false;
    return T->Id;
}


interface void AAKillTimer(int timer)
{   struct AATimer_node *T = NULL;
    int i;

    for (each_oeli(T, AATimers)) 
    {
        if (T->Id == timer) {
            ListDelN(AATimers, i);
            break;
        }
    }
    KillTimer(NULL,timer);
}


/*------------------- Unicode and UTF8: ------------------------*/

interface bool WideToUtf8(wchar_t *wide, char dest[], int sizeofdest)
{
	if (wide == NULL) {
		*dest = 0;
		return no;
	}
	if (unicodeMode == unicode_UTF8)
		return WideCharToMultiByte(CP_UTF8, 0, wide, -1, dest, sizeofdest, NULL, NULL) > 0;
	else // WesternEuropean
		return WideCharToMultiByte(CP_ACP, 0, wide, -1, dest, sizeofdest, NULL, NULL) > 0;
}


interface bool Utf8ToWide(kstr src, wchar_t wide[], int sizeofwide)
{
	if (unicodeMode == unicode_UTF8)
		return MultiByteToWideChar(CP_UTF8, 0, src, -1, wide, sizeofwide/2) > 0;
	else // WesternEuropean 
		return MultiByteToWideChar(CP_ACP, 0, src, -1, wide, sizeofwide/2) > 0;
}


wchar_t* ToWideStrdup(kstr buf)
/* Use this if the input string could be very large. */
{   
	int len;

	len = strlen(buf) + 1;
	wchar_t* wbuf = (wchar_t*)malloc(sizeof(wchar_t)*len);
	Utf8ToWide(buf, wbuf, len*2);
	return wbuf;    
}


int utf8len(str buf, str bufEnd)
{
	if (buf >= bufEnd && bufEnd != NULL)
		return 0;
	if (unicodeMode != unicode_UTF8)
		return bufEnd ? bufEnd - buf : strlen(buf);

	str ptr = buf;        
	int length = 0;

	do {
		if (*ptr) {
			if (!(*ptr  & 0x80)) // simple ASCII byte
				length++;
			else {
				if ((*ptr  & 0x80) && !(*ptr & 0x40)) // 0x10xx xxxx byte -> not leading
					;
				else                            
					length++;
			}
			ptr++;
		}
		if (!bufEnd) {
			if (!*ptr)
				break;
		}
		else
			if (ptr == bufEnd)
				break;
	} forever;
	return length;
}



static double scaleX = 1;
static double scaleY = 1;


double DpiGetScaleX() {
	return scaleX;
}


double DpiGetScaleY() {
	return scaleY;
}


void DpiInitScaling() {
	HDC screen = GetDC(0);
	scaleX = GetDeviceCaps(screen, LOGPIXELSX) / 96.0;
	scaleY = GetDeviceCaps(screen, LOGPIXELSY) / 96.0;
	ReleaseDC(0, screen);
}


AutoInitAndCleanUp::AutoInitAndCleanUp(VoidFuncPtr initFunc,
        VoidFuncPtr cleanUpFunc) :
    initFunc(initFunc), cleanUpFunc(cleanUpFunc) 
{
	if (winMainCalled) {
		CallInitFunc();
	} else {
		if (initFunc)
			ListAdd(initers, this);
	}
}


AutoInitAndCleanUp::~AutoInitAndCleanUp() 
{
	CallCleanUpFunc();
}


void AutoInitAndCleanUp::CallInitFunc() const 
{
	if (initFunc)
		(*initFunc)();
}


void AutoInitAndCleanUp::CallCleanUpFunc() const 
{
	if (cleanUpFunc)
		(*cleanUpFunc)();
}



/*--------------- Laco's Dump system -------------------------------------*/
#include <time.h>

static HANDLE msg_dump = NULL;
static char msg_dump_buf[200];
static clock_t clock_base = 0;

#define USE_DUMP
#ifdef USE_DUMP

void Dump(str window, int resp)
{
	/* filter for this message only */
	if (200 == resp or 210 == resp) {} else
		return;

	if (NULL == msg_dump) return;
	if (INVALID_HANDLE_VALUE == msg_dump) return;
	clock_t clocks = clock();
	clock_t secs = clocks / 1000;
	clock_t msec = clocks % 1000;
	clock_t min = secs / 60;
	clock_t sec = secs - 60*min;
	char code[50];
	code[0] = 0;
	switch (resp)
	{
	case WINDOW_QUIT:
		strcpy(code, "WINDOW_QUIT");
		break;
	case WINDOW_RESIZE:
		strcpy(code, "WINDOW_RESIZE");
		break;
	case 40020:
		strcpy(code, "ID_DATAENTRY_TEACHERS");
		break;
	case AUTO_POLL:
		strcpy(code, "AUTO_POLL");
		break;
	case 40062:
		strcpy(code, "ID_STUDENTS_DATAENTRY");
		break;
	}
	if (resp == 210) {
		sprintf(msg_dump_buf, "%s \r\n", window);
	} else {
		sprintf(msg_dump_buf, "%3d:%2d:%3d -> %7d -> %s %s \r\n", min, sec, msec, resp, code, window);
	}
	//sprintf(msg_dump_buf, "%s \r\n", window);
	DWORD l = strlen(msg_dump_buf);
	DWORD w = 0;
	WriteFile(msg_dump, msg_dump_buf, l, &w, NULL);
}

void OpenDump(str filepath)
{
	if (NULL == filepath or '\0' == filepath[0])
		filepath = "msg_log.txt";
	msg_dump = CreateFile(filepath,
					GENERIC_WRITE|GENERIC_READ,
					FILE_SHARE_READ | FILE_SHARE_WRITE,
					NULL,
					CREATE_ALWAYS,
					FILE_ATTRIBUTE_NORMAL,
					NULL);
}

void CloseDump()
{
	CloseHandle(msg_dump);
}

void StartClock(str message)
{
	if (NULL == msg_dump) return;
	if (INVALID_HANDLE_VALUE == msg_dump) return;

	clock_base = clock();
	clock_t clocks = clock() - clock_base;
	clock_t secs = clocks / 1000;
	clock_t msec = clocks % 1000;
	clock_t min = secs / 60;
	clock_t sec = secs - 60*min;

	sprintf(msg_dump_buf, "clock %3d:%2d:%3d -> %s \r\n", min, sec, msec, message);
	DWORD l = strlen(msg_dump_buf);
	DWORD w = 0;
	WriteFile(msg_dump, msg_dump_buf, l, &w, NULL);
	clock_base = clock();
}

void DumpClock(str message, bool deltaTime)
{
	if (NULL == msg_dump) return;
	if (INVALID_HANDLE_VALUE == msg_dump) return;

	clock_t clocks = clock() - clock_base;
	clock_t secs = clocks / 1000;
	clock_t msec = clocks % 1000;
	clock_t min = secs / 60;
	clock_t sec = secs - 60*min;

	sprintf(msg_dump_buf, "clock %3d:%2d:%3d -> %s \r\n", min, sec, msec, message);
	DWORD l = strlen(msg_dump_buf);
	DWORD w = 0;
	WriteFile(msg_dump, msg_dump_buf, l, &w, NULL);

	if (deltaTime)
		clock_base = clock();
}

#else

static void Dump(str window, int resp) {;}
static void OpenDump() {;}
static void CloseDump() {;}
static void StartClock(str message) {;}
static void DumpClock(str message, bool deltaTime) {;}

#endif // USE_DUMP



kstr TfcGetExePath()
{
	return exeFilePath;
}


/* return writable filename */
str TfcGetTempFileName(char dest[]) {
	#define TFC_BUFSIZE 512

	DWORD dwRetVal;
	UINT uRetVal;
	HANDLE hTempFile;
	// Get the temp path.
	char temppath[TFC_BUFSIZE];
	dwRetVal = GetTempPath(	TFC_BUFSIZE,	// length of the buffer
							temppath);		// buffer for path 
	if (dwRetVal > TFC_BUFSIZE || (dwRetVal == 0)) {
		//printf ("GetTempPath failed with error %d.\n", 
		//	GetLastError());
		return NULL;
	}

	// Create a temporary file. 
	uRetVal = GetTempFileName(	temppath,		// directory for tmp files
								"NEW",			// temp file name prefix
								0,				// create unique name
								dest);			// buffer for name 
	if (uRetVal == 0) {
		//printf ("GetTempFileName failed with error %d.\n", 
		//		GetLastError());
		return NULL;
	}

	// Create the new file to write the upper-case version to.
	hTempFile = CreateFile((LPTSTR) dest,					// file name
							GENERIC_READ | GENERIC_WRITE,	// open r-w
							0,								// do not share
							NULL,							// default security
							CREATE_ALWAYS,					// overwrite existing
							FILE_ATTRIBUTE_NORMAL,			// normal file
							NULL);							// no template 
	if (hTempFile == INVALID_HANDLE_VALUE) {
		//printf ("CreateFile failed with error %d.\n",
		//	GetLastError());
		return NULL;
	}
	CloseHandle (hTempFile);

	return dest;
}


kstr TfcCreateGuid(char dest[])
{	GUID guid;

	CoCreateGuid(&guid);
	for (int i=0; i < 16; i++) {
		int byte = ((unsigned char*)&guid)[i];
		dest[i*2] = byte>>4;
		dest[i*2+1] = byte&0xf;
	}
	for (int i=0; i < 32; i++) {
		if (dest[i] < 10)
			dest[i] += '0';
		else dest[i] += 'A'-10;
	}
	dest[32] = '\0';
	return dest;
}


kstr TfcGetAppVersion()
{
	static kstr version = NULL;

	if (NULL == version)
		version = TfcGetFileVersion(TfcGetExePath());
	return version;
}

kstr TfcGetFileVersion(kstr filePath)
{
	char* version = NULL;

	LPTSTR lpszFilePath = strdup(filePath); 
	DWORD dwDummy = 64; 
	DWORD dwFVISize = GetFileVersionInfoSize( lpszFilePath , &dwDummy );
	if (0 == dwFVISize) {
		version = "0.0.0";
	} else {
		LPBYTE lpVersionInfo = new BYTE[dwFVISize]; 
		GetFileVersionInfo( lpszFilePath , 0 , dwFVISize , lpVersionInfo ); 
		UINT uLen; 
		VS_FIXEDFILEINFO *lpFfi; 
		bool success = VerQueryValue( lpVersionInfo , _T("\\") , (LPVOID *)&lpFfi , &uLen ); 
		if (success) {
			DWORD dwFileVersionMS = lpFfi->dwFileVersionMS; 
			DWORD dwFileVersionLS = lpFfi->dwFileVersionLS; 
			delete [] lpVersionInfo; 
			//printf( "Higher: %x\n" , dwFileVersionMS ); 
			//printf( "Lower: %x\n" , dwFileVersionLS ); 
			DWORD dwLeftMost = HIWORD(dwFileVersionMS); 
			DWORD dwSecondLeft = LOWORD(dwFileVersionMS); 
			DWORD dwSecondRight = HIWORD(dwFileVersionLS); 
			DWORD dwRightMost = LOWORD(dwFileVersionLS);
			char appVersion[20];
			sprintf(appVersion, "%d.%d.%d" , dwLeftMost, dwSecondLeft, dwSecondRight);
			version = strdup(appVersion);
		} else {
			version = "0.0.0";
		}
	}

	return version;
}

