(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)

MODULE Code; 

PROCEDURE Setup() =
  BEGIN
    dataCompareArity[OpDataCompareClass.OpSameCase] := 3;
    dataCompareArity[OpDataCompareClass.OpOtherCase] := 3;

    dataBoolArity[OpDataBoolClass.OpBoolNotCase] := 2;
    dataBoolArity[OpDataBoolClass.OpBoolAndCase] := 3;
    dataBoolArity[OpDataBoolClass.OpBoolOrCase] := 3;

    dataAsciiArity[OpDataAsciiClass.OpAsciiCharCase] := 2;
    dataAsciiArity[OpDataAsciiClass.OpAsciiValCase] := 2;

    dataIntArity[OpDataIntClass.OpIntPlusCase] := 3;
    dataIntArity[OpDataIntClass.OpIntDiffCase] := 3;
    dataIntArity[OpDataIntClass.OpIntMulCase] := 3;
    dataIntArity[OpDataIntClass.OpIntDivCase] := 3;
    dataIntArity[OpDataIntClass.OpIntModCase] := 3;
    dataIntArity[OpDataIntClass.OpIntLessCase] := 3;
    dataIntArity[OpDataIntClass.OpIntMoreCase] := 3;
    dataIntArity[OpDataIntClass.OpIntLessEqCase] := 3;
    dataIntArity[OpDataIntClass.OpIntMoreEqCase] := 3;

    dataRealArity[OpDataRealClass.OpRealIntCase] := 2;
    dataRealArity[OpDataRealClass.OpRealFloorCase] := 2;
    dataRealArity[OpDataRealClass.OpRealRoundCase] := 2;
    dataRealArity[OpDataRealClass.OpRealPlusCase] := 3;
    dataRealArity[OpDataRealClass.OpRealDiffCase] := 3;
    dataRealArity[OpDataRealClass.OpRealMulCase] := 3;
    dataRealArity[OpDataRealClass.OpRealDivCase] := 3;
    dataRealArity[OpDataRealClass.OpRealExpCase] := 3;
    dataRealArity[OpDataRealClass.OpRealLogCase] := 2;
    dataRealArity[OpDataRealClass.OpRealLessCase] := 3;
    dataRealArity[OpDataRealClass.OpRealMoreCase] := 3;
    dataRealArity[OpDataRealClass.OpRealLessEqCase] := 3;
    dataRealArity[OpDataRealClass.OpRealMoreEqCase] := 3;

    dataStringArity[OpDataStringClass.OpStringErrorCase] := 1;
    dataStringArity[OpDataStringClass.OpStringNewCase] := 3;
    dataStringArity[OpDataStringClass.OpStringIsEmptyCase] := 2;
    dataStringArity[OpDataStringClass.OpStringLengthCase] := 2;
    dataStringArity[OpDataStringClass.OpStringEqualCase] := 3;
    dataStringArity[OpDataStringClass.OpStringEqualSubCase] := 7;
    dataStringArity[OpDataStringClass.OpStringPrecedesCase] := 3;
    dataStringArity[OpDataStringClass.OpStringPrecedesSubCase] := 7;
    dataStringArity[OpDataStringClass.OpStringGetCharCase] := 3;
    dataStringArity[OpDataStringClass.OpStringSetCharCase] := 4;
    dataStringArity[OpDataStringClass.OpStringGetSubCase] := 4;
    dataStringArity[OpDataStringClass.OpStringSetSubCase] := 6;
    dataStringArity[OpDataStringClass.OpStringCatCase] := 3;
    dataStringArity[OpDataStringClass.OpStringCatSubCase] := 7;
    dataStringArity[OpDataStringClass.OpStringConcatCase] := 3;

    dataArrayArity[OpDataArrayClass.OpArrayErrorCase] := 1;
    dataArrayArity[OpDataArrayClass.OpArrayNewCase] := 4;
    dataArrayArity[OpDataArrayClass.OpArraySizeCase] := 3;
    dataArrayArity[OpDataArrayClass.OpArrayGetCase] := 4;
    dataArrayArity[OpDataArrayClass.OpArraySetCase] := 5;

    dataReaderArity[OpDataReaderClass.OpReaderErrorCase] := 1;
    dataReaderArity[OpDataReaderClass.OpReaderInputCase] := 1;
    dataReaderArity[OpDataReaderClass.OpReaderFileCase] := 2;
    dataReaderArity[OpDataReaderClass.OpReaderMoreCase] := 2;
    dataReaderArity[OpDataReaderClass.OpReaderReadyCase] := 2;
    dataReaderArity[OpDataReaderClass.OpReaderGetCharCase] := 2;
    dataReaderArity[OpDataReaderClass.OpReaderGetStringCase] := 3;
    dataReaderArity[OpDataReaderClass.OpReaderGetSubStringCase] := 5;
    dataReaderArity[OpDataReaderClass.OpReaderCloseCase] := 2;

    dataWriterArity[OpDataWriterClass.OpWriterErrorCase] := 1;
    dataWriterArity[OpDataWriterClass.OpWriterOutputCase] := 1;
    dataWriterArity[OpDataWriterClass.OpWriterFileCase] := 2;
    dataWriterArity[OpDataWriterClass.OpWriterFlushCase] := 2;
    dataWriterArity[OpDataWriterClass.OpWriterPutCharCase] := 3;
    dataWriterArity[OpDataWriterClass.OpWriterPutStringCase] := 3;
    dataWriterArity[OpDataWriterClass.OpWriterPutSubStringCase] := 5;
    dataWriterArity[OpDataWriterClass.OpWriterCloseCase] := 2;

    dataDynamicArity[OpDataDynamicClass.OpDynamicErrorCase] := 1;
    dataDynamicArity[OpDataDynamicClass.OpDynamicNewCase] := 3;
    dataDynamicArity[OpDataDynamicClass.OpDynamicBeCase] := 3;
    dataDynamicArity[OpDataDynamicClass.OpDynamicCopyCase] := 3;
    dataDynamicArity[OpDataDynamicClass.OpDynamicInternCase] := 2;
    dataDynamicArity[OpDataDynamicClass.OpDynamicExternCase] := 3;
    dataDynamicArity[OpDataDynamicClass.OpDynamicInternPortableCase] := 2;
    dataDynamicArity[OpDataDynamicClass.OpDynamicExternPortableCase] := 3;

    dataTimeArity[OpDataTimeClass.OpTimeZeroCase] := 1;
    dataTimeArity[OpDataTimeClass.OpTimeNowCase] := 1;
    dataTimeArity[OpDataTimeClass.OpTimeSecondsCase] := 2;
    dataTimeArity[OpDataTimeClass.OpTimeMicrosecondsCase] := 2;
    dataTimeArity[OpDataTimeClass.OpTimeEqualCase] := 3;
    dataTimeArity[OpDataTimeClass.OpTimeBeforeCase] := 3;
    dataTimeArity[OpDataTimeClass.OpTimeAfterCase] := 3;

    dataValueArity[OpDataValueClass.OpValueNewCase] := 3;
    dataValueArity[OpDataValueClass.OpValueBeCase] := 3;
    dataValueArity[OpDataValueClass.OpValueFetchCase] := 3;
    dataValueArity[OpDataValueClass.OpValueStoreCase] := 4;

    dataMachineArity[OpDataMachineClass.OpMachineExecCase] := 4;
    dataMachineArity[OpDataMachineClass.OpMachineResumeCase] := 2;
    dataMachineArity[OpDataMachineClass.OpMachineGotoCase] := 3;
    dataMachineArity[OpDataMachineClass.OpMachinePopFrameCase] := 2;
    dataMachineArity[OpDataMachineClass.OpMachineTraceCase] := 3;
    dataMachineArity[OpDataMachineClass.OpMachineTraceExcCase] := 2;
    dataMachineArity[OpDataMachineClass.OpMachineBreakCase] := 3;
    dataMachineArity[OpDataMachineClass.OpMachineBreakExcCase] := 2;

    dataStoreArity[OpDataStoreClass.OpStoreErrorCase] := 1;
    dataStoreArity[OpDataStoreClass.OpStoreLoopholeCase] := 2;
    dataStoreArity[OpDataStoreClass.OpStoreAddressCase] := 2;
    dataStoreArity[OpDataStoreClass.OpStoreAtCase] := 2;
    dataStoreArity[OpDataStoreClass.OpStoreClearCase] := 3;
    dataStoreArity[OpDataStoreClass.OpStoreCopyCase] := 4;
    dataStoreArity[OpDataStoreClass.OpStoreGetByteCase] := 2;
    dataStoreArity[OpDataStoreClass.OpStoreSetByteCase] := 3;
    dataStoreArity[OpDataStoreClass.OpStoreGetShortCase] := 2;
    dataStoreArity[OpDataStoreClass.OpStoreSetShortCase] := 3;
    dataStoreArity[OpDataStoreClass.OpStoreGetLongCase] := 2;
    dataStoreArity[OpDataStoreClass.OpStoreSetLongCase] := 3;
    dataStoreArity[OpDataStoreClass.OpStoreGetRealCase] := 2;
    dataStoreArity[OpDataStoreClass.OpStoreSetRealCase] := 3;

    dataOsArity[OpDataOsClass.OpOsErrorCase] := 1;
    dataOsArity[OpDataOsClass.OpOsChdirCase] := 2;
    dataOsArity[OpDataOsClass.OpOsWhereCase] := 3;
  END Setup;

BEGIN
END Code.
