(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)

INTERFACE Exec;
IMPORT Data, Value;

VAR
  traceOnRaise, breakOnRaise: BOOLEAN;

PROCEDURE Setup();

PROCEDURE Exec(machineState: Value.T): Value.T;

PROCEDURE ExecProg(
    prog: Value.T;
    newStack: Value.T;
    newRelTL: Data.Pointer)
    : Value.T;

PROCEDURE ReentrantExecProg(
    prog: Value.T;
    newStack: Value.T;
    newRelTL: Data.Pointer)
    : Value.T;

PROCEDURE PopFrame(machineState: Value.T): Value.T;

END Exec.
