(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)

INTERFACE Store;
IMPORT Data;

CONST
  MinIndex = 0;
  DataAlignment = Data.PointeesPerPolymorph;

VAR
  MaxIndex: Data.Int;
  heapAdr: Data.Pointer;
  hp: Data.Pointer;

PROCEDURE Setup(heapSize: Data.Integer);
(* Heap size in pointees. *)

PROCEDURE Clear(hp: Data.Pointer; length: Data.Int);
PROCEDURE Copy(dest,source:Data.Pointer; length: Data.Int);

<*INLINE*> PROCEDURE GetByte(hp: Data.Pointer): Data.Byte;
<*INLINE*> PROCEDURE SetByte(hp: Data.Pointer; byte: Data.Byte);
<*INLINE*> PROCEDURE GetShort(hp: Data.Pointer): Data.Short;
<*INLINE*> PROCEDURE SetShort(hp: Data.Pointer; short: Data.Short);
<*INLINE*> PROCEDURE GetLong(hp: Data.Pointer): Data.Long;
<*INLINE*> PROCEDURE SetLong(hp: Data.Pointer; long: Data.Long);
<*INLINE*> PROCEDURE GetFloat(hp: Data.Pointer): Data.Float;
<*INLINE*> PROCEDURE SetFloat(hp: Data.Pointer; float: Data.Float);

<*INLINE*> PROCEDURE GetPointee(hp: Data.Pointer): Data.Pointee;
<*INLINE*> PROCEDURE SetPointee(hp: Data.Pointer; pointee: Data.Pointee);
<*INLINE*> PROCEDURE GetPolymorph(hp: Data.Pointer): Data.Polymorph;
<*INLINE*> PROCEDURE SetPolymorph(hp: Data.Pointer; polymorph: Data.Polymorph);
<*INLINE*> PROCEDURE GetPointer(hp: Data.Pointer): Data.Pointer;
<*INLINE*> PROCEDURE SetPointer(hp: Data.Pointer; pointer: Data.Pointer);
<*INLINE*> PROCEDURE GetImmediate(hp: Data.Pointer): Data.Immediate;
<*INLINE*> PROCEDURE SetImmediate(hp: Data.Pointer; immediate: Data.Immediate);
<*INLINE*> PROCEDURE GetSmallCard(hp: Data.Pointer): Data.SmallCard;
<*INLINE*> PROCEDURE SetSmallCard(hp: Data.Pointer; smallCard: Data.SmallCard);
<*INLINE*> PROCEDURE GetSmallInt(hp: Data.Pointer): Data.SmallInt;
<*INLINE*> PROCEDURE SetSmallInt(hp: Data.Pointer; smallInt: Data.SmallInt);
<*INLINE*> PROCEDURE GetInt(hp: Data.Pointer): Data.Int;
<*INLINE*> PROCEDURE SetInt(hp: Data.Pointer; int: Data.Int);
<*INLINE*> PROCEDURE GetRelJump(hp: Data.Pointer): Data.Int;
<*INLINE*> PROCEDURE SetRelJump(hp: Data.Pointer; int: Data.Int);

<*INLINE*> PROCEDURE Align();
<*INLINE*> PROCEDURE LayPointee(pointee: Data.Pointee);
<*INLINE*> PROCEDURE LayPolymorph(polymorph: Data.Polymorph);
<*INLINE*> PROCEDURE LayPointer(pointer: Data.Pointer);
<*INLINE*> PROCEDURE LayImmediate(immediate: Data.Immediate);
<*INLINE*> PROCEDURE LaySmallCard(smallCard: Data.SmallCard);
<*INLINE*> PROCEDURE LaySmallInt(smallInt: Data.SmallInt);
<*INLINE*> PROCEDURE LayInt(int: Data.Int);
<*INLINE*> PROCEDURE LayRelJump(int: Data.Int);

END Store.
