(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)

UNSAFE MODULE Store;
IMPORT Data, QOS, Word;

PROCEDURE Setup(heapSize: Data.Integer) =
  BEGIN 
    MaxIndex := heapSize-1;
    heapAdr := LOOPHOLE(QOS.Alloc(heapSize), Data.Pointer); 
    hp := MinIndex; 
  END Setup;

PROCEDURE Clear(hp: Data.Pointer; length: Data.Int) =
  VAR addr: Data.BytePtr; scan: Data.Pointer;
  BEGIN
    <*ASSERT NOT( (length<0) OR (hp < MinIndex) OR 
      (LOOPHOLE(LOOPHOLE(hp, Data.Int)+length, Data.Pointer) > MaxIndex)) *>
    scan := heapAdr+hp;
    FOR i := 0 TO length-1 DO
      addr := LOOPHOLE(scan, Data.BytePtr);
      addr^ := 0;
      INC(scan);
    END;
  END Clear;

PROCEDURE Copy(dest,source:Data.Pointer; length: Data.Int) =
  VAR addrSrc,addrDst: Data.BytePtr; scanSrc,scanDst: Data.Pointer;
  BEGIN
    <*ASSERT NOT( (length<0) OR (dest < MinIndex) OR 
       (LOOPHOLE(LOOPHOLE(dest, Data.Int)+length, Data.Pointer) > MaxIndex) OR
	(source < MinIndex) OR 
	(LOOPHOLE(LOOPHOLE(source, Data.Int)+length, Data.Pointer) > 
	  MaxIndex) ) *>
    IF dest < source THEN
      scanDst := heapAdr+dest;
      scanSrc := heapAdr+source;
      FOR i := 0 TO length-1 DO
        addrDst := LOOPHOLE(scanDst, Data.BytePtr);
        addrSrc := LOOPHOLE(scanSrc, Data.BytePtr);
        addrDst^ := addrSrc^;
        INC(scanDst);
        INC(scanSrc);
      END;
    ELSIF dest > source THEN
      scanDst := heapAdr+dest; INC(scanDst,length);
      scanSrc := heapAdr+source; INC(scanSrc, length);
      FOR i := 0 TO length-1 DO
        DEC(scanDst);
        DEC(scanSrc);
        addrDst := LOOPHOLE(scanDst, Data.BytePtr);
        addrSrc := LOOPHOLE(scanSrc, Data.BytePtr);
        addrDst^ := addrSrc^
      END;
    END;
  END Copy;

PROCEDURE GetByte(hp: Data.Pointer): Data.Byte =
  BEGIN
    <* ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    RETURN LOOPHOLE(heapAdr+hp, Data.BytePtr)^;
  END GetByte;

PROCEDURE SetByte(hp: Data.Pointer; byte: Data.Byte) =
  BEGIN 
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    LOOPHOLE(heapAdr+hp, Data.BytePtr)^ := byte;
  END SetByte;

PROCEDURE GetShort(hp: Data.Pointer): Data.Short =
  BEGIN
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    RETURN LOOPHOLE(heapAdr+hp, Data.ShortPtr)^;
  END GetShort;

PROCEDURE SetShort(hp: Data.Pointer; short: Data.Short) =
  BEGIN 
    <* ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    LOOPHOLE(heapAdr+hp, Data.ShortPtr)^ := short;
  END SetShort;

TYPE 
  ShortShort = RECORD lo, hi: Data.Short END;

PROCEDURE GetLong(hp: Data.Pointer): Data.Long =
  VAR shortShort: ShortShort;
  BEGIN
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex)) *>
    shortShort.lo := LOOPHOLE(heapAdr+hp, Data.ShortPtr)^;
    shortShort.hi := LOOPHOLE(heapAdr+hp+2, Data.ShortPtr)^;
    RETURN LOOPHOLE(shortShort, Data.Long);
  END GetLong;
(*
PROCEDURE GetLong(hp: Data.Pointer): Data.Long =
  BEGIN
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex)) *>
    RETURN LOOPHOLE(heapAdr+hp,  Data.LongPtr)^;
  END GetLong;
*)

PROCEDURE SetLong(hp: Data.Pointer; long: Data.Long) =
  BEGIN 
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex)) *>
    LOOPHOLE(heapAdr+hp, Data.ShortPtr)^ := LOOPHOLE(long, ShortShort).lo;
    LOOPHOLE(heapAdr+hp+2, Data.ShortPtr)^ := LOOPHOLE(long, ShortShort).hi;
  END SetLong;
(*
PROCEDURE SetLong(hp: Data.Pointer; long: Data.Long) =
  BEGIN 
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex)) *>
    LOOPHOLE(heapAdr+hp, Data.LongPtr)^ := long;
  END SetLong;
*)

PROCEDURE GetFloat(hp: Data.Pointer): Data.Float =
  VAR shortShort: ShortShort;
  BEGIN
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    shortShort.lo := LOOPHOLE(heapAdr+hp, Data.ShortPtr)^;
    shortShort.hi := LOOPHOLE(heapAdr+hp+2, Data.ShortPtr)^;
    RETURN LOOPHOLE(shortShort, Data.Float);
  END GetFloat;
(*
PROCEDURE GetFloat(hp: Data.Pointer): Data.Float =
  BEGIN
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    RETURN LOOPHOLE(heapAdr+hp, Data.FloatPtr)^;
  END GetFloat;
*)

PROCEDURE SetFloat(hp: Data.Pointer; float: Data.Float) =
  BEGIN 
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    LOOPHOLE(heapAdr+hp, Data.ShortPtr)^ := LOOPHOLE(float, ShortShort).lo;
    LOOPHOLE(heapAdr+hp+2, Data.ShortPtr)^ := LOOPHOLE(float, ShortShort).hi;
  END SetFloat;
(*
PROCEDURE SetFloat(hp: Data.Pointer; float: Data.Float) =
  BEGIN 
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    LOOPHOLE(heapAdr+hp, Data.FloatPtr)^ := float;
  END SetFloat;
*)

PROCEDURE GetPointee(hp: Data.Pointer): Data.Pointee =
  BEGIN
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    RETURN LOOPHOLE(heapAdr+hp, Data.PointeePtr)^;
  END GetPointee;

PROCEDURE SetPointee(hp: Data.Pointer; pointee: Data.Pointee) =
  BEGIN 
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    LOOPHOLE(heapAdr+hp, Data.PointeePtr)^ := pointee;
  END SetPointee;

PROCEDURE GetPolymorph(hp: Data.Pointer): Data.Polymorph =
  VAR shortShort: ShortShort;
  BEGIN 
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    shortShort.lo := LOOPHOLE(heapAdr+hp, Data.ShortPtr)^;
    shortShort.hi := LOOPHOLE(heapAdr+hp+2, Data.ShortPtr)^;
    RETURN LOOPHOLE(shortShort, Data.Polymorph);
  END GetPolymorph;
(*
PROCEDURE GetPolymorph(hp: Data.Pointer): Data.Polymorph =
  BEGIN 
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    RETURN LOOPHOLE(heapAdr+hp, Data.PolymorphPtr)^; 
  END GetPolymorph;
*)

PROCEDURE SetPolymorph(hp: Data.Pointer; polymorph: Data.Polymorph) =
  BEGIN
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    LOOPHOLE(heapAdr+hp, Data.ShortPtr)^ := LOOPHOLE(polymorph, ShortShort).lo;
    LOOPHOLE(heapAdr+hp+2, Data.ShortPtr)^ := LOOPHOLE(polymorph, ShortShort).hi;
  END SetPolymorph;
(*
PROCEDURE SetPolymorph(hp: Data.Pointer; polymorph: Data.Polymorph) =
  BEGIN
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    LOOPHOLE(heapAdr+hp, Data.PolymorphPtr)^ := polymorph;
  END SetPolymorph;
*)

PROCEDURE GetPointer(hp: Data.Pointer): Data.Pointer =
  VAR shortShort: ShortShort;
  BEGIN 
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    shortShort.lo := LOOPHOLE(heapAdr+hp, Data.ShortPtr)^;
    shortShort.hi := LOOPHOLE(heapAdr+hp+2, Data.ShortPtr)^;
    RETURN LOOPHOLE(shortShort, Data.Pointer);
  END GetPointer;
(*
PROCEDURE GetPointer(hp: Data.Pointer): Data.Pointer =
  BEGIN 
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    RETURN LOOPHOLE(heapAdr + hp, Data.PointerPtr)^; 
  END GetPointer;
*)

PROCEDURE SetPointer(hp: Data.Pointer; pointer: Data.Pointer) =
  BEGIN
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    LOOPHOLE(heapAdr+hp, Data.ShortPtr)^ := LOOPHOLE(pointer, ShortShort).lo;
    LOOPHOLE(heapAdr+hp+2, Data.ShortPtr)^ := LOOPHOLE(pointer, ShortShort).hi;
  END SetPointer;
(*
PROCEDURE SetPointer(hp: Data.Pointer; pointer: Data.Pointer) =
  BEGIN
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    LOOPHOLE(heapAdr + hp, Data.PointerPtr)^ := pointer;
  END SetPointer;
*)

PROCEDURE GetImmediate(hp: Data.Pointer): Data.Immediate =
  VAR shortShort: ShortShort;
  BEGIN 
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    shortShort.lo := LOOPHOLE(heapAdr+hp, Data.ShortPtr)^;
    shortShort.hi := LOOPHOLE(heapAdr+hp+2, Data.ShortPtr)^;
    RETURN LOOPHOLE(shortShort, Data.Immediate);
  END GetImmediate;
(*
PROCEDURE GetImmediate(hp: Data.Pointer): Data.Immediate =
  BEGIN 
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    RETURN LOOPHOLE(heapAdr + hp, Data.ImmediatePtr)^; 
  END GetImmediate;
*)

PROCEDURE SetImmediate(hp: Data.Pointer; immediate: Data.Immediate) =
  BEGIN
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    LOOPHOLE(heapAdr+hp, Data.ShortPtr)^ := LOOPHOLE(immediate, ShortShort).lo;
    LOOPHOLE(heapAdr+hp+2, Data.ShortPtr)^ := LOOPHOLE(immediate, ShortShort).hi;
  END SetImmediate;
(*
PROCEDURE SetImmediate(hp: Data.Pointer; immediate: Data.Immediate) =
  BEGIN
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    LOOPHOLE(heapAdr + hp, Data.ImmediatePtr)^ := immediate;
  END SetImmediate;

*)

PROCEDURE GetSmallCard(hp: Data.Pointer): Data.SmallCard =
  BEGIN 
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    RETURN LOOPHOLE(heapAdr + hp, Data.SmallCardPtr)^; 
  END GetSmallCard;

PROCEDURE SetSmallCard(hp: Data.Pointer; smallCard: Data.SmallCard) =
  BEGIN
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    LOOPHOLE(heapAdr + hp, Data.SmallCardPtr)^ := smallCard;
  END SetSmallCard;

PROCEDURE GetSmallInt(hp: Data.Pointer): Data.SmallInt =
  BEGIN 
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    RETURN LOOPHOLE(heapAdr + hp, Data.SmallIntPtr)^; 
  END GetSmallInt;

PROCEDURE SetSmallInt(hp: Data.Pointer; smallInt: Data.SmallInt) =
  BEGIN
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    LOOPHOLE(heapAdr + hp, Data.SmallIntPtr)^ := smallInt;
  END SetSmallInt;

PROCEDURE GetInt(hp: Data.Pointer): Data.Int =
  VAR shortShort: ShortShort;
  BEGIN 
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    shortShort.lo := LOOPHOLE(heapAdr+hp, Data.ShortPtr)^;
    shortShort.hi := LOOPHOLE(heapAdr+hp+2, Data.ShortPtr)^;
    RETURN LOOPHOLE(shortShort, Data.Int);
  END GetInt;
(*
PROCEDURE GetInt(hp: Data.Pointer): Data.Int =
  BEGIN 
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    RETURN LOOPHOLE(heapAdr + hp, Data.IntPtr)^; 
  END GetInt;
*)

PROCEDURE SetInt(hp: Data.Pointer; int: Data.Int) =
  BEGIN 
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    LOOPHOLE(heapAdr+hp, Data.ShortPtr)^ := LOOPHOLE(int, ShortShort).lo;
    LOOPHOLE(heapAdr+hp+2, Data.ShortPtr)^ := LOOPHOLE(int, ShortShort).hi;
  END SetInt;
(*
PROCEDURE SetInt(hp: Data.Pointer; int: Data.Int) =
  BEGIN 
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    LOOPHOLE(heapAdr + hp, Data.IntPtr)^ := int; 
  END SetInt;
*)

PROCEDURE GetRelJump(hp: Data.Pointer): Data.Int =
  BEGIN
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    RETURN LOOPHOLE(heapAdr + hp, Data.SmallIntPtr)^; 
  END GetRelJump;

PROCEDURE SetRelJump(hp: Data.Pointer; int: Data.Int) =
  BEGIN
    IF ((int < Data.FirstSmallInt) OR (int > Data.LastSmallInt)) THEN 
      Data.Fault("") 
    END;
    <*ASSERT NOT( (hp < MinIndex) OR (hp > MaxIndex) ) *>
    LOOPHOLE(heapAdr + hp, Data.SmallIntPtr)^ := int;
  END SetRelJump;

PROCEDURE Align() = BEGIN hp := Data.AlignUp(hp, DataAlignment); END Align;

PROCEDURE LayPointee(pointee: Data.Pointee) =
  BEGIN 
    <*ASSERT NOT( hp > MaxIndex ) *>
    LOOPHOLE(heapAdr+hp, Data.PointeePtr)^ := pointee;
    INC(hp, Data.PointeesPerPointee); 
  END LayPointee;

PROCEDURE LayPolymorph(polymorph: Data.Polymorph) =
  BEGIN
    <*ASSERT NOT( hp > MaxIndex ) *>
    LOOPHOLE(heapAdr+hp, Data.ShortPtr)^ := LOOPHOLE(polymorph, ShortShort).lo;
    LOOPHOLE(heapAdr+hp+2, Data.ShortPtr)^ := LOOPHOLE(polymorph, ShortShort).hi;
    INC(hp, Data.PointeesPerPolymorph);
  END LayPolymorph;
(*
PROCEDURE LayPolymorph(polymorph: Data.Polymorph) =
  BEGIN
    <*ASSERT NOT( hp > MaxIndex ) *>
    LOOPHOLE(heapAdr + hp, Data.PolymorphPtr)^ := polymorph;
    INC(hp, Data.PointeesPerPolymorph);
  END LayPolymorph;
*)

PROCEDURE LayPointer(pointer: Data.Pointer) =
  BEGIN
    <*ASSERT NOT( hp > MaxIndex ) *>
    LOOPHOLE(heapAdr+hp, Data.ShortPtr)^ := LOOPHOLE(pointer, ShortShort).lo;
    LOOPHOLE(heapAdr+hp+2, Data.ShortPtr)^ := LOOPHOLE(pointer, ShortShort).hi;
    INC(hp, Data.PointeesPerPointer);
  END LayPointer;
(*
PROCEDURE LayPointer(pointer: Data.Pointer) =
  BEGIN
    <*ASSERT NOT( hp > MaxIndex ) *>
    LOOPHOLE(heapAdr + hp, Data.PointerPtr)^ := pointer;
    INC(hp, Data.PointeesPerPointer);
  END LayPointer;
*)

PROCEDURE LayImmediate(immediate: Data.Immediate) =
  BEGIN
    <*ASSERT NOT( hp > MaxIndex ) *>
    LOOPHOLE(heapAdr+hp, Data.ShortPtr)^ := LOOPHOLE(immediate, ShortShort).lo;
    LOOPHOLE(heapAdr+hp+2, Data.ShortPtr)^ := LOOPHOLE(immediate, ShortShort).hi;
    INC(hp, Data.PointeesPerImmediate);
  END LayImmediate;
(*
PROCEDURE LayImmediate(immediate: Data.Immediate) =
  BEGIN
    <*ASSERT NOT( hp > MaxIndex ) *>
    LOOPHOLE(heapAdr + hp, Data.ImmediatePtr)^ := immediate;
    INC(hp, Data.PointeesPerImmediate);
  END LayImmediate;
*)

PROCEDURE LaySmallCard(smallCard: Data.SmallCard) =
  BEGIN
    <*ASSERT NOT( hp > MaxIndex ) *>
    LOOPHOLE(heapAdr + hp, Data.SmallCardPtr)^ := smallCard;
    INC(hp, Data.PointeesPerSmallCard);
  END LaySmallCard;

PROCEDURE LaySmallInt(smallInt: Data.SmallInt) =
  BEGIN
    <*ASSERT NOT( hp > MaxIndex ) *>
    LOOPHOLE(heapAdr + hp, Data.SmallIntPtr)^ := smallInt;
    INC(hp, Data.PointeesPerSmallInt);
  END LaySmallInt;

PROCEDURE LayInt(int: Data.Int) =
  BEGIN
    <*ASSERT NOT( hp > MaxIndex ) *>
    LOOPHOLE(heapAdr+hp, Data.ShortPtr)^ := LOOPHOLE(int, ShortShort).lo;
    LOOPHOLE(heapAdr+hp+2, Data.ShortPtr)^ := LOOPHOLE(int, ShortShort).hi;
    INC(hp, Data.PointeesPerInt);
  END LayInt;
(*
PROCEDURE LayInt(int: Data.Int) =
  BEGIN
    <*ASSERT NOT( hp > MaxIndex ) *>
    LOOPHOLE(heapAdr + hp, Data.IntPtr)^ := int;
    INC(hp, Data.PointeesPerInt);
  END LayInt;
*)

PROCEDURE LayRelJump(int: Data.Int) =
  BEGIN 
    IF ((int < Data.FirstSmallInt) OR (int > Data.LastSmallInt)) THEN 
      Data.Fault("") 
    END;
    <*ASSERT NOT( hp > MaxIndex ) *>
    LOOPHOLE(heapAdr + hp, Data.SmallIntPtr)^ := int;
    INC(hp, Data.PointeesPerSmallInt);
  END LayRelJump;

BEGIN
END Store.
