
interface ByteArray
export

  T::TYPE
  (* An array of bytes. *)

  error:Exception(Ok)
  (* Raised when any of the following operation cannot be carried out. *)

  new(size:Int):T
  (* Create a new byteArray of given size in bytes, all initialized to 0. *)

  length(arr:T):Int
  (* Return the length of a byteArray. *)

  getByte(arr:T index:Int):Int
  (* Extract a byte. *)

  setByte(arr:T index:Int byte:Int):Ok
  (* Update a byte element. *)

  getShort(arr:T index:Int):Int
  (* Extract a short. *)

  setShort(arr:T index:Int short:Int):Ok
  (* Update a short element. *)

  getLong(arr:T index:Int):Int
  (* Extract a long. Fails if the result is not representable as in Int. *)

  setLong(arr:T index:Int long:Int):Ok
  (* Update a long element. *)

  getReal(arr:T index:Int):Real
  (* Extract a real. Fails if the result is not representable as a Real. *)

  setReal(arr:T index:Int real:Real):Ok
  (* Update a real element. *)

  clear(arr:T start,size:Int):Ok
  (* Zero a byteArray from start for size bytes. *)

  copy(dest:T destStart:Int
    source: T sourceStart,size: Int):Ok
  (* Replace a subarray of a byteArray. If source and dest are the same,
     copies characters in the appropriate direction. *)

end;
