(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 01:43:26 1990 by luca           *)

interface Dynamic
import reader :Reader writer :Writer
export

  (* -- This interface is currently unsound: dynamic.be is a no-op. *)

  T ::TYPE
  (* A pair of an arbitrary object and its type. But the type cannot
     contain type variables. *)

  error :Exception(Ok)
  (* Raised with an operation cannot be carried out. *)

  new(A ::TYPE a :A) :T
  (* Package an object of any closed type into an object of type T. *)

  be(A ::TYPE d :T) :A
  (* If the object d was generated from an object a of type A, then
     return a, otherwise raise error. *)

  copy(A ::TYPE a :A) :A
  (* Make a complete copy of an object of type A, preserving
     sharing and circularities. *)

  intern(rd :reader.T) :T
  (* Read a representation of dynamic object from a reader. *)

  extern(wr :writer.T d :T) :Ok
  (* Write a representation of a dynamic object to a writer.
     The externed representation is in general architecture-
     dependent and should be interned on the same architecture.
     It does not make sense to extern I/O handles such as
     readers and writers.  *)

  internPortable(rd :reader.T) :T
  (* Same as intern, but use an architecture-independent
     representation. *)

  externPortable(wr :writer.T d :T) :Ok
  (* Same as extern, but use an architecture-independent
     representation. *)

end;
