(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Sun Aug 20 18:46:54 1989 by luca           *)

interface Envir
import ident:Ident :Term :Exp
export

  (* An Env.T is a mapping of either a type identifier to its kind, or a value
     identifier to its type. Kinds and types are in normal form. *)

  T::TYPE
  (* An environment. *)

  empty:T
  (* The empty environment. *)
  var topEnv:T
  (* The top-level interactive environment. *)
  var moduleCache:T
  (* The set of currently loaded modules. *)

  consTypSpec(ide:ident.T typSpecKnd:Term_KndExp rest:T):T
  (* Add an association <type identifier, kind> to an environment; the
     identifier must not already be in the environment. *)

  consValSpec(ide:ident.T valSpecTyp:Term_TypExp rest:T):T
  (* Add an association <value identifier, type> to an environment; the
     identifier must not already be in the environment. *)

  getTypSpec(ide:ident.T env:T out knd:Term_KndExp):Bool
  (* Get the kind of a type identifier in an environment; return false if not
     found. *)

  getValSpec(ide:ident.T env:T out typ:Term_TypExp):Bool
  (* Get the type of a value identifier in an environment; return false if not
     found. *)

end;

