(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Sun Aug 20 18:46:55 1989 by luca           *)

interface FreeVars
import :Term
export

  (* Computes the free variables of a REDUCED term, and assigns them to the
   named type and kind nodes. *)

  kndExp(knd:Term_KndExp recs,free:Term_FreeVars):Term_FreeVars
  (* Add the free vars of knd to the list free. *)

  typExp(typ:Term_TypExp recs,free:Term_FreeVars):Term_FreeVars
  (* Add the free vars of typ to the list free. *)

  typExpPath(path:Term_TypExpPath free:Term_FreeVars):Term_FreeVars
  (* Add the free variable of path to the list free. *)

  specExp(spec:Term_SpecExp recs,free:Term_FreeVars):Term_FreeVars
  (* Add the free variables of spec to the list free. *)

  defExpKnd(
    kndDef:Term_DefExpKnd
    recs,free:Term_FreeVars)
    :Term_FreeVars
  (* Add the free variables of kndDef to the list free. *)

  defExpTyp(
    recTyp:Bool
    typLet:Term_DefExpTyp
    recs,free:Term_FreeVars)
    :Term_FreeVars
  (* Add the free variables of typLet to the list free. *)

  defExpTypRec(
    typDef:Term_DefExpTyp
    recs,free:Term_FreeVars)
    :Term_FreeVars

end;
