(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Sun Aug 20 18:46:56 1989 by luca           *)
interface Ident
import nester:Nester
export

  T ::TYPE
  (* An identifier. *)

  List ::TYPE
  (* A list of identifiers. *)

  none :T
  (* An anonimous identifier, just for initializing variables. *)

  new(name :String external :Bool) :T
  (* Create a new unique identifier with given name. A new identifier is 
     not "Same" with any other identifier *)

  anonimous() :T
  (* Create a new nameless identifier. *)

  isAnonimousName(name:String):Bool
  (* Whether this name is anonimous. *)

  isAnonimous(ide :T) :Bool
  (* Whether this identifier has an anonimous name. *)

  like(ide :T) :T
  (* Create a new identifier with the same name as ide, but not "Same" as ide.
     Equivalent to "New(Name(ide), External(ide))". *)

  name(ide :T) : String
  (* Return the name of an identifier *)

  external(ide :T) : Bool
  (* Whether the identifier is external. *)

  equal(ide1,ide2 :T) : Bool
  (* Check whether two identifiers have the same name. *)

  same(ide1,ide2 :T) : Bool
  (* Check whether two identifiers are the "same". Two identifier with the 
     same name might not be the "same" identifier. *)

  print(wr :nester.T ide: T) :Ok
  (* Print an identifier. *)

  (* -- use polymorphic lists *)
  nil :List
  cons(ide :T rest :List) :List
  null(list :List) :Bool
  head(list :List) :T
  tail(list :List) :List

end;

