(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 02:00:25 1990 by luca           *)

interface InferExp
import :Term :Exp envir:Envir subst:Subst :Op
export

  valExp(
    val:Exp_ValExp
    sub:subst.T
    env:envir.T
    hand:Op_Hand)
    :Term_TypExp
  (* Infer the TypExp of a ValExp. *)

  defExp(
    def:Exp_DefExp
    defSub:subst.T
    extSub:subst.T out outExtSub:subst.T
    env:envir.T out outEnv:envir.T)
    :Ok
  (* Check a defExp and produce extended subst and env. *)

  defExtend(
    def:Exp_DefExp out outDef:Exp_DefExp
    defSub:subst.T
    funSpec:Term_SpecExp
    extSub:subst.T out outExtSub:subst.T
    env:envir.T out outEnv:envir.T)
    :Term_SpecExp
  (* As above, but also return the inferred SpecExp of the DefExp. *)

  state:Tuple var traceOn:Bool end
  (* Enable tracing (for debugging) *)

end;
