(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 02:12:21 1990 by luca           *)
interface InferTop
import
  ident :Ident :Term :Exp :Top scoping :Scoping envir :Envir
export

  interfaceExp(
    interfaceImports :Top_ImportList
    interfaceSpec :Term_SpecExp
    interfaceUnsound :Bool)
    :Term_SpecExp
  (* Check an interface. This includes typechecking, unsound imports,
     and module/interface pairing. *)

  moduleExp(
    moduleInterfaceName :ident.T
    moduleImports :Top_ImportList
    moduleBody :Exp_DefExp
    moduleUnsound :Bool
    moduleScope :scoping.T)
    :Ok
  (* Check a module. This includes typechecking, unsound imports,
     module/interface pairing, and module/interface matching *)

  linkageExp(
    linkageImports :Top_ImportList
    env :envir.T out outEnv:envir.T)
    :Ok
  (* Check a linkage line. This includes unsound imports,
     and module/interface pairing *)

  state: Tuple var topLevelSound:Bool end
  (* Soundness state of the top level (default sound). *)

end;
