(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 02:37:28 1990 by luca           *)

interface Literal
import nester :Nester :Code value :Value :ByteCode
export

  Def Rec T =
    Option
      litStringCase with string :String end
      litBadgeCase with badge :Badge end
      litProgCase with prog :Prog end
      litTypeCase
      litValueProgCase with prog :ByteCode_Prog end
      litValueCase with val :value.T end
    end
  (* Keep compatible with Exec.Setup in Exec.m3 *)
  (* The various kinds of literals. 
     String is a string literal in this program.
     Badge is a program badge (literal 0 is the badge of this program).
     Prog is the program of a nested lambda in this program.
     Type is for future use. ValueProg and Value are for linking and
     bootstrapping. *)

  and TList =
    Option
      nil
      cons with lit :T var rest :TList end
    end
  (* A list of literals. *)

  and Badge =
    Tuple
      moduleName,progName :String
      machineId,processId :Int
      timeSecs,timeMicroSecs,timeSerialNo :Int
    end
  (* Compile code is kept in ".impl.x" files. The debugging
     information is kept in ".info.x" files. A badge is a unique
     identifier for a compiled program so that the two pieces
     of information in .impl.x and .info.x can be correlated.
     It identifies the function, the module, the machine and
     process that compiled it, and the instant of compilation. *)

  and Prog =
    Tuple
      badge :Badge
      code :Code_T
      literals :TList
    end
  (* A bytecode sequence with its literals (which are referenced
     by the OpAddrLiteral addressing mode). *)

  emptyTList :TList
  newTList(lit :T rest :TList) :TList
  appendTList(lit :T literals :TList) :TList
  (* Create and append TList's. *)

  newLitString(string :String) :T
  newLitBadge(badge :Badge) :T
  newLitProg(prog :Prog) :T
  newLitType() :T
  newLitValueProg(prog :ByteCode_Prog) :T
  newLitValue(val :value.T) :T
  (* Create various literals. *)

  newBadge(
    moduleName,progName :String
    machineId,processId :Int
    timeSecs,timeMicroSecs,timeSerialNo: Int)
    : Badge
  (* Create a badge. *)

  freshBadge(moduleName,progName :String) : Badge
  (* Create a badge for a program, filling the other info. *)

  sameBadge(badge1,badge2 :Badge) :Bool
  (* Check whether two badges have equal fields. *)

  newProg(badge :Badge code :Code_T literals :TList) :Prog
  (* Create a Prog. *)

  printProg(wr :nester.T prog :Prog indent :String) :Ok
  (* Print a Prog (for debugging) *)

end;
