(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 02:58:18 1990 by luca           *)

unsound interface Machine
import value :Value
export

  (* A Quest interface to the Quest Machine, for interactive 
     compiling, executing, linking, printing, and debugging. *)

  Def Prog =
    value.T
  (* A value which is a ByteCode_Prog. *)

  Def Closure =
    value.T
  (* A value which is a closure. *)

  Def Stack =
    Array(value.T)
  (* A run-time stack. *)

  Def ExcPacket =
    Tuple name :String val :value.T end
  (* An exception packet. *)

  Def State =
    Tuple
      var stack :Stack		(* The evaluation stack *)
      var tl :Int		(* The top-level (i.e. minimum fp) pointer *)
      var tp :Int		(* The trap fram pointer *)
      var fp :Int		(* The frame pointer *)
      var cp :Closure		(* The closure pointer *)
      var pc :Int		(* The program counter *)
      var ex :ExcPacket		(* The exception packet *)
      var home :value.T		(* The special home location *)
      var fault :Bool		(* The fault indicator *)
    end

  exec(prog :Prog stack :Stack tl :Int) :State
  (* Creates a new machine state from the arguments and runs it.
     Returns the final state, after a Stop instruction. *)

  resume(state :State) :State
  (* Run from a given state. Returns the final state, after a 
     Stop instruction. *)

  goto(state :State prog :Prog) :State
  (* Execute the code of prog in the context of a given machine state.
     The pc is switched to prog, but state.prog is left in place so
     its literals can be accesses (and the ones of prog cannot). 
     Any operations (such as apply and return) that rely on the normal
     relation between state.prog and state.pc may crash. 
     Returns the final state, after a Stop instruction. *)

  popFrame(state :State): State
  (* Returns a new machine state obtained by popping one frame
     from a given machine state. *)

  trace(closure :Closure on :Bool) :Ok
  (* Switch trace on or off on a closure. *)

  traceExc(on :Bool) :Ok
  (* Switch trace on or off on exceptions. *)

  break(closure :Closure on :Bool) :Ok
  (* Switch break on or off on a closure. *)

  breakExc(on :Bool) :Ok
  (* Switch break on or off on exceptions. *)

end;
