(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 04:53:29 1990 by luca           *)

interface ModPool
import ident :Ident value :Value
export

  (* Maintain a pool of loaded interfaces and modules. *)

  Def ModuleInstance = value.T
  (* A linked module instance. *)

  noInstance: ModuleInstance
  (* No instance. *)

  addInstance(ide,interfaceName :ident.T instance :ModuleInstance) :Ok
  (* Add an instance to the pool. *)

  fetchInstance(ide,interfaceName :ident.T out instance :ModuleInstance) :Bool
  (* Fetch an instance by name; return true if found. *)

  flushDependentOnInterface(ide :ident.T) :Ok
  (* Flush from the pool the interfaces and modules depending on the
     interface called ide. *)

  flushDependentOnModule(ide :ident.T) :Ok
  (* Flush from the pool the modules depending on the
     module called ide. *)

end;
