(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 03:24:00 1990 by luca           *)

interface Os
export

  (* Minimal Quest System needs from the operating system. *)

  error :Exception(Ok)
  (* Raised when an operation cannot be carried out. *)

  chdir(dirName :String) :Ok
  (* Change the current working directory. *)

  where(path,fileName :String) :String
  (* Try to find the first directory in the path containing a file called
   fileName, and return the directory name as it appears in the path. 
   A path is a sequence of directory names (each can be an absolute name, 
   or a name relative to the current directory) separated by ":".
   Raise error if not found. 
   If path = "", fileName alone is considered. If path = "$d" where d is 
   a digit, the effective path is taken from the Unix program argument 
   corresponding to that digit. If path = "$name", the value of that
   Unix environment variable name is used as the path. Raise error
   if not found. *)

end;
