(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 04:33:43 1990 by luca           *)

interface ParseTerm
import ident :Ident :Term
export

  state :Tuple var unsoundFlag :Bool end
  (* Allows parsing unsound features. *)

  ide(external :Bool) :ident.T
  (* Parse an identifier.
     external is true if this is an external ide. *)

  kndExp() :Term_KndExp
  (* Parse a KndExp. *)

  typExp() :Term_TypExp
  (* Parse a TypExp. *)

  specExp(val,arg: Bool) :Term_SpecExp
  (* Parse a SpecExp. 
     val is true is this signature may contain value specs.
     arg is true if this is a function or operator signature. *)

  defExpKnd() :Term_DefExpKnd
  (* Parse a DefExpKnd. *)

  defExpTyp(recTyp :Bool) :Term_DefExpTyp
  (* Parse a DefExpTyp.
     recTyp is true if this is a recursive definition. *)

end;
