(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 04:48:15 1990 by luca           *)

interface Run
import ident :Ident scoping :Scoping :Term :Exp :Top
export

  interfaceExp(
    interfaceName :ident.T 
    interfaceImports :Top_ImportList
    interfaceSpec :Term_SpecExp
    interfaceUnsound :Bool)
    :Ok
  (* Save a checked interface to file, and flush dependent interfaces
     and modules from the top level. *)

  moduleExp(
    moduleName, moduleInterfaceName :ident.T
    moduleImports :Top_ImportList 
    moduleBody :Exp_DefExp
    moduleUnsound :Bool
    scope :scoping.T) 
    :Ok
  (* Compile and assemble to bytecode a checked module, save it to file, and
     flush dependent modules from the top level. *)

  linkageExp(imports :Top_ImportList) :Ok
  (* Link a checked import list into the top level, reading
     from file all the necessary interface a modules. *)

  defExp(def: Exp_DefExp) :Ok
  (* Compile and assemble to bytecode a checked DefExp, invoke the
     Quest Machine on the code, check the machine outcome (potentially
     entering the debugger), and print the result. *)

end;
