(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 05:26:01 1990 by luca           *)

interface Scoping
import ident :Ident :Term :Exp :Top
export

  (* Flag unbound identifiers, and identify all the identifiers 
     bound by the same binding occurrence. *)

  T ::TYPE
  (* A scoping list. *)

  Def Class =
    Option kndCase typCase valCase end
  kndCase,typCase,valCase: Class
  (* Binding classes. *)

  emptyScope,initialScope :T
  (* Empty scope. *)

  var topScope :T
  (* Top-level scope. *)

  extend(ide :ident.T class :Class scope :T) :T
  (* Extend a scope. *)

  extendRecTyp(ide :ident.T recTyp:Term_TypExp scope :T) :T
  (* Extend a scope with a recursive type. *)

  kndExp(knd :Term_KndExp scope :T) :Ok
  (* Scope a KndExp. *)

  typExp(typ :Term_TypExp scope :T) :Ok
  (* Scope a TypExp. *)

  specExp(spec :Term_SpecExp scope :T) :T
  (* Scope a SpecExp; return the extended scope. *)

  valExp(val :Exp_ValExp scope :T) :Ok
  (* Scope a ValExp. *)

  defExp(def :Exp_DefExp scope :T) :T
  (* Scope a DefExp; return the extended scope. *)

  interfaceExp(interfaceImports :Top_ImportList
    interfaceSpec :Term_SpecExp) :Ok
  (* Scope an interface. *)

  moduleExp(moduleInterfaceName :ident.T moduleImports :Top_ImportList
    moduleBody :Exp_DefExp) :T
  (* Scope a module; return the extended scope. *)

  linkageExp(linkageImports :Top_ImportList scope :T) :T
  (* Scope a linkage line; return the extended scope. *)

  failIfErrorsFound() :Ok
  (* Generate an error if unbound identifiers were found since
     the last call to this function. *)

end;

